/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.AdvancedTerrain;
import common.CampaignData;
import common.Continent;
import common.House;
import common.Influences;
import common.MutableSerializable;
import common.PlanetEnvironments;
import common.UnitFactory;
import common.util.BinReader;
import common.util.BinWriter;
import common.util.Position;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import megamek.common.PlanetaryConditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Planet
implements Comparable<Object>,
MutableSerializable {
    private int id;
    private String name;
    private Position position;
    private Vector<UnitFactory> unitFactories = new Vector(1, 1);
    private PlanetEnvironments environments = new PlanetEnvironments();
    private String description = "";
    private int baysProvided = 0;
    private boolean conquerable = true;
    private int compProduction = 0;
    private Influences influence;
    private Dimension MapSize = new Dimension(1, 1);
    private Dimension BoardSize = new Dimension(16, 17);
    private Dimension temperature = new Dimension(25, 25);
    private double gravity = 1.0;
    private boolean vacuum = false;
    private int nightChance = 0;
    private int nightTempMod = 0;
    private Hashtable<Integer, AdvancedTerrain> advanceTerrain = new Hashtable();
    private int minPlanetOwnerShip = -1;
    private boolean homeWorld = false;
    private String originalOwner = "";
    private TreeMap<String, String> planetFlags = new TreeMap();
    private int maxConquestPoints = 100;
    private int DBID = 0;

    public Planet(int id, String name, Position position, Influences influence) {
        this.setId(id);
        this.setName(name);
        this.setPosition(position);
        this.setInfluence(influence);
    }

    public Planet() {
    }

    public Planet(BinReader in, Map<Integer, House> factions, CampaignData data) throws IOException {
        int i;
        this.setId(new Integer(in.readInt("id")));
        this.setName(in.readLine("name"));
        this.setPosition(new Position(in.readDouble("x"), in.readDouble("y")));
        int size = in.readInt("unitFactories.size");
        this.setUnitFactories(new Vector<UnitFactory>(size, 1));
        for (i = 0; i < size; ++i) {
            UnitFactory uf = new UnitFactory();
            uf.binIn(in);
            this.getUnitFactories().add(uf);
        }
        this.setEnvironments(new PlanetEnvironments());
        this.getEnvironments().binIn(in, data);
        this.setDescription(in.readLine("description"));
        this.setBaysProvided(in.readInt("baysProvided"));
        this.setConquerable(in.readBoolean("conquerable"));
        this.setCompProduction(in.readInt("compProduction"));
        this.setInfluence(new Influences());
        this.getInfluence().binIn(in, factions);
        this.setMapSize(new Dimension(in.readInt("x"), in.readInt("y")));
        this.setBoardSize(new Dimension(in.readInt("x"), in.readInt("y")));
        this.setTemp(new Dimension(in.readInt("lowtemp"), in.readInt("hitemp")));
        this.setGravity(in.readDouble("gravity"));
        this.setVacuum(in.readBoolean("vacuum"));
        this.setMinPlanetOwnerShip(in.readInt("minplanetownership"));
        this.setHomeWorld(in.readBoolean("homeworld"));
        this.setOriginalOwner(in.readLine("originalowner"));
        size = in.readInt("AdvancedTerrain.size");
        for (i = 0; i < size; ++i) {
            AdvancedTerrain aTerrain = new AdvancedTerrain();
            int id = in.readInt("AdvancedTerrainId");
            aTerrain.binIn(in);
            this.getAdvancedTerrain().put(new Integer(id), aTerrain);
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        size = in.readInt("PlanetFlags.size");
        for (int i2 = 0; i2 < size; ++i2) {
            String key = in.readLine("PlanetFlags.key");
            String value = in.readLine("PlanetFlags.value");
            map.put(key, value);
        }
        this.setPlanetFlags(map);
        this.setConquestPoints(in.readInt("MaxInfluence"));
    }

    public int getBaysProvided() {
        return this.baysProvided;
    }

    public void setBaysProvided(int baysProvided) {
        this.baysProvided = baysProvided;
    }

    public int getDBID() {
        return this.DBID;
    }

    public void setDBID(int ID) {
        this.DBID = ID;
    }

    public int getCompProduction() {
        return this.compProduction;
    }

    public void setCompProduction(int compProduction) {
        this.compProduction = compProduction;
    }

    public Integer getPlanetOwner() {
        Integer ownerid = this.getInfluence().getOwner();
        return ownerid;
    }

    public boolean isOwner(int factionid) {
        Integer ownerID = this.getPlanetOwner();
        if (ownerID == null) {
            return false;
        }
        return ownerID == factionid;
    }

    public boolean isConquerable() {
        return this.conquerable;
    }

    public void setConquerable(boolean conquerable) {
        this.conquerable = conquerable;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getNameAsLink() {
        return "<a href=\"JUMPTOPLANET" + this.name + "#\">" + this.name + "</a>";
    }

    public void setName(String name) {
        this.name = name;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public Vector<UnitFactory> getUnitFactories() {
        return this.unitFactories;
    }

    public void setUnitFactories(Vector<UnitFactory> unitFactories) {
        this.unitFactories = unitFactories;
    }

    public PlanetEnvironments getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(PlanetEnvironments environments) {
        this.environments = environments;
    }

    public Influences getInfluence() {
        return this.influence;
    }

    public void setInfluence(Influences influence) {
        this.influence = influence;
    }

    public void updateInfluences() {
        int totalCP = this.getConquestPoints();
        for (House house : this.getInfluence().getHouses()) {
            if (house.getId() == -1) continue;
            totalCP -= this.getInfluence().getInfluence(house.getId());
        }
        if (totalCP > 0) {
            this.getInfluence().updateHouse(-1, totalCP);
        }
    }

    @Override
    public int compareTo(Object o) {
        Planet p = (Planet)o;
        return this.getId() < p.getId() ? -1 : (this.getId() == p.getId() ? 0 : 1);
    }

    @Override
    public void encodeMutableFields(BinWriter out, CampaignData dataProvider) throws IOException {
        out.println(this.getId(), "id");
        this.getInfluence().encodeMutableFields(out, dataProvider);
        this.binOut(out);
    }

    @Override
    public void decodeMutableFields(BinReader in, CampaignData dataProvider) throws IOException {
        this.setId(new Integer(in.readInt("id")));
        this.getInfluence().decodeMutableFields(in, dataProvider);
        this.binIn(in, dataProvider);
    }

    public void binOut(BinWriter out) throws IOException {
        out.println(this.getId(), "id");
        out.println(this.getName(), "name");
        out.println(this.getPosition().x, "x");
        out.println(this.getPosition().y, "y");
        out.println(this.getUnitFactories().size(), "unitFactories.size");
        for (UnitFactory i : this.getUnitFactories()) {
            i.binOut(out);
        }
        this.getEnvironments().binOut(out);
        out.println(this.getDescription(), "description");
        out.println(this.getBaysProvided(), "baysProvided");
        out.println(this.isConquerable(), "conquerable");
        out.println(this.getCompProduction(), "compProduction");
        this.getInfluence().binOut(out);
        out.println(this.getMapSize().width, "x");
        out.println(this.getMapSize().height, "y");
        out.println(this.getBoardSize().width, "x");
        out.println(this.getBoardSize().height, "y");
        out.println(this.getTemp().width, "lowtemp");
        out.println(this.getTemp().height, "hitemp");
        out.println(this.getGravity(), "gravity");
        out.println(this.isVacuum(), "vacuum");
        out.println(this.getMinPlanetOwnerShip(), "minplanetownership");
        out.println(this.isHomeWorld(), "homeworld");
        out.println(this.getOriginalOwner(), "originalowner");
        out.println(this.getAdvancedTerrain().size(), "AdvancedTerrain.size");
        for (Integer currI : this.getAdvancedTerrain().keySet()) {
            out.println(currI, "AdvancedTerrainId");
            AdvancedTerrain aTerrain = this.getAdvancedTerrain().get(currI);
            aTerrain.binOut(out);
        }
        out.println(this.getPlanetFlags().size(), "PlanetFlags.size");
        for (String key : this.getPlanetFlags().keySet()) {
            out.println(key, "PlanetFlags.key");
            out.println(this.getPlanetFlags().get(key), "PlayerFlags.value");
        }
        out.println(this.getConquestPoints(), "MaxInfluence");
    }

    public void binIn(BinReader in, CampaignData data) throws IOException {
        int i;
        this.setId(new Integer(in.readInt("id")));
        this.setName(in.readLine("name"));
        this.setPosition(new Position(in.readDouble("x"), in.readDouble("y")));
        int size = in.readInt("unitFactories.size");
        this.setUnitFactories(new Vector<UnitFactory>(size, 1));
        for (i = 0; i < size; ++i) {
            UnitFactory uf = new UnitFactory();
            uf.binIn(in);
            this.getUnitFactories().add(uf);
        }
        this.setEnvironments(new PlanetEnvironments());
        this.getEnvironments().binIn(in, data);
        this.setDescription(in.readLine("description"));
        this.setBaysProvided(in.readInt("baysProvided"));
        this.setConquerable(in.readBoolean("conquerable"));
        this.setCompProduction(in.readInt("compProduction"));
        this.setInfluence(new Influences());
        this.getInfluence().binIn(in);
        this.setMapSize(new Dimension(in.readInt("x"), in.readInt("y")));
        this.setBoardSize(new Dimension(in.readInt("x"), in.readInt("y")));
        this.setTemp(new Dimension(in.readInt("lowtemp"), in.readInt("hitemp")));
        this.setGravity(in.readDouble("gravity"));
        this.setVacuum(in.readBoolean("vacuum"));
        this.setMinPlanetOwnerShip(in.readInt("minplanetownership"));
        this.setHomeWorld(in.readBoolean("homeworld"));
        this.setOriginalOwner(in.readLine("originalowner"));
        size = in.readInt("AdvancedTerrain.size");
        for (i = 0; i < size; ++i) {
            AdvancedTerrain aTerrain = new AdvancedTerrain();
            int id = in.readInt("AdvancedTerrainId");
            aTerrain.binIn(in);
            this.getAdvancedTerrain().put(new Integer(id), aTerrain);
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        size = in.readInt("PlanetFlags.size");
        for (int i2 = 0; i2 < size; ++i2) {
            String key = in.readLine("PlanetFlags.key");
            String value = in.readLine("PlanetFlags.value");
            map.put(key, value);
        }
        this.setPlanetFlags(map);
        this.setConquestPoints(in.readInt("MaxInfluence"));
    }

    public StringBuilder getLongDescription(boolean client) {
        StringBuilder result = new StringBuilder("Information for Planet: <b>");
        result.append(this.getName() + "</b><br><br>");
        result.append("<b>Location:</b> " + (int)this.getPosition().x + " x " + (int)this.getPosition().y + " y<br>" + Math.round(this.getPosition().distanceSq(0.0, 0.0)) + " Lightyears from the galaxy center <br><br>");
        result.append("<b>Industry:</b><br>");
        if (this.getCompProduction() > 0) {
            result.append("Heavy industry allows an export of " + this.getCompProduction() + " parts.<br>");
        }
        if (this.getBaysProvided() > 0) {
            result.append("A warehouse on this world provides all players with " + this.getBaysProvided() + " extra bays.<br>");
        }
        if (this.getUnitFactories().size() > 0) {
            String founder = "";
            if (this.getUnitFactories().size() == 1) {
                result.append("<br><b>Factory:</b><br>");
            } else {
                result.append("<br><b>Factories:</b><br>");
            }
            for (UnitFactory u : this.getUnitFactories()) {
                founder = u.getFounder();
                String openImage = "./data/images/open" + founder + ".gif";
                if (!new File(openImage).exists()) {
                    openImage = "./data/images/open.gif";
                }
                result.append("<img src=\"file:///" + new File(openImage).getAbsolutePath() + "\">" + u.getSize() + " " + u.getFullTypeString() + u.getName() + " built by " + founder + "<br>");
            }
        }
        result.append("<br><b>Planetary Conditions</b><br>");
        result.append("Atmosphere: ");
        if (this.isVacuum()) {
            result.append("None<br>");
        } else {
            result.append("Present<br>");
        }
        result.append("Gravity: " + this.getGravity() + "<br>");
        result.append("Average Low: " + this.getTemp().width + "<br>");
        result.append("Average High: " + this.getTemp().height + "<br>");
        result.append("<br><b>Terrain:</b><br>");
        int maxProbab = this.getEnvironments().getTotalEnivronmentPropabilities();
        if (this.getEnvironments().size() < 1) {
            result.append("nothing special");
        } else {
            for (Continent pe : this.getEnvironments().toArray()) {
                int curProb = pe.getSize() * 100 / maxProbab;
                if (curProb < 10) {
                    result.append("0");
                }
                result.append(curProb + "% ");
                if (client) {
                    result.append(pe.getEnvironment().toImageAbsolutePathDescription());
                } else {
                    result.append(pe.getEnvironment().toImageDescription());
                }
                String terrainName = pe.getEnvironment().getName();
                result.append(" " + terrainName);
                result.append("<br>");
            }
        }
        result.append("<br><b>Influence:</b><br>");
        for (House h : this.getInfluence().getHouses()) {
            String color = "#999999";
            String name = "None";
            int id = -1;
            if (h != null) {
                color = h.getHouseColor();
                name = h.getName();
                id = h.getId();
            }
            result.append("<font color=" + color + ">" + name + "</font> (" + this.getInfluence().getInfluence(id) + ")");
            result.append(", ");
        }
        result.replace(result.length() - 2, result.length(), "<br>");
        if (this.getPlanetFlags().size() > 0) {
            result.append("<br><b>Points of Intereset:</b><br>");
            for (String value : this.getPlanetFlags().values()) {
                result.append(value + ", ");
            }
            result.replace(result.length() - 2, result.length(), "<br> <br>");
        }
        return result;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public StringBuilder getAdvanceDescription(int level) {
        StringBuilder result = new StringBuilder();
        result.append("Information for Planet: <b>");
        result.append(this.getName() + "</b><br><br>");
        result.append("<b>Location:</b> " + (int)this.getPosition().x + " x " + (int)this.getPosition().y + " y<br>" + Math.round(this.getPosition().distanceSq(0.0, 0.0)) + " Lightyears from the galaxy center <br><br>");
        result.append("<b>Industry:</b><br>");
        if (this.getCompProduction() > 0) {
            result.append("Heavy industry allows an export of " + this.getCompProduction() + " parts.<br>");
        }
        if (this.getBaysProvided() > 0) {
            result.append("A warehouse on this world provides all players with " + this.getBaysProvided() + " extra .<br><br>");
        }
        if (this.getUnitFactories().size() > 0) {
            String founder = "";
            if (this.getUnitFactories().size() == 1) {
                result.append("<br><b>Factory:</b><br>");
            } else {
                result.append("<br><b>Factories:</b><br>");
            }
            for (UnitFactory u : this.getUnitFactories()) {
                founder = u.getFounder();
                String openImage = "./data/images/open" + founder + ".gif";
                if (!new File(openImage).exists()) {
                    openImage = "./data/images/open.gif";
                }
                result.append("<img src=\"file:///" + new File(openImage).getAbsolutePath() + "\">" + u.getSize() + " " + u.getFullTypeString() + u.getName() + " built by " + founder + "<br>");
            }
        }
        result.append("<br><b>Terrain:</b><br>");
        int maxProbab = this.getEnvironments().getTotalEnivronmentPropabilities();
        if (this.getEnvironments().size() < 1) {
            result.append("nothing special");
        } else {
            for (Continent pe : this.getEnvironments().toArray()) {
                int curProb = pe.getSize() * 100 / maxProbab;
                if (curProb < 10) {
                    result.append("0");
                }
                result.append(curProb + "% ");
                result.append(pe.getEnvironment().toImageAbsolutePathDescription());
                AdvancedTerrain aTerrain = this.getAdvancedTerrain().get(new Integer(pe.getEnvironment().getId()));
                if (aTerrain == null) {
                    result.append("Nothing special");
                } else {
                    result.append(" " + aTerrain.getDisplayName());
                    result.append("<br>Atmosphere: ");
                    result.append(PlanetaryConditions.getAtmosphereDisplayableName(aTerrain.getAtmosphere()));
                    result.append("<br>");
                    result.append("Gravity: " + aTerrain.getGravity());
                    result.append("<br>Average Low: " + aTerrain.getLowTemp());
                    result.append("<br>Average High: " + aTerrain.getHighTemp());
                    if (level >= 100) {
                        result.append("<br>Night Chance: " + aTerrain.getNightChance());
                        result.append("<br>Night Temp Mod: " + aTerrain.getNightTempMod());
                        if (aTerrain.isStaticMap()) {
                            result.append("<br>Map Name: " + aTerrain.getStaticMapName());
                            result.append("<br>Map Size(XxY): " + aTerrain.getXSize() + " x " + aTerrain.getYSize());
                            result.append("<br>Board Size(XxY): " + aTerrain.getXBoardSize() + " x " + aTerrain.getYBoardSize());
                        }
                    }
                }
                result.append("<br>");
            }
        }
        result.append("<br><br><b>Influence:</b><br>");
        for (House h : this.getInfluence().getHouses()) {
            String color = "#999999";
            String name = "None";
            int id = -1;
            if (h != null) {
                color = h.getHouseColor();
                name = h.getName();
                id = h.getId();
            }
            result.append("<font color=" + color + ">" + name + "</font> (" + this.getInfluence().getInfluence(id) + ")");
            result.append(", ");
        }
        result.replace(result.length() - 2, result.length(), "<br>");
        if (this.getPlanetFlags().size() > 0) {
            result.append("<br><b>Points of Intereset:</b><br>");
            for (String value : this.getPlanetFlags().values()) {
                result.append(value + ", ");
            }
            result.delete(result.length() - 2, result.length());
            result.append("<br><br>");
        }
        return result;
    }

    public int getFactoryCount() {
        return this.getUnitFactories().size();
    }

    public Dimension getMapSize() {
        return this.MapSize;
    }

    public void setMapSize(Dimension map) {
        this.MapSize = map;
    }

    public Dimension getBoardSize() {
        return this.BoardSize;
    }

    public void setBoardSize(Dimension board) {
        this.BoardSize = board;
    }

    public Dimension getTemp() {
        return this.temperature;
    }

    public void setTemp(Dimension temp) {
        this.temperature = temp;
    }

    public double getGravity() {
        return this.gravity;
    }

    public void setGravity(double grav) {
        this.gravity = grav;
    }

    public boolean isVacuum() {
        return this.vacuum;
    }

    public void setVacuum(boolean vac) {
        this.vacuum = vac;
    }

    public int getNightChance() {
        return this.nightChance;
    }

    public void setNightChance(int chance) {
        this.nightChance = chance;
    }

    public int getNightTempMod() {
        return this.nightTempMod;
    }

    public void setNightTempMod(int mod) {
        this.nightTempMod = mod;
    }

    public Hashtable<Integer, AdvancedTerrain> getAdvancedTerrain() {
        return this.advanceTerrain;
    }

    public void setAdvancedTerrain(Hashtable<Integer, AdvancedTerrain> terrain) {
        this.advanceTerrain = terrain;
    }

    public int getMinPlanetOwnerShip() {
        return this.minPlanetOwnerShip;
    }

    public void setMinPlanetOwnerShip(int ownership) {
        this.minPlanetOwnerShip = ownership;
    }

    public void setHomeWorld(boolean homeworld) {
        this.homeWorld = homeworld;
    }

    public boolean isHomeWorld() {
        return this.homeWorld;
    }

    public void setOriginalOwner(String owner) {
        this.originalOwner = owner;
    }

    public String getOriginalOwner() {
        return this.originalOwner;
    }

    public TreeMap<String, String> getPlanetFlags() {
        return this.planetFlags;
    }

    public void setPlanetFlags(TreeMap<String, String> flags) {
        this.planetFlags = flags;
    }

    public int getConquestPoints() {
        return this.maxConquestPoints;
    }

    public void setConquestPoints(int points) {
        this.maxConquestPoints = Math.max(1, points);
    }
}

