/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CampaignData;
import common.Continent;
import common.PlanetEnvironment;
import common.Terrain;
import common.TerrainProvider;
import common.util.BinReader;
import common.util.BinWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanetEnvironments {
    public static transient TerrainProvider data;
    private ArrayList<Continent> continents = new ArrayList();

    public Iterator<Continent> iterator() {
        return this.continents.iterator();
    }

    public int size() {
        return this.continents.size();
    }

    public Continent[] toArray() {
        Continent[] ret = new Continent[this.size()];
        int i = 0;
        Iterator<Continent> it = this.iterator();
        while (it.hasNext()) {
            ret[i++] = it.next();
        }
        return ret;
    }

    public synchronized void add(Continent newPE) {
        this.continents.add(newPE);
    }

    public synchronized void remove(String terrain) {
        int count = 0;
        for (Continent land : this.continents) {
            if (land.getEnvironment().getName().equals(terrain)) break;
            ++count;
        }
        if (count < this.continents.size()) {
            this.continents.remove(count);
            this.continents.trimToSize();
        }
    }

    public synchronized void removeAll() {
        this.continents.clear();
    }

    public Continent getBiggestEnvironment() {
        Continent result = new Continent(0, new Terrain());
        Iterator<Continent> it = this.iterator();
        while (it.hasNext()) {
            Continent p = it.next();
            if (p.getSize() <= result.getSize()) continue;
            result = p;
        }
        return result;
    }

    public int getTotalEnivronmentPropabilities() {
        int result = 0;
        Iterator<Continent> it = this.iterator();
        while (it.hasNext()) {
            result += it.next().getSize();
        }
        return result;
    }

    public PlanetEnvironment getRandomEnvironment(Random r) {
        int probs = this.getTotalEnivronmentPropabilities();
        Iterator<Continent> it = this.iterator();
        while (it.hasNext()) {
            Continent pe = it.next();
            if (r.nextInt(probs) < pe.getSize()) {
                probs = pe.getEnvironment().getTotalEnivronmentPropabilities();
                for (PlanetEnvironment env : pe.getEnvironment().getEnviroments()) {
                    if (r.nextInt(probs) < env.getEnvironmentalProb()) {
                        return env;
                    }
                    probs -= env.getEnvironmentalProb();
                }
            }
            probs -= pe.getSize();
        }
        return new PlanetEnvironment();
    }

    public void binOut(BinWriter out) {
        out.println(this.size(), "terrain.size");
        for (Continent cont : this.continents) {
            out.println(cont.getSize(), "size");
            out.println(cont.getEnvironment().getId(), "id");
        }
    }

    public void binIn(BinReader in, CampaignData data) throws IOException {
        int size = in.readInt("terrain.size");
        for (int i = 0; i < size; ++i) {
            this.add(new Continent(in.readInt("size"), data.getTerrain(in.readInt("id"))));
        }
    }
}

