/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CampaignData;
import common.PlanetEnvironment;
import common.util.BinReader;
import common.util.BinWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Terrain {
    private int id = -1;
    private String Name = "";
    private Vector<PlanetEnvironment> environments = new Vector(10, 1);

    public Terrain() {
    }

    public Terrain(String s) {
        StringTokenizer ST = new StringTokenizer(s, "$");
        ST.nextToken();
        this.Name = ST.nextToken();
        while (ST.hasMoreElements()) {
            PlanetEnvironment PE = new PlanetEnvironment(ST);
            this.environments.add(PE);
        }
    }

    public String toString() {
        String result = "TE$";
        result = result + this.Name + "$";
        for (PlanetEnvironment env : this.environments) {
            result = result + env.toString();
        }
        return result;
    }

    public void binOut(BinWriter out) throws IOException {
        out.println(this.id, "id");
        out.println(this.Name, "name");
        out.println(this.environments.size(), "environmentsize");
        for (PlanetEnvironment env : this.environments) {
            env.binOut(out);
        }
    }

    public void binIn(BinReader in, CampaignData data) throws IOException {
        this.id = in.readInt("id");
        this.Name = in.readLine("name");
        int environments = in.readInt("environmentsize");
        for (int pos = 0; pos < environments; ++pos) {
            PlanetEnvironment PE = new PlanetEnvironment();
            PE.binIn(in, data);
            this.environments.add(PE);
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        for (PlanetEnvironment pe : this.environments) {
            pe.setId(id);
        }
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public Vector<PlanetEnvironment> getEnviroments() {
        return this.environments;
    }

    public String toImageDescription() {
        if (this.environments.size() > 0) {
            return this.environments.get(0).toImageDescription();
        }
        return "";
    }

    public String toImageAbsolutePathDescription() {
        if (this.environments.size() > 0) {
            return this.environments.get(0).toImageAbsolutePathDescription();
        }
        return "";
    }

    public int getTotalEnivronmentPropabilities() {
        int result = 0;
        for (PlanetEnvironment pe : this.environments) {
            result += pe.getEnvironmentalProb();
        }
        return result;
    }
}

