/*
 * Decompiled with CFR 0.152.
 */
package common.campaign.pilot.skills;

import common.campaign.pilot.skills.PilotSkill;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PilotSkills {
    private LinkedList<PilotSkill> skills = new LinkedList();

    public boolean has(PilotSkill p) {
        if (p == null) {
            return false;
        }
        return this.skills.contains(p);
    }

    public boolean has(int id) {
        Iterator<PilotSkill> it = this.getSkillIterator();
        while (it.hasNext()) {
            if (it.next().getId() != id) continue;
            return true;
        }
        return false;
    }

    public void add(PilotSkill p) {
        if (p != null && !this.has(p)) {
            this.skills.add(p);
        }
    }

    public void remove(PilotSkill p) {
        if (p != null) {
            this.skills.remove(p);
        }
    }

    public int size() {
        return this.skills.size();
    }

    public Iterator<PilotSkill> getSkillIterator() {
        return this.skills.iterator();
    }

    public LinkedList<PilotSkill> getPilotSkills() {
        return this.skills;
    }

    public PilotSkill getPilotSkill(int skillid) {
        Iterator<PilotSkill> skills = this.getSkillIterator();
        while (skills.hasNext()) {
            PilotSkill pSkill = skills.next();
            if (pSkill.getId() != skillid) continue;
            return pSkill;
        }
        return null;
    }

    public String getDescription() {
        Iterator<PilotSkill> i = this.getSkillIterator();
        String result = "";
        if (i.hasNext()) {
            result = " Skills: ";
        }
        while (i.hasNext()) {
            PilotSkill skill = i.next();
            result = result + skill.getName();
            if (skill.getLevel() > 1) {
                result = result + " " + skill.getLevel();
            }
            if (!i.hasNext()) continue;
            result = result + ", ";
        }
        return result;
    }
}

