/*
 * Decompiled with CFR 0.152.
 */
package OperationsEditor.dialog;

import client.MWClient;
import common.CampaignData;
import common.DefaultOperation;
import common.util.SpringLayoutHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class OperationsDialog
extends JFrame
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = -238767483230471330L;
    private static final String windowName = "MekWars Operations Editor";
    private static final int SHORT_OP = 0;
    private static final int LONG_OP = 0;
    private static final int SPECIAL_OP = 0;
    public static final int OP_VERSION = 2;
    private int currentOpType = 0;
    private boolean shortOpScreenCreated = false;
    private String taskName = "";
    private DefaultOperation defaultOperationInfo = new DefaultOperation();
    private BackedTreeMap opValues;
    private JTextField BaseTextField = new JTextField(10);
    private JCheckBox BaseCheckBox = new JCheckBox();
    private JComboBox BaseComboBox = new JComboBox();
    private String filePathName = "./data/operations";
    private JOptionPane pane;
    private JScrollPane scrollPane;
    private Object mwclient = null;
    JPanel contentPane;
    private boolean changesMade = false;
    private Dimension textBoxSize = new Dimension(70, 22);
    JTabbedPane ConfigPane = new JTabbedPane(1);

    public OperationsDialog(Object o) {
        if (o != null) {
            this.mwclient = o;
        }
        String logFileName = "./logs/opeditorlog.txt";
        try {
            PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFileName), 64));
            System.setOut(ps);
            System.setErr(ps);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenu createMenu = new JMenu();
        JMenu loadMenu = new JMenu();
        fileMenu.setText("File");
        fileMenu.setMnemonic('F');
        createMenu.setText("New");
        createMenu.setMnemonic('N');
        loadMenu.setText("Load");
        loadMenu.setMnemonic('L');
        fileMenu.add(createMenu);
        fileMenu.add(loadMenu);
        menuBar.add(fileMenu);
        menuBar.setVisible(true);
        JMenuItem item = new JMenuItem("Short Operation");
        item.setMnemonic('S');
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OperationsDialog.this.jMenuLoadShortOp_actionPerformed(e);
            }
        });
        loadMenu.add(item);
        item = new JMenuItem("Long Operation");
        item.setMnemonic('L');
        item.setEnabled(false);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OperationsDialog.this.jMenuLoadLongOp_actionPerformed(e);
            }
        });
        loadMenu.add(item);
        item = new JMenuItem("Special Operation");
        item.setMnemonic('p');
        item.setEnabled(false);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OperationsDialog.this.jMenuLoadSpecialOp_actionPerformed(e);
            }
        });
        loadMenu.add(item);
        item = new JMenuItem("Short Operation");
        item.setMnemonic('S');
        item.setEnabled(true);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OperationsDialog.this.jMenuCreateShortOp_actionPerformed(e);
            }
        });
        createMenu.add(item);
        item = new JMenuItem("Long Operation");
        item.setMnemonic('L');
        item.setEnabled(false);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OperationsDialog.this.jMenuCreateLongOp_actionPerformed(e);
            }
        });
        createMenu.add(item);
        item = new JMenuItem("Special Operation");
        item.setMnemonic('p');
        item.setEnabled(false);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OperationsDialog.this.jMenuCreateSpecialOp_actionPerformed(e);
            }
        });
        createMenu.add(item);
        item = new JMenuItem("Save");
        item.setMnemonic('S');
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (OperationsDialog.this.currentOpType == 0) {
                    OperationsDialog.this.saveShortOperations();
                }
            }
        });
        fileMenu.add(item);
        item = new JMenuItem("Save as");
        item.setMnemonic('A');
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OperationsDialog.this.jMenuSaveAsOp_actionPerformed(e);
            }
        });
        fileMenu.add(item);
        fileMenu.addSeparator();
        item = new JMenuItem("Exit");
        item.setMnemonic('X');
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (OperationsDialog.this.changesMade) {
                    int result = JOptionPane.showConfirmDialog(null, "Changes have been made\n\rDo you want to exit without saving?", "Exit Without Saving", 0);
                    if (result == 0) {
                        if (OperationsDialog.this.mwclient == null) {
                            System.exit(0);
                        } else {
                            OperationsDialog.this.dispose();
                        }
                    }
                } else if (OperationsDialog.this.mwclient == null) {
                    System.exit(0);
                } else {
                    OperationsDialog.this.dispose();
                }
            }
        });
        fileMenu.add(item);
        if (this.mwclient != null) {
            menuBar.add(this.createEditMenu());
        }
        this.setResizable(true);
        this.setSize(new Dimension(640, 480));
        this.setExtendedState(0);
        if (this.mwclient != null) {
            this.setTitle("MekWars Operations Editor(Integrated)");
        } else {
            this.setTitle(windowName);
        }
        File shortDir = new File("./data/operations/short/");
        File longDir = new File("./data/operations/long/");
        File modDir = new File("./data/operations/modifiers/");
        try {
            if (!shortDir.exists()) {
                shortDir.mkdirs();
            }
            if (!longDir.exists()) {
                longDir.mkdir();
            }
            if (!modDir.exists()) {
                modDir.mkdir();
            }
        }
        catch (Exception e) {
            System.err.println("Error while creating operations directories.");
            System.exit(1);
        }
        this.setJMenuBar(menuBar);
        Object[] options = new Object[]{};
        this.pane = new JOptionPane(this.ConfigPane, -1, -1, null, options, null);
        this.pane.setVisible(false);
        this.scrollPane = new JScrollPane(this.pane, 20, 30);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.scrollPane, "Center");
        this.repaint();
        this.setLocation(this.getLocation().x + 10, this.getLocation().y);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                boolean closeit = true;
                if (OperationsDialog.this.changesMade) {
                    int result = JOptionPane.showConfirmDialog(null, "Changes were been made!\n\rDo you want to exit without saving?", "Exit Without Saving", 0);
                    closeit = result == 0;
                }
                if (closeit) {
                    if (OperationsDialog.this.mwclient != null) {
                        OperationsDialog.this.dispose();
                    } else {
                        System.exit(0);
                    }
                }
            }
        });
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        this.changesMade = true;
        if (this.getTitle().indexOf("*") == -1) {
            this.setTitle(this.getTitle() + "*");
        }
    }

    public void jMenuLoadShortOp_actionPerformed(ActionEvent e) {
        this.currentOpType = 0;
        if (!this.shortOpScreenCreated) {
            this.createShortOpPanel();
        }
        this.initShortOpVars();
        this.loadShortOp();
    }

    public void jMenuLoadLongOp_actionPerformed(ActionEvent e) {
        this.currentOpType = 0;
    }

    public void jMenuLoadSpecialOp_actionPerformed(ActionEvent e) {
        this.currentOpType = 0;
    }

    public void jMenuCreateShortOp_actionPerformed(ActionEvent e) {
        this.taskName = JOptionPane.showInputDialog(null, "Operation Name", "New Operation Name", 2);
        if (this.taskName == null || this.taskName.length() == 0) {
            return;
        }
        if (!this.shortOpScreenCreated) {
            this.createShortOpPanel();
        }
        this.defaultOperationInfo = new DefaultOperation();
        this.initShortOpVars();
        this.currentOpType = 0;
        this.setTitle("MekWars Operations Editor (" + this.taskName + ")");
        this.filePathName = "./data/operations/short/" + this.taskName + ".txt";
    }

    public void jMenuCreateLongOp_actionPerformed(ActionEvent e) {
        this.currentOpType = 0;
    }

    public void jMenuCreateSpecialOp_actionPerformed(ActionEvent e) {
        this.currentOpType = 0;
    }

    public void jMenuSaveAsOp_actionPerformed(ActionEvent e) {
        FileDialog fDialog = new FileDialog((Frame)this, "Save Short Op As", 1);
        fDialog.setDirectory(this.filePathName);
        fDialog.setVisible(true);
        if (fDialog.getFile() != null) {
            this.filePathName = fDialog.getDirectory() + fDialog.getFile();
            this.taskName = fDialog.getFile().substring(0, fDialog.getFile().indexOf(".txt"));
            if (this.currentOpType == 0) {
                this.saveShortOperations();
            }
            this.setTitle("MekWars Operations Editor (" + this.taskName + ")");
            this.changesMade = false;
        }
    }

    public void createShortOpPanel() {
        JPanel rangePanel = new JPanel();
        JPanel factionPanel = new JPanel();
        JPanel unitsPanel = new JPanel();
        JPanel costsPanel = new JPanel();
        JPanel playerPropertiesPanel = new JPanel();
        JPanel scenarioPanel = new JPanel();
        JPanel opresultsPanel = new JPanel();
        JPanel salvagePanel = new JPanel();
        JPanel newbieOpsPanel = new JPanel();
        JPanel metaSetupPanel = new JPanel();
        JPanel chickenLeechPanel = new JPanel();
        JPanel pilotExpPanel = new JPanel();
        JPanel buildingsPanel = new JPanel();
        JPanel victoryPanel = new JPanel();
        JPanel teamPanel = new JPanel();
        JPanel deploymentPanel = new JPanel();
        this.ConfigPane = new JTabbedPane();
        this.shortOpScreenCreated = true;
        JPanel rangesBox = new JPanel(new SpringLayout());
        JPanel rangesBox2 = new JPanel(new SpringLayout());
        JPanel rangesmasterBox = new JPanel();
        rangesmasterBox.setLayout(new BoxLayout(rangesmasterBox, 1));
        this.BaseTextField = new JTextField(5);
        rangesBox.add(new JLabel("Operation Color:", 11));
        this.BaseTextField.setToolTipText("html or hex color for an op");
        this.BaseTextField.setName("OperationColor");
        rangesBox.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        rangesBox.add(new JLabel("Operation Range:", 11));
        this.BaseTextField.setToolTipText("One Jump");
        this.BaseTextField.setName("OperationRange");
        rangesBox.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        rangesBox.add(new JLabel("% To Attack On World:", 11));
        this.BaseTextField.setToolTipText("<Html>Min Percent needed by a faction to launch this operation aginst<br>this world from on the world itself.</html>");
        this.BaseTextField.setName("PercentageToAttackOnWorld");
        rangesBox.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        rangesBox.add(new JLabel("% to Attack Off World:", 11));
        this.BaseTextField.setToolTipText("<Html>Min Percent needed by a faction to launch this operation aginst<br>another world from this world.</html>");
        this.BaseTextField.setName("PercentageToAttackOffWorld");
        rangesBox.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        rangesBox.add(new JLabel("Min % Owned:", 11));
        this.BaseTextField.setToolTipText("Min % owned to use attack on a world.");
        this.BaseTextField.setName("MinPlanetOwnership");
        rangesBox.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        rangesBox.add(new JLabel("Max % Owned:", 11));
        this.BaseTextField.setToolTipText("Max % owned to use attack on a world.");
        this.BaseTextField.setName("MaxPlanetOwnership");
        rangesBox.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        rangesBox.add(new JLabel("Allowed Planet Flags:", 11));
        this.BaseTextField.setToolTipText("<html>Flags the planet must have to allow this op.<br>Delimit/Sperate with ^ Example AA^BB^CC</html>");
        this.BaseTextField.setName("AllowPlanetFlags");
        rangesBox.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        rangesBox.add(new JLabel("Disallowed Planet Flags:", 11));
        this.BaseTextField.setToolTipText("<html>Flags the planet cannot have for this op to be allowed.<br>Delimit/Sperate with ^ Example AA^BB^CC</html>");
        this.BaseTextField.setName("DisallowPlanetFlags");
        rangesBox.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        rangesBox.add(new JLabel("Max ELO Difference:", 11));
        this.BaseTextField.setToolTipText("<html>The Max Difference in ELO between the attacker and the defender</html>");
        this.BaseTextField.setName("MaxELODifference");
        rangesBox.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        rangesBox.add(new JLabel("Min SubFaction Access Level:", 11));
        this.BaseTextField.setToolTipText("<html>Your SubFactionAcessLevel must be this high to ride.<br>Default 0</html>");
        this.BaseTextField.setName("MinSubFactionAccessLevel");
        rangesBox.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        rangesBox.add(new JLabel("Max BV Difference:", 11));
        this.BaseTextField.setToolTipText("<html>Max BV difference between attacker and defender.<br>Default 150</html>");
        this.BaseTextField.setName("MaxBVDifference");
        rangesBox.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        rangesBox.add(new JLabel("Max % BV Difference:", 11));
        this.BaseTextField.setToolTipText("<html>Double Field. Max % BV diffence between Attacker and defneder.<br>Example .05 = 5% 1.5 = 150%. Default = 0%</html>");
        this.BaseTextField.setName("MaxBVPercent");
        rangesBox.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        rangesBox.add(new JLabel("Night Chance:", 11));
        this.BaseTextField.setToolTipText("<html>% chance operation will occur at night. Default 0</html>");
        this.BaseTextField.setName("NightChance");
        rangesBox.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        rangesBox.add(new JLabel("Dusk Chance:", 11));
        this.BaseTextField.setToolTipText("<html>% Chance operation will occur at dusk.  Default 0%</html>");
        this.BaseTextField.setName("DuskChance");
        rangesBox.add(this.BaseTextField);
        this.BaseCheckBox = new JCheckBox("Must Have Fac");
        this.BaseCheckBox.setToolTipText("<html>If checked, attack type may only be used against<br>a world which has a production facility.</html>");
        this.BaseCheckBox.setName("OnlyAgainstFactoryWorlds");
        rangesBox2.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("May Not Have Fac");
        this.BaseCheckBox.setToolTipText("<html>If checked, attack type may only be used against<br>a world which has NO production facilities.</html>");
        this.BaseCheckBox.setName("OnlyAgainstNonFactoryWorlds");
        rangesBox2.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Must Have Home");
        this.BaseCheckBox.setToolTipText("<html>If checked, attack type may only be used against<br>a world that is set as a homeworld.</html>");
        this.BaseCheckBox.setName("OnlyAgainstHomeWorlds");
        rangesBox2.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("May Not Have Home");
        this.BaseCheckBox.setToolTipText("<html>If checked, attack type may only be used against<br>a world which has not been labeled as a homeworld.</html>");
        this.BaseCheckBox.setName("OnlyAgainstNonHomeWorlds");
        rangesBox2.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Real Blind Drop");
        this.BaseCheckBox.setToolTipText("<html>If checked the operation will play in<br>real blind drop and double blind mode</html>");
        this.BaseCheckBox.setName("RealBlindDrop");
        rangesBox2.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Report Op To News Feed");
        this.BaseCheckBox.setToolTipText("<html>This will send the op info to the servers newsfeed file.</html>");
        this.BaseCheckBox.setName("ReportOpToNewsFeed");
        rangesBox2.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Doesn't Count Toward PP");
        this.BaseCheckBox.setToolTipText("<html>Armies that are only legal for this op will not produce components.</html>");
        this.BaseCheckBox.setName("DoesNotCountForPP");
        rangesBox2.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Forbid Counterattacks");
        this.BaseCheckBox.setToolTipText("<html>Check to stop players from using this attack if under attack themselves.</html>");
        this.BaseCheckBox.setName("ForbidCounterAttacks");
        rangesBox2.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("AFR Only");
        this.BaseCheckBox.setToolTipText("Check to stop players on active duty from using this attack (AFR only).");
        this.BaseCheckBox.setName("OnlyAllowedFromReserve");
        rangesBox2.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Active Only");
        this.BaseCheckBox.setToolTipText("Check to stop players on reserve duty from using this attack (No AFR).");
        this.BaseCheckBox.setName("OnlyAllowedFromActive");
        rangesBox2.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Debug Op");
        this.BaseCheckBox.setToolTipText("<html>This will help send debug message to the Error logs for ops to debug ops.</html>");
        this.BaseCheckBox.setName("DebugOp");
        rangesBox2.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Individual Initiative");
        this.BaseCheckBox.setToolTipText("<html>Set Individual Initiative for MegaMek Games</html>");
        this.BaseCheckBox.setName("IndividualInit");
        rangesBox2.add(this.BaseCheckBox);
        SpringLayoutHelper.setupSpringGrid(rangesBox, 4);
        SpringLayoutHelper.setupSpringGrid(rangesBox2, 3);
        rangesmasterBox.add(rangesBox);
        rangesmasterBox.add(rangesBox2);
        rangePanel.add(rangesmasterBox);
        JPanel factionsBox = new JPanel(new SpringLayout());
        JPanel factionsmasterBox = new JPanel();
        factionsmasterBox.setLayout(new BoxLayout(factionsmasterBox, 1));
        this.BaseTextField = new JTextField(5);
        factionsBox.add(new JLabel("Legal Attack Factions:", 11));
        this.BaseTextField.setToolTipText("<html>Factions which may use this attack. Separate with $'s<br>Example: Liao$Davion$<br>Only add $ if you have more then one faction listed.</html>");
        this.BaseTextField.setName("LegalAttackFactions");
        factionsBox.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        factionsBox.add(new JLabel("Illegal Attack Factions:", 11));
        this.BaseTextField.setToolTipText("<html>Factions which may NOT use this attack. Separate with $'s.<br>Only used if Legal is blank.<br>Example: Pirates$Bandits<br>Only add $ if you have more then one faction listed.</html>");
        this.BaseTextField.setName("IllegalAttackFactions");
        factionsBox.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        factionsBox.add(new JLabel("Legal Defense Factions:", 11));
        this.BaseTextField.setToolTipText("<html>Factions which may defend against this attack. Separate with $'s<br>Example: Marik$Kurita$Steiner<br>Only add $ if you have more then one faction listed.</html>");
        this.BaseTextField.setName("LegalDefendFactions");
        factionsBox.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        factionsBox.add(new JLabel("Illegal Defense Factions:", 11));
        this.BaseTextField.setToolTipText("<html>Factions which may NOT defend this attack. Separate with $'s.<br>Only used if Legal is blank.<br>Example: Solaris Training Company$Periphery<br>Only add $ if you have more then one faction listed.</html>");
        this.BaseTextField.setName("IllegalDefendFactions");
        factionsBox.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(factionsBox, 4);
        factionsmasterBox.add(factionsBox);
        factionPanel.add(factionsmasterBox);
        JPanel unitBox = new JPanel();
        JPanel masterBox = new JPanel();
        unitBox.setLayout(new BoxLayout(unitBox, 0));
        masterBox.setLayout(new BoxLayout(masterBox, 1));
        JPanel attackerBox = new JPanel();
        attackerBox.setLayout(new BoxLayout(attackerBox, 1));
        JPanel defenderBox = new JPanel();
        defenderBox.setLayout(new BoxLayout(defenderBox, 1));
        JPanel spreadPanel = new JPanel(new SpringLayout());
        JPanel attackerPanel = new JPanel(new SpringLayout());
        JPanel attackerCBoxPanel = new JPanel(new SpringLayout());
        JPanel defenderPanel = new JPanel(new SpringLayout());
        JPanel defenderCBoxPanel = new JPanel(new SpringLayout());
        this.BaseCheckBox = new JCheckBox("Proto Grouping");
        this.BaseCheckBox.setToolTipText("<html>If enabled, protos must be moved in movement groups. For example, an<br> army w/ 4 protos will be ilelgal if they move in groups of 5</html>");
        this.BaseCheckBox.setName("ProtosMustbeGrouped");
        spreadPanel.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Mul Armies Only");
        this.BaseCheckBox.setToolTipText("<html>If enabled players can go active without armies as they will be provided with muls.</html>");
        this.BaseCheckBox.setName("MULArmiesOnly");
        spreadPanel.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Count Vehs in Spread");
        this.BaseCheckBox.setToolTipText("If true, vehicles are included when checking BV spreads between high/low units.");
        this.BaseCheckBox.setName("CountVehsForSpread");
        spreadPanel.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Count Aeros in Spread");
        this.BaseCheckBox.setToolTipText("If true, aeros are included when checking BV spreads between high/low units.");
        this.BaseCheckBox.setName("CountAerosForSpread");
        spreadPanel.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Count Protos in Spread");
        this.BaseCheckBox.setToolTipText("If true, protos are included when checking BV spreads between high/low units.");
        this.BaseCheckBox.setName("CountProtosForSpread");
        spreadPanel.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Count Inf in Spread");
        this.BaseCheckBox.setToolTipText("If true, infantry and BA are included when checking BV spreads between high/low units.");
        this.BaseCheckBox.setName("CountInfForSpread");
        spreadPanel.add(this.BaseCheckBox);
        this.BaseTextField = new JTextField(5);
        spreadPanel.add(new JLabel("Repod Omni to Base:", 11));
        this.BaseTextField.setToolTipText("<HTML>String. Omni's that where used in this op are repodded<br>back to this base configuration.<br>Leave blank to disable this option </HTML>");
        this.BaseTextField.setName("RepodOmniUnitsToBase");
        spreadPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(spreadPanel, 2);
        this.BaseCheckBox = new JCheckBox("Allow Meks");
        this.BaseCheckBox.setToolTipText("Allow meks in this operation for the attacker");
        this.BaseCheckBox.setName("AttackerAllowedMeks");
        attackerCBoxPanel.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Allow Veh");
        this.BaseCheckBox.setToolTipText("Allow Vehciles in this operation for the attacker");
        this.BaseCheckBox.setName("AttackerAllowedVehs");
        attackerCBoxPanel.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Allow Aero");
        this.BaseCheckBox.setToolTipText("Allow Aeros in this operation for the attacker");
        this.BaseCheckBox.setName("AttackerAllowedAeros");
        attackerCBoxPanel.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Allow Inf");
        this.BaseCheckBox.setToolTipText("Allow Infantry in this operation for the attacker");
        this.BaseCheckBox.setName("AttackerAllowedInf");
        attackerCBoxPanel.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Powered Inf");
        this.BaseCheckBox.setToolTipText("<html>Overrides Allow Infantry and allows BA and Protos.<br>Set inf allowed to False and this to True to ban<br>foot/jump/moto inf but allow BA and Protos.</html>");
        this.BaseCheckBox.setName("AttackerPoweredInfAllowed");
        attackerCBoxPanel.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Standard Inf");
        this.BaseCheckBox.setToolTipText("<html>Overrides Allow Infantry and allows foot/moto/jump units.<br>Set inf allowed to False and this to True to BA/Protos<br>but allow foot/jump/moto inf.</html>");
        this.BaseCheckBox.setName("AttackerStandardInfAllowed");
        attackerCBoxPanel.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("OmniMeks Only");
        this.BaseCheckBox.setToolTipText("Attackers mechs must be OmniMeks");
        this.BaseCheckBox.setName("AttackerOmniMeksOnly");
        attackerCBoxPanel.add(this.BaseCheckBox);
        SpringLayoutHelper.setupSpringGrid(attackerCBoxPanel, 2);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Max BV:", 11));
        this.BaseTextField.setToolTipText("Max BV for the Attackers Army");
        this.BaseTextField.setName("MaxAttackerBV");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Min BV:", 11));
        this.BaseTextField.setToolTipText("Min BV for the Attackers Army");
        this.BaseTextField.setName("MinAttackerBV");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Max Meks:", 11));
        this.BaseTextField.setToolTipText("Max number of Meks in the attackers army");
        this.BaseTextField.setName("MaxAttackerMeks");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Min Meks:", 11));
        this.BaseTextField.setToolTipText("Min number of Meks in the attackers army");
        this.BaseTextField.setName("MinAttackerMeks");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Max Vehicles:", 11));
        this.BaseTextField.setToolTipText("Max number of Vehicles in the attackers army");
        this.BaseTextField.setName("MaxAttackerVehicles");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Min Vehicles:", 11));
        this.BaseTextField.setToolTipText("Min number of Vehicles in the attackers army");
        this.BaseTextField.setName("MinAttackerVehicles");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Max Aero:", 11));
        this.BaseTextField.setToolTipText("Max number of Aero in the attackers army");
        this.BaseTextField.setName("MaxAttackerAero");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Min Aero:", 11));
        this.BaseTextField.setToolTipText("Min number of Aero in the attackers army");
        this.BaseTextField.setName("MinAttackerAero");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Max Non-Infantry:", 11));
        this.BaseTextField.setToolTipText("<html>Max number of Non-Infantry in the attackers army<br>Includes Meks and Vehicles</html>");
        this.BaseTextField.setName("MaxAttackerNonInfantry");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Min Non-Infantry:", 11));
        this.BaseTextField.setToolTipText("<html>Min number of Non-Infantry in the attackers army<br>Includes Meks and Vehicles</html>");
        this.BaseTextField.setName("MinAttackerNonInfantry");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Max Infantry:", 11));
        this.BaseTextField.setToolTipText("<html>Max number of Infantry in the attackers army<br>Includes non-Powered, BA, and ProtoMeks</html>");
        this.BaseTextField.setName("MaxAttackerInfantry");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Min Infantry:", 11));
        this.BaseTextField.setToolTipText("<html>Min number of Infantry in the attackers army<br>Includes non-Powered, BA, and ProtoMeks</html>");
        this.BaseTextField.setName("MinAttackerInfantry");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Min Walk:", 11));
        this.BaseTextField.setToolTipText("<html>Min number of movement points, i.e. Walking,<br>that any unit in the attackers army can have<br>to participate in this operation</html>");
        this.BaseTextField.setName("MinAttackerWalk");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Min Jump:", 11));
        this.BaseTextField.setToolTipText("<html>Min number of jump points<br>that any unit in the attackers army can have<br>to participate in this operation</html>");
        this.BaseTextField.setName("MinAttackerJump");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Max Unit Tons:", 11));
        this.BaseTextField.setToolTipText("Max Tons any unit in the attackers army can have for this op");
        this.BaseTextField.setName("MaxAttackerUnitTonnage");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Min Unit Tons:", 11));
        this.BaseTextField.setToolTipText("Min Tons any unit in the attackers army maybe for this op");
        this.BaseTextField.setName("MinAttackerUnitTonnage");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Max Total Tons:", 11));
        this.BaseTextField.setToolTipText("Max Total Tonnage for an army to run this op");
        this.BaseTextField.setName("MaxTotalAttackerTonnage");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Min Total Tons:", 11));
        this.BaseTextField.setToolTipText("Min Total Tonnage for an army to run this op");
        this.BaseTextField.setName("MinTotalAttackerTonnage");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Max Unit BV:", 11));
        this.BaseTextField.setToolTipText("Min Tons any unit in the attackers army maybe for this op");
        this.BaseTextField.setName("MaxAttackerUnitBV");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Min Unit BV:", 11));
        this.BaseTextField.setToolTipText("Min Tons any unit in the attackers army maybe for this op");
        this.BaseTextField.setName("MinAttackerUnitBV");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Max BV Spread:", 11));
        this.BaseTextField.setToolTipText("Max BV difference between the highest and lowest counted units.");
        this.BaseTextField.setName("MaxAttackerUnitBVSpread");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Min BV Spread:", 11));
        this.BaseTextField.setToolTipText("Min BV difference between the highest and lowest counted units.");
        this.BaseTextField.setName("MinAttackerUnitBVSpread");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Highest Pilot Skill:", 11));
        this.BaseTextField.setToolTipText("<html>Highest total skill, Gunnery + Piloting, that an<br>attacking Units pilot can have<br>NOTE: Units will not be checked if they<br>are not counted for the BV Spread</html>");
        this.BaseTextField.setName("HighestAttackerPilotSkillTotal");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Lowest Pilot Skill:", 11));
        this.BaseTextField.setToolTipText("<html>Lowest total skill, Gunnery + Piloting, that an<br>attacking Units pilot can have<br>NOTE: Units will not be checked if they<br>are not counted for the BV Spread</html>");
        this.BaseTextField.setName("LowestAttackerPilotSkillTotal");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Highest Piloting:", 11));
        this.BaseTextField.setToolTipText("<html>Highest Piloting that an<br>attacking Units pilot can have<br>NOTE: Units will not be checked if they<br>are not counted for the BV Spread</html>");
        this.BaseTextField.setName("HighestAttackerPiloting");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Lowest Piloting:", 11));
        this.BaseTextField.setToolTipText("<html>Lowest Piloting that an<br>attacking Units pilot can have<br>NOTE: Units will not be checked if they<br>are not counted for the BV Spread</html>");
        this.BaseTextField.setName("LowestAttackerPiloting");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Highest Gunnery:", 11));
        this.BaseTextField.setToolTipText("<html>Highest Gunnery that an<br>attacking Units pilot can have<br>NOTE: Units will not be checked if they<br>are not counted for the BV Spread</html>");
        this.BaseTextField.setName("HighestAttackerGunnery");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Lowest Gunnery:", 11));
        this.BaseTextField.setToolTipText("<html>Lowest Gunnery that an<br>attacking Units pilot can have<br>NOTE: Units will not be checked if they<br>are not counted for the BV Spread</html>");
        this.BaseTextField.setName("LowestAttackerGunnery");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Average Army Skill Max:", 11));
        this.BaseTextField.setToolTipText("<html>Max Average piloting skills a attacking army can have<br>NOTE: Units will not be checked if they<br>are not counted for the BV Spread</html>");
        this.BaseTextField.setName("AttackerAverageArmySkillMax");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Average Army Skill Min:", 11));
        this.BaseTextField.setToolTipText("<html>Min Average piloting skills a attacking army can have<br>NOTE: Units will not be checked if they<br>are not counted for the BV Spread</html>");
        this.BaseTextField.setName("AttackerAverageArmySkillMin");
        attackerPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(attackerPanel, 4);
        this.BaseCheckBox = new JCheckBox("Allow Meks");
        this.BaseCheckBox.setToolTipText("Allow Defender to use Meks in this op");
        this.BaseCheckBox.setName("DefenderAllowedMeks");
        defenderCBoxPanel.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Allow Veh");
        this.BaseCheckBox.setToolTipText("Allow Defender to use Vehicles in this Op");
        this.BaseCheckBox.setName("DefenderAllowedVehs");
        defenderCBoxPanel.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Allow Aero");
        this.BaseCheckBox.setToolTipText("Allow Defender to use Aeros in this Op");
        this.BaseCheckBox.setName("DefenderAllowedAeros");
        defenderCBoxPanel.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Allow Inf");
        this.BaseCheckBox.setToolTipText("Allow Defender to use infantry in this Op");
        this.BaseCheckBox.setName("DefenderAllowedInf");
        defenderCBoxPanel.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Powered Inf");
        this.BaseCheckBox.setToolTipText("<html>Overrides Allow Infantry and allows BA and Protos.<br>Set inf allowed to False and this to True to ban<br>foot/jump/moto inf but allow BA and Protos.</html>");
        this.BaseCheckBox.setName("DefenderPoweredInfAllowed");
        defenderCBoxPanel.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Standard Inf");
        this.BaseCheckBox.setToolTipText("<html>Overrides Allow Infantry and allows foot/moto/jump units.<br>Set inf allowed to False and this to True to BA/Protos<br>but allow foot/jump/moto inf.</html>");
        this.BaseCheckBox.setName("DefenderStandardInfAllowed");
        defenderCBoxPanel.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("OmniMeks Only");
        this.BaseCheckBox.setToolTipText("Defenders mechs must be OmniMeks");
        this.BaseCheckBox.setName("DefenderOmniMeksOnly");
        defenderCBoxPanel.add(this.BaseCheckBox);
        SpringLayoutHelper.setupSpringGrid(defenderCBoxPanel, 2);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Max BV:", 11));
        this.BaseTextField.setToolTipText("Max BV the defenders army can be for this Op");
        this.BaseTextField.setName("MaxDefenderBV");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Min BV:", 11));
        this.BaseTextField.setToolTipText("Min BV the defenders army can be for this Op");
        this.BaseTextField.setName("MinDefenderBV");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Max Meks:", 11));
        this.BaseTextField.setToolTipText("Max Number of Meks a Defender my use in this op");
        this.BaseTextField.setName("MaxDefenderMeks");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Min Meks:", 11));
        this.BaseTextField.setToolTipText("Min number of Meks a defender must use in this op");
        this.BaseTextField.setName("MinDefenderMeks");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Max Vehicles:", 11));
        this.BaseTextField.setToolTipText("Max Number of Vehicles a Defender my use in this op");
        this.BaseTextField.setName("MaxDefenderVehicles");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Min Vehicles:", 11));
        this.BaseTextField.setToolTipText("Min number of Vehicles a defender must use in this op");
        this.BaseTextField.setName("MinDefenderVehicles");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Max Aero:", 11));
        this.BaseTextField.setToolTipText("Max Number of Aero a Defender my use in this op");
        this.BaseTextField.setName("MaxDefenderAero");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Min Aero:", 11));
        this.BaseTextField.setToolTipText("Min number of Aero a defender must use in this op");
        this.BaseTextField.setName("MinDefenderAero");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Max Non-Infantry:", 11));
        this.BaseTextField.setToolTipText("<html>Max Number of Non-Infantry a Defender my use in this op<br>This includes Meks and Vehicles</html>");
        this.BaseTextField.setName("MaxDefenderNonInfantry");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Min Non-Infantry:", 11));
        this.BaseTextField.setToolTipText("<html>Min number of Non-Infantry a defender must use in this op<br>This includes Meks and Vehicles</html>");
        this.BaseTextField.setName("MinDefenderNonInfantry");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Max Infantry:", 11));
        this.BaseTextField.setToolTipText("<html>Max Number of Infantry a Defender my use in this op<br>This includes non-Powered Infantry, BA, and ProtoMeks</html>");
        this.BaseTextField.setName("MaxDefenderInfantry");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Min Infantry:", 11));
        this.BaseTextField.setToolTipText("<html>Min number of Infantry a defender must use in this op<br>This includes non-Powered Infantry, BA, and ProtoMeks</html>");
        this.BaseTextField.setName("MinDefenderInfantry");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Min Walk:", 11));
        this.BaseTextField.setToolTipText("<html>Min number of movement points, i.e. Walking,<br>that any unit in the defenders army can have<br>to participate in this operation</html>");
        this.BaseTextField.setName("MinDefenderWalk");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Min Jump:", 11));
        this.BaseTextField.setToolTipText("<html>Min number of jump points<br>that any unit in the defenders army can have<br>to participate in this operation</html>");
        this.BaseTextField.setName("MinDefenderJump");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Max Unit Tons:", 11));
        this.BaseTextField.setToolTipText("Max Tonnage any unit in the defenders army may have for this op");
        this.BaseTextField.setName("MaxDefenderUnitTonnage");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Min Unit Tons", 11));
        this.BaseTextField.setToolTipText("Min tonnage any unit in the defeneders army may have for this op");
        this.BaseTextField.setName("MinDefenderUnitTonnage");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Max Total Tons", 11));
        this.BaseTextField.setToolTipText("Max Tonnage for the defenders army for this op");
        this.BaseTextField.setName("MaxTotalDefenderTonnage");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Min Total Tons", 11));
        this.BaseTextField.setToolTipText("Min Total the defenders army may have for this op");
        this.BaseTextField.setName("MinTotalDefenderTonnage");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Max Unit BV:", 11));
        this.BaseTextField.setToolTipText("Min Tons any unit in the attackers army maybe for this op");
        this.BaseTextField.setName("MaxDefenderUnitBV");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Min Unit BV:", 11));
        this.BaseTextField.setToolTipText("Min Tons any unit in the attackers army maybe for this op");
        this.BaseTextField.setName("MinDefenderUnitBV");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Max BV Spread:", 11));
        this.BaseTextField.setToolTipText("Max BV difference between the highest and lowest counted units.");
        this.BaseTextField.setName("MaxDefenderUnitBVSpread");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Min BV Spread:", 11));
        this.BaseTextField.setToolTipText("Min BV difference between the highest and lowest counted units.");
        this.BaseTextField.setName("MinDefenderUnitBVSpread");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Highest Pilot Skill:", 11));
        this.BaseTextField.setToolTipText("<html>Highest total skill, Gunnery + Piloting, that a<br>defending Units pilot can have<br>NOTE: Units will not be checked if they<br>are not counted for the BV Spread</html>");
        this.BaseTextField.setName("HighestDefenderPilotSkillTotal");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Lowest Pilot Skill:", 11));
        this.BaseTextField.setToolTipText("<html>Lowest total skill, Gunnery + Piloting, that a<br>defending Units pilot can have<br>NOTE: Units will not be checked if they<br>are not counted for the BV Spread</html>");
        this.BaseTextField.setName("LowestDefenderPilotSkillTotal");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Highest Piloting:", 11));
        this.BaseTextField.setToolTipText("<html>Highest Piloting that a<br>defending Units pilot can have<br>NOTE: Units will not be checked if they<br>are not counted for the BV Spread</html>");
        this.BaseTextField.setName("HighestDefenderPiloting");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Lowest Piloting:", 11));
        this.BaseTextField.setToolTipText("<html>Lowest Piloting that a<br>defending Units pilot can have<br>NOTE: Units will not be checked if they<br>are not counted for the BV Spread</html>");
        this.BaseTextField.setName("LowestDefenderPiloting");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Highest Gunnery:", 11));
        this.BaseTextField.setToolTipText("<html>Highest Gunnery that a<br>defending Units pilot can have<br>NOTE: Units will not be checked if they<br>are not counted for the BV Spread</html>");
        this.BaseTextField.setName("HighestDefenderGunnery");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Lowest Gunnery:", 11));
        this.BaseTextField.setToolTipText("<html>Lowest Gunnery that a<br>defending Units pilot can have<br>NOTE: Units will not be checked if they<br>are not counted for the BV Spread</html>");
        this.BaseTextField.setName("LowestDefenderGunnery");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Average Army Skill Max:", 11));
        this.BaseTextField.setToolTipText("<html>Max Average piloting skills a defending army can have<br>NOTE: Units will not be checked if they<br>are not counted for the BV Spread</html>");
        this.BaseTextField.setName("DefenderAverageArmySkillMax");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Average Army Skill Min:", 11));
        this.BaseTextField.setToolTipText("<html>Min Average piloting skills a defending army can have<br>NOTE: Units will not be checked if they<br>are not counted for the BV Spread</html>");
        this.BaseTextField.setName("DefenderAverageArmySkillMin");
        defenderPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(defenderPanel, 4);
        attackerBox.add(new JLabel("Attacker"));
        attackerBox.add(attackerCBoxPanel);
        attackerBox.add(attackerPanel);
        attackerBox.setBorder(BorderFactory.createLineBorder(Color.black));
        defenderBox.add(new JLabel("Defender"));
        defenderBox.add(defenderCBoxPanel);
        defenderBox.add(defenderPanel);
        defenderBox.setBorder(BorderFactory.createLineBorder(Color.black));
        unitBox.add(attackerBox);
        unitBox.add(defenderBox);
        masterBox.add(spreadPanel);
        masterBox.add(unitBox);
        unitsPanel.add(masterBox);
        JPanel costBox = new JPanel();
        costBox.setLayout(new BoxLayout(costBox, 0));
        attackerBox = new JPanel();
        attackerBox.setLayout(new BoxLayout(attackerBox, 1));
        defenderBox = new JPanel();
        defenderBox.setLayout(new BoxLayout(defenderBox, 1));
        attackerPanel = new JPanel(new SpringLayout());
        defenderPanel = new JPanel(new SpringLayout());
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Cost Money:", 11));
        this.BaseTextField.setToolTipText("What it costs the attacker, in money, to preform this op");
        this.BaseTextField.setName("AttackerCostMoney");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Cost Flu:", 11));
        this.BaseTextField.setToolTipText("What it costs the attacker, in flu, to preform this op");
        this.BaseTextField.setName("AttackerCostInfluence");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Cost Rewards:", 11));
        this.BaseTextField.setToolTipText("What it costs the attacker, in reward points, to preform this op");
        this.BaseTextField.setName("AttackerCostReward");
        attackerPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(attackerPanel, 3, 2);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Cost Money:", 11));
        this.BaseTextField.setToolTipText("What it costs the defender, in money, to preform this op");
        this.BaseTextField.setName("DefenderCostMoney");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Cost Flu:", 11));
        this.BaseTextField.setToolTipText("What it costs the defender, in flu, to preform this op");
        this.BaseTextField.setName("DefenderCostInfluence");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Cost Rewards:", 11));
        this.BaseTextField.setToolTipText("What it costs the defender, in reward points, to preform this op");
        this.BaseTextField.setName("DefenderCostReward");
        defenderPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(defenderPanel, 3, 2);
        attackerBox.add(new JLabel("Attacker"));
        attackerBox.add(attackerPanel);
        attackerBox.setBorder(BorderFactory.createLineBorder(Color.black));
        defenderBox.add(new JLabel("Defender"));
        defenderBox.add(defenderPanel);
        defenderBox.setBorder(BorderFactory.createLineBorder(Color.black));
        costBox.add(attackerBox);
        costBox.add(defenderBox);
        costsPanel.add(costBox);
        JPanel playerPropertiesBox = new JPanel();
        playerPropertiesBox.setLayout(new BoxLayout(playerPropertiesBox, 0));
        attackerBox = new JPanel();
        attackerBox.setLayout(new BoxLayout(attackerBox, 1));
        defenderBox = new JPanel();
        defenderBox.setLayout(new BoxLayout(defenderBox, 1));
        attackerPanel = new JPanel(new SpringLayout());
        defenderPanel = new JPanel(new SpringLayout());
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Min Rating:", 11));
        this.BaseTextField.setToolTipText("Min Rating Attacker must have for this op");
        this.BaseTextField.setName("MinAttackerRating");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Max Rating:", 11));
        this.BaseTextField.setToolTipText("Max Rating Attacker must have for this op");
        this.BaseTextField.setName("MaxAttackerRating");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Min Exp:", 11));
        this.BaseTextField.setToolTipText("Min Exp Attacker must have for this op");
        this.BaseTextField.setName("MinAttackerXP");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Max Exp:", 11));
        this.BaseTextField.setToolTipText("Max Exp Attacker must have for this op");
        this.BaseTextField.setName("MaxAttackerXP");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Min Games:", 11));
        this.BaseTextField.setToolTipText("Min Games Attacker must have played for this op");
        this.BaseTextField.setName("MinAttackerGamesPlayed");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Max Games:", 11));
        this.BaseTextField.setToolTipText("Max Games Attacker must have played for this op");
        this.BaseTextField.setName("MaxAttackerGamesPlayed");
        attackerPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(attackerPanel, 6, 2);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Min Rating:", 11));
        this.BaseTextField.setToolTipText("Min Rating Defender must have for this op");
        this.BaseTextField.setName("MinDefenderRating");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Max Rating:", 11));
        this.BaseTextField.setToolTipText("Max Rating Defender must have for this op");
        this.BaseTextField.setName("MaxDefenderRating");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Min Exp:", 11));
        this.BaseTextField.setToolTipText("Min Exp Defender must have for this op");
        this.BaseTextField.setName("MinDefenderXP");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Max Exp:", 11));
        this.BaseTextField.setToolTipText("Max Exp Defender must have for this op");
        this.BaseTextField.setName("MaxDefenderXP");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Min Games:", 11));
        this.BaseTextField.setToolTipText("Min Games Defender must have played for this op");
        this.BaseTextField.setName("MinDefenderGamesPlayed");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Max Games:", 11));
        this.BaseTextField.setToolTipText("Max Games Defender must have played for this op");
        this.BaseTextField.setName("MaxDefenderGamesPlayed");
        defenderPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(defenderPanel, 6, 2);
        attackerBox.add(new JLabel("Attacker"));
        attackerBox.add(attackerPanel);
        attackerBox.setBorder(BorderFactory.createLineBorder(Color.black));
        defenderBox.add(new JLabel("Defender"));
        defenderBox.add(defenderPanel);
        defenderBox.setBorder(BorderFactory.createLineBorder(Color.black));
        playerPropertiesBox.add(attackerBox);
        playerPropertiesBox.add(defenderBox);
        playerPropertiesPanel.add(playerPropertiesBox);
        Dimension boxSize = new Dimension(199, 110);
        masterBox = new JPanel();
        masterBox.setLayout(new BoxLayout(masterBox, 1));
        JPanel scenarioBox = new JPanel();
        scenarioBox.setLayout(new BoxLayout(scenarioBox, 0));
        JPanel scenarioBox2 = new JPanel();
        scenarioBox2.setLayout(new BoxLayout(scenarioBox2, 0));
        JPanel scenarioBox3 = new JPanel();
        scenarioBox3.setLayout(new BoxLayout(scenarioBox3, 0));
        JPanel scenarioBox4 = new JPanel();
        scenarioBox4.setLayout(new BoxLayout(scenarioBox4, 0));
        JPanel scenarioBox5 = new JPanel();
        scenarioBox5.setLayout(new BoxLayout(scenarioBox5, 0));
        attackerBox = new JPanel();
        attackerBox.setLayout(new BoxLayout(attackerBox, 1));
        defenderBox = new JPanel();
        defenderBox.setLayout(new BoxLayout(defenderBox, 1));
        attackerPanel = new JPanel(new SpringLayout());
        defenderPanel = new JPanel(new SpringLayout());
        attackerPanel.setPreferredSize(boxSize);
        attackerPanel.setMaximumSize(boxSize);
        attackerPanel.setMinimumSize(boxSize);
        defenderPanel.setPreferredSize(boxSize);
        defenderPanel.setMaximumSize(boxSize);
        defenderPanel.setMinimumSize(boxSize);
        JPanel attackerTurretBox = new JPanel();
        attackerTurretBox.setLayout(new BoxLayout(attackerTurretBox, 1));
        JPanel defenderTurretBox = new JPanel();
        defenderTurretBox.setLayout(new BoxLayout(defenderTurretBox, 1));
        JPanel attackerTurretPanel = new JPanel(new SpringLayout());
        JPanel defenderTurretPanel = new JPanel(new SpringLayout());
        attackerTurretPanel.setPreferredSize(boxSize);
        attackerTurretPanel.setMaximumSize(boxSize);
        attackerTurretPanel.setMinimumSize(boxSize);
        defenderTurretPanel.setPreferredSize(boxSize);
        defenderTurretPanel.setMaximumSize(boxSize);
        defenderTurretPanel.setMinimumSize(boxSize);
        JPanel attackerMineBox = new JPanel();
        attackerMineBox.setLayout(new BoxLayout(attackerMineBox, 1));
        JPanel defenderMineBox = new JPanel();
        defenderMineBox.setLayout(new BoxLayout(defenderMineBox, 1));
        JPanel BotsBox = new JPanel();
        BotsBox.setLayout(new BoxLayout(BotsBox, 1));
        JPanel BotsPanel = new JPanel(new SpringLayout());
        JPanel attackerMinePanel = new JPanel(new SpringLayout());
        JPanel defenderMinePanel = new JPanel(new SpringLayout());
        attackerMinePanel.setPreferredSize(boxSize);
        attackerMinePanel.setMaximumSize(boxSize);
        attackerMinePanel.setMinimumSize(boxSize);
        defenderMinePanel.setPreferredSize(boxSize);
        defenderMinePanel.setMaximumSize(boxSize);
        defenderMinePanel.setMinimumSize(boxSize);
        JPanel attackerMULBox = new JPanel();
        attackerMULBox.setLayout(new BoxLayout(attackerMULBox, 1));
        JPanel defenderMULBox = new JPanel();
        defenderMULBox.setLayout(new BoxLayout(defenderMULBox, 1));
        JPanel attackerMULPanel = new JPanel(new SpringLayout());
        JPanel defenderMULPanel = new JPanel(new SpringLayout());
        attackerMULPanel.setPreferredSize(boxSize);
        attackerMULPanel.setMaximumSize(boxSize);
        attackerMULPanel.setMinimumSize(boxSize);
        defenderMULPanel.setPreferredSize(boxSize);
        defenderMULPanel.setMaximumSize(boxSize);
        defenderMULPanel.setMinimumSize(boxSize);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Flat Artillery:", 11));
        this.BaseTextField.setToolTipText("Amount of BV to shift attacker");
        this.BaseTextField.setName("AttackerFlatArtilleryModifier");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Perecent Artillery:", 11));
        this.BaseTextField.setToolTipText("<html>% adjustment to relative assignment BV<br>NOTE: this is a double field and percent<br>1 would be normal bv .75 would be 75% of normal<br>1.15 would be a 15% increase of normal bv</html>");
        this.BaseTextField.setName("AttackerPercentArtilleryModifier");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Min BV Artillery:", 11));
        this.BaseTextField.setToolTipText("<html>Min BV to be presumed for attack/defender player<br>hen assigning autoartillery. Floor for modifiers.</html>");
        this.BaseTextField.setName("MinAttackerArtilleryBV");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Max BV Artillery:", 11));
        this.BaseTextField.setToolTipText("<html>Max BV to be presumed for attack/def player when<br>assigning artillery. Ceiling for modifiers.</html>");
        this.BaseTextField.setName("MaxAttackerArtilleryBV");
        attackerPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(attackerPanel, 4, 2);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Flat Artillery:", 11));
        this.BaseTextField.setToolTipText("Amount of BV to shift defender");
        this.BaseTextField.setName("DefenderFlatArtilleryModifier");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Perecent Artillery:", 11));
        this.BaseTextField.setToolTipText("% adjustment to relative assignment BV");
        this.BaseTextField.setName("DefenderPercentArtilleryModifier");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Min BV Artillery:", 11));
        this.BaseTextField.setToolTipText("<html>Min BV to be presumed for defend/defender player<br>hen assigning autoartillery. Floor for modifiers.</html>");
        this.BaseTextField.setName("MinDefenderArtilleryBV");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Max BV Artillery:", 11));
        this.BaseTextField.setToolTipText("<html>Max BV to be presumed for defend/def player when<br>assigning artillery. Ceiling for modifiers.</html>");
        this.BaseTextField.setName("MaxDefenderArtilleryBV");
        defenderPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(defenderPanel, 4, 2);
        attackerBox.add(new JLabel("Attacker"));
        this.BaseCheckBox = new JCheckBox("Artillery");
        this.BaseCheckBox.setToolTipText("<html>If true, attack players will receive<br>normal autoartillery. Set false to make the<br>grant lopsided.</html>");
        this.BaseCheckBox.setName("AttackerReceivesAutoArtillery");
        attackerBox.add(this.BaseCheckBox);
        attackerBox.add(attackerPanel);
        attackerBox.setBorder(BorderFactory.createLineBorder(Color.black));
        defenderBox.add(new JLabel("Defender"));
        this.BaseCheckBox = new JCheckBox("Artillery");
        this.BaseCheckBox.setToolTipText("<html>If true, defend players will receive<br>normal autoartillery. Set false to make the<br>grant lopsided.</html>");
        this.BaseCheckBox.setName("DefenderReceivesAutoArtillery");
        defenderBox.add(this.BaseCheckBox);
        defenderBox.add(defenderPanel);
        defenderBox.setBorder(BorderFactory.createLineBorder(Color.black));
        scenarioBox.add(attackerBox);
        scenarioBox.add(defenderBox);
        this.BaseTextField = new JTextField(5);
        attackerTurretPanel.add(new JLabel("Flat Turret:", 11));
        this.BaseTextField.setToolTipText("Amount of BV to shift attacker");
        this.BaseTextField.setName("AttackerFlatGunEmplacementModifier");
        attackerTurretPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerTurretPanel.add(new JLabel("Perecent Turret:", 11));
        this.BaseTextField.setToolTipText("% adjustment to relative assignment BV");
        this.BaseTextField.setName("AttackerPercentGunEmplacementModifier");
        attackerTurretPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerTurretPanel.add(new JLabel("Min BV Turret:", 11));
        this.BaseTextField.setToolTipText("<html>Min BV to be presumed for attack/defender player<br>when assigning gun emplacements. Floor for modifiers.</html>");
        this.BaseTextField.setName("MinAttackerGunEmplacementBV");
        attackerTurretPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerTurretPanel.add(new JLabel("Max BV Turret:", 11));
        this.BaseTextField.setToolTipText("<html>Max BV to be presumed for attack/def player when<br>assigning gun emplacements. Ceiling for modifiers.</html>");
        this.BaseTextField.setName("MaxAttackerGunEmplacementBV");
        attackerTurretPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(attackerTurretPanel, 4, 2);
        this.BaseTextField = new JTextField(5);
        defenderTurretPanel.add(new JLabel("Flat Turret:", 11));
        this.BaseTextField.setToolTipText("Amount of BV to shift defender");
        this.BaseTextField.setName("DefenderFlatGunEmplacementModifier");
        defenderTurretPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderTurretPanel.add(new JLabel("Perecent Turret:", 11));
        this.BaseTextField.setToolTipText("<html>% adjustment to relative assignment BV<br>NOTE: this is a double field and percent<br>1 would be normal bv .75 would be 75% of normal<br>1.15 would be a 15% increase of normal bv</html>");
        this.BaseTextField.setName("DefenderPercentGunEmplacementModifier");
        defenderTurretPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderTurretPanel.add(new JLabel("Min BV Turret:", 11));
        this.BaseTextField.setToolTipText("<html>Min BV to be presumed for defend/defender player<br>when assigning gun emplacements. Floor for modifiers.</html>");
        this.BaseTextField.setName("MinDefenderGunEmplacementBV");
        defenderTurretPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderTurretPanel.add(new JLabel("Max BV Turret:", 11));
        this.BaseTextField.setToolTipText("<html>Max BV to be presumed for defend/def player when<br>assigning gun emplacements. Ceiling for modifiers.</html>");
        this.BaseTextField.setName("MaxDefenderGunEmplacementBV");
        defenderTurretPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(defenderTurretPanel, 4, 2);
        attackerTurretBox.add(new JLabel("Attacker"));
        this.BaseCheckBox = new JCheckBox("Turret");
        this.BaseCheckBox.setToolTipText("<html>If true, attack players will receive<br>normal gun emplacements. Set false to make the<br>grant lopsided.</html>");
        this.BaseCheckBox.setName("AttackerReceivesGunEmplacement");
        attackerTurretBox.add(this.BaseCheckBox);
        attackerTurretBox.add(attackerTurretPanel);
        attackerTurretBox.setBorder(BorderFactory.createLineBorder(Color.black));
        defenderTurretBox.add(new JLabel("Defender"));
        this.BaseCheckBox = new JCheckBox("Turret");
        this.BaseCheckBox.setToolTipText("<html>If true, defend players will receive<br>normal gun emplacements. Set false to make the<br>grant lopsided.</html>");
        this.BaseCheckBox.setName("DefenderReceivesGunEmplacement");
        defenderTurretBox.add(this.BaseCheckBox);
        defenderTurretBox.add(defenderTurretPanel);
        defenderTurretBox.setBorder(BorderFactory.createLineBorder(Color.black));
        scenarioBox2.add(attackerTurretBox);
        scenarioBox2.add(defenderTurretBox);
        this.BaseTextField = new JTextField(5);
        attackerMinePanel.add(new JLabel("BV Per Conventional:", 11));
        this.BaseTextField.setToolTipText("<html>Set the BV amount for 1 conventional mine i.e set to 100<br>and the total of both armies bv is 10k you get 100 mines</html>");
        this.BaseTextField.setName("AttackerBVPerConventional");
        attackerMinePanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerMinePanel.add(new JLabel("Ton Per Conventional:", 11));
        this.BaseTextField.setToolTipText("<html>Set the Ton amount for 1 conventional mine i.e set to 100<br>and the total of both armies ton is 500 you get 5 mines</html>");
        this.BaseTextField.setName("AttackerTonPerConventional");
        attackerMinePanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerMinePanel.add(new JLabel("BV Per Vibra:", 11));
        this.BaseTextField.setToolTipText("<html>Set the BV amount for 1 vibra mine i.e set to 100<br>and the total of both armies bv is 10k you get 100 mines</html>");
        this.BaseTextField.setName("AttackerBVPerVibra");
        attackerMinePanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerMinePanel.add(new JLabel("Ton Per Vibra:", 11));
        this.BaseTextField.setToolTipText("<html>Set the Ton amount for 1 vibra mine i.e set to 100<br>and the total of both armies ton is 500 you get 5 mines</html>");
        this.BaseTextField.setName("AttackerTonPerVibra");
        attackerMinePanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(attackerMinePanel, 4, 2);
        this.BaseTextField = new JTextField(5);
        defenderMinePanel.add(new JLabel("BV Per Conventional:", 11));
        this.BaseTextField.setToolTipText("<html>Set the BV amount for 1 conventional mine i.e set to 100<br>and the total of both armies bv is 10k you get 100 mines</html>");
        this.BaseTextField.setName("DefenderBVPerConventional");
        defenderMinePanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderMinePanel.add(new JLabel("Ton Per Conventional:", 11));
        this.BaseTextField.setToolTipText("<html>Set the Ton amount for 1 conventional mine i.e set to 100<br>and the total of both armies ton is 500 you get 5 mines</html>");
        this.BaseTextField.setName("DefenderTonPerConventional");
        defenderMinePanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderMinePanel.add(new JLabel("BV Per Vibra:", 11));
        this.BaseTextField.setToolTipText("<html>Set the BV amount for 1 vibra mine i.e set to 100<br>and the total of both armies bv is 10k you get 100 mines</html>");
        this.BaseTextField.setName("DefenderBVPerVibra");
        defenderMinePanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderMinePanel.add(new JLabel("Ton Per Vibra:", 11));
        this.BaseTextField.setToolTipText("<html>Set the Ton amount for 1 vibra mine i.e set to 100<br>and the total of both armies ton is 500 you get 5 mines</html>");
        this.BaseTextField.setName("DefenderTonPerVibra");
        defenderMinePanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(defenderMinePanel, 4, 2);
        attackerMineBox.add(new JLabel("Attacker"));
        this.BaseCheckBox = new JCheckBox("Mine");
        this.BaseCheckBox.setToolTipText("<html>If true, attacking players will receive mines.<br>Set false to make the grant lopsided.</html>");
        this.BaseCheckBox.setName("AttackerReceivesMines");
        attackerMineBox.add(this.BaseCheckBox);
        attackerMineBox.add(attackerMinePanel);
        attackerMineBox.setBorder(BorderFactory.createLineBorder(Color.black));
        defenderMineBox.add(new JLabel("Defender"));
        this.BaseCheckBox = new JCheckBox("Mine");
        this.BaseCheckBox.setToolTipText("<html>If true, defending players will receive mines.<br>Set false to make the grant lopsided.</html>");
        this.BaseCheckBox.setName("DefenderReceivesMines");
        defenderMineBox.add(this.BaseCheckBox);
        defenderMineBox.add(defenderMinePanel);
        defenderMineBox.setBorder(BorderFactory.createLineBorder(Color.black));
        scenarioBox3.add(attackerMineBox);
        scenarioBox3.add(defenderMineBox);
        BotsBox.add(new JLabel("Bots"));
        BotsBox.setBorder(BorderFactory.createLineBorder(Color.black));
        this.BaseCheckBox = new JCheckBox("Bots Control all Support Units");
        this.BaseCheckBox.setToolTipText("<html>If true any support units giving to the task<br>are given to a bot to be controlled by instead.<br>this includes arty gun emplacements and mines<br>all players will be given a bot and any support<br>that would have gone to that player will goto the bot<br>instead.<br>NOTE: bots will fire upon all players and other bots<br>if not on the same team!</html>");
        this.BaseCheckBox.setName("BotControlsAll");
        BotsPanel.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Bots are all on the same team.");
        this.BaseCheckBox.setToolTipText("<html>If set all bots will be added to the same team<br>This way all bots will attack the players and not<br>other bots. Bots unite!</html>");
        this.BaseCheckBox.setName("BotsAllOnSameTeam");
        BotsPanel.add(this.BaseCheckBox);
        SpringLayoutHelper.setupSpringGrid(BotsPanel, 2);
        BotsBox.add(BotsPanel);
        scenarioBox4.add(BotsBox);
        this.BaseTextField = new JTextField(5);
        defenderMULPanel.add(new JLabel("Min Armies:", 11));
        this.BaseTextField.setToolTipText("<html>Min number of MUL armies a Defender can receive</html>");
        this.BaseTextField.setName("MinDefenderMulArmies");
        defenderMULPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderMULPanel.add(new JLabel("Max Armies:", 11));
        this.BaseTextField.setToolTipText("<html>Max number of MUL armies a Defender can receive</html>");
        this.BaseTextField.setName("MaxDefenderMulArmies");
        defenderMULPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderMULPanel.add(new JLabel("Mul Army List:", 11));
        this.BaseTextField.setToolTipText("<html>List of the MUL files to choose from separated by ; <br>These files exist in the servers data\\armies folder</html>");
        this.BaseTextField.setName("DefenderMulArmyList");
        defenderMULPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(defenderMULPanel, 2);
        this.BaseTextField = new JTextField(5);
        attackerMULPanel.add(new JLabel("Min Armies:", 11));
        this.BaseTextField.setToolTipText("<html>Min number of MUL armies a Attacker can receive</html>");
        this.BaseTextField.setName("MinAttackerMulArmies");
        attackerMULPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerMULPanel.add(new JLabel("Max Armies:", 11));
        this.BaseTextField.setToolTipText("<html>Max number of MUL armies a Attacker can receive</html>");
        this.BaseTextField.setName("MaxAttackerMulArmies");
        attackerMULPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerMULPanel.add(new JLabel("Mul Army List:", 11));
        this.BaseTextField.setToolTipText("<html>List of the MUL files to choose from separated by ; <br>These files exist in the servers data\\armies folder</html>");
        this.BaseTextField.setName("AttackerMulArmyList");
        attackerMULPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(attackerMULPanel, 2);
        attackerMULBox.add(new JLabel("Attacker"));
        this.BaseCheckBox = new JCheckBox("MUL Armies");
        this.BaseCheckBox.setToolTipText("<html>If true, attacking players will receive Mul Armies.</html>");
        this.BaseCheckBox.setName("AttackerReceivesMULArmy");
        attackerMULBox.add(this.BaseCheckBox);
        attackerMULBox.add(attackerMULPanel);
        attackerMULBox.setBorder(BorderFactory.createLineBorder(Color.black));
        defenderMULBox.add(new JLabel("Defender"));
        this.BaseCheckBox = new JCheckBox("MUL Armies");
        this.BaseCheckBox.setToolTipText("<html>If true, defending players will receive Mul Armies.</html>");
        this.BaseCheckBox.setName("DefenderReceivesMULArmy");
        defenderMULBox.add(this.BaseCheckBox);
        defenderMULBox.add(defenderMULPanel);
        defenderMULBox.setBorder(BorderFactory.createLineBorder(Color.black));
        scenarioBox5.add(attackerMULBox);
        scenarioBox5.add(defenderMULBox);
        JPanel groupBox1 = new JPanel();
        groupBox1.setLayout(new BoxLayout(groupBox1, 0));
        JPanel groupBox2 = new JPanel();
        groupBox2.setLayout(new BoxLayout(groupBox2, 0));
        groupBox1.add(scenarioBox);
        groupBox1.add(scenarioBox2);
        groupBox2.add(scenarioBox3);
        groupBox2.add(scenarioBox5);
        masterBox.add(groupBox1);
        masterBox.add(groupBox2);
        masterBox.add(scenarioBox4);
        scenarioPanel.add(masterBox);
        JPanel opResultsBox = new JPanel();
        opResultsBox.setLayout(new BoxLayout(opResultsBox, 0));
        masterBox = new JPanel();
        masterBox.setLayout(new BoxLayout(masterBox, 1));
        attackerBox = new JPanel();
        attackerBox.setLayout(new BoxLayout(attackerBox, 1));
        attackerBox.setPreferredSize(new Dimension(350, 260));
        attackerBox.setMinimumSize(new Dimension(350, 260));
        attackerBox.setMaximumSize(new Dimension(350, 260));
        defenderBox = new JPanel();
        defenderBox.setLayout(new BoxLayout(defenderBox, 1));
        defenderBox.setPreferredSize(new Dimension(350, 260));
        defenderBox.setMinimumSize(new Dimension(350, 260));
        defenderBox.setMaximumSize(new Dimension(350, 260));
        JPanel outcomeBox = new JPanel();
        outcomeBox.setLayout(new BoxLayout(outcomeBox, 1));
        outcomeBox.setPreferredSize(new Dimension(697, 100));
        outcomeBox.setMinimumSize(new Dimension(697, 100));
        outcomeBox.setMaximumSize(new Dimension(697, 100));
        JPanel penaltyBox = new JPanel();
        penaltyBox.setLayout(new BoxLayout(penaltyBox, 1));
        penaltyBox.setPreferredSize(new Dimension(700, 50));
        penaltyBox.setMinimumSize(new Dimension(700, 50));
        penaltyBox.setMaximumSize(new Dimension(700, 50));
        JPanel fleeingBox = new JPanel();
        Dimension dim = new Dimension(700, 100);
        fleeingBox.setLayout(new BoxLayout(fleeingBox, 1));
        fleeingBox.setPreferredSize(dim);
        fleeingBox.setMinimumSize(dim);
        fleeingBox.setMaximumSize(dim);
        attackerPanel = new JPanel(new SpringLayout());
        defenderPanel = new JPanel(new SpringLayout());
        JPanel outcomePanel = new JPanel(new SpringLayout());
        JPanel penaltyPanel = new JPanel(new SpringLayout());
        JPanel fleeingPanel = new JPanel(new SpringLayout());
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Money Paid:", 11));
        this.BaseTextField.setToolTipText("flat amount attacker is paid for participating");
        this.BaseTextField.setName("BaseAttackerPayCBills");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Flu Paid:", 11));
        this.BaseTextField.setToolTipText("flat amount attacker is paid for participating");
        this.BaseTextField.setName("BaseAttackerPayInfluence");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Exp Paid:", 11));
        this.BaseTextField.setToolTipText("flat amount attacker is paid for participating");
        this.BaseTextField.setName("BaseAttackerPayExperience");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Money per BV:", 11));
        this.BaseTextField.setToolTipText("<html>1 CBill added to Base pay for every complete<br>increment. ie - if 2, will add BV/2 Cbills to pay</html>");
        this.BaseTextField.setName("AttackerPayBVforCBill");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Flu per BV:", 11));
        this.BaseTextField.setToolTipText("<html>1 flu added to Base pay for every complete<br>increment. ie - if 2, will add BV/2 flu to pay</html>");
        this.BaseTextField.setName("AttackerPayBVforInfluence");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Exp per BV:", 11));
        this.BaseTextField.setToolTipText("<html>1 Exp added to Base pay for every complete<br>increment. ie - if 2, will add BV/2 Exp to pay</html>");
        this.BaseTextField.setName("AttackerPayBVforExperience");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Win Money:", 11));
        this.BaseTextField.setToolTipText("flat boost to pay for winning attack");
        this.BaseTextField.setName("AttackerWinModifierCBillsFlat");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Loss Money:", 11));
        this.BaseTextField.setToolTipText("flat drop in pay for losing attack");
        this.BaseTextField.setName("AttackerLossModifierCBillsFlat");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Win %Mod Money:", 11));
        this.BaseTextField.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        this.BaseTextField.setName("AttackerWinModifierCBillsPercent");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Loss %Mod Money:", 11));
        this.BaseTextField.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        this.BaseTextField.setName("AttackerLossModifierCBillsPercent");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Win Flu:", 11));
        this.BaseTextField.setToolTipText("flat boost to pay for winning attack");
        this.BaseTextField.setName("AttackerWinModifierInfluenceFlat");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Loss Flu:", 11));
        this.BaseTextField.setToolTipText("flat drop in pay for losing attack");
        this.BaseTextField.setName("AttackerLossModifierInfluenceFlat");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Win %Mod Flu:", 11));
        this.BaseTextField.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        this.BaseTextField.setName("AttackerWinModifierInfluencePercent");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Loss %Mod Flu:", 11));
        this.BaseTextField.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        this.BaseTextField.setName("AttackerLossModifierInfluencePercent");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Win Exp:", 11));
        this.BaseTextField.setToolTipText("flat boost to pay for winning attack");
        this.BaseTextField.setName("AttackerWinModifierExperienceFlat");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Loss Exp:", 11));
        this.BaseTextField.setToolTipText("flat drop in pay for losing attack");
        this.BaseTextField.setName("AttackerLossModifierExperienceFlat");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Win %Mod Exp:", 11));
        this.BaseTextField.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        this.BaseTextField.setName("AttackerWinModifierExperiencePercent");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Loss %Mod Exp:", 11));
        this.BaseTextField.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        this.BaseTextField.setName("AttackerLossModifierExperiencePercent");
        attackerPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(attackerPanel, 9, 4);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Money Paid:", 11));
        this.BaseTextField.setToolTipText("flat amount defender is paid for participating");
        this.BaseTextField.setName("BaseDefenderPayCBills");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Flu Paid:", 11));
        this.BaseTextField.setToolTipText("flat amount defender is paid for participating");
        this.BaseTextField.setName("BaseDefenderPayInfluence");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Exp Paid:", 11));
        this.BaseTextField.setToolTipText("flat amount defender is paid for participating");
        this.BaseTextField.setName("BaseDefenderPayExperience");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Money per BV:", 11));
        this.BaseTextField.setToolTipText("<html>1 CBill added to Base pay for every complete<br>increment. ie - if 2, will add BV/2 Cbills to pay</html>");
        this.BaseTextField.setName("DefenderPayBVforCBill");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Flu per BV:", 11));
        this.BaseTextField.setToolTipText("<html>1 flu added to Base pay for every complete<br>increment. ie - if 2, will add BV/2 flu to pay</html>");
        this.BaseTextField.setName("DefenderPayBVforInfluence");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Exp per BV:", 11));
        this.BaseTextField.setToolTipText("<html>1 Exp added to Base pay for every complete<br>increment. ie - if 2, will add BV/2 Exp to pay</html>");
        this.BaseTextField.setName("DefenderPayBVforExperience");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Win Money:", 11));
        this.BaseTextField.setToolTipText("flat boost to pay for winning defend");
        this.BaseTextField.setName("DefenderWinModifierCBillsFlat");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Loss Money:", 11));
        this.BaseTextField.setToolTipText("flat drop in pay for losing defend");
        this.BaseTextField.setName("DefenderLossModifierCBillsFlat");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Win %Mod Money:", 11));
        this.BaseTextField.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        this.BaseTextField.setName("DefenderWinModifierCBillsPercent");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Loss %Mod Money:", 11));
        this.BaseTextField.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        this.BaseTextField.setName("DefenderLossModifierCBillsPercent");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Win Flu:", 11));
        this.BaseTextField.setToolTipText("flat boost to pay for winning defend");
        this.BaseTextField.setName("DefenderWinModifierInfluenceFlat");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Loss Flu:", 11));
        this.BaseTextField.setToolTipText("flat drop in pay for losing defend");
        this.BaseTextField.setName("DefenderLossModifierInfluenceFlat");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Win %Mod Flu:", 11));
        this.BaseTextField.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        this.BaseTextField.setName("DefenderWinModifierInfluencePercent");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Loss %Mod Flu:", 11));
        this.BaseTextField.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        this.BaseTextField.setName("DefenderLossModifierInfluencePercent");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Win Exp:", 11));
        this.BaseTextField.setToolTipText("flat boost to pay for winning defend");
        this.BaseTextField.setName("DefenderWinModifierExperienceFlat");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Loss Exp:", 11));
        this.BaseTextField.setToolTipText("flat drop in pay for losing defend");
        this.BaseTextField.setName("DefenderLossModifierExperienceFlat");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Win %Mod Exp:", 11));
        this.BaseTextField.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        this.BaseTextField.setName("DefenderWinModifierExperiencePercent");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Loss %Mod Exp:", 11));
        this.BaseTextField.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        this.BaseTextField.setName("DefenderLossModifierExperiencePercent");
        defenderPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(defenderPanel, 9, 4);
        this.BaseTextField = new JTextField(5);
        outcomePanel.add(new JLabel("Attacker RP:", 11));
        this.BaseTextField.setToolTipText("number of RP to give Attacker(s)");
        this.BaseTextField.setName("RPForAttacker");
        outcomePanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        outcomePanel.add(new JLabel("Defender RP:", 11));
        this.BaseTextField.setToolTipText("num RP to give Defender(s)");
        this.BaseTextField.setName("RPForDefender");
        outcomePanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        outcomePanel.add(new JLabel("Winner RP:", 11));
        this.BaseTextField.setToolTipText("num RP to give Winner");
        this.BaseTextField.setName("RPForWinner");
        outcomePanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        outcomePanel.add(new JLabel("Loser RP:", 11));
        this.BaseTextField.setToolTipText("num RP to give Loser");
        this.BaseTextField.setName("RPForLoser");
        outcomePanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(outcomePanel, 2, 4);
        outcomeBox.add(new JLabel("Reward Points"));
        this.BaseCheckBox = new JCheckBox("Winner Only Gets RP");
        this.BaseCheckBox.setToolTipText("use to restrict attack/def RP to winning players");
        this.BaseCheckBox.setName("OnlyGiveRPtoWinners");
        outcomeBox.add(this.BaseCheckBox);
        outcomeBox.add(outcomePanel);
        outcomeBox.setBorder(BorderFactory.createLineBorder(Color.black));
        this.BaseTextField = new JTextField(5);
        penaltyPanel.add(new JLabel("Min BV Difference:", 11));
        this.BaseTextField.setToolTipText("<html><b>NOTE:</b>This is a double field. 0.25 = 25%<br>This is the min difference between the starting BV of the losers army<br>and his ending BV. if the difference is less then this<br>the player will not get a full payout</html>");
        this.BaseTextField.setName("MinBVDifferenceForFullPay");
        penaltyPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        penaltyPanel.add(new JLabel("BV Failure Payment Mod:", 11));
        this.BaseTextField.setToolTipText("<html><b>NOTE:</b>This is an Integer Field. 25 = 25%<br>This is precentage the payment is reduced to when players<br>fail to meet the min BV difference</html>");
        this.BaseTextField.setName("BVFailurePaymentModifier");
        penaltyPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(penaltyPanel, 4);
        penaltyBox.add(new JLabel("BV Payment Penalties"));
        penaltyBox.add(penaltyPanel);
        penaltyBox.setBorder(BorderFactory.createLineBorder(Color.black));
        this.BaseTextField = new JTextField(5);
        fleeingPanel.add(new JLabel("Fled Slavage Chance:", 11));
        this.BaseTextField.setToolTipText("<html><b>NOTE:</b>This is an Integer Field. 25 = 25%<br>Chance that a unit that flees the field is put into the salvage pool. Default 0</html>");
        this.BaseTextField.setName("FledUnitSalvageChance");
        fleeingPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        fleeingPanel.add(new JLabel("Fled Scrapped Chance:", 11));
        this.BaseTextField.setToolTipText("<html><b>NOTE:</b>This is an Integer Field. 25 = 25%<br>Chance, out of 100, that a unit that flees the field is scrapped. Default 0.</html>");
        this.BaseTextField.setName("FledUnitScrappedChance");
        fleeingPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        fleeingPanel.add(new JLabel("Pushed Slavage Chance:", 11));
        this.BaseTextField.setToolTipText("<html><b>NOTE:</b>This is an Integer Field. 25 = 25%<br>Chance that a unit that is pushed off the field is put into the salvage pool. Default 0</html>");
        this.BaseTextField.setName("PushedUnitSalvageChance");
        fleeingPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        fleeingPanel.add(new JLabel("Pushed Scrapped Chance:", 11));
        this.BaseTextField.setToolTipText("<html><b>NOTE:</b>This is an Integer Field. 25 = 25%<br>Chance, out of 100, that a unit that is pushed off the field is scrapped. Default 0.</html>");
        this.BaseTextField.setName("PushedUnitScrappedChance");
        fleeingPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        fleeingPanel.add(new JLabel("Engined Units Scrapped:", 11));
        this.BaseTextField.setToolTipText("<html><b>NOTE:</b>This is an Integer Field. 25 = 25%<br>Chance, out of 100, that an engined unit is utterly<br>destroyed while trying to be salvaged. Default 0</html>");
        this.BaseTextField.setName("EnginedUnitsScrappedChance");
        fleeingPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        fleeingPanel.add(new JLabel("Forced Salvaged Units Scrapped:", 11));
        this.BaseTextField.setToolTipText("<html><html><b>NOTE:</b>This is an Integer Field. 25 = 25%<br>Chance, out of 100, that a legged/gyroed unit is utterly destroyed while trying to be salvaged. Default 0</html>");
        this.BaseTextField.setName("ForcedSalvageUnitsScrappedChance");
        fleeingPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(fleeingPanel, 4);
        fleeingBox.add(new JLabel("Fleeing Penalties"));
        fleeingBox.add(fleeingPanel);
        fleeingBox.setBorder(BorderFactory.createLineBorder(Color.black));
        attackerBox.add(new JLabel("Attacker"));
        attackerBox.add(attackerPanel);
        attackerBox.setBorder(BorderFactory.createLineBorder(Color.black));
        defenderBox.add(new JLabel("Defender"));
        defenderBox.add(defenderPanel);
        defenderBox.setBorder(BorderFactory.createLineBorder(Color.black));
        opResultsBox.add(attackerBox);
        opResultsBox.add(defenderBox);
        masterBox.add(opResultsBox);
        masterBox.add(outcomeBox);
        masterBox.add(penaltyBox);
        masterBox.add(fleeingBox);
        opresultsPanel.add(masterBox);
        JPanel salvageBox = new JPanel();
        salvageBox.setLayout(new BoxLayout(salvageBox, 0));
        masterBox = new JPanel();
        masterBox.setLayout(new BoxLayout(masterBox, 1));
        attackerBox = new JPanel();
        attackerBox.setLayout(new BoxLayout(attackerBox, 1));
        defenderBox = new JPanel();
        defenderBox.setLayout(new BoxLayout(defenderBox, 1));
        attackerPanel = new JPanel(new SpringLayout());
        defenderPanel = new JPanel(new SpringLayout());
        this.BaseTextField = new JTextField();
        attackerPanel.add(new JLabel("Base Salvage%:", 11));
        this.BaseTextField.setToolTipText(" attacker starting salvage rate if he wins");
        this.BaseTextField.setName("BaseAttackerSalvagePercent");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField();
        attackerPanel.add(new JLabel("Salvage Adjustment:", 11));
        this.BaseTextField.setToolTipText("<html>Adjustment after each salvage attempt. IE - if base<br>is 50, and adjust is 20, 2nd attempt will be 30 or 70<br>30 if salvage attempt was successful 70 if not.</html>");
        this.BaseTextField.setName("AttackerSalvageAdjustment");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField();
        attackerPanel.add(new JLabel("BV To Boost Salvage:", 11));
        this.BaseTextField.setToolTipText("<html>UnitBV/BVToBoost is the starting cost of salvage. If<br>set to 0, salvage will be *FREE*. IMPORTANT!</html>");
        this.BaseTextField.setName("BVToBoostAttackerSalvageCost");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField();
        attackerPanel.add(new JLabel("Salvage Cost Mod:", 11));
        this.BaseTextField.setToolTipText("<html>salvage cost multiplier. is a double. entry of .75 will<br>reduct cost by 25%, entry of 2.00 will double the cost<br>to salvage a unit.</html>");
        this.BaseTextField.setName("AttackerSalvageCostModifier");
        attackerPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(attackerPanel, 4, 2);
        this.BaseTextField = new JTextField();
        defenderPanel.add(new JLabel("Base Salvage%:", 11));
        this.BaseTextField.setToolTipText(" defender starting salvage rate if he wins");
        this.BaseTextField.setName("BaseDefenderSalvagePercent");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField();
        defenderPanel.add(new JLabel("Salvage Adjustment:", 11));
        this.BaseTextField.setToolTipText("<html>Adjustment after each salvage attempt. IE - if base<br>is 50, and adjust is 20, 2nd attempt will be 30 or 70<br>30 if salvage attempt was successful 70 if not.</html>");
        this.BaseTextField.setName("DefenderSalvageAdjustment");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField();
        defenderPanel.add(new JLabel("BV To Boost Salvage:", 11));
        this.BaseTextField.setToolTipText("<html>UnitBV/BVToBoost is the starting cost of salvage. If<br>set to 0, salvage will be *FREE*. IMPORTANT!</html>");
        this.BaseTextField.setName("BVToBoostDefenderSalvageCost");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField();
        defenderPanel.add(new JLabel("Salvage Cost Mod:", 11));
        this.BaseTextField.setToolTipText("<html>salvage cost multiplier. is a double. entry of .75 will<br>reduct cost by 25%, entry of 2.00 will double the cost<br>to salvage a unit.</html>");
        this.BaseTextField.setName("DefenderSalvageCostModifier");
        defenderPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(defenderPanel, 4, 2);
        attackerBox.add(new JLabel("Attacker"));
        attackerBox.add(attackerPanel);
        attackerBox.setBorder(BorderFactory.createLineBorder(Color.black));
        defenderBox.add(new JLabel("Defender"));
        defenderBox.add(defenderPanel);
        defenderBox.setBorder(BorderFactory.createLineBorder(Color.black));
        salvageBox.add(attackerBox);
        salvageBox.add(defenderBox);
        this.BaseCheckBox = new JCheckBox("Winner Salvages Own Units");
        this.BaseCheckBox.setToolTipText("if true winner gets all his salvageables");
        this.BaseCheckBox.setName("WinnerAlwaysSalvagesOwnUnits");
        masterBox.add(this.BaseCheckBox);
        masterBox.add(salvageBox);
        this.BaseCheckBox = new JCheckBox("Support Units Go To Salvage Pool");
        this.BaseCheckBox.setToolTipText("if true support units, arty, mul armies, and others go to the salvage pool instead of going away");
        this.BaseCheckBox.setName("SupportUnitsAreSalvageable");
        masterBox.add(this.BaseCheckBox);
        masterBox.add(salvageBox);
        salvagePanel.add(masterBox);
        JPanel newbieBox = new JPanel();
        newbieBox.setLayout(new BoxLayout(newbieBox, 1));
        JPanel newbiePanel1 = new JPanel(new SpringLayout());
        JPanel newbiePanel2 = new JPanel(new SpringLayout());
        JPanel newbiePanel3 = new JPanel(new SpringLayout());
        JPanel newbiePanel4 = new JPanel(new SpringLayout());
        this.BaseCheckBox = new JCheckBox("Allow SOL To Use");
        this.BaseCheckBox.setToolTipText("set true to allow a newbie to initiate");
        this.BaseCheckBox.setName("AllowSOLToUse");
        newbiePanel1.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Allow Against SOL");
        this.BaseCheckBox.setToolTipText("set true to allow a player to launch this task against SOL");
        this.BaseCheckBox.setName("AllowAgainstSOL");
        newbiePanel1.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Allow For NonConquer");
        this.BaseCheckBox.setToolTipText("set false to forbid non-conquer players from using this attack");
        this.BaseCheckBox.setName("AllowNonConqToUse");
        newbiePanel1.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Allow Against NonConquer");
        this.BaseCheckBox.setToolTipText("set false to forbid players from using this attack against a non-conq player");
        this.BaseCheckBox.setName("AllowAgainstNonConq");
        newbiePanel1.add(this.BaseCheckBox);
        SpringLayoutHelper.setupSpringGrid(newbiePanel1, 1, 4);
        this.BaseCheckBox = new JCheckBox("SOL Pilots Gain XP");
        this.BaseCheckBox.setToolTipText("set true to allow SOL player's units to gain XP");
        this.BaseCheckBox.setName("SOLPilotsGainXP");
        newbiePanel2.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("House Pilots Gain XP");
        this.BaseCheckBox.setToolTipText("set true to allow faction units to gain XP vs SOL");
        this.BaseCheckBox.setName("HousePilotsGainXP");
        newbiePanel2.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("SOL Pilots Can Level");
        this.BaseCheckBox.setToolTipText("set true to allow SOL player's units to level after game");
        this.BaseCheckBox.setName("SOLPilotsCheckLevelUp");
        newbiePanel2.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("House Pilots Can Level");
        this.BaseCheckBox.setToolTipText("set true to allow faction units to level after game vs SOL");
        this.BaseCheckBox.setName("HousePilotsCheckLevelUp");
        newbiePanel2.add(this.BaseCheckBox);
        SpringLayoutHelper.setupSpringGrid(newbiePanel2, 1, 4);
        this.BaseCheckBox = new JCheckBox("Pay all As Winners");
        this.BaseCheckBox.setToolTipText("<html>enable to play all players in a task involving a SOL as game <br> winners, regardless of outcome. <br><br> NOTEs: for a training task, AllowSOLtoUse and AllowAgainstSOL should be <br> set true simultaneously, otherwise player would be able to LAUNCH <br> attack, but other SOLs would not be able to defend. <br> It is NOT recommended that PayAllAsWinners be used unless NoStats <br> and NoDestruction are also enabled.</html>");
        this.BaseCheckBox.setName("PayAllAsWinners");
        newbiePanel3.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Count Game For Ranking");
        this.BaseCheckBox.setToolTipText("<html>set to true in order to stop ELO changes.</html>");
        this.BaseCheckBox.setName("CountGameForRanking");
        newbiePanel3.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("No Statisitcs Mode");
        this.BaseCheckBox.setToolTipText("<html>if enabled, stats will not be kept in games involving SOLs. <br> Pilot/Unit kills will not be counted or published.</html>");
        this.BaseCheckBox.setName("NoStatisticsMode");
        newbiePanel3.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("No Destruction Mode");
        this.BaseCheckBox.setToolTipText("<html>if enabled, no units will be destroyed and no units will<br>be salvaged (essentially sets up a sim-task).</html>");
        this.BaseCheckBox.setName("NoDestructionMode");
        newbiePanel3.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Pay Techs");
        this.BaseCheckBox.setToolTipText("set false to turn off technician payments.");
        this.BaseCheckBox.setName("PayTechsForGame");
        newbiePanel3.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Allow In Faction");
        this.BaseCheckBox.setToolTipText("<html>If enabled then players in the same faction<br>will be able to attack each other.</html>");
        this.BaseCheckBox.setName("AllowInFaction");
        newbiePanel3.add(this.BaseCheckBox);
        SpringLayoutHelper.setupSpringGrid(newbiePanel3, 4);
        newbiePanel4.add(new JLabel("Count Game For Production:", 11));
        this.BaseTextField = new JTextField(5);
        this.BaseTextField.setToolTipText("<html>Double. Controls amount of production players generate<br>Set to 0 to disable production. Defaults to 1.0, the<br>same amount that a solitary army would generate.</html>");
        this.BaseTextField.setName("CountGameForProduction");
        newbiePanel4.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(newbiePanel4, 1, 2);
        newbieBox.add(newbiePanel1);
        newbieBox.add(newbiePanel2);
        newbieBox.add(newbiePanel3);
        newbieBox.add(newbiePanel4);
        newbieOpsPanel.add(newbieBox);
        JPanel metaBox = new JPanel();
        metaBox.setLayout(new BoxLayout(metaBox, 0));
        JPanel capsBox = new JPanel();
        capsBox.setLayout(new BoxLayout(capsBox, 1));
        masterBox = new JPanel();
        masterBox.setLayout(new BoxLayout(masterBox, 1));
        JPanel destructionBox = new JPanel();
        destructionBox.setLayout(new BoxLayout(destructionBox, 1));
        destructionBox.setPreferredSize(new Dimension(746, 104));
        destructionBox.setMaximumSize(new Dimension(746, 104));
        destructionBox.setMinimumSize(new Dimension(746, 104));
        attackerBox = new JPanel();
        attackerBox.setLayout(new BoxLayout(attackerBox, 1));
        defenderBox = new JPanel();
        defenderBox.setLayout(new BoxLayout(defenderBox, 1));
        defenderBox.setPreferredSize(new Dimension(372, 204));
        defenderBox.setMaximumSize(new Dimension(372, 204));
        defenderBox.setMinimumSize(new Dimension(372, 204));
        JPanel capsPanel = new JPanel(new SpringLayout());
        JPanel destructionPanel = new JPanel(new SpringLayout());
        JPanel destructionCapPanel = new JPanel(new SpringLayout());
        attackerPanel = new JPanel(new SpringLayout());
        defenderPanel = new JPanel(new SpringLayout());
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Base Conquer:", 11));
        this.BaseTextField.setToolTipText("Base points of a planet taken for winning attacker");
        this.BaseTextField.setName("AttackerBaseConquestAmount");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Conquer BV Mod:", 11));
        this.BaseTextField.setToolTipText("Amount of BV needed for extra points");
        this.BaseTextField.setName("AttackerConquestBVAdjustment");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Conquer Unit Mod:", 11));
        this.BaseTextField.setToolTipText("Number of units needed for extra points");
        this.BaseTextField.setName("AttackerConquestUnitAdjustment");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Base Delay Amount:", 11));
        this.BaseTextField.setToolTipText("Base miniticks delay caused by winning attacker");
        this.BaseTextField.setName("AttackerBaseDelayAmount");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Delay BV Mod:", 11));
        this.BaseTextField.setToolTipText("Amount of BV needed for extra minitick of delay");
        this.BaseTextField.setName("AttackerDelayBVAdjustment");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Delay Unit Mod:", 11));
        this.BaseTextField.setToolTipText("Number of units needed for extra minitick of delay");
        this.BaseTextField.setName("AttackerDelayUnitAdjustment");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Base Components:", 11));
        this.BaseTextField.setToolTipText("Base components taken by winning attacker");
        this.BaseTextField.setName("AttackerBasePPAmount");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Component BV Mod:", 11));
        this.BaseTextField.setToolTipText("Amount of BV needed for extra batch of components");
        this.BaseTextField.setName("AttackerPPBVAdjustment");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Component Unit Mod:", 11));
        this.BaseTextField.setToolTipText("Number of units needed for extra batch of components");
        this.BaseTextField.setName("AttackerPPUnitAdjustment");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Units Taken:", 11));
        this.BaseTextField.setToolTipText("base number of units taken by winning attacker");
        this.BaseTextField.setName("AttackerBaseUnitsTaken");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Units BV Mod:", 11));
        this.BaseTextField.setToolTipText("BV to take an additonal unit");
        this.BaseTextField.setName("AttackerUnitsBVAdjustment");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Units Unit Mod:", 11));
        this.BaseTextField.setToolTipText("Units to take an additional unit (confusing!)");
        this.BaseTextField.setName("AttackerUnitsUnitAdjustment");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Factory Units Taken:", 11));
        this.BaseTextField.setToolTipText("<html>Base number of units taken by winning attacker<br>from factories on the planet</html>");
        this.BaseTextField.setName("AttackerBaseFactoryUnitsTaken");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Factory Units BV Mod:", 11));
        this.BaseTextField.setToolTipText("BV to take an additonal factory unit");
        this.BaseTextField.setName("AttackerFactoryUnitsBVAdjustment");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Factory Units Unit Mod:", 11));
        this.BaseTextField.setToolTipText("units to take an additional factory unit (confusing!)");
        this.BaseTextField.setName("AttackerFactoryUnitsUnitAdjustment");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Target Op Mod:", 11));
        this.BaseTextField.setToolTipText("<html>Op Adjustments are used to increase or decrease victory THRESHOLDS for<br>targetted long-ops. Not recommended for individual games. Generally, better<br>for use as a long-op (w/ fewer games than target) set up as a counter-assault<br>or spoling attack.</html>");
        this.BaseTextField.setName("AttackerTargetOpAdjustment");
        attackerPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(attackerPanel, 4);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Base Conquer:", 11));
        this.BaseTextField.setToolTipText("Base points of a planet taken for winning defender");
        this.BaseTextField.setName("DefenderBaseConquestAmount");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Conquer BV Mod:", 11));
        this.BaseTextField.setToolTipText("Amount of BV needed for extra points");
        this.BaseTextField.setName("DefenderConquestBVAdjustment");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Conquer Unit Mod:", 11));
        this.BaseTextField.setToolTipText("Number of units needed for extra points");
        this.BaseTextField.setName("DefenderConquestUnitAdjustment");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Base Delay Amount:", 11));
        this.BaseTextField.setToolTipText("Base miniticks REPAIR caused by winning defender");
        this.BaseTextField.setName("DefenderBaseDelayAmount");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Delay BV Mod:", 11));
        this.BaseTextField.setToolTipText("Amount of BV needed for extra minitick of REPAIR");
        this.BaseTextField.setName("DefenderDelayBVAdjustment");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Delay Unit Mod:", 11));
        this.BaseTextField.setToolTipText("Number of units needed for extra minitick of REPAIR");
        this.BaseTextField.setName("DefenderDelayUnitAdjustment");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Base Components:", 11));
        this.BaseTextField.setToolTipText("Base components taken by winning defender");
        this.BaseTextField.setName("DefenderBasePPAmount");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Component BV Mod:", 11));
        this.BaseTextField.setToolTipText("Amount of BV needed for extra batch of components");
        this.BaseTextField.setName("DefenderPPBVAdjustment");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Component Unit Mod:", 11));
        this.BaseTextField.setToolTipText("Number of units needed for extra batch of components");
        this.BaseTextField.setName("DefenderPPUnitAdjustment");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Target Op Mod:", 11));
        this.BaseTextField.setToolTipText("<html>Op Adjustments are used to increase or decrease victory THRESHOLDS for<br>targetted long-ops. Not recommended for individual games. Generlly, better<br>for use as a long-op (w/ fewer games than target) set up as a counter-assault<br>or spoling defend.</html>");
        this.BaseTextField.setName("DefenderTargetOpAdjustment");
        defenderPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(defenderPanel, 4);
        this.BaseTextField = new JTextField(5);
        capsPanel.add(new JLabel("Conqer Cap:", 11));
        this.BaseTextField.setToolTipText("Max amount of % to take, regardless of BV/units involved.");
        this.BaseTextField.setName("ConquestAmountCap");
        capsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        capsPanel.add(new JLabel("Delay Cap:", 11));
        this.BaseTextField.setToolTipText("Max amount of delay to apply, regardless of BV/units involved.");
        this.BaseTextField.setName("DelayAmountCap");
        capsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        capsPanel.add(new JLabel("Component Cap:", 11));
        this.BaseTextField.setToolTipText("Max # of PP to take/generate");
        this.BaseTextField.setName("PPCapptureCap");
        capsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        capsPanel.add(new JLabel("Unit Cap:", 11));
        this.BaseTextField.setToolTipText("Ceiling on number of units which may be raided");
        this.BaseTextField.setName("UnitCaptureCap");
        capsPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(capsPanel, 1, 8);
        this.BaseTextField = new JTextField(5);
        destructionCapPanel.add(new JLabel("Component Cap:", 11));
        this.BaseTextField.setToolTipText("Ceiling on number of components which may be destroyed");
        this.BaseTextField.setName("PPDestructionCap");
        destructionCapPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        destructionCapPanel.add(new JLabel("Unit Cap:", 11));
        this.BaseTextField.setToolTipText("Ceiling on number of Units which may be destroyed");
        this.BaseTextField.setName("UnitDestructionCap");
        destructionCapPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        destructionPanel.add(new JLabel("Base Units:", 11));
        this.BaseTextField.setToolTipText("Base number of units to destroy");
        this.BaseTextField.setName("BaseUnitsDestroyed");
        destructionPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        destructionPanel.add(new JLabel("Units BV adjust:", 11));
        this.BaseTextField.setToolTipText("Number of units to destroy based on BV");
        this.BaseTextField.setName("DestroyedUnitsBVAdjustment");
        destructionPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        destructionPanel.add(new JLabel("Unit Unit adjust:", 11));
        this.BaseTextField.setToolTipText("Number of units to destroy based on units used in the op.");
        this.BaseTextField.setName("DestroyedUnitsUnitAdjustment");
        destructionPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        destructionPanel.add(new JLabel("Base Components:", 11));
        this.BaseTextField.setToolTipText("Base number of components to destroy");
        this.BaseTextField.setName("BasePPDestroyed");
        destructionPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        destructionPanel.add(new JLabel("Component BV adjust:", 11));
        this.BaseTextField.setToolTipText("Number of components to destroy based on BV");
        this.BaseTextField.setName("DestroyedPPBVAdjustment");
        destructionPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        destructionPanel.add(new JLabel("Unit Component Adjust:", 11));
        this.BaseTextField.setToolTipText("Number of components to destroy based on units used in the op");
        this.BaseTextField.setName("DestroyedPPUnitAdjustment");
        destructionPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(destructionPanel, 6);
        SpringLayoutHelper.setupSpringGrid(destructionCapPanel, 4);
        destructionBox.add(new JLabel("Destruction"));
        destructionBox.add(destructionCapPanel);
        destructionBox.add(destructionPanel);
        destructionBox.setBorder(BorderFactory.createLineBorder(Color.black));
        attackerBox.add(new JLabel("Attacker"));
        this.BaseCheckBox = new JCheckBox("Units Taken First");
        this.BaseCheckBox.setToolTipText("<html>If enabled then the attacker will start the game with<br>the stolen units and must get them off the battle field.</html>");
        this.BaseCheckBox.setName("AttackerUnitsTakenBeforeFightStarts");
        attackerBox.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Unclaimed Land");
        this.BaseCheckBox.setToolTipText("<html>If enabled then the attacker can target a planet without claimed land and will automatically capture CP.</html>");
        this.BaseCheckBox.setName("AttackerAllowAgainstUnclaimedLand");
        attackerBox.add(this.BaseCheckBox);
        attackerBox.add(attackerPanel);
        attackerBox.setBorder(BorderFactory.createLineBorder(Color.black));
        defenderBox.add(new JLabel("Defender"));
        defenderBox.add(defenderPanel);
        defenderBox.setBorder(BorderFactory.createLineBorder(Color.black));
        capsBox.add(new JLabel("Max Operation Winnings"));
        capsBox.add(capsPanel);
        metaBox.add(attackerBox);
        metaBox.add(defenderBox);
        masterBox.add(capsBox);
        masterBox.add(metaBox);
        masterBox.add(destructionBox);
        metaSetupPanel.add(masterBox);
        JPanel chickenLeechBox = new JPanel();
        chickenLeechBox.setLayout(new BoxLayout(metaBox, 0));
        JPanel leechBox1 = new JPanel();
        leechBox1.setLayout(new BoxLayout(leechBox1, 1));
        JPanel leechPanel1 = new JPanel(new SpringLayout());
        JPanel leechPanel2 = new JPanel(new SpringLayout());
        JPanel leechPanel3 = new JPanel(new SpringLayout());
        JPanel leechPanel4 = new JPanel(new SpringLayout());
        this.BaseTextField = new JTextField(5);
        leechPanel1.add(new JLabel("Chicken Time:", 11));
        this.BaseTextField.setToolTipText("time, in SECONDS, from attack init to penalty.");
        this.BaseTextField.setName("TimeToNondefensePenalty");
        leechPanel1.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        leechPanel1.add(new JLabel("Total Allowed Leeches:", 11));
        this.BaseTextField.setToolTipText("num leeches before a player is moved into reserve.");
        this.BaseTextField.setName("LeechesToDeactivate");
        leechPanel1.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(leechPanel1, 1, 4);
        this.BaseTextField = new JTextField(5);
        leechPanel2.add(new JLabel("RP Penalty:", 11));
        this.BaseTextField.setToolTipText("# of RP to take.");
        this.BaseTextField.setName("FlatRPChickenPenalty");
        leechPanel2.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        leechPanel2.add(new JLabel("Exp Penalty:", 11));
        this.BaseTextField.setToolTipText("# of EXP to take.");
        this.BaseTextField.setName("FlatExpChickenPenalty");
        leechPanel2.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        leechPanel2.add(new JLabel("Flu Penalty:", 11));
        this.BaseTextField.setToolTipText("# of Inf to take.");
        this.BaseTextField.setName("FlatInfluenceChickenPenalty");
        leechPanel2.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        leechPanel2.add(new JLabel("Money Penalty:", 11));
        this.BaseTextField.setToolTipText("# of CBills to take.");
        this.BaseTextField.setName("FlatCBillChickenPenalty");
        leechPanel2.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(leechPanel2, 2, 4);
        this.BaseTextField = new JTextField(5);
        leechPanel3.add(new JLabel("% RP Penalty:", 11));
        this.BaseTextField.setToolTipText("% of RP to take. i.e. .10 for 10%");
        this.BaseTextField.setName("PercentRPChickenPenalty");
        leechPanel3.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        leechPanel3.add(new JLabel("% Exp Penalty:", 11));
        this.BaseTextField.setToolTipText("% of EXP to take. i.e. .10 for 10%");
        this.BaseTextField.setName("PercentExpChickenPenalty");
        leechPanel3.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        leechPanel3.add(new JLabel("% Flu Penalty:", 11));
        this.BaseTextField.setToolTipText("% of Flu to take. i.e. .10 for 10%");
        this.BaseTextField.setName("PercentInfluenceChickenPenalty");
        leechPanel3.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        leechPanel3.add(new JLabel("% Money Penalty:", 11));
        this.BaseTextField.setToolTipText("% of Money to take. i.e. .10 for 10%");
        this.BaseTextField.setName("PercentCBillChickenPenalty");
        leechPanel3.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(leechPanel3, 2, 4);
        this.BaseTextField = new JTextField(5);
        leechPanel4.add(new JLabel("Land Taken:", 11));
        this.BaseTextField.setToolTipText("% control transferred on each leech");
        this.BaseTextField.setName("ConquestPerLeech");
        leechPanel4.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        leechPanel4.add(new JLabel("Factory Delays (Ticks):", 11));
        this.BaseTextField.setToolTipText("delay to on-target facilities w/ each leech");
        this.BaseTextField.setName("DelayPerLeech");
        leechPanel4.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        leechPanel4.add(new JLabel("Components Taken:", 11));
        this.BaseTextField.setToolTipText("Components taken with each leech");
        this.BaseTextField.setName("ProdPointsPerLeech");
        leechPanel4.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        leechPanel4.add(new JLabel("Units Taken:", 11));
        this.BaseTextField.setToolTipText("Units taken with each leech");
        this.BaseTextField.setName("UnitsPerLeech");
        leechPanel4.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        leechPanel4.add(new JLabel("Failure Penalty:", 11));
        this.BaseTextField.setToolTipText("<html>Components taken if no other penalty is applied. Use it<br>to ensure that a penalty is always given, even<br>if there is no % to yeild or factory to delay.</html>");
        this.BaseTextField.setName("FailurePenalty");
        leechPanel4.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(leechPanel4, 4);
        leechBox1.add(leechPanel1);
        leechBox1.add(leechPanel2);
        leechBox1.add(leechPanel3);
        leechBox1.add(leechPanel4);
        chickenLeechPanel.add(leechBox1);
        JPanel pilotExpBox = new JPanel();
        pilotExpBox.setLayout(new BoxLayout(pilotExpBox, 0));
        JPanel pilotPanel = new JPanel(new SpringLayout());
        this.BaseTextField = new JTextField(5);
        pilotPanel.add(new JLabel("Base Unit Exp:", 11));
        this.BaseTextField.setToolTipText("XP earned by all surviving units for playing the game");
        this.BaseTextField.setName("BaseUnitXP");
        pilotPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        pilotPanel.add(new JLabel("Surviving Unit Adjustment:", 11));
        this.BaseTextField.setToolTipText("<html>bonus XP given to all surviving units, based on the starting size of the game<br>if there are 10 units in game, and Adjust is set to 10, all units will get +1<br>XP. if there are 10 in game and Adjust is 5, all units will get +2 XP, etc.</html>");
        this.BaseTextField.setName("UnitXPUnitsAdjustment");
        pilotPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        pilotPanel.add(new JLabel("BV Adjustment:", 11));
        this.BaseTextField.setToolTipText("<html>bonus XP given to all surviving units, based on the starting size of the game. if<br>total BV in game is 30,000 and Adjust is 10,000, all units will get +3 XP.</html>");
        this.BaseTextField.setName("UnitXPBVAdjustment");
        pilotPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        pilotPanel.add(new JLabel("Winner Bonus:", 11));
        this.BaseTextField.setToolTipText("<html>bonux XP given to all surviving units owned by a winning player</html>");
        this.BaseTextField.setName("WinnerBonusUnitXP");
        pilotPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        pilotPanel.add(new JLabel("Defender Bonus:", 11));
        this.BaseTextField.setToolTipText("bonus XP given to all surviving units owned by a defending player");
        this.BaseTextField.setName("DefenderBonusUnitXP");
        pilotPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        pilotPanel.add(new JLabel("Units Killed Bonus:", 11));
        this.BaseTextField.setToolTipText("<html>flat amount of XP given to a unit for each kill it earned. this is granted only<br>to the killing unit, and only if it survives or is salvaged by original owner<br>with original pilot.</html>");
        this.BaseTextField.setName("KillBonusUnitXP");
        pilotPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        pilotPanel.add(new JLabel("BV Killed Bonus:", 11));
        this.BaseTextField.setToolTipText("<html>KilledUnitsBV/KillBonusXPforBV. bonus XP based on the BV of units killed. added<br>only to the killing unit, and only if the unit survives or is salvaged by its<br>original owner with original pilot.</html>");
        this.BaseTextField.setName("KillBonusXPforBV");
        pilotPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(pilotPanel, 7, 2);
        pilotExpBox.add(pilotPanel);
        pilotExpPanel.add(pilotExpBox);
        JPanel buildingsBox = new JPanel();
        buildingsBox.setLayout(new BoxLayout(buildingsBox, 0));
        JPanel constructionPanel = new JPanel(new SpringLayout());
        masterBox = new JPanel();
        masterBox.setLayout(new BoxLayout(masterBox, 1));
        attackerBox = new JPanel();
        attackerBox.setLayout(new BoxLayout(attackerBox, 1));
        defenderBox = new JPanel();
        defenderBox.setLayout(new BoxLayout(defenderBox, 1));
        defenderBox.setPreferredSize(new Dimension(210, 178));
        defenderBox.setMaximumSize(new Dimension(210, 178));
        defenderBox.setMinimumSize(new Dimension(210, 178));
        attackerPanel = new JPanel(new SpringLayout());
        defenderPanel = new JPanel(new SpringLayout());
        this.BaseTextField = new JTextField(5);
        constructionPanel.add(new JLabel("Total Buildings:", 11));
        this.BaseTextField.setToolTipText("Total number of buildings to place on the map");
        this.BaseTextField.setName("TotalBuildings");
        constructionPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        constructionPanel.add(new JLabel("Min Buildings:", 11));
        this.BaseTextField.setToolTipText("<html>Minimum number of buildings the Attack needs to destroy for the op to be a sucess<br>I.E. 10 buildings 5 min. if the attacker kills only 4 they don't get any of the b</html>");
        this.BaseTextField.setName("MinBuildingsForOp");
        constructionPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        constructionPanel.add(new JLabel("Min Floors:", 11));
        this.BaseTextField.setToolTipText("Minimum number of floors in each building.");
        this.BaseTextField.setName("MinFloors");
        constructionPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        constructionPanel.add(new JLabel("Max Floors:", 11));
        this.BaseTextField.setToolTipText("Maximum number of floors in each building.");
        this.BaseTextField.setName("MaxFloors");
        constructionPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        constructionPanel.add(new JLabel("Min CF:", 11));
        this.BaseTextField.setToolTipText("Minimum Construction Factor each building can have (How many points of damage it'll take)");
        this.BaseTextField.setName("MinCF");
        constructionPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        constructionPanel.add(new JLabel("Max CF:", 11));
        this.BaseTextField.setToolTipText("Maximum Construction Factor each building can have (How many points of damage it'll take)");
        this.BaseTextField.setName("MaxCF");
        constructionPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        constructionPanel.add(new JLabel("Building Type:", 11));
        this.BaseTextField.setToolTipText("1: Light, 2: Medium, 3: Heavy, 4: Hardend");
        this.BaseTextField.setName("BuildingType");
        constructionPanel.add(this.BaseTextField);
        this.BaseCheckBox = new JCheckBox("Buildings Start on map edge");
        this.BaseCheckBox.setToolTipText("<html>defaults to true.<br>If selected a random edge is selected<br>and the defender is set to that<br>and the attacker to the opposite edge.<br>If not selected the buildings<br>will be placed randomly around the map.</html>");
        this.BaseCheckBox.setName("BuildingsStartOnMapEdge");
        constructionPanel.add(this.BaseCheckBox);
        SpringLayoutHelper.setupSpringGrid(constructionPanel, 4);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Min Buildings if Attacker wins:", 11));
        this.BaseTextField.setToolTipText("<html>If The attacket wins the ops and the number of buildings destroyed is blow this it gets set to this.<br>I.E. Keep the defender from screwing the Attacker by quiting early.</html>");
        this.BaseTextField.setName("AttackerMinBuildingsIfAttackerWins");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Delay Per Building:", 11));
        this.BaseTextField.setToolTipText("<html>Number of Delay ticks set to the planet factories for each building destroyed,<br>if they meet the min amount of buildings destroyed.</html>");
        this.BaseTextField.setName("DelayPerBuilding");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Money Per Building:", 11));
        this.BaseTextField.setToolTipText("<html>Amount of Money the attacker gets for each building destroyed,<br>if they meet the min amount of buildings destroyed.</html>");
        this.BaseTextField.setName("AttackerMoneyPerBuilding");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Exp Per Building:", 11));
        this.BaseTextField.setToolTipText("<html>Amount of Exp the attacker gets for each building destroyed,<br>if they meet the min amount of buildings destroyed.</html>");
        this.BaseTextField.setName("AttackerExpPerBuilding");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("Flu Per Building:", 11));
        this.BaseTextField.setToolTipText("<html>Amount of Flu the attacker gets for each building destroyed,<br>if they meet the min amount of buildings destroyed.</html>");
        this.BaseTextField.setName("AttackerFluPerBuilding");
        attackerPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        attackerPanel.add(new JLabel("RP Per Building:", 11));
        this.BaseTextField.setToolTipText("<html>Amount of RP the attacker gets for each building destroyed,<br>if they meet the min amount of buildings destroyed.</html>");
        this.BaseTextField.setName("AttackerRPPerBuilding");
        attackerPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(attackerPanel, 6, 2);
        defenderPanel.add(new JLabel("  ", 11));
        defenderPanel.add(new JLabel("  ", 11));
        defenderPanel.add(new JLabel("  ", 11));
        defenderPanel.add(new JLabel("  ", 11));
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Money Per Building:", 11));
        this.BaseTextField.setToolTipText("Amount of Money the defender gets for each building left standing.");
        this.BaseTextField.setName("DefenderMoneyPerBuilding");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Exp Per Building:", 11));
        this.BaseTextField.setToolTipText("Amount of Exp the defender gets for each building left standing.");
        this.BaseTextField.setName("DefenderExpPerBuilding");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("Flu Per Building:", 11));
        this.BaseTextField.setToolTipText("Amount of Flu the defender gets for each building left standing.");
        this.BaseTextField.setName("DefenderFluPerBuilding");
        defenderPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        defenderPanel.add(new JLabel("RP Per Building:", 11));
        this.BaseTextField.setToolTipText("Amount of RP the defender gets for each building left standing.");
        this.BaseTextField.setName("DefenderRPPerBuilding");
        defenderPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(defenderPanel, 6, 2);
        attackerBox.add(new JLabel("Attacker"));
        attackerBox.add(attackerPanel);
        attackerBox.setBorder(BorderFactory.createLineBorder(Color.black));
        defenderBox.add(new JLabel("Defender"));
        defenderBox.add(defenderPanel);
        defenderBox.setBorder(BorderFactory.createLineBorder(Color.black));
        buildingsBox.add(attackerBox);
        buildingsBox.add(defenderBox);
        masterBox.add(constructionPanel);
        masterBox.add(buildingsBox);
        JPanel checkBoxBox = new JPanel(new SpringLayout());
        JPanel cityParamsPanel = new JPanel(new SpringLayout());
        this.BaseCheckBox = new JCheckBox("Use City Generator for this Op?");
        this.BaseCheckBox.setToolTipText("<html>Check if you want MM to generate a city for this op<br>Using the settings below</html>");
        this.BaseCheckBox.setName("RCGUseCityGenerator");
        checkBoxBox.add(this.BaseCheckBox);
        SpringLayoutHelper.setupSpringGrid(checkBoxBox, 1);
        this.BaseTextField = new JTextField(5);
        cityParamsPanel.add(new JLabel("City Type:", 11));
        this.BaseTextField.setToolTipText("<html>Set a city type<br>GRID, METRO, HUB</html>");
        this.BaseTextField.setName("RCGCityType");
        cityParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        cityParamsPanel.add(new JLabel("City Blocks:", 11));
        this.BaseTextField.setToolTipText("Number of city blocks for this city. This goes west to east and north to south");
        this.BaseTextField.setName("RCGCityBlocks");
        cityParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        cityParamsPanel.add(new JLabel("Min CF:", 11));
        this.BaseTextField.setToolTipText("Minimum Construction Factor each building can have (How many points of damage it'll take)");
        this.BaseTextField.setName("RCGMinCF");
        cityParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        cityParamsPanel.add(new JLabel("Max CF:", 11));
        this.BaseTextField.setToolTipText("Maximum Construction Factor each building can have (How many points of damage it'll take)");
        this.BaseTextField.setName("RCGMaxCF");
        cityParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        cityParamsPanel.add(new JLabel("Min Floors:", 11));
        this.BaseTextField.setToolTipText("Minimum number of floors in each building.");
        this.BaseTextField.setName("RCGMinFloors");
        cityParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        cityParamsPanel.add(new JLabel("Max Floors:", 11));
        this.BaseTextField.setToolTipText("Maximum number of floors in each building.");
        this.BaseTextField.setName("RCGMaxFloors");
        cityParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        cityParamsPanel.add(new JLabel("City Density:", 11));
        this.BaseTextField.setToolTipText("<html>1-100 This is the % chance that a hex will contain a building the higher the number<br>the more buildings will be generated.</html>");
        this.BaseTextField.setName("RCGCityDensity");
        cityParamsPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(cityParamsPanel, 4);
        masterBox.add(checkBoxBox);
        masterBox.add(cityParamsPanel);
        buildingsPanel.add(masterBox);
        JPanel victoryParamsPanel = new JPanel(new SpringLayout());
        checkBoxBox = new JPanel(new SpringLayout());
        masterBox = new JPanel();
        masterBox.setLayout(new BoxLayout(masterBox, 1));
        this.BaseCheckBox = new JCheckBox("Use Destroy Enemy BV?");
        this.BaseCheckBox.setToolTipText("<html>If this is turned on DestroyEnemyBV field well be sent to MM</html>");
        this.BaseCheckBox.setName("UseDestroyEnemyBV");
        checkBoxBox.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Use BV Ratio Percent?");
        this.BaseCheckBox.setToolTipText("<html>If this is turned on UseBVRatioPercent field will be sent to MM.</html>");
        this.BaseCheckBox.setName("UseBVRatioPercent");
        checkBoxBox.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Use Unit Commanders?");
        this.BaseCheckBox.setToolTipText("<html>If this is turned on UseUnitCommanders field will be sent to MM.</html>");
        this.BaseCheckBox.setName("UseUnitCommander");
        checkBoxBox.add(this.BaseCheckBox);
        this.BaseTextField = new JTextField(5);
        victoryParamsPanel.add(new JLabel("Victory Conditions:", 11));
        this.BaseTextField.setToolTipText("<html>The number of victory conditions that must<br>be achieved by the winning team.<br>Default 0 (off)</html>");
        this.BaseTextField.setName("NumberOfVictoryConditions");
        victoryParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        victoryParamsPanel.add(new JLabel("Destroy Enemy BV:", 11));
        this.BaseTextField.setToolTipText("<html>Destroy/damage a certain percentage<br>of the enemy force to win,<br>measured by current BV / original BV</html>");
        this.BaseTextField.setName("DestroyEnemyBV");
        victoryParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        victoryParamsPanel.add(new JLabel("BV Ratio Percent:", 11));
        this.BaseTextField.setToolTipText("<html>Friendly forces outnumber enemy forces by a percentage ratio.<br>Measured by current BV.<br>E.G. 300 means you have 3x the surviving BV of the enemy.</html>");
        this.BaseTextField.setName("BVRatioPercent");
        victoryParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        victoryParamsPanel.add(new JLabel("Minimum Commanders:", 11));
        this.BaseTextField.setToolTipText("<html>Minimum number of unit commanders this op needs for players to launch/defend it.</html>");
        this.BaseTextField.setName("MinimumUnitCommanders");
        victoryParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        victoryParamsPanel.add(new JLabel("Maximum Commanders:", 11));
        this.BaseTextField.setToolTipText("<html>Maximum number of unit commanders this op needs for players to launch/defend it.</html>");
        this.BaseTextField.setName("MaximumUnitCommanders");
        victoryParamsPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(checkBoxBox, 3);
        SpringLayoutHelper.setupSpringGrid(victoryParamsPanel, 2);
        masterBox.add(checkBoxBox);
        masterBox.add(victoryParamsPanel);
        victoryPanel.add(masterBox);
        JPanel teamParamsPanel = new JPanel(new SpringLayout());
        checkBoxBox = new JPanel(new SpringLayout());
        masterBox = new JPanel();
        masterBox.setLayout(new BoxLayout(masterBox, 1));
        this.BaseCheckBox = new JCheckBox("Free For All Op");
        this.BaseCheckBox.setToolTipText("<html>If checked this op become a free for all.<br>Unlimited number of defenders can join<br>The op will start when the attacker clicks on the commence link<br>or the leech time has timed out<br>This of note you will want to set Min planet ownership to 0<br>This way any player can join no matter what planet is hosting</html>");
        this.BaseCheckBox.setName("FreeForAllOperation");
        checkBoxBox.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Team Operation");
        this.BaseCheckBox.setToolTipText("<html>If checked this operation is set up for teams</html>");
        this.BaseCheckBox.setName("TeamOperation");
        checkBoxBox.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Random Teams");
        this.BaseCheckBox.setToolTipText("<html>If checked Players are randomly placed on teams</html>");
        this.BaseCheckBox.setName("RandomTeamDetermination");
        checkBoxBox.add(this.BaseCheckBox);
        this.BaseCheckBox = new JCheckBox("Same Factions");
        this.BaseCheckBox.setToolTipText("<html>If checked players are divided up based on factions</html>");
        this.BaseCheckBox.setName("TeamsMustBeSameFaction");
        checkBoxBox.add(this.BaseCheckBox);
        SpringLayoutHelper.setupSpringGrid(checkBoxBox, 3);
        this.BaseTextField = new JTextField(5);
        teamParamsPanel.add(new JLabel("Min Number Of Players:", 11));
        this.BaseTextField.setToolTipText("<html>Minimum number of players needed for<br>the Free For All to launch.</html>");
        this.BaseTextField.setName("MinNumberOfPlayers");
        teamParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        teamParamsPanel.add(new JLabel("Team Size:", 11));
        this.BaseTextField.setToolTipText("<html>Maximum number of players per team.</html>");
        this.BaseTextField.setName("TeamSize");
        teamParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        teamParamsPanel.add(new JLabel("Team Numbers:", 11));
        this.BaseTextField.setToolTipText("<html>Maximum number teams.</html>");
        this.BaseTextField.setName("NumberOfTeams");
        teamParamsPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(teamParamsPanel, 4);
        masterBox.add(checkBoxBox);
        masterBox.add(teamParamsPanel);
        teamPanel.add(masterBox);
        JPanel deploymentParamsPanel = new JPanel(new SpringLayout());
        JPanel deploymentParamsPanel2 = new JPanel(new SpringLayout());
        checkBoxBox = new JPanel(new SpringLayout());
        masterBox = new JPanel();
        masterBox.setLayout(new BoxLayout(masterBox, 1));
        JPanel deploymentBox = new JPanel();
        deploymentBox.setLayout(new BoxLayout(deploymentBox, 0));
        this.BaseCheckBox = new JCheckBox("Random Deployment");
        this.BaseCheckBox.setToolTipText("<html>If checked the operation picks what sides<br>the attacker and defender start on.</html>");
        this.BaseCheckBox.setName("RandomDeployment");
        checkBoxBox.add(this.BaseCheckBox);
        SpringLayoutHelper.setupSpringGrid(checkBoxBox, 3);
        this.BaseTextField = new JTextField(5);
        deploymentParamsPanel.add(new JLabel("Northwest:", 11));
        this.BaseTextField.setToolTipText("<html>Chances for the attacker to deploy Northwest</html>");
        this.BaseTextField.setName("DeployNorthwest");
        deploymentParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        deploymentParamsPanel.add(new JLabel("North:", 11));
        this.BaseTextField.setToolTipText("<html>Chances for the attacker to deploy North</html>");
        this.BaseTextField.setName("DeployNorth");
        deploymentParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        deploymentParamsPanel.add(new JLabel("Northeast:", 11));
        this.BaseTextField.setToolTipText("<html>Chances for the attacker to deploy Northeast</html>");
        this.BaseTextField.setName("DeployNortheast");
        deploymentParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        deploymentParamsPanel.add(new JLabel("East:", 11));
        this.BaseTextField.setToolTipText("<html>Chances for the attacker to deploy East</html>");
        this.BaseTextField.setName("DeployEast");
        deploymentParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        deploymentParamsPanel.add(new JLabel("Southeast:", 11));
        this.BaseTextField.setToolTipText("<html>Chances for the attacker to deploy Southeast</html>");
        this.BaseTextField.setName("DeploySoutheast");
        deploymentParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        deploymentParamsPanel.add(new JLabel("South:", 11));
        this.BaseTextField.setToolTipText("<html>Chances for the attacker to deploy South</html>");
        this.BaseTextField.setName("DeploySouth");
        deploymentParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        deploymentParamsPanel.add(new JLabel("Southwest:", 11));
        this.BaseTextField.setToolTipText("<html>Chances for the attacker to deploy Southwest</html>");
        this.BaseTextField.setName("DeploySouthwest");
        deploymentParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        deploymentParamsPanel.add(new JLabel("West:", 11));
        this.BaseTextField.setToolTipText("<html>Chances for the attacker to deploy West</html>");
        this.BaseTextField.setName("DeployWest");
        deploymentParamsPanel.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        deploymentParamsPanel.add(new JLabel("Edge:", 11));
        this.BaseTextField.setToolTipText("<html>Chances for the attacker to deploy Edge</html>");
        this.BaseTextField.setName("DeployEdge");
        deploymentParamsPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(deploymentParamsPanel, 2);
        this.BaseTextField = new JTextField(5);
        deploymentParamsPanel2.add(new JLabel("Northwest (Deep):", 11));
        this.BaseTextField.setToolTipText("<html>Chances for the attacker to deploy Northwest (Deep)</html>");
        this.BaseTextField.setName("DeployNorthwestdeep");
        deploymentParamsPanel2.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        deploymentParamsPanel2.add(new JLabel("North (Deep):", 11));
        this.BaseTextField.setToolTipText("<html>Chances for the attacker to deploy North (Deep)</html>");
        this.BaseTextField.setName("DeployNorthdeep");
        deploymentParamsPanel2.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        deploymentParamsPanel2.add(new JLabel("Northeast (Deep):", 11));
        this.BaseTextField.setToolTipText("<html>Chances for the attacker to deploy Northeast (Deep)</html>");
        this.BaseTextField.setName("DeployNortheastdeep");
        deploymentParamsPanel2.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        deploymentParamsPanel2.add(new JLabel("East (Deep):", 11));
        this.BaseTextField.setToolTipText("<html>Chances for the attacker to deploy East (Deep)</html>");
        this.BaseTextField.setName("DeployEastdeep");
        deploymentParamsPanel2.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        deploymentParamsPanel2.add(new JLabel("Southeast (Deep):", 11));
        this.BaseTextField.setToolTipText("<html>Chances for the attacker to deploy Southeast (Deep)</html>");
        this.BaseTextField.setName("DeploySoutheastdeep");
        deploymentParamsPanel2.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        deploymentParamsPanel2.add(new JLabel("South (Deep):", 11));
        this.BaseTextField.setToolTipText("<html>Chances for the attacker to deploy South (Deep)</html>");
        this.BaseTextField.setName("DeploySouthdeep");
        deploymentParamsPanel2.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        deploymentParamsPanel2.add(new JLabel("Southwest (Deep):", 11));
        this.BaseTextField.setToolTipText("<html>Chances for the attacker to deploy Southwest (Deep)</html>");
        this.BaseTextField.setName("DeploySouthwestdeep");
        deploymentParamsPanel2.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        deploymentParamsPanel2.add(new JLabel("West (deep):", 11));
        this.BaseTextField.setToolTipText("<html>Chances for the attacker to deploy West (Deep)</html>");
        this.BaseTextField.setName("DeployWestdeep");
        deploymentParamsPanel2.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        deploymentParamsPanel2.add(new JLabel("Center:", 11));
        this.BaseTextField.setToolTipText("<html>Chances for the attacker to deploy Center</html>");
        this.BaseTextField.setName("DeployCenter");
        deploymentParamsPanel2.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(deploymentParamsPanel2, 2);
        deploymentBox.add(deploymentParamsPanel);
        deploymentBox.add(deploymentParamsPanel2);
        masterBox.add(checkBoxBox);
        masterBox.add(deploymentBox);
        JPanel mapParamsPanel = new JPanel(new SpringLayout());
        JPanel mapParamsPanel2 = new JPanel(new SpringLayout());
        checkBoxBox = new JPanel(new SpringLayout());
        this.BaseCheckBox = new JCheckBox("Use Operation Map");
        this.BaseCheckBox.setToolTipText("<html>If checked use the Operation map instead of the terrain on the planet.</html>");
        this.BaseCheckBox.setName("UseOperationMap");
        checkBoxBox.add(this.BaseCheckBox);
        SpringLayoutHelper.setupSpringGrid(checkBoxBox, 1);
        this.BaseTextField = new JTextField(5);
        mapParamsPanel.add(new JLabel("Map Name:", 11));
        this.BaseTextField.setToolTipText("<html>Name of the map to use or surprise/generated if using sizes</html>");
        this.BaseTextField.setName("MapName");
        mapParamsPanel.add(this.BaseTextField);
        SpringLayoutHelper.setupSpringGrid(mapParamsPanel, 2);
        this.BaseTextField = new JTextField(5);
        mapParamsPanel2.add(new JLabel("Board Size X:", 11));
        this.BaseTextField.setToolTipText("<html>Number of maps along the X axis of the Board</html>");
        this.BaseTextField.setName("BoardSizeX");
        mapParamsPanel2.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        mapParamsPanel2.add(new JLabel("Board Size Y:", 11));
        this.BaseTextField.setToolTipText("<html>Number of maps along the Y axis of the board</html>");
        this.BaseTextField.setName("BoardSizeY");
        mapParamsPanel2.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        mapParamsPanel2.add(new JLabel("Map Size X:", 11));
        this.BaseTextField.setToolTipText("<html>X Size of the map<br>Also can be used to set the base X size of a generated map.</html>");
        this.BaseTextField.setName("MapSizeX");
        mapParamsPanel2.add(this.BaseTextField);
        this.BaseTextField = new JTextField(5);
        mapParamsPanel2.add(new JLabel("Map Size Y:", 11));
        this.BaseTextField.setToolTipText("<html>Y Size of the map<br>Also can be used to set the base Y size of a generated map.</html>");
        this.BaseTextField.setName("MapSizeY");
        mapParamsPanel2.add(this.BaseTextField);
        String[] mediumNames = new String[]{"Ground", "Atmosphere", "Space"};
        this.BaseComboBox = new JComboBox<String>(mediumNames);
        mapParamsPanel2.add(new JLabel("Map Medium:", 11));
        this.BaseComboBox.setToolTipText("<html>Ground, Space, Atmosphere</html>");
        this.BaseComboBox.setName("MapMedium");
        mapParamsPanel2.add(this.BaseComboBox);
        SpringLayoutHelper.setupSpringGrid(mapParamsPanel2, 4);
        masterBox.add(checkBoxBox);
        masterBox.add(mapParamsPanel);
        masterBox.add(mapParamsPanel2);
        deploymentPanel.add(masterBox);
        this.ConfigPane.addTab("Buildings", null, buildingsPanel, "Set up buildings for operations.");
        this.ConfigPane.addTab("Chicken/Leech", null, chickenLeechPanel, "<html>Set up what happens to those that flee and<br>those that don't pay attention to an attack.</html>");
        this.ConfigPane.addTab("Deployment", null, deploymentPanel, "Set Army Deployment Chances.");
        this.ConfigPane.addTab("Faction Limits", null, factionPanel, "Exlude factions from using or defending the op.");
        this.ConfigPane.addTab("Meta Awards", null, metaSetupPanel, "<html>Set what your faction gets for this op.<br>Land, Units, Components</html>");
        this.ConfigPane.addTab("Newbie Ops", null, newbieOpsPanel, "how to treat the new player in your life");
        this.ConfigPane.addTab("Operation Costs", null, costsPanel, "Cost to attack or defend an op");
        this.ConfigPane.addTab("Operation Results", null, opresultsPanel, "who gets payed what and how much");
        this.ConfigPane.addTab("Player Properties", null, playerPropertiesPanel, "<html>mins/maxes for players if<br>they can attack/defend an op</html>");
        this.ConfigPane.addTab("Pilot Exp", null, pilotExpPanel, "Set up how unit pilots will be reward for surviving.");
        this.ConfigPane.addTab("Ranges & Misc", null, rangePanel, "Ranges & Targets for the Op. Includes some Misc. values.");
        this.ConfigPane.addTab("Salvage", null, salvagePanel, "how the units are divied up");
        this.ConfigPane.addTab("Scenario Addons", null, scenarioPanel, "<html>Arty/mines anything given to an attacker/<br>defender besides their own units</HTML>");
        this.ConfigPane.addTab("Teams", null, teamPanel, "Team Settings For MegaMek");
        this.ConfigPane.addTab("Units", null, unitsPanel, "Unit mins and maxes for the op");
        this.ConfigPane.addTab("Victroy Conditions", null, victoryPanel, "Victory Conditions For MegaMek");
        this.pane.remove(0);
        this.pane.add((Component)this.ConfigPane, 0);
        this.pane.setVisible(true);
        this.repaint();
    }

    public void initShortOpVars() {
        for (int pos = this.ConfigPane.getComponentCount() - 1; pos >= 0; --pos) {
            JPanel panel = (JPanel)this.ConfigPane.getComponent(pos);
            this.findAndPopulateTextAndCheckBoxes(panel);
        }
    }

    public void saveShortOperations() {
        try {
            FileOutputStream out = new FileOutputStream(this.filePathName);
            PrintStream p = new PrintStream(out);
            for (int pos = this.ConfigPane.getComponentCount() - 1; pos >= 0; --pos) {
                JPanel panel = (JPanel)this.ConfigPane.getComponent(pos);
                this.findAndSaveConfigs(panel, p);
            }
            p.close();
            out.close();
            JOptionPane.showMessageDialog(null, this.taskName + " saved to " + this.filePathName, "File Saved", 1);
            this.changesMade = false;
            this.setTitle("MekWars Operations Editor (" + this.taskName + ")");
        }
        catch (Exception ex) {
            System.err.println("Unable to save file");
        }
    }

    public void loadShortOp() {
        this.opValues = new BackedTreeMap(this.defaultOperationInfo);
        FileDialog fDialog = new FileDialog((Frame)this, "Load Short Op File", 0);
        fDialog.setDirectory(System.getProperty("user.dir") + "/data/operations/short");
        fDialog.setVisible(true);
        if (fDialog.getFile() == null) {
            return;
        }
        File shortOP = new File(fDialog.getDirectory(), fDialog.getFile());
        this.filePathName = fDialog.getDirectory() + fDialog.getFile();
        this.taskName = fDialog.getFile().substring(0, fDialog.getFile().indexOf(".txt"));
        this.setTitle("MekWars Operations Editor (" + this.taskName + ")");
        try {
            FileInputStream fis = new FileInputStream(shortOP);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                String values = "";
                try {
                    values = dis.readLine();
                    StringTokenizer OperationOption = new StringTokenizer(values, "=");
                    String opVar = OperationOption.nextToken();
                    String value = OperationOption.nextToken();
                    this.opValues.put(opVar, value);
                }
                catch (Exception ex) {
                    System.err.println("Error reading file " + this.filePathName);
                    System.err.println("Bad value " + values);
                }
            }
        }
        catch (Exception ex) {
            System.err.println("Error loading file " + this.filePathName);
            CampaignData.mwlog.errLog(ex);
        }
        for (int pos = this.ConfigPane.getComponentCount() - 1; pos >= 0; --pos) {
            JPanel panel = (JPanel)this.ConfigPane.getComponent(pos);
            this.findAndPopulateTextAndCheckBoxes(panel, this.opValues);
        }
    }

    public void keyTyped(KeyEvent arg0) {
        if (arg0.getKeyCode() >= 32 && arg0.getKeyCode() <= 126) {
            this.changesMade = true;
            if (this.getTitle().indexOf("*") == -1) {
                this.setTitle(this.getTitle() + "*");
            }
        }
    }

    public void keyPressed(KeyEvent arg0) {
        if (arg0.getKeyCode() >= 32 && arg0.getKeyCode() <= 126) {
            this.changesMade = true;
            if (this.getTitle().indexOf("*") == -1) {
                this.setTitle(this.getTitle() + "*");
            }
        }
    }

    public void keyReleased(KeyEvent arg0) {
        if (arg0.getKeyCode() >= 32 && arg0.getKeyCode() <= 126) {
            this.changesMade = true;
            if (this.getTitle().indexOf("*") == -1) {
                this.setTitle(this.getTitle() + "*");
            }
        }
    }

    public void findAndPopulateTextAndCheckBoxes(JPanel panel) {
        String key = null;
        for (int fieldPos = panel.getComponentCount() - 1; fieldPos >= 0; --fieldPos) {
            Component field = panel.getComponent(fieldPos);
            if (field instanceof JPanel) {
                this.findAndPopulateTextAndCheckBoxes((JPanel)field);
                continue;
            }
            if (field instanceof JTextField) {
                JTextField textBox = (JTextField)field;
                key = textBox.getName();
                if (key == null) continue;
                textBox.setText(this.defaultOperationInfo.getDefault(key));
                textBox.addKeyListener(this);
                textBox.setPreferredSize(this.textBoxSize);
                textBox.setMaximumSize(this.textBoxSize);
                textBox.setMinimumSize(this.textBoxSize);
                continue;
            }
            if (field instanceof JCheckBox) {
                JCheckBox checkBox = (JCheckBox)field;
                key = checkBox.getName();
                if (key == null) {
                    System.err.println("Null Checkbox: " + checkBox.getToolTipText());
                    continue;
                }
                checkBox.setSelected(Boolean.parseBoolean(this.defaultOperationInfo.getDefault(key)));
                checkBox.addKeyListener(this);
                continue;
            }
            if (!(field instanceof JComboBox)) continue;
            JComboBox combo = (JComboBox)field;
            key = combo.getName();
            if (key == null) {
                System.err.println("Null Checkbox: " + combo.getToolTipText());
                continue;
            }
            combo.setSelectedIndex(Integer.parseInt(this.defaultOperationInfo.getDefault(key)));
        }
    }

    public void findAndPopulateTextAndCheckBoxes(JPanel panel, BackedTreeMap OperationInfo) {
        String key = null;
        for (int fieldPos = panel.getComponentCount() - 1; fieldPos >= 0; --fieldPos) {
            Component field = panel.getComponent(fieldPos);
            if (field instanceof JPanel) {
                this.findAndPopulateTextAndCheckBoxes((JPanel)field, OperationInfo);
                continue;
            }
            if (field instanceof JTextField) {
                JTextField textBox = (JTextField)field;
                key = textBox.getName();
                if (key == null) continue;
                textBox.setText(OperationInfo.getV(key));
                textBox.setPreferredSize(this.textBoxSize);
                textBox.setMaximumSize(this.textBoxSize);
                textBox.setMinimumSize(this.textBoxSize);
                continue;
            }
            if (field instanceof JCheckBox) {
                JCheckBox checkBox = (JCheckBox)field;
                key = checkBox.getName();
                if (key == null) {
                    System.err.println("Null Checkbox: " + checkBox.getToolTipText());
                    continue;
                }
                checkBox.setSelected(Boolean.parseBoolean(OperationInfo.getV(key)));
                continue;
            }
            if (!(field instanceof JComboBox)) continue;
            JComboBox combo = (JComboBox)field;
            key = combo.getName();
            if (key == null) {
                System.err.println("Null Checkbox: " + combo.getToolTipText());
                continue;
            }
            combo.setSelectedIndex(Integer.parseInt(OperationInfo.getV(key)));
        }
    }

    public void findAndSaveConfigs(JPanel panel, PrintStream p) {
        String key = null;
        String value = null;
        for (int fieldPos = panel.getComponentCount() - 1; fieldPos >= 0; --fieldPos) {
            Component field = panel.getComponent(fieldPos);
            if (field instanceof JPanel) {
                this.findAndSaveConfigs((JPanel)field, p);
                continue;
            }
            if (field instanceof JTextField) {
                JTextField textBox = (JTextField)field;
                value = textBox.getText();
                key = textBox.getName();
                if (key == null || value == null || value.equals(this.defaultOperationInfo.getDefault(key)) || value.length() <= 0) continue;
                p.println(key + "=" + value);
                continue;
            }
            if (field instanceof JCheckBox) {
                JCheckBox checkBox = (JCheckBox)field;
                value = Boolean.toString(checkBox.isSelected());
                key = checkBox.getName();
                if (key == null || value == null || Boolean.parseBoolean(value) == Boolean.parseBoolean(this.defaultOperationInfo.getDefault(key))) continue;
                p.println(key + "=" + value);
                continue;
            }
            if (!(field instanceof JComboBox)) continue;
            JComboBox combo = (JComboBox)field;
            value = Integer.toString(combo.getSelectedIndex());
            key = combo.getName();
            if (key == null || value == null || Integer.parseInt(value) == Integer.parseInt(this.defaultOperationInfo.getDefault(key))) continue;
            p.println(key + "=" + value);
        }
    }

    private JMenu createEditMenu() {
        JMenu jMenuOperations = new JMenu();
        jMenuOperations.setText("Edit");
        JMenuItem jMenuSendCurrentOperationFile = new JMenuItem();
        JMenuItem jMenuRetrieveOperationFile = new JMenuItem();
        JMenuItem jMenuSetOperationFile = new JMenuItem();
        JMenuItem jMenuSetNewOperationFile = new JMenuItem();
        JMenuItem jMenuSendAllOperationFiles = new JMenuItem();
        JMenuItem jMenuUpdateOperations = new JMenuItem();
        jMenuSendCurrentOperationFile.setText("Send Current File");
        jMenuSendCurrentOperationFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OperationsDialog.this.jMenuSendCurrentFile_actionPerformed(e);
            }
        });
        jMenuRetrieveOperationFile.setText("Retrieve Operation File");
        jMenuRetrieveOperationFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((MWClient)OperationsDialog.this.mwclient).getMainFrame().jMenuRetrieveOperationFile_actionPerformed(e);
            }
        });
        jMenuSetOperationFile.setText("Set Operation File");
        jMenuSetOperationFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((MWClient)OperationsDialog.this.mwclient).getMainFrame().jMenuSetOperationFile_actionPerformed(e);
            }
        });
        jMenuSetNewOperationFile.setText("Set New Operation File");
        jMenuSetNewOperationFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((MWClient)OperationsDialog.this.mwclient).getMainFrame().jMenuSetNewOperationFile_actionPerformed(e);
            }
        });
        jMenuSendAllOperationFiles.setText("Send All Local Op Files");
        jMenuSendAllOperationFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((MWClient)OperationsDialog.this.mwclient).getMainFrame().jMenuSendAllOperationFiles_actionPerformed(e);
            }
        });
        jMenuUpdateOperations.setText("Update Operations");
        jMenuUpdateOperations.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((MWClient)OperationsDialog.this.mwclient).getMainFrame().jMenuUpdateOperations_actionPerformed(e);
            }
        });
        int userLevel = ((MWClient)this.mwclient).getUser(((MWClient)this.mwclient).getUsername()).getUserlevel();
        if (userLevel >= ((MWClient)this.mwclient).getData().getAccessLevel("RetrieveOperation")) {
            jMenuOperations.add(jMenuRetrieveOperationFile);
        }
        if (userLevel >= ((MWClient)this.mwclient).getData().getAccessLevel("SetOperation")) {
            jMenuOperations.add(jMenuSendCurrentOperationFile);
            jMenuOperations.add(jMenuSetOperationFile);
            jMenuOperations.add(jMenuSetNewOperationFile);
            jMenuOperations.add(jMenuSendAllOperationFiles);
        }
        if (userLevel >= ((MWClient)this.mwclient).getData().getAccessLevel("UpdateOperations")) {
            jMenuOperations.add(jMenuUpdateOperations);
        }
        return jMenuOperations;
    }

    private void jMenuSendCurrentFile_actionPerformed(ActionEvent e) {
        File opFile;
        if (this.changesMade) {
            this.saveShortOperations();
        }
        if (!(opFile = new File("./data/operations/short/" + this.taskName + ".txt")).exists()) {
            return;
        }
        StringBuilder opData = new StringBuilder();
        try {
            FileInputStream fis = new FileInputStream(opFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            opData.append(this.taskName + "#");
            while (dis.ready()) {
                opData.append(dis.readLine().replaceAll("#", "(pound)") + "#");
            }
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Unable to read " + opFile);
            return;
        }
        ((MWClient)this.mwclient).sendChat("/c setoperation#short#" + opData.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BackedTreeMap
    extends TreeMap<String, String> {
        private static final long serialVersionUID = 1L;
        DefaultOperation defaults;

        public BackedTreeMap(DefaultOperation dop) {
            this.defaults = dop;
        }

        public String getV(String key) {
            Object toReturn = super.get(key);
            if (toReturn == null) {
                toReturn = this.defaults.getDefault(key);
            }
            return (String)toReturn;
        }
    }
}

