/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MMGame
implements Serializable {
    private static final long serialVersionUID = -7500735952739732172L;
    int port;
    int maxPlayers;
    String ip;
    String version;
    String comment = "";
    String hostName;
    String Status = "Open";
    TreeSet<String> currentPlayers = new TreeSet();

    public MMGame(String s) {
        StringTokenizer ST = new StringTokenizer(s, "~");
        this.hostName = ST.nextToken();
        this.ip = ST.nextToken();
        this.port = Integer.parseInt(ST.nextToken());
        this.maxPlayers = Integer.parseInt(ST.nextToken());
        this.version = ST.nextToken();
        if (ST.hasMoreTokens()) {
            this.comment = ST.nextToken();
        }
        while (ST.hasMoreTokens()) {
            this.currentPlayers.add(ST.nextToken());
        }
    }

    public MMGame(String name, String ip, int port, int maxpplayers, String version, String comment) {
        this.hostName = name;
        this.ip = ip;
        this.port = port;
        this.maxPlayers = maxpplayers;
        this.version = version;
        this.comment = comment;
        if (comment.trim().length() == 0) {
            comment = " ";
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.hostName + "~" + this.ip + "~" + this.port + "~" + this.maxPlayers + "~" + this.version + "~");
        if (this.comment == null || this.comment.length() == 0) {
            result.append(" ~");
        } else {
            result.append(this.comment + "~");
        }
        for (String currName : this.currentPlayers) {
            result.append(currName + "~");
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        MMGame game;
        if (o == null) {
            return false;
        }
        try {
            game = (MMGame)o;
        }
        catch (ClassCastException e) {
            return false;
        }
        return game.getHostName().equalsIgnoreCase(this.getHostName());
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getIp() {
        return this.ip;
    }

    public String getStatus() {
        return this.Status;
    }

    public void setStatus(String Status) {
        this.Status = Status;
    }

    public TreeSet<String> getCurrentPlayers() {
        return this.currentPlayers;
    }

    public void setCurrentPlayer(TreeSet<String> v) {
        this.currentPlayers = v;
    }

    public String getComment() {
        return this.comment;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getVersion() {
        return this.version;
    }
}

