/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import java.awt.Color;

public final class StringUtils {
    private static String[] colorWheel = new String[]{"blue", "BLUE", "black", "BLACK", "yellow", "YELLOW", "green", "GREEN", "red", "RED", "cyan", "CYAN", "gray", "GRAY", "darkGray", "DARK_GRAY", "lightGray", "LIGHT_GRAY", "orange", "ORANGE", "pink", "PINK", "magenta", "MAGENTA", "white", "WHITE"};
    private static Color[] colors = new Color[]{Color.blue, Color.BLUE, Color.black, Color.BLACK, Color.yellow, Color.YELLOW, Color.green, Color.GREEN, Color.red, Color.RED, Color.cyan, Color.CYAN, Color.gray, Color.GRAY, Color.darkGray, Color.DARK_GRAY, Color.lightGray, Color.LIGHT_GRAY, Color.orange, Color.ORANGE, Color.pink, Color.PINK, Color.magenta, Color.MAGENTA, Color.white, Color.WHITE};

    public static String aOrAn(String s, boolean lowerCase) {
        return StringUtils.aOrAn(s, lowerCase, true);
    }

    public static String aOrAn(String s, boolean lowerCase, boolean returnString) {
        String AorAn = "A ";
        String checkString = s.toLowerCase();
        if (checkString.toLowerCase().startsWith("a") || checkString.startsWith("e") || checkString.startsWith("i") || checkString.startsWith("o") || checkString.startsWith("u")) {
            AorAn = "An ";
        }
        if (lowerCase) {
            AorAn = AorAn.toLowerCase();
        }
        if (returnString) {
            return AorAn + " " + s;
        }
        return AorAn;
    }

    public static String addAnS(int i) {
        if (i > 1) {
            return "s";
        }
        return "";
    }

    public static Color html2Color(String htmlColor) {
        try {
            return Color.decode(htmlColor);
        }
        catch (RuntimeException e) {
            try {
                return Color.decode("#" + htmlColor);
            }
            catch (RuntimeException ex) {
                for (int pos = 0; pos < colorWheel.length; ++pos) {
                    if (!colorWheel[pos].equals(htmlColor)) continue;
                    return colors[pos];
                }
                return Color.lightGray;
            }
        }
    }

    public static String color2html(Color color) {
        return "#" + StringUtils.int2hex(color.getRed()) + StringUtils.int2hex(color.getGreen()) + StringUtils.int2hex(color.getBlue());
    }

    private static String int2hex(int i) {
        String s = Integer.toHexString(i);
        return s.length() == 2 ? s : "0" + s;
    }

    public static Color invertColor(Color color) {
        Color newColor = Color.white;
        int red = color.getRed();
        int blue = color.getBlue();
        int green = color.getGreen();
        red = red < 128 ? (red += 128) : (red -= 128);
        blue = blue < 128 ? (blue += 128) : (blue -= 128);
        green = green < 128 ? (green += 128) : (green -= 128);
        try {
            newColor = new Color(red, green, blue);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return newColor;
    }

    public static String hasBadChars(String string) {
        return StringUtils.hasBadChars(string, false);
    }

    public static String hasBadChars(String string, boolean pilot) {
        char[] badChars = new char[]{'%', '~', '$', '|', '*', '#', '@', '&', '^', '+', '=', ';', ':', '\'', '\"', '/', '\\', '{', '}'};
        for (int pos = badChars.length - 1; pos >= 0; --pos) {
            if (string.indexOf(badChars[pos]) == -1) continue;
            return "AM:Illegal string(" + badChars[pos] + " forbidden).";
        }
        if (string.toLowerCase().startsWith("vacant") && pilot) {
            return "AM:Illegal pilot name (\"vacant\" forbidden).";
        }
        return "";
    }
}

