/*
 * Decompiled with CFR 0.152.
 */
package dedicatedhost;

import common.CampaignData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import javax.swing.JOptionPane;

public class CConfig {
    public static final String CONFIG_FILE = "./data/mwconfig.txt";
    public static final String CONFIG_BACKUP_FILE = "./data/mwconfig.txt.bak";
    private Properties config = this.setDefaults();

    public CConfig(boolean dedicated) {
        FileInputStream fis;
        File configfile;
        if (!new File(CONFIG_FILE).exists() && !new File(CONFIG_BACKUP_FILE).exists()) {
            this.createConfig();
        }
        try {
            configfile = new File(CONFIG_FILE);
            fis = new FileInputStream(configfile);
            File backupfile = new File(CONFIG_BACKUP_FILE);
            if (backupfile.exists()) {
                FileInputStream backupStream = new FileInputStream(backupfile);
                if (fis.available() < backupStream.available()) {
                    try {
                        this.config.load(backupStream);
                        backupStream.close();
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.errLog(ex);
                        JOptionPane.showMessageDialog(null, "Unable to load Backup config file");
                    }
                } else {
                    this.config.load(fis);
                }
            } else {
                this.config.load(fis);
            }
            fis.close();
        }
        catch (IOException ie) {
            try {
                File configfile2 = new File(CONFIG_BACKUP_FILE);
                FileInputStream fis2 = new FileInputStream(configfile2);
                this.config.load(fis2);
                fis2.close();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
                JOptionPane.showMessageDialog(null, "Unable to load Backup config file");
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            JOptionPane.showMessageDialog(null, "Unable to load main config file");
        }
        try {
            configfile = new File("serverdata.dat");
            fis = new FileInputStream(configfile);
            this.config.load(fis);
            fis.close();
            configfile.delete();
            this.saveConfig();
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        this.setParam("DEDICATED", "TRUE");
    }

    private Properties setDefaults() {
        Properties defaults = new Properties();
        defaults.setProperty("NAME", "");
        defaults.setProperty("NAMEPASSWORD", "");
        defaults.setProperty("PORT", "2346");
        defaults.setProperty("SERVERIP", "");
        defaults.setProperty("SERVERPORT", "2347");
        defaults.setProperty("DATAPORT", "4867");
        defaults.setProperty("TIMEOUT", "180");
        defaults.setProperty("DEDICATED", "YES");
        defaults.setProperty("DEDICATEDOWNERNAME", "");
        defaults.setProperty("DEDAUTORESTART", "10");
        defaults.setProperty("SERVERPORT", "2347");
        defaults.setProperty("DATAPORT", "4867");
        defaults.setProperty("PORT", "2346");
        defaults.setProperty("MAXPLAYERS", "12");
        defaults.setProperty("MAXSAVEDGAMEDAYS", "7");
        defaults.setProperty("UPDATEKEY", "-1");
        defaults.setProperty("DEDMEMORY", "64");
        return defaults;
    }

    public void createConfig() {
        try {
            FileOutputStream fos = new FileOutputStream(CONFIG_FILE);
            PrintStream ps = new PrintStream(fos);
            ps.close();
            fos.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Failed to create config file. Check folder write access privledges?");
            System.exit(0);
        }
    }

    public String getParam(String param) {
        String tparam = null;
        if (param.endsWith(":")) {
            param = param.substring(0, param.lastIndexOf(":"));
        }
        if ((tparam = this.config.getProperty(param)) == null) {
            tparam = "";
        }
        return tparam;
    }

    public void setParam(String param, String value) {
        this.config.setProperty(param, value);
    }

    public boolean isParam(String param) {
        String tparam = this.getParam(param);
        return tparam.equalsIgnoreCase("YES") || tparam.equalsIgnoreCase("TRUE") || tparam.equalsIgnoreCase("ON");
    }

    public int getIntParam(String param) {
        int toReturn;
        try {
            toReturn = Integer.parseInt(this.getParam(param));
        }
        catch (Exception ex) {
            return 0;
        }
        return toReturn;
    }

    public void saveConfig() {
        PrintStream ps;
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(CONFIG_BACKUP_FILE);
            ps = new PrintStream(fos);
            this.config.store(ps, "Client Config Backup");
            fos.close();
            ps.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Failed backingup config file");
            return;
        }
        try {
            fos = new FileOutputStream(CONFIG_FILE);
            ps = new PrintStream(fos);
            this.config.store(ps, "Client Config");
            fos.close();
            ps.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Failed saving config file");
        }
    }
}

