/*
 * Decompiled with CFR 0.152.
 */
package dedicatedhost;

import common.CampaignData;
import common.MMGame;
import common.campaign.Buildings;
import dedicatedhost.CConfig;
import dedicatedhost.CUser;
import dedicatedhost.cmd.Command;
import dedicatedhost.protocol.CConnector;
import dedicatedhost.protocol.DataFetchClient;
import dedicatedhost.protocol.IClient;
import dedicatedhost.protocol.TransportCodec;
import dedicatedhost.protocol.commands.AckSignonPCmd;
import dedicatedhost.protocol.commands.CommPCmd;
import dedicatedhost.protocol.commands.IProtCommand;
import dedicatedhost.protocol.commands.PingPCmd;
import dedicatedhost.protocol.commands.PongPCmd;
import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.rmi.dgc.VMID;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import megamek.MegaMek;
import megamek.common.options.IOption;
import megamek.common.preference.IClientPreferences;
import megamek.common.preference.PreferenceManager;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MWDedHost
implements IClient {
    CConfig Config;
    DataFetchClient dataFetcher;
    public static final int STATUS_DISCONNECTED = 0;
    public static final int STATUS_LOGGEDOUT = 1;
    public static final String CLIENT_VERSION = "0.2.39.0";
    CConnector Connector;
    TimeOutThread TO;
    Collection<CUser> Users;
    TreeMap<String, MMGame> servers = new TreeMap();
    Server myServer = null;
    Date mytime = new Date(System.currentTimeMillis());
    Vector<IOption> GameOptions = new Vector(1, 1);
    Vector<String> decodeBuffer = new Vector(1, 1);
    boolean SignOff = false;
    public String myUsername = "";
    String password = "";
    String myDedOwners = "";
    int myPort = -1;
    int gameCount = 0;
    long lastResetCheck = System.currentTimeMillis();
    int dedRestartAt = 50;
    int savedGamesMaxDays = 30;
    long TimeOut = 120L;
    long LastPing = 0L;
    int Status = 0;
    Dimension MapSize;
    Dimension BoardSize;
    public static final String CAMPAIGN_PATH = "data/campaign/";
    public static final String PROTOCOL_DELIMITER = "\t";
    public static final String PROTOCOL_PREFIX = "/";
    public static final String COMMAND_DELIMITER = "|";
    public static final String GUI_PREFIX = "/";
    public static final String CAMPAIGN_PREFIX = "/";
    TreeMap<String, IProtCommand> ProtCommands = new TreeMap();
    HashMap<String, Command> commands = new HashMap();
    String LastQuery = "";
    private String cacheDir;
    public Properties serverConfigs = new Properties();
    Buildings buildingTemplate = null;

    public static void main(String[] args) {
        CampaignData.mwlog.enableLogging(true);
        CampaignData.mwlog.enableSeconds(true);
        CampaignData.mwlog.createClientLoggers();
        String logFileName = "./logs/megameklog.txt";
        try {
            PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFileName), 64));
            System.setOut(ps);
            System.setErr(ps);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Unable to redirect MegaMek output to " + logFileName);
        }
        CampaignData.mwlog.infoLog("Starting MekWars Client Version: 0.2.39.0");
        try {
            CConfig config = new CConfig(true);
            File cache = new File("./data/mechfiles/units.cache");
            if (cache.exists()) {
                cache.delete();
            }
            new MWDedHost(config);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Couldn't create Client Object");
            System.exit(1);
        }
    }

    public MWDedHost(CConfig config) {
        this.Config = config;
        this.Connector = new CConnector(this);
        this.Users = Collections.synchronizedList(new Vector(1, 1));
        this.createProtCommands();
        this.dataFetcher = new DataFetchClient(Integer.parseInt(this.Config.getParam("DATAPORT")), Integer.parseInt(this.Config.getParam("SOCKETTIMEOUTDELAY")));
        this.dataFetcher.setData(this.Config.getParam("SERVERIP"), this.getCacheDir());
        this.dataFetcher.closeDataConnection();
        File localGameOptions = new File("./mmconf");
        try {
            if (localGameOptions.exists() && (localGameOptions = new File("./mmconf/gameoptions.xml")).exists()) {
                localGameOptions.delete();
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        this.getServerConfigData();
        this.myUsername = this.getConfigParam("NAME");
        if (!this.myUsername.startsWith("[Dedicated]")) {
            this.Config.setParam("NAME", "[Dedicated] " + this.Config.getParam("NAME"));
            this.myUsername = this.Config.getParam("NAME");
        }
        this.dedRestartAt = Integer.parseInt(this.getConfigParam("DEDAUTORESTART"));
        this.savedGamesMaxDays = Integer.parseInt(this.getConfigParam("MAXSAVEDGAMEDAYS"));
        this.myDedOwners = this.getConfigParam("DEDICATEDOWNERNAME");
        this.myPort = Integer.parseInt(this.getConfigParam("PORT"));
        CampaignData.mwlog.infoLog("Starting pAS");
        PurgeAutoSaves pAS = new PurgeAutoSaves();
        new Thread(pAS).start();
        String chatServerIP = "";
        int chatServerPort = -1;
        try {
            chatServerIP = this.Config.getParam("SERVERIP");
            chatServerPort = this.Config.getIntParam("SERVERPORT");
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog(e);
            System.exit(1);
        }
        int retryCount = 0;
        while (this.Status == 0 && retryCount++ < 20) {
            this.connectToServer(chatServerIP, chatServerPort);
            if (this.Status != 0) continue;
            CampaignData.mwlog.infoLog("Couldn't connect to server. Retrying in 90 seconds.");
            try {
                Thread.sleep(90000L);
            }
            catch (Exception exe) {
                CampaignData.mwlog.errLog(exe);
                System.exit(2);
            }
        }
        this.TimeOut = Long.parseLong(this.Config.getParam("TIMEOUT"));
        this.LastPing = System.currentTimeMillis() / 1000L;
        this.TO = new TimeOutThread(this);
        this.TO.run();
    }

    public synchronized void doParseDataInput(String input) {
        if (this.decodeBuffer.size() > 0) {
            Iterator<String> i = this.decodeBuffer.iterator();
            while (i.hasNext()) {
                String currS = i.next();
                this.doParseDataHelper(currS);
                i.remove();
            }
        } else {
            this.doParseDataHelper(input);
        }
    }

    private void doParseDataHelper(String input) {
        try {
            if (input.length() == 0) {
                return;
            }
            StringTokenizer ST = null;
            String task = null;
            CampaignData.mwlog.infoLog(input);
            ST = new StringTokenizer(input, COMMAND_DELIMITER);
            task = ST.nextToken();
            if (!this.commands.containsKey(task)) {
                try {
                    Class<?> cmdClass = Class.forName(this.getClass().getPackage().getName() + ".cmd." + task);
                    Constructor<?> c = cmdClass.getConstructor(MWDedHost.class);
                    Command cmd = (Command)c.newInstance(this);
                    this.commands.put(task, cmd);
                }
                catch (Exception e) {
                    CampaignData.mwlog.errLog(e);
                }
            }
            if (this.commands.containsKey(task)) {
                this.commands.get(task).execute(input);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public synchronized void parseDedDataInput(String data) {
        if (data.startsWith("US|") || data.startsWith("NU|") || data.startsWith("UG|") || data.startsWith("RGTS|") || data.startsWith("DSD|") || data.startsWith("USD|")) {
            this.doParseDataHelper(data);
            return;
        }
        if (!data.startsWith("PM|")) {
            return;
        }
        data = data.substring(3);
        StringTokenizer st = new StringTokenizer(data, COMMAND_DELIMITER);
        StringTokenizer own = new StringTokenizer(this.myDedOwners, "$");
        String name = st.nextToken().trim();
        if (!st.hasMoreTokens()) {
            return;
        }
        if (name.equals(this.myUsername)) {
            return;
        }
        String command = st.nextToken().trim();
        if (command.equals("checkrestartcount")) {
            this.checkForRestart();
            return;
        }
        if (command.equals("displaymegameklog")) {
            CampaignData.mwlog.infoLog("display megameklog command received from " + name);
            try {
                File logFile = new File("./logs/megameklog.txt");
                FileInputStream fis = new FileInputStream(logFile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                this.sendChat("/c sendtomisc#" + name + "#MegaMek Log from " + this.myUsername);
                int counter = 0;
                while (dis.ready()) {
                    this.sendChat("/c sendtomisc#" + name + "#" + dis.readLine());
                    if (counter++ % 100 != 0) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception ex) {}
                }
                fis.close();
                dis.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.sendChat("/c mm# " + name + " used the display megamek logs command on " + this.myUsername);
            return;
        }
        if (command.equals("displaydederrorlog")) {
            CampaignData.mwlog.infoLog("display ded error command received from " + name);
            try {
                File logFile = new File("./logs/errlog.0");
                FileInputStream fis = new FileInputStream(logFile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                this.sendChat("/c sendtomisc#" + name + "#Error Log from " + this.myUsername);
                int counter = 0;
                while (dis.ready()) {
                    this.sendChat("/c sendtomisc#" + name + "#" + dis.readLine());
                    if (counter++ % 100 != 0) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception ex) {}
                }
                fis.close();
                dis.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.sendChat("/c mm# " + name + " used the display ded error log command on " + this.myUsername);
            return;
        }
        if (command.equals("displaydedlog")) {
            CampaignData.mwlog.infoLog("display ded log command received from " + name);
            try {
                File logFile = new File("./logs/infolog.0");
                FileInputStream fis = new FileInputStream(logFile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                this.sendChat("/c sendtomisc#" + name + "#Ded Log from " + this.myUsername);
                int counter = 0;
                while (dis.ready()) {
                    this.sendChat("/c sendtomisc#" + name + "#" + dis.readLine());
                    if (counter++ % 100 != 0) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception ex) {}
                }
                fis.close();
                dis.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.sendChat("/c mm# " + name + " used the display ded log command on " + this.myUsername);
            return;
        }
        while (this.myDedOwners.equals("") || own.hasMoreTokens()) {
            String owner = own.hasMoreTokens() ? own.nextToken() : "";
            if (!this.myDedOwners.equals("") && !name.equals(owner) && this.getUser(name).getUserlevel() < 100) continue;
            if (command.equals("restart")) {
                CampaignData.mwlog.infoLog("Restart command received from " + name);
                this.stopHost();
                File localGameOptions = new File("./mmconf");
                try {
                    if (localGameOptions.exists() && (localGameOptions = new File("./mmconf/gameoptions.xml")).exists()) {
                        localGameOptions.delete();
                    }
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
                this.sendChat("/c mm# " + name + " used the restart command on " + this.myUsername);
                this.restartDed();
                return;
            }
            if (command.equals("reset")) {
                CampaignData.mwlog.infoLog("Reset command received from " + name);
                if (this.myServer != null) {
                    this.resetGame();
                }
                this.sendChat("/c mm# " + name + " used the reset command on " + this.myUsername);
                return;
            }
            if (command.equals("die")) {
                this.goodbye();
                System.exit(0);
            } else {
                if (command.equals("start")) {
                    CampaignData.mwlog.infoLog("Start command received from " + name);
                    if (this.myServer == null) {
                        this.startHost(true, false, false);
                    }
                    this.sendChat("/c mm# " + name + " used the start command on " + this.myUsername);
                    return;
                }
                if (command.equals("stop")) {
                    CampaignData.mwlog.infoLog("Stop command received from " + name);
                    if (this.myServer != null) {
                        this.stopHost();
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.errLog(ex);
                    }
                    this.sendChat("/c mm# " + name + " used the stop command on " + this.myUsername);
                    return;
                }
                if (command.equals("owners")) {
                    CampaignData.mwlog.infoLog("Owners command received from " + name);
                    this.sendChat("/mail " + name + ", My owners: " + this.myDedOwners.replace('$', ' '));
                    this.sendChat("/c mm# " + name + " used the owners command on " + this.myUsername);
                    return;
                }
                if (command.startsWith("owner ")) {
                    CampaignData.mwlog.infoLog("Owner command received from " + name);
                    if (!this.myDedOwners.equals("")) {
                        this.myDedOwners = this.myDedOwners + "$";
                    }
                    this.myDedOwners = this.myDedOwners + command.substring("owner ".length()).trim();
                    this.getConfig().setParam("DEDICATEDOWNERNAME", this.myDedOwners);
                    this.getConfig().saveConfig();
                    this.setConfig();
                    this.sendChat("/c mm# " + name + " used the owner " + this.myDedOwners + " command on " + this.myUsername);
                    return;
                }
                if (command.equals("clearowners")) {
                    CampaignData.mwlog.infoLog("Clearowners command received from " + name);
                    this.myDedOwners = "";
                    this.sendChat("/mail " + name + ", My owners: " + this.myDedOwners);
                    this.getConfig().setParam("DEDICATEDOWNERNAME", this.myDedOwners);
                    this.getConfig().saveConfig();
                    this.setConfig();
                    this.sendChat("/c mm# " + name + " used the clear owners command on " + this.myUsername);
                    return;
                }
                if (command.equals("port")) {
                    CampaignData.mwlog.infoLog("Port command received from " + name);
                    this.sendChat("/mail " + name + ", My port: " + this.myPort);
                    this.sendChat("/c mm# " + name + " used the port command on " + this.myUsername);
                    return;
                }
                if (command.startsWith("port ")) {
                    int port;
                    CampaignData.mwlog.infoLog("Port (set) command received from " + name);
                    try {
                        port = Integer.parseInt(command.substring("port ".length()).trim());
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.infoLog("Command error: " + command + ": non-numeral port.");
                        return;
                    }
                    if (port > 0 && port < 65536) {
                        this.myPort = port;
                    } else {
                        CampaignData.mwlog.infoLog("Command error: " + command + ": port out of valid range.");
                    }
                    String portString = Integer.toString(this.myPort);
                    this.getConfig().setParam("PORT", portString);
                    this.getConfig().saveConfig();
                    this.setConfig();
                    this.sendChat("/c mm# " + name + " changed the port for " + this.myUsername + " to " + this.myPort);
                    return;
                }
                if (command.equals("savegamepurge")) {
                    CampaignData.mwlog.infoLog("Save game purge command received from " + name);
                    this.sendChat("/mail " + name + ", I purge saved games that are " + this.savedGamesMaxDays + " days old, or older.");
                    this.sendChat("/c mm# " + name + " used the save game purge command on " + this.myUsername);
                    return;
                }
                if (command.startsWith("savegamepurge ")) {
                    int mySavedGamesMaxDays = 7;
                    CampaignData.mwlog.infoLog("Savegamepurge command received from " + name);
                    try {
                        mySavedGamesMaxDays = Integer.parseInt(command.substring("savegamepurge ".length()).trim());
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.infoLog("Command error: " + command + ": invalid number.");
                        return;
                    }
                    String purgeString = Integer.toString(mySavedGamesMaxDays);
                    this.getConfig().setParam("MAXSAVEDGAMEDAYS", purgeString);
                    this.getConfig().saveConfig();
                    this.setConfig();
                    this.savedGamesMaxDays = mySavedGamesMaxDays;
                    this.sendChat("/c mm# " + name + " changed the save game purge for " + this.myUsername + " to " + mySavedGamesMaxDays + " days.");
                    return;
                }
                if (command.equals("displaysavedgames")) {
                    CampaignData.mwlog.infoLog("displaysavedgames command received from " + name);
                    String list = "<br><b>Saved files on " + this.myUsername + "</b><br>";
                    String dateTimeFormat = "MM/dd/yyyy HH:mm:ss";
                    SimpleDateFormat sDF = new SimpleDateFormat(dateTimeFormat);
                    try {
                        File tempFile = new File("./savegames/");
                        File[] fileList = tempFile.listFiles();
                        for (int i = 0; i < fileList.length; ++i) {
                            File dateFile = fileList[i];
                            Date date = new Date(dateFile.lastModified());
                            String dateTime = sDF.format(date);
                            list = list + "<a href=\"MEKMAIL" + this.myUsername + "*loadgamewithfullpath " + fileList[i] + "\">Load " + fileList[i] + "</a> " + dateTime + "<br>";
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.sendChat("/mail " + name + ", " + list);
                    this.sendChat("/c mm# " + name + " used the display saved games command on " + this.myUsername);
                    return;
                }
                if (command.equals("update")) {
                    this.sendChat("/c mm# " + name + " used the update command on " + this.myUsername);
                    CampaignData.mwlog.infoLog("Update command received from " + name);
                    this.stopHost();
                    this.updateDed();
                    return;
                }
                if (command.equals("ping")) {
                    CampaignData.mwlog.infoLog("Ping command received from " + name);
                    String version = CLIENT_VERSION;
                    this.sendChat("/mail " + name + ", I'm active with version " + version + ".");
                    this.sendChat("/c mm# " + name + " used the ping command on " + this.myUsername);
                    return;
                }
            }
            if (command.equals("loadgame") || command.startsWith("loadgame ")) {
                CampaignData.mwlog.infoLog("Loadgame command received from " + name);
                String filename = "";
                if (command.startsWith("loadgame ")) {
                    filename = command.substring("loadgame ".length()).trim();
                }
                if (command.equals("loadgame") || filename.equals("")) {
                    filename = "autosave.sav";
                }
                if (this.myServer != null) {
                    if (!this.loadGame(filename)) {
                        this.sendChat("/mail " + name + ", Unable to load saved game.");
                    } else {
                        this.sendChat("/mail " + name + ", Saved game loaded.");
                    }
                }
                this.sendChat("/c mm# " + name + " loaded game " + filename + " on " + this.myUsername);
                return;
            }
            if (command.startsWith("loadgamewithfullpath ")) {
                CampaignData.mwlog.infoLog("Loadgamewithfullpath command received from " + name);
                String filename = "";
                if (command.startsWith("loadgamewithfullpath ")) {
                    filename = command.substring("loadgamewithfullpath ".length()).trim();
                }
                if (command.equals("loadgamewithfullpath") || filename.equals("")) {
                    filename = "autosave.sav";
                }
                if (this.myServer != null) {
                    if (!this.loadGameWithFullPath(filename)) {
                        this.sendChat("/mail " + name + ", Unable to load saved game.");
                    } else {
                        this.sendChat("/mail " + name + ", Saved game loaded.");
                    }
                }
                this.sendChat("/c mm# " + name + " loaded game " + filename + " on " + this.myUsername);
                return;
            }
            if (command.equals("loadautosave")) {
                CampaignData.mwlog.infoLog("Loadautosave command received from " + name);
                String filename = "autosave.sav";
                if (this.myServer != null) {
                    filename = this.getParanoidAutoSave();
                    if (!this.loadGame(filename)) {
                        this.sendChat("/mail " + name + ", Unable to load saved game.");
                    } else {
                        this.sendChat("/mail " + name + ", " + filename + " loaded.");
                    }
                }
                this.sendChat("/c mm# " + name + " loaded " + filename + " game on " + this.myUsername);
                return;
            }
            if (command.startsWith("name ")) {
                CampaignData.mwlog.infoLog("Name command received from " + name);
                String myComName = command.substring("name ".length()).trim();
                this.getConfig().setParam("NAME", myComName);
                this.getConfig().saveConfig();
                this.setConfig();
                this.sendChat("/c mm# " + name + " used the set name command to change the name to " + myComName + " command on " + this.myUsername);
                this.Config.setParam("NAME", "[Dedicated] " + myComName);
                this.myUsername = this.Config.getParam("NAME");
                return;
            }
            if (command.startsWith("comment ")) {
                CampaignData.mwlog.infoLog("Prefix command received from " + name);
                String myComComment = command.substring("comment ".length()).trim();
                this.getConfig().setParam("COMMENT", myComComment);
                this.getConfig().saveConfig();
                this.setConfig();
                this.sendChat("/c mm# " + name + " has set the comment to " + myComComment + " on " + this.myUsername);
                return;
            }
            if (command.startsWith("players ")) {
                CampaignData.mwlog.infoLog("Prefix command received from " + name);
                try {
                    String numPlayers = command.substring("players ".length()).trim();
                    this.getConfig().setParam("MAXPLAYERS", numPlayers);
                    this.getConfig().saveConfig();
                    this.setConfig();
                    this.sendChat("/c mm# " + name + " has set the max number of players to " + numPlayers + " on " + this.myUsername);
                    return;
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                    CampaignData.mwlog.errLog("Unable to convert number of players to int");
                    return;
                }
            }
            if (command.equals("restartcount")) {
                CampaignData.mwlog.infoLog("Restartcount command received from " + name);
                this.sendChat("/mail " + name + ", My restart count is set to " + this.dedRestartAt + " my current game count is " + this.gameCount);
                this.sendChat("/c mm# " + name + " used the restartcount command on " + this.myUsername);
                return;
            }
            if (command.startsWith("restartcount ")) {
                CampaignData.mwlog.infoLog("restartcount change command received from " + name);
                try {
                    this.dedRestartAt = Integer.parseInt(command.substring("restartcount ".length()).trim());
                }
                catch (Exception ex) {
                    CampaignData.mwlog.infoLog("Command error: " + command + ": bad counter.");
                    return;
                }
                String restartString = Integer.toString(this.dedRestartAt);
                this.getConfig().setParam("DEDAUTORESTART", restartString);
                this.getConfig().saveConfig();
                this.setConfig();
                this.sendChat("/c mm# " + name + " changed the restart count for " + this.myUsername + " to " + this.dedRestartAt);
                return;
            }
            if (command.equals("getupdateurl")) {
                CampaignData.mwlog.infoLog("GetUpdateUrl command received from " + name);
                String updateURL = this.getConfigParam("UPDATEURL");
                this.sendChat("/c mm# " + name + " used the getUpdateURL command on " + this.myUsername);
                this.sendChat("/mail " + name + ", My update URL is " + updateURL + ".");
                return;
            }
            if (command.startsWith("setupdateurl ")) {
                CampaignData.mwlog.infoLog("setUpdateURL command received from " + name);
                String myUpdateURL = command.substring("setupdateurl ".length()).trim();
                this.getConfig().setParam("UPDATEURL", myUpdateURL);
                this.getConfig().saveConfig();
                this.setConfig();
                this.sendChat("/c mm# " + name + " used the set update url command to change the the update url to " + myUpdateURL + " on " + this.myUsername);
                return;
            }
            CampaignData.mwlog.infoLog("Command error: " + command + ": unknown command.");
            return;
        }
        this.sendChat("/c mm# " + name + " tried to use the " + command + " on " + this.myUsername + ", but does not have ownership.");
        this.sendChat("/mail " + name + ", You do not have management rights for this host!");
        CampaignData.mwlog.infoLog("Command error: " + command + ": access denied for " + name + ".");
    }

    protected void createProtCommands() {
        this.addProtCommand(new CommPCmd(this));
        this.addProtCommand(new PingPCmd(this));
        this.addProtCommand(new PongPCmd(this));
        this.addProtCommand(new AckSignonPCmd(this));
    }

    protected void addProtCommand(IProtCommand command) {
        this.ProtCommands.put(command.getName(), command);
    }

    IProtCommand getProtCommand(String command) {
        return this.ProtCommands.get(command);
    }

    public String getLastQuery() {
        return this.LastQuery;
    }

    public void setLastQuery(String name) {
        this.LastQuery = name;
    }

    public int getMyStatus() {
        return this.Status;
    }

    public void setLastPing(long lastping) {
        this.LastPing = lastping;
    }

    public String getStatus() {
        if (this.Status == 0) {
            return "Not connected";
        }
        if (this.Status == 1) {
            return "Logged out";
        }
        return "";
    }

    public String getShortTime() {
        this.mytime = new Date();
        StringTokenizer s = new StringTokenizer(this.mytime.toString());
        s.nextElement();
        s.nextElement();
        s.nextElement();
        String t = (String)s.nextElement();
        s = new StringTokenizer(t, ":");
        String result = "[" + s.nextElement() + ":" + s.nextElement() + "] ";
        return result;
    }

    public void sendChat(String s) {
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreElements()) {
            String str = (String)st.nextElement();
            if (str.trim().equals("")) continue;
            this.serverSend("CH|" + str);
        }
    }

    public String doEscape(String str) {
        if (str.indexOf("<a href=\"MEKINFO") != -1) {
            return str;
        }
        str = this.doEscapeString(str, 38, "&amp;");
        str = this.doEscapeString(str, 60, "&lt;");
        str = this.doEscapeString(str, 62, "&gt;");
        return str;
    }

    public String doEscapeString(String t, int character, String replace) {
        int pos = t.indexOf(character);
        if (pos != -1) {
            String res = "";
            if (pos > 0) {
                res = res + t.substring(0, pos);
            }
            res = res + replace;
            if (pos < t.length()) {
                res = res + this.doEscapeString(t.substring(pos + 1), character, replace);
            }
            return res;
        }
        return t;
    }

    protected Vector<String> splitString(String string, String splitter) {
        Vector<String> vector = new Vector<String>(1, 1);
        String[] splitted = string.split(splitter);
        for (int i = 0; i < splitted.length; ++i) {
            vector.add(splitted[i].trim());
        }
        Iterator i = vector.iterator();
        while (i.hasNext()) {
            String currString = (String)i.next();
            if (currString.trim().length() != 0) continue;
            i.remove();
        }
        return vector;
    }

    public TreeMap<String, MMGame> getServers() {
        return this.servers;
    }

    public synchronized CUser getUser(String name) {
        for (CUser currUser : this.Users) {
            if (!currUser.getName().equalsIgnoreCase(name)) continue;
            return currUser;
        }
        CUser dummyUser = new CUser();
        return dummyUser;
    }

    public synchronized void clearUserCampaignData() {
        for (CUser currUser : this.Users) {
            currUser.clearCampaignData();
        }
    }

    public synchronized Collection<CUser> getUsers() {
        return this.Users;
    }

    public String getProtocolVersion() {
        return "4";
    }

    public void setUsername(String s) {
        this.myUsername = s.trim();
    }

    public void setPassword(String s) {
        this.password = s;
    }

    public String getUsername() {
        return this.myUsername;
    }

    public CConfig getConfig() {
        return this.Config;
    }

    public void setConfig() {
        this.Config = new CConfig(false);
    }

    public String getConfigParam(String p) {
        String tparam = "";
        if (p.endsWith(":")) {
            p = p.substring(0, p.lastIndexOf(":"));
        }
        if (p.equals("NAME") && !this.myUsername.equals("")) {
            return this.myUsername;
        }
        if (p.equals("NAMEPASSWORD") && !this.password.equals("")) {
            return this.password;
        }
        tparam = this.Config.getParam(p);
        if (tparam == null) {
            tparam = "";
        }
        if (tparam.equals("") && p.equals("NAME") && this.isDedicated()) {
            CampaignData.mwlog.infoLog("Error: no dedicated name set.");
            System.exit(1);
        }
        return tparam;
    }

    @Override
    public void processIncoming(String incoming) {
        IProtCommand pcommand = null;
        if (incoming.startsWith("/")) {
            StringTokenizer ST = new StringTokenizer(incoming = incoming.substring("/".length()), PROTOCOL_DELIMITER);
            String s = ST.nextToken();
            pcommand = this.getProtCommand(s);
            if (pcommand != null && pcommand.check(s)) {
                if (!pcommand.execute(incoming)) {
                    CampaignData.mwlog.infoLog("COMMAND ERROR: wrong protocol command executed or execution failed.");
                    CampaignData.mwlog.infoLog("COMMAND RECEIVED: " + incoming);
                }
                return;
            }
            if (pcommand == null) {
                CampaignData.mwlog.infoLog("COMMAND ERROR: unknown protocol command from server.");
                CampaignData.mwlog.infoLog("COMMAND RECEIVED: " + incoming);
                return;
            }
        } else {
            CampaignData.mwlog.infoLog("COMMAND ERROR: received protocol command without protocol prefix.");
            CampaignData.mwlog.infoLog("COMMAND RECEIVED: " + incoming);
            return;
        }
    }

    @Override
    public void connectionLost() {
        this.Status = 0;
        if (this.SignOff) {
            return;
        }
        this.errorMessage("Connection lost.");
        if (this.isDedicated()) {
            this.stopHost();
            try {
                Thread.sleep(90000L);
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
            while (this.Status == 0) {
                this.connectToServer(this.Config.getParam("SERVERIP"), this.Config.getIntParam("SERVERPORT"));
                if (this.Status != 0) continue;
                CampaignData.mwlog.infoLog("Couldn't reconnect to server. Retrying in 120 seconds.");
                try {
                    Thread.sleep(90000L);
                }
                catch (Exception exe) {
                    CampaignData.mwlog.errLog(exe);
                }
            }
        } else {
            this.Users.clear();
        }
    }

    @Override
    public void connectionEstablished() {
        this.LastPing = System.currentTimeMillis() / 1000L;
        CampaignData.mwlog.errLog("Connected. Signing on.");
        String VersionSubID = new VMID().toString();
        StringTokenizer ST = new StringTokenizer(VersionSubID, ":");
        String passToSend = this.getConfigParam("NAMEPASSWORD");
        if (passToSend == null || passToSend.length() == 0) {
            passToSend = "1337";
        }
        this.Connector.send("/signon\t" + this.getConfigParam("NAME") + PROTOCOL_DELIMITER + passToSend + PROTOCOL_DELIMITER + this.getProtocolVersion() + PROTOCOL_DELIMITER + this.Config.getParam("COLOR") + PROTOCOL_DELIMITER + CLIENT_VERSION + PROTOCOL_DELIMITER + ST.nextToken());
        this.Status = 1;
    }

    public void connectToServer() {
        this.connectToServer(this.Config.getParam("SERVERIP"), this.Config.getIntParam("SERVERPORT"));
    }

    public void connectToServer(String ip, int port) {
        if (this.myUsername == null || this.myUsername.equals("")) {
            this.errorMessage("Username not set.");
            return;
        }
        this.Connector.connect(ip, port);
    }

    public void goodbye() {
        this.SignOff = true;
        if (this.Status != 0) {
            this.Connector.send("/signoff");
            this.dataFetcher.closeDataConnection();
            this.Connector.closeConnection();
        }
    }

    public CConnector getConnector() {
        return this.Connector;
    }

    public void serverSend(String s) {
        try {
            this.Connector.send("/comm\t" + TransportCodec.encode(s));
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog(e);
        }
    }

    public void startHost(boolean dedicated, boolean deploy, boolean loadSavegame) {
        String MMVersion;
        String ip = "127.0.0.1";
        if (!this.getConfigParam("IP:").equals("")) {
            try {
                ip = this.getConfigParam("IP:");
                InetAddress IA = InetAddress.getByName(ip);
                ip = IA.getHostAddress();
            }
            catch (Exception ex) {
                return;
            }
        }
        if (!(MMVersion = this.getserverConfigs("AllowedMegaMekVersion")).equals("-1") && !MMVersion.equalsIgnoreCase(MegaMek.VERSION)) {
            CampaignData.mwlog.errLog("You are using an invalid version of MegaMek. Please use version " + MMVersion);
            this.stopHost();
            this.updateDed();
            return;
        }
        if (this.servers.get(this.myUsername) != null) {
            if (this.isDedicated()) {
                CampaignData.mwlog.errLog("Attempted to start a second host while host was already running.");
            } else {
                String toUser = "CH|CLIENT: You already have a host open.";
                this.doParseDataInput(toUser);
            }
            return;
        }
        int MaxPlayers = Integer.parseInt(this.getConfigParam("MAXPLAYERS:"));
        String comment = this.getConfigParam("COMMENT:");
        String gpassword = this.getConfigParam("GAMEPASSWORD:");
        if (gpassword == null) {
            gpassword = "";
        }
        try {
            this.myServer = new Server(gpassword, this.myPort);
        }
        catch (Exception ex) {
            try {
                if (this.myServer == null) {
                    CampaignData.mwlog.errLog("Error opening dedicated server. Result = null host.");
                    CampaignData.mwlog.errLog(ex);
                } else {
                    CampaignData.mwlog.errLog("Error opening dedicated server. Will attempt a .die().");
                    CampaignData.mwlog.errLog(ex);
                    this.myServer.die();
                    this.myServer = null;
                }
            }
            catch (Exception e) {
                CampaignData.mwlog.errLog("Further error while trying to clean up failed host attempt.");
                CampaignData.mwlog.errLog(e);
            }
            return;
        }
        this.serverSend("NG|" + new MMGame(this.myUsername, ip, this.myPort, MaxPlayers, MegaMek.VERSION + " " + MegaMek.TIMESTAMP, comment).toString());
        this.clearSavedGames();
        this.purgeOldLogs();
        IClientPreferences cs = PreferenceManager.getClientPreferences();
        cs.setStampFilenames(Boolean.parseBoolean(this.getserverConfigs("MMTimeStampLogFile")));
    }

    public void stopHost() {
        this.serverSend("CG");
        try {
            if (this.myServer != null) {
                this.myServer.die();
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Megamek Error:");
            CampaignData.mwlog.errLog(ex);
        }
        this.myServer = null;
    }

    public void resetGame() {
        if (this.myServer != null) {
            this.myServer.resetGame();
        }
    }

    public boolean loadGame(String filename) {
        if (this.myServer != null && filename != null && !filename.equals("")) {
            return this.myServer.loadGame(new File("./savegames/", filename));
        }
        if (this.myServer == null) {
            CampaignData.mwlog.infoLog("MyServer == NULL!");
        }
        if (filename == null) {
            CampaignData.mwlog.infoLog("Filename == NULL!");
        } else if (filename.equals("")) {
            CampaignData.mwlog.infoLog("Filename == \"\"!");
        }
        return false;
    }

    public boolean loadGameWithFullPath(String filename) {
        if (this.myServer != null && filename != null && !filename.equals("")) {
            return this.myServer.loadGame(new File(filename));
        }
        if (this.myServer == null) {
            CampaignData.mwlog.infoLog("MyServer == NULL!");
        }
        if (filename == null) {
            CampaignData.mwlog.infoLog("Filename == NULL!");
        } else if (filename.equals("")) {
            CampaignData.mwlog.infoLog("Filename == \"\"!");
        }
        return false;
    }

    public boolean isServerRunning() {
        return this.myServer != null;
    }

    public void closingGame(String hostName) {
        CampaignData.mwlog.infoLog("Leaving " + hostName);
        this.serverSend("LG|" + hostName);
        System.gc();
    }

    public Vector<IOption> getGameOptions() {
        return this.GameOptions;
    }

    public Dimension getMapSize() {
        return this.MapSize;
    }

    public Dimension getBoardSize() {
        return this.BoardSize;
    }

    public void loadServerMegaMekGameOptions() {
        try {
            this.dataFetcher.getServerMegaMekGameOptions();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error loading Server MegaMekGameOptions files");
            CampaignData.mwlog.errLog(ex);
        }
    }

    public String getCacheDir() {
        this.cacheDir = "data/servers/" + this.Config.getParam("SERVERIP") + "." + this.Config.getParam("SERVERPORT");
        File dir = new File(this.cacheDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return this.cacheDir;
    }

    public void changeStatus(int newStatus) {
        this.Status = newStatus;
    }

    public boolean isAdmin() {
        return this.getUser(this.getUsername()).getUserlevel() >= 200;
    }

    public boolean isMod() {
        return this.getUser(this.getUsername()).getUserlevel() >= 100;
    }

    public void checkForRestart() {
        ++this.gameCount;
        if (System.currentTimeMillis() - 30000L < this.lastResetCheck) {
            return;
        }
        if (this.gameCount >= this.dedRestartAt) {
            CampaignData.mwlog.infoLog("System has reached " + this.gameCount + " games played and is restarting");
            try {
                Thread.sleep(5000L);
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
            try {
                this.stopHost();
                Thread.sleep(5000L);
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
            this.restartDed();
        }
        this.lastResetCheck = System.currentTimeMillis();
    }

    public void clearSavedGames() {
        long daysInSeconds = (long)this.savedGamesMaxDays * 24L * 60L * 60L * 1000L;
        File saveFiles = new File("./savegames/");
        if (!saveFiles.exists()) {
            return;
        }
        File[] fileList = saveFiles.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            File savedFile = fileList[i];
            long lastTime = savedFile.lastModified();
            if (!savedFile.exists() || !savedFile.isFile() || lastTime >= System.currentTimeMillis() - daysInSeconds) continue;
            try {
                CampaignData.mwlog.infoLog("Purging File: " + savedFile.getName() + " Time: " + lastTime + " purge Time: " + (System.currentTimeMillis() - daysInSeconds));
                savedFile.delete();
                continue;
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Error trying to delete these files!");
                CampaignData.mwlog.errLog(ex);
            }
        }
    }

    public void purgeOldLogs() {
        long daysInSeconds = (long)this.savedGamesMaxDays * 24L * 60L * 60L * 1000L;
        File saveFiles = new File("./logs/backup");
        if (!saveFiles.exists()) {
            return;
        }
        File[] fileList = saveFiles.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            File savedFile = fileList[i];
            long lastTime = savedFile.lastModified();
            if (!savedFile.exists() || !savedFile.isFile() || lastTime >= System.currentTimeMillis() - daysInSeconds) continue;
            try {
                CampaignData.mwlog.infoLog("Purging File: " + savedFile.getName() + " Time: " + lastTime + " purge Time: " + (System.currentTimeMillis() - daysInSeconds));
                savedFile.delete();
                continue;
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Error trying to delete these files!");
                CampaignData.mwlog.errLog(ex);
            }
        }
    }

    public String getParanoidAutoSave() {
        File tempFile = new File("./savegames/");
        AutoSaveFilter filter = new AutoSaveFilter();
        File[] fileList = tempFile.listFiles(filter);
        long time = 0L;
        String saveFile = "autosave.sav";
        for (int i = 0; i < fileList.length; ++i) {
            File newFile = fileList[i];
            if (newFile.lastModified() <= time) continue;
            time = newFile.lastModified();
            saveFile = newFile.getName();
        }
        return saveFile;
    }

    public void sendGameOptionsToServer() {
        StringBuilder packet = new StringBuilder();
        try {
            FileInputStream gameOptionsFile = new FileInputStream("./mmconf/gameoptions.xml");
            BufferedReader gameOptions = new BufferedReader(new InputStreamReader(gameOptionsFile));
            while (gameOptions.ready()) {
                packet.append(gameOptions.readLine() + "#");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sendChat("/c servergameoptions#" + packet.toString());
    }

    public void retrieveOpData(String type, String data) {
        StringTokenizer st = new StringTokenizer(data, "#");
        String opName = st.nextToken();
        File opFile = new File("./data/operations/" + type);
        if (!opFile.exists()) {
            opFile.mkdirs();
        }
        opFile = new File("./data/operations/" + type + "/" + opName + ".txt");
        try {
            FileOutputStream out = new FileOutputStream(opFile);
            PrintStream p = new PrintStream(out);
            while (st.hasMoreTokens()) {
                p.println(st.nextToken().replaceAll("\\(pound\\)", "#"));
            }
            p.close();
            out.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void retrieveMul(String data) {
        StringTokenizer st = new StringTokenizer(data, "#");
        String mulName = st.nextToken();
        File mulFile = new File("./data/armies/");
        if (!mulFile.exists()) {
            mulFile.mkdirs();
        }
        mulFile = new File("./data/armies/" + mulName);
        try {
            FileOutputStream out = new FileOutputStream(mulFile);
            PrintStream p = new PrintStream(out);
            while (st.hasMoreTokens()) {
                p.println(st.nextToken().replaceAll("\\(pound\\)", "#"));
            }
            p.close();
            out.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public boolean isDedicated() {
        return true;
    }

    public void updateParam(StringTokenizer ST) {
        try {
            this.getConfig().setParam(ST.nextToken(), ST.nextToken());
            this.getConfig().saveConfig();
            this.setConfig();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public Server getMyServer() {
        return this.myServer;
    }

    public boolean isUsingAdvanceRepairs() {
        return Boolean.parseBoolean(this.getserverConfigs("UseAdvanceRepair")) || Boolean.parseBoolean(this.getserverConfigs("UseSimpleRepair"));
    }

    @Override
    public void errorMessage(String message) {
    }

    @Override
    public void systemMessage(String message) {
    }

    public void getServerConfigData() {
        try {
            this.dataFetcher.getServerConfigData(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getserverConfigs(String key) {
        if (this.serverConfigs.getProperty(key) == null) {
            return "-1";
        }
        return this.serverConfigs.getProperty(key).trim();
    }

    public Properties getServerConfigs() {
        return this.serverConfigs;
    }

    public void setBuildingTemplate(Buildings buildingTemplate) {
        this.buildingTemplate = buildingTemplate;
    }

    public Buildings getBuildingTemplate() {
        return this.buildingTemplate;
    }

    private void restartDed() {
        try {
            String memory = this.Config.getParam("DEDMEMORY");
            Runtime runTime = Runtime.getRuntime();
            String[] call = new String[]{"java", "-Xmx" + memory + "m", "-jar", "MekWarsDed.jar"};
            runTime.exec(call);
            System.exit(0);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Unable to find MekWarsDed.jar");
        }
    }

    private void updateDed() {
        try {
            if (this.myServer != null) {
                this.myServer.die();
            }
            this.goodbye();
            Runtime runtime = Runtime.getRuntime();
            String[] call = new String[]{"java", "-jar", "MekWarsAutoUpdate.jar", "DEDICATED", this.getConfigParam("DEDUPDATECOMMANDFILE")};
            runtime.exec(call);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        System.exit(0);
    }

    private static class PurgeAutoSaves
    implements Runnable {
        public void run() {
            long twoHours = 0x6DDD00L;
            try {
                while (true) {
                    File saveFiles;
                    if (!(saveFiles = new File("./savegames")).exists()) {
                        return;
                    }
                    AutoSaveFilter filter = new AutoSaveFilter();
                    File[] fileList = saveFiles.listFiles(filter);
                    for (int i = 0; i < fileList.length; ++i) {
                        File savedFile = fileList[i];
                        long lastTime = savedFile.lastModified();
                        if (!savedFile.exists() || !savedFile.isFile() || lastTime >= System.currentTimeMillis() - twoHours) continue;
                        try {
                            CampaignData.mwlog.infoLog("Purging File: " + savedFile.getName() + " Time: " + lastTime + " purge Time: " + (System.currentTimeMillis() - twoHours));
                            savedFile.delete();
                            continue;
                        }
                        catch (Exception ex) {
                            CampaignData.mwlog.errLog("Error trying to delete these files!");
                            CampaignData.mwlog.errLog(ex);
                        }
                    }
                    Thread.sleep(twoHours);
                }
            }
            catch (Exception ex) {
                return;
            }
        }
    }

    static class AutoSaveFilter
    implements FilenameFilter {
        AutoSaveFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.startsWith("autosave");
        }
    }

    protected class TimeOutThread
    extends Thread {
        MWDedHost mwdedhost;

        public TimeOutThread(MWDedHost client) {
            this.mwdedhost = client;
        }

        public void run() {
            while (true) {
                try {
                    TimeOutThread.sleep(this.mwdedhost.TimeOut * 100L);
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
                if (this.mwdedhost.Status != 0) {
                    long timeout = System.currentTimeMillis() / 1000L - MWDedHost.this.LastPing;
                    if (timeout <= this.mwdedhost.TimeOut) continue;
                    MWDedHost.this.systemMessage("Ping timeout (" + timeout + " s)");
                    MWDedHost.this.Connector.closeConnection();
                    continue;
                }
                MWDedHost.this.LastPing = System.currentTimeMillis() / 1000L;
            }
        }
    }
}

