/*
 * Decompiled with CFR 0.152.
 */
package dedicatedhost.cmd;

import common.CampaignData;
import dedicatedhost.MWDedHost;
import dedicatedhost.cmd.Command;
import dedicatedhost.util.SerializeEntity;
import java.util.Enumeration;
import java.util.StringTokenizer;
import megamek.common.Building;
import megamek.common.Entity;
import megamek.common.Player;
import megamek.server.Server;

public class RGTS
extends Command {
    private Server server = null;

    public RGTS(MWDedHost mwclient) {
        super(mwclient);
    }

    public void execute(String input) {
        Entity ent;
        this.server = this.mwclient.getMyServer();
        if (this.server != null && this.server.getGame().getEntitiesVector().size() < 1) {
            return;
        }
        StringBuilder result = new StringBuilder();
        String name = "";
        String winnerName = "";
        if (this.server.getGame().getVictoryTeam() != 0) {
            int numberOfWinners = 0;
            for (Player p : this.server.getGame().getPlayersVector()) {
                if (p.getTeam() != this.server.getGame().getVictoryTeam()) continue;
                StringTokenizer st = new StringTokenizer(p.getName().trim(), "~");
                name = "";
                while (st.hasMoreElements()) {
                    name = st.nextToken().trim();
                }
                if (numberOfWinners > 0) {
                    winnerName = winnerName + "*";
                }
                ++numberOfWinners;
                winnerName = winnerName + name;
            }
            if (winnerName.endsWith("*")) {
                winnerName = winnerName.substring(0, winnerName.length() - 1);
            }
            winnerName = winnerName + "#";
        } else if (this.server.getGame().getVictoryPlayerId() == -1) {
            winnerName = "DRAW#";
        } else {
            winnerName = this.server.getGame().getPlayer(this.server.getGame().getVictoryPlayerId()).getName();
            StringTokenizer st = new StringTokenizer(winnerName, "~");
            name = "";
            while (st.hasMoreElements()) {
                name = st.nextToken().trim();
            }
            winnerName = name + "#";
        }
        result.append(winnerName);
        Enumeration<Entity> en = this.server.getGame().getDevastatedEntities();
        while (en.hasMoreElements()) {
            ent = en.nextElement();
            if (ent.getOwner().getName().startsWith("War Bot")) continue;
            result.append(SerializeEntity.serializeEntity(ent, true, false, this.mwclient.isUsingAdvanceRepairs()));
            result.append("#");
        }
        en = this.server.getGame().getGraveyardEntities();
        while (en.hasMoreElements()) {
            ent = en.nextElement();
            if (ent.getOwner().getName().startsWith("War Bot")) continue;
            result.append(SerializeEntity.serializeEntity(ent, true, false, this.mwclient.isUsingAdvanceRepairs()));
            result.append("#");
        }
        en = this.server.getGame().getEntities();
        while (en.hasMoreElements()) {
            ent = en.nextElement();
            if (ent.getOwner().getName().startsWith("War Bot")) continue;
            result.append(SerializeEntity.serializeEntity(ent, true, false, this.mwclient.isUsingAdvanceRepairs()));
            result.append("#");
        }
        en = this.server.getGame().getRetreatedEntities();
        while (en.hasMoreElements()) {
            ent = en.nextElement();
            if (ent.getOwner().getName().startsWith("War Bot")) continue;
            result.append(SerializeEntity.serializeEntity(ent, true, false, this.mwclient.isUsingAdvanceRepairs()));
            result.append("#");
        }
        if (this.mwclient.getBuildingTemplate() != null) {
            result.append("BL*" + this.getBuildingsLeft());
        }
        CampaignData.mwlog.infoLog("CR|" + result);
        this.mwclient.serverSend("CR|" + result.toString());
        this.mwclient.serverSend("SHS|" + this.mwclient.myUsername + "|Open");
        this.server.resetGame();
        this.mwclient.checkForRestart();
    }

    public int getBuildingsLeft() {
        Enumeration<Building> buildings = this.server.getGame().getBoard().getBuildings();
        int buildingCount = 0;
        while (buildings.hasMoreElements()) {
            buildings.nextElement();
            ++buildingCount;
        }
        return buildingCount;
    }
}

