/*
 * Decompiled with CFR 0.152.
 */
package dedicatedhost.protocol;

import common.CampaignData;
import dedicatedhost.protocol.ConnectionHandlerLocal;
import dedicatedhost.protocol.IClient;
import dedicatedhost.protocol.IConnectionHandler;
import dedicatedhost.protocol.IConnectionListener;
import java.io.IOException;
import java.net.Socket;

public class CConnector
implements IConnectionListener {
    protected IClient Client;
    protected String _host = "";
    protected int _port = -1;
    protected boolean _connected = false;
    protected IConnectionHandler _connectionHandler;

    public CConnector(IClient client) {
        this.Client = client;
    }

    public CConnector(IClient client, String host, int port) {
        this.Client = client;
        this._host = host;
        this._port = port;
    }

    public boolean isConnected() {
        return this._connected;
    }

    public void incomingMessage(String message) {
        this.Client.processIncoming(message);
    }

    public void socketClosed() {
        this._connected = false;
        this.Client.connectionLost();
    }

    public void send(String message) {
        if (message.indexOf("CH%7c%2fc+sendclientdata%23") < 0 && message.indexOf("CH%7c%2fc+sendtomisc%23") < 0 && message.indexOf("/pong") < 0) {
            CampaignData.mwlog.infoLog("SENT: " + message);
        }
        this._connectionHandler.queueMessage(message);
    }

    public void connect(String host, int port) {
        this._host = host;
        this._port = port;
        this.connect();
    }

    public void connect() {
        try {
            if (this._connected) {
                CampaignData.mwlog.errLog("already connected...");
                return;
            }
            if (this._host.equals("") || this._port == -1) {
                CampaignData.mwlog.errLog("no host or port set...");
                return;
            }
            IOException ioexception = null;
            CampaignData.mwlog.errLog("Opening socket connection to " + this._host + ":" + this._port);
            Socket s = null;
            try {
                s = new Socket(this._host, this._port);
                CampaignData.mwlog.errLog("CConnector: connected to " + this._host + ":" + this._port);
                s.setTcpNoDelay(true);
                this._connectionHandler = new ConnectionHandlerLocal(s);
                this._connectionHandler.setListener(this);
                this._connected = true;
                this.Client.connectionEstablished();
                return;
            }
            catch (IOException e) {
                ioexception = e;
                CampaignData.mwlog.errLog("giving up");
                if (ioexception != null) {
                    throw ioexception;
                }
            }
        }
        catch (IOException e) {
            CampaignData.mwlog.errLog(e);
            return;
        }
    }

    public void closeConnection() {
        this._connectionHandler.shutdown(true);
    }
}

