/*
 * Decompiled with CFR 0.152.
 */
package dedicatedhost.protocol;

import common.CampaignData;
import dedicatedhost.protocol.IConnectionHandler;
import dedicatedhost.protocol.IConnectionListener;
import dedicatedhost.protocol.ReaderThread;
import dedicatedhost.protocol.WriterThread;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;

public class ConnectionHandlerLocal
implements IConnectionHandler {
    protected PrintStream _out;
    protected Socket _socket;
    protected IConnectionListener _listener;
    protected ReaderThread _reader;
    protected WriterThread _writer;
    static final boolean DEBUG = false;

    public ConnectionHandlerLocal(Socket s) throws IOException {
        this._socket = s;
        this._out = new PrintStream(s.getOutputStream());
        this._reader = new ReaderThread(this, this._socket);
        this._writer = new WriterThread(this._out);
        this._writer.start();
    }

    public void setListener(IConnectionListener listener) {
        this._listener = listener;
        this._reader.setListener(listener);
        this._reader.start();
    }

    public void queueMessage(String message) {
        this._writer.queueMessage(message);
    }

    public void sendImmediately(String message) {
        this._out.println(message);
        this._out.flush();
    }

    public void shutdown(boolean notify) {
        this._reader.pleaseStop();
        this._writer.pleaseStop();
        this._writer.flushOutputQueue();
        try {
            this._socket.close();
        }
        catch (IOException e) {
            CampaignData.mwlog.errLog("Error closing socket.");
            CampaignData.mwlog.errLog(e);
        }
        if (notify) {
            this._listener.socketClosed();
        }
    }

    static final void DEBUG(String s) {
    }
}

