/*
 * Decompiled with CFR 0.152.
 */
package dedicatedhost.util;

import common.util.UnitUtils;
import java.util.Enumeration;
import megamek.common.Aero;
import megamek.common.BattleArmor;
import megamek.common.BipedMech;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.MechWarrior;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.Tank;

public class SerializeEntity {
    public static String serializeEntity(Entity e, boolean fullStatus, boolean forceDevastate, boolean useRepairs) {
        StringBuilder result = new StringBuilder();
        if (fullStatus) {
            if (!(e instanceof MechWarrior)) {
                result.append(e.getExternalId() + "*");
                result.append(e.getOwner().getName().trim() + "*");
                result.append(e.getCrew().getHits() + "*");
                if (forceDevastate) {
                    result.append("1024*");
                } else {
                    result.append(e.getRemovalCondition() + "*");
                }
                if (e instanceof BipedMech) {
                    result.append("0*");
                } else if (e instanceof QuadMech) {
                    result.append("6*");
                } else if (e instanceof Tank) {
                    result.append("1*");
                } else if (e instanceof Protomech) {
                    result.append("3*");
                } else if (e instanceof BattleArmor) {
                    result.append("4*");
                } else if (e instanceof Aero) {
                    result.append("5*");
                } else {
                    result.append("2*");
                }
                Enumeration<Entity> en = e.getKills();
                if (!en.hasMoreElements()) {
                    result.append(" *");
                }
                while (en.hasMoreElements()) {
                    Entity kill = en.nextElement();
                    result.append(kill.getExternalId());
                    if (en.hasMoreElements()) {
                        result.append("~");
                        continue;
                    }
                    result.append("*");
                }
            }
            if (e instanceof Mech) {
                result.append(e.getCrew().isUnconscious() + "*");
                result.append(e.getInternal(1) + "*");
                result.append(e.getInternal(0) + "*");
                result.append(e.getInternal(7) + "*");
                result.append(e.getInternal(6) + "*");
                result.append(e.getInternal(5) + "*");
                result.append(e.getInternal(4) + "*");
                result.append(e.getBadCriticals(0, 4, 1) + "*");
                result.append(((Mech)e).getCockpitType() + "*");
                if (useRepairs) {
                    result.append(UnitUtils.unitBattleDamage(e) + "*");
                }
                result.append(UnitUtils.getEntityFileName(e));
            } else if (e instanceof Tank) {
                result.append(e.isRepairable() + "*");
                result.append(e.isImmobile() + "*");
                result.append(e.getCrew().isDead() + "*");
                if (useRepairs) {
                    result.append(UnitUtils.unitBattleDamage(e) + "*");
                }
                result.append(UnitUtils.getEntityFileName(e));
            } else if (e instanceof Aero) {
                result.append(e.isRepairable() + "*");
                result.append(e.isImmobile() + "*");
                result.append(e.getCrew().isDead() + "*");
                result.append(UnitUtils.getEntityFileName(e));
            } else if (e instanceof MechWarrior) {
                MechWarrior mw = (MechWarrior)e;
                result.append("MW*");
                result.append(mw.getOriginalRideExternalId() + "*");
                result.append(mw.getPickedUpByExternalId() + "*");
                result.append(mw.isDestroyed() + "*");
            }
            if (e.isOffBoard()) {
                result.append(e.getOffBoardDistance() + "*");
            }
        } else if (e instanceof MechWarrior) {
            MechWarrior mw = (MechWarrior)e;
            result.append("MW*" + mw.getOriginalRideExternalId() + "*");
            result.append(mw.getPickedUpByExternalId() + "*");
            result.append(mw.isDestroyed() + "*");
        } else {
            result.append(e.getOwner().getName() + "*");
            result.append(e.getExternalId() + "*");
            if (forceDevastate) {
                result.append("1024*");
            } else {
                result.append(e.getRemovalCondition() + "*");
            }
            if (e instanceof Mech) {
                result.append(e.getInternal(1) + "*");
                result.append(e.getInternal(0) + "*");
            } else {
                result.append("1*");
                result.append("1*");
            }
            result.append(e.isRepairable() + "*");
        }
        return result.toString();
    }
}

