/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.commands;

import megamek.client.Client;
import megamek.client.commands.ClientCommand;
import megamek.common.Coords;
import megamek.common.LosEffects;
import megamek.common.ToHitData;

public class RulerCommand
extends ClientCommand {
    public RulerCommand(Client client) {
        super(client, "ruler", "Show Line of Sight (LOS) information between two points of the map. Usage: #ruler x1 y1 x2 y2 [elev1 [elev2]]. Where x1, y1 and x2, y2 are the coordiantes of the tiles, and the optional elev numbers are the elevations of the targets over the terrain. If elev is not given 1 is assumed which is for standing mechs. Prone mechs and most other units are at elevation 0.");
    }

    public String run(String[] stringArray) {
        try {
            ToHitData toHitData;
            int n = 1;
            int n2 = 1;
            Coords coords = null;
            Coords coords2 = null;
            String string = "";
            String string2 = "";
            coords = new Coords(Integer.parseInt(stringArray[1]) - 1, Integer.parseInt(stringArray[2]) - 1);
            coords2 = new Coords(Integer.parseInt(stringArray[3]) - 1, Integer.parseInt(stringArray[4]) - 1);
            if (stringArray.length > 5) {
                try {
                    n = Integer.parseInt(stringArray[5]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (stringArray.length > 6) {
                    try {
                        n = Integer.parseInt(stringArray[6]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if ((toHitData = LosEffects.calculateLos(this.client.game, this.buildAttackInfo(coords, coords2, n, n2)).losModifiers(this.client.game)).getValue() != Integer.MAX_VALUE) {
                string = toHitData.getValue() + " because ";
            }
            string = string + toHitData.getDesc();
            toHitData = LosEffects.calculateLos(this.client.game, this.buildAttackInfo(coords2, coords, n2, n)).losModifiers(this.client.game);
            if (toHitData.getValue() != Integer.MAX_VALUE) {
                string2 = toHitData.getValue() + " because  ";
            }
            string2 = string2 + toHitData.getDesc();
            return "The ToHit from hex (" + (coords.x + 1) + ", " + (coords.y + 1) + ") at elevation " + n + " to (" + (coords2.x + 1) + ", " + (coords2.y + 1) + ") at elevation " + n2 + " has a range of " + coords.distance(coords2) + " and a modifier of " + string + " and return fire has a modifier of " + string2 + ".";
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return "Error parsing the ruler command. Usage: #ruler x1 y1 x2 y2 [elev1 [elev2]] where x1, y1, x2, y2, and the optional elev agruments are integers.";
    }

    private LosEffects.AttackInfo buildAttackInfo(Coords coords, Coords coords2, int n, int n2) {
        LosEffects.AttackInfo attackInfo = new LosEffects.AttackInfo();
        attackInfo.attackPos = coords;
        attackInfo.targetPos = coords2;
        attackInfo.attackHeight = n;
        attackInfo.targetHeight = n2;
        attackInfo.attackAbsHeight = this.client.getBoard().getHex(coords).floor() + n;
        attackInfo.targetAbsHeight = this.client.getBoard().getHex(coords2).floor() + n2;
        return attackInfo;
    }
}

