/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.UnitFailureDialog;
import megamek.client.ui.AWT.UnitLoadingDialog;
import megamek.client.ui.AWT.widget.BufferedPanel;
import megamek.client.ui.MechView;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.EntityWeightClass;
import megamek.common.EquipmentType;
import megamek.common.FighterSquadron;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.MechSummaryComparator;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Tank;
import megamek.common.TechConstants;
import megamek.common.UnitType;
import megamek.common.WeaponType;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.options.PilotOptions;
import megamek.common.preference.IClientPreferences;
import megamek.common.preference.PreferenceManager;
import megamek.common.verifier.EntityVerifier;
import megamek.common.verifier.TestEntity;
import megamek.common.verifier.TestMech;
import megamek.common.verifier.TestTank;

public class CustomFighterSquadronDialog
extends Dialog
implements ActionListener,
ItemListener,
KeyListener,
Runnable,
WindowListener {
    private static final long serialVersionUID = 4037247031384528887L;
    private static final int KEY_TIMEOUT = 1000;
    private String[] m_saSorts = new String[]{Messages.getString("MechSelectorDialog.0"), Messages.getString("MechSelectorDialog.1"), Messages.getString("MechSelectorDialog.2"), Messages.getString("MechSelectorDialog.3"), Messages.getString("MechSelectorDialog.4"), Messages.getString("MechSelectorDialog.5")};
    private MechSummary[] m_mechsCurrent;
    private Client m_client;
    private ClientGUI m_clientgui;
    private UnitLoadingDialog unitLoadingDialog;
    private StringBuffer m_sbSearch = new StringBuffer();
    private long m_nLastSearch = 0L;
    private Label m_labelWeightClass = new Label(Messages.getString("MechSelectorDialog.m_labelWeightClass"), 2);
    private Choice m_chWeightClass = new Choice();
    private Label m_labelType = new Label(Messages.getString("MechSelectorDialog.m_labelType"), 2);
    private Choice m_chType = new Choice();
    private Choice m_chUnitType = new Choice();
    private Label m_labelSort = new Label(Messages.getString("MechSelectorDialog.m_labelSort"), 2);
    private Choice m_chSort = new Choice();
    private Panel m_pParams = new Panel();
    private Panel m_pListOptions = new Panel();
    private Label m_labelListOptions = new Label(Messages.getString("MechSelectorDialog.m_labelListOptions"));
    private Checkbox m_cModel = new Checkbox(Messages.getString("MechSelectorDialog.m_cModel"), GUIPreferences.getInstance().getMechSelectorIncludeModel());
    private Checkbox m_cName = new Checkbox(Messages.getString("MechSelectorDialog.m_cName"), GUIPreferences.getInstance().getMechSelectorIncludeName());
    private Checkbox m_cTons = new Checkbox(Messages.getString("MechSelectorDialog.m_cTons"), GUIPreferences.getInstance().getMechSelectorIncludeTons());
    private Checkbox m_cBV = new Checkbox(Messages.getString("MechSelectorDialog.m_cBV"), GUIPreferences.getInstance().getMechSelectorIncludeBV());
    private Checkbox m_cYear = new Checkbox(Messages.getString("MechSelectorDialog.m_cYear"), GUIPreferences.getInstance().getMechSelectorIncludeYear());
    private Checkbox m_cLevel = new Checkbox(Messages.getString("MechSelectorDialog.m_cLevel"), GUIPreferences.getInstance().getMechSelectorIncludeLevel());
    private Checkbox m_cCost = new Checkbox(Messages.getString("MechSelectorDialog.m_cCost"), GUIPreferences.getInstance().getMechSelectorIncludeCost());
    private Button butRemove = new Button("<<");
    private Button butAdd = new Button(">>");
    private Panel m_pOpenAdvanced = new Panel();
    private Button m_bToggleAdvanced = new Button("< Advanced Search >");
    private Panel m_pSouthParams = new Panel();
    List m_mechList = new List(10);
    private List listFightersSelected = new List();
    private Vector<Entity> squadron = new Vector();
    private Button m_bPick = new Button(Messages.getString("CustomFighterSquadronDialog.m_bPick"));
    private Button m_bCancel = new Button(Messages.getString("Close"));
    private Panel m_pButtons = new Panel();
    private Panel m_pChooseButtons = new Panel();
    private TextArea m_mechView = new TextArea("", 36, 35);
    private TextArea squadronView = new TextArea("", 18, 35);
    private Panel m_pLeft = new Panel();
    private Panel m_pMiddle = new Panel();
    private Choice m_cWalk = new Choice();
    private TextField m_tWalk = new TextField(2);
    private Choice m_cJump = new Choice();
    private TextField m_tJump = new TextField(2);
    private Choice m_cArmor = new Choice();
    private TextField m_tWeapons1 = new TextField(2);
    private Choice m_cWeapons1 = new Choice();
    private Choice m_cOrAnd = new Choice();
    private TextField m_tWeapons2 = new TextField(2);
    private Choice m_cWeapons2 = new Choice();
    private Checkbox m_chkEquipment = new Checkbox();
    private Choice m_cEquipment = new Choice();
    private TextField m_tStartYear = new TextField(4);
    private TextField m_tEndYear = new TextField(4);
    private Button m_bSearch = new Button(Messages.getString("MechSelectorDialog.Search.Search"));
    private Button m_bReset = new Button(Messages.getString("MechSelectorDialog.Search.Reset"));
    private Label m_lCount = new Label();
    private int m_count;
    private int m_old_nType;
    private int m_old_nUnitType;
    private Panel m_pUpper = new Panel();
    private Panel m_pLower = new Panel();
    BufferedPanel m_pPreview = new BufferedPanel();
    private Label m_labelPlayer = new Label(Messages.getString("MechSelectorDialog.m_labelPlayer"), 2);
    private Choice m_chPlayer = new Choice();
    private boolean includeMaxTech;
    private EntityVerifier entityVerifier = new EntityVerifier(new File("data/mechfiles/UnitVerifierOptions.xml"));
    private static final String SPACES = "                        ";

    public CustomFighterSquadronDialog(ClientGUI clientGUI, UnitLoadingDialog unitLoadingDialog) {
        super(clientGUI.frame, Messages.getString("CustomFighterSquadronDialog.title"), true);
        this.m_client = clientGUI.getClient();
        this.m_clientgui = clientGUI;
        this.unitLoadingDialog = unitLoadingDialog;
        for (int i = 0; i < this.m_saSorts.length; ++i) {
            this.m_chSort.addItem(this.m_saSorts[i]);
        }
        this.updatePlayerChoice();
        this.m_pParams.setLayout(new GridLayout(3, 2));
        this.m_pParams.add(this.m_labelWeightClass);
        this.m_pParams.add(this.m_chWeightClass);
        this.m_pParams.add(this.m_labelType);
        this.m_pParams.add(this.m_chType);
        this.m_pParams.add(this.m_labelSort);
        this.m_pParams.add(this.m_chSort);
        this.m_pChooseButtons.setLayout(new GridLayout(6, 2));
        this.m_pChooseButtons.add(this.butAdd);
        this.m_pChooseButtons.add(this.butRemove);
        this.m_pListOptions.add(this.m_labelListOptions);
        this.m_cModel.addItemListener(this);
        this.m_pListOptions.add(this.m_cModel);
        this.m_cName.addItemListener(this);
        this.m_pListOptions.add(this.m_cName);
        this.m_cTons.addItemListener(this);
        this.m_pListOptions.add(this.m_cTons);
        this.m_cBV.addItemListener(this);
        this.m_pListOptions.add(this.m_cBV);
        this.m_cYear.addItemListener(this);
        this.m_pListOptions.add(this.m_cYear);
        this.m_cLevel.addItemListener(this);
        this.m_pListOptions.add(this.m_cLevel);
        this.m_cCost.addItemListener(this);
        this.m_pListOptions.add(this.m_cCost);
        if (GUIPreferences.getInstance().getMechSelectorShowAdvanced()) {
            this.buildSouthParams(true);
        } else {
            this.buildSouthParams(false);
        }
        this.m_pButtons.setLayout(new FlowLayout(1));
        this.m_pButtons.add(this.m_bPick);
        this.m_pButtons.add(this.m_bCancel);
        this.m_pButtons.add(this.m_labelPlayer);
        this.m_pButtons.add(this.m_chPlayer);
        this.m_pUpper.setLayout(new BorderLayout());
        this.m_pPreview.setPreferredSize(84, 72);
        this.m_pUpper.add((Component)this.m_pParams, "West");
        this.m_pUpper.add((Component)this.m_pPreview, "Center");
        this.m_pUpper.add((Component)this.m_pSouthParams, "South");
        this.m_pLower.setLayout(new BorderLayout());
        this.m_mechList.setFont(new Font("Monospaced", 0, 12));
        this.m_mechList.addKeyListener(this);
        this.m_pLower.add((Component)this.m_mechList, "Center");
        this.m_pLower.add((Component)this.m_pButtons, "South");
        this.m_pLower.add((Component)this.m_pChooseButtons, "East");
        this.m_pLeft.setLayout(new BorderLayout());
        this.m_pLeft.add((Component)this.m_pUpper, "North");
        this.m_pLeft.add((Component)this.m_pLower, "Center");
        this.m_pMiddle.setLayout(new BorderLayout());
        this.m_pMiddle.add((Component)this.listFightersSelected, "Center");
        this.squadronView.setFont(new Font("Monospaced", 0, 12));
        this.m_pMiddle.add((Component)this.squadronView, "South");
        this.clearSquadPreview();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_pLeft, "West");
        this.add((Component)this.m_pMiddle, "Center");
        this.m_mechView.setFont(new Font("Monospaced", 0, 12));
        this.add((Component)this.m_mechView, "East");
        this.clearMechPreview();
        this.listFightersSelected.addItemListener(this);
        this.listFightersSelected.addKeyListener(this);
        this.m_chWeightClass.addItemListener(this);
        this.m_chType.addItemListener(this);
        this.m_chUnitType.addItemListener(this);
        this.m_chSort.addItemListener(this);
        this.m_mechList.addItemListener(this);
        this.m_bPick.addActionListener(this);
        this.m_bCancel.addActionListener(this);
        this.m_bSearch.addActionListener(this);
        this.m_bReset.addActionListener(this);
        this.m_bToggleAdvanced.addActionListener(this);
        this.butAdd.addActionListener(this);
        this.butRemove.addActionListener(this);
        this.setSize(1100, 350);
        this.setLocation(this.computeDesiredLocation());
        this.populateChoices();
        this.addWindowListener(this);
        this.updateWidgetEnablements();
    }

    private void buildSouthParams(boolean bl) {
        if (bl) {
            this.m_bToggleAdvanced.setLabel(Messages.getString("MechSelectorDialog.Search.Hide"));
            this.m_pOpenAdvanced.add(this.m_bToggleAdvanced);
            this.m_pSouthParams.setLayout(new GridLayout(11, 1));
            this.m_pSouthParams.add(this.m_pListOptions);
            this.m_pSouthParams.add(this.m_pOpenAdvanced);
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout(0));
            panel.add(new Label(Messages.getString("MechSelectorDialog.Search.Walk")));
            panel.add(this.m_cWalk);
            panel.add(this.m_tWalk);
            this.m_pSouthParams.add(panel);
            Panel panel2 = new Panel();
            panel2.setLayout(new FlowLayout(0));
            panel2.add(new Label(Messages.getString("MechSelectorDialog.Search.Jump")));
            panel2.add(this.m_cJump);
            panel2.add(this.m_tJump);
            this.m_pSouthParams.add(panel2);
            Panel panel3 = new Panel();
            panel3.setLayout(new FlowLayout(0));
            panel3.add(new Label(Messages.getString("MechSelectorDialog.Search.Armor")));
            panel3.add(this.m_cArmor);
            this.m_pSouthParams.add(panel3);
            Panel panel4 = new Panel();
            panel4.setLayout(new FlowLayout(0));
            panel4.add(new Label(Messages.getString("MechSelectorDialog.Search.Weapons")));
            this.m_pSouthParams.add(panel4);
            Panel panel5 = new Panel();
            panel5.setLayout(new FlowLayout(0));
            panel5.add(new Label(Messages.getString("MechSelectorDialog.Search.WeaponsAtLeast")));
            panel5.add(this.m_tWeapons1);
            panel5.add(this.m_cWeapons1);
            this.m_pSouthParams.add(panel5);
            Panel panel6 = new Panel();
            panel6.setLayout(new FlowLayout(0));
            panel6.add(this.m_cOrAnd);
            panel6.add(new Label(Messages.getString("MechSelectorDialog.Search.WeaponsAtLeast")));
            panel6.add(this.m_tWeapons2);
            panel6.add(this.m_cWeapons2);
            this.m_pSouthParams.add(panel6);
            Panel panel7 = new Panel();
            panel7.setLayout(new FlowLayout(0));
            panel7.add(new Label(Messages.getString("MechSelectorDialog.Search.Equipment")));
            panel7.add(this.m_chkEquipment);
            panel7.add(this.m_cEquipment);
            this.m_pSouthParams.add(panel7);
            Panel panel8 = new Panel();
            panel8.setLayout(new FlowLayout(0));
            panel8.add(new Label(Messages.getString("MechSelectorDialog.Search.Year")));
            panel8.add(this.m_tStartYear);
            panel8.add(new Label("-"));
            panel8.add(this.m_tEndYear);
            this.m_pSouthParams.add(panel8);
            Panel panel9 = new Panel();
            panel9.add(this.m_bSearch);
            panel9.add(this.m_bReset);
            panel9.add(this.m_lCount);
            this.m_pSouthParams.add(panel9);
        } else {
            this.m_bToggleAdvanced.setLabel(Messages.getString("MechSelectorDialog.Search.Show"));
            this.m_pOpenAdvanced.add(this.m_bToggleAdvanced);
            this.m_pSouthParams.setLayout(new GridLayout(2, 1));
            this.m_pSouthParams.add(this.m_pListOptions);
            this.m_pSouthParams.add(this.m_pOpenAdvanced);
        }
    }

    private void toggleAdvanced() {
        this.m_pUpper.remove(this.m_pSouthParams);
        this.m_pSouthParams = new Panel();
        if (GUIPreferences.getInstance().getMechSelectorShowAdvanced()) {
            this.buildSouthParams(false);
            GUIPreferences.getInstance().setMechSelectorShowAdvanced(false);
        } else {
            this.buildSouthParams(true);
            GUIPreferences.getInstance().setMechSelectorShowAdvanced(true);
        }
        this.m_pUpper.add((Component)this.m_pSouthParams, "South");
        this.invalidate();
        this.pack();
    }

    private void updateTechChoice() {
        int n;
        boolean bl = this.m_client.game.getOptions().booleanOption("allow_advanced_units");
        int n2 = n = bl ? TechConstants.SIZE : 5;
        if (this.includeMaxTech == bl) {
            return;
        }
        this.includeMaxTech = bl;
        this.m_chType.removeAll();
        for (int i = 0; i < n; ++i) {
            this.m_chType.addItem(TechConstants.getLevelDisplayableName(i));
        }
    }

    private void updatePlayerChoice() {
        String string = this.m_chPlayer.getSelectedItem();
        this.m_chPlayer.removeAll();
        this.m_chPlayer.setEnabled(true);
        this.m_chPlayer.addItem(this.m_clientgui.getClient().getName());
        Iterator<Client> iterator = this.m_clientgui.getBots().values().iterator();
        while (iterator.hasNext()) {
            this.m_chPlayer.addItem(iterator.next().getName());
        }
        if (this.m_chPlayer.getItemCount() == 1) {
            this.m_chPlayer.setEnabled(false);
        } else {
            this.m_chPlayer.select(string);
        }
    }

    public void run() {
        this.filterMechs(false);
        this.m_mechList.invalidate();
        this.pack();
        this.setLocation(this.computeDesiredLocation());
        this.unitLoadingDialog.setVisible(false);
        Map<String, String> map = MechSummaryCache.getInstance().getFailedFiles();
        if (map != null && map.size() > 0) {
            new UnitFailureDialog(this.m_clientgui.frame, map);
        }
    }

    private void populateChoices() {
        int n;
        int n2;
        for (n2 = 0; n2 < EntityWeightClass.SIZE; ++n2) {
            this.m_chWeightClass.addItem(EntityWeightClass.getClassName(n2));
        }
        this.m_chWeightClass.addItem(Messages.getString("MechSelectorDialog.All"));
        this.m_chWeightClass.select(0);
        this.includeMaxTech = this.m_client.game.getOptions().booleanOption("allow_advanced_units");
        n2 = this.includeMaxTech ? TechConstants.SIZE : 5;
        for (n = 0; n < n2; ++n) {
            this.m_chType.addItem(TechConstants.getLevelDisplayableName(n));
        }
        this.m_chType.select(0);
        for (n = 0; n < UnitType.SIZE; ++n) {
            this.m_chUnitType.addItem(UnitType.getTypeDisplayableName(n));
        }
        this.m_chUnitType.addItem(Messages.getString("MechSelectorDialog.All"));
        this.m_chUnitType.select(9);
        this.m_cWalk.addItem(Messages.getString("MechSelectorDialog.Search.AtLeast"));
        this.m_cWalk.addItem(Messages.getString("MechSelectorDialog.Search.EqualTo"));
        this.m_cWalk.addItem(Messages.getString("MechSelectorDialog.Search.NoMoreThan"));
        this.m_cJump.addItem(Messages.getString("MechSelectorDialog.Search.AtLeast"));
        this.m_cJump.addItem(Messages.getString("MechSelectorDialog.Search.EqualTo"));
        this.m_cJump.addItem(Messages.getString("MechSelectorDialog.Search.NoMoreThan"));
        this.m_cArmor.addItem(Messages.getString("MechSelectorDialog.Search.Any"));
        this.m_cArmor.addItem(Messages.getString("MechSelectorDialog.Search.Armor25"));
        this.m_cArmor.addItem(Messages.getString("MechSelectorDialog.Search.Armor50"));
        this.m_cArmor.addItem(Messages.getString("MechSelectorDialog.Search.Armor75"));
        this.m_cArmor.addItem(Messages.getString("MechSelectorDialog.Search.Armor90"));
        this.m_cOrAnd.addItem(Messages.getString("MechSelectorDialog.Search.or"));
        this.m_cOrAnd.addItem(Messages.getString("MechSelectorDialog.Search.and"));
        this.populateWeaponsAndEquipmentChoices();
    }

    private void populateWeaponsAndEquipmentChoices() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
        this.m_cWeapons1.removeAll();
        this.m_cWeapons2.removeAll();
        this.m_cEquipment.removeAll();
        this.m_tWeapons1.setText("");
        this.m_tWeapons2.setText("");
        this.m_chkEquipment.setState(false);
        int n = this.m_chType.getSelectedIndex();
        int n2 = this.m_chUnitType.getSelectedIndex();
        Iterator iterator = EquipmentType.getAllTypes();
        while (iterator.hasMoreElements()) {
            EquipmentType object = iterator.nextElement();
            if (!(!(object instanceof WeaponType) || object.getTechLevel() != n && (n != 4 || object.getTechLevel() != 0 && object.getTechLevel() != 1 && object.getTechLevel() != 2) && (n != 3 && n != 1 || object.getTechLevel() != 0 && object.getTechLevel() != 1))) {
                if (n2 != UnitType.SIZE && (UnitType.getTypeName(n2).equals("Mek") || UnitType.getTypeName(n2).equals("Tank")) && object.hasFlag(2048L)) continue;
                linkedHashSet.add(object.getName());
                if (object.hasFlag(0x8000000L) && (n == 4 || n == 1 || n == 3)) {
                    linkedHashSet2.add(object.getName());
                }
            }
            if (!(object instanceof MiscType) || object.getTechLevel() != n && (n != 4 || object.getTechLevel() != 0 && object.getTechLevel() != 1 && object.getTechLevel() != 2) && (n != 3 && n != 1 || object.getTechLevel() != 0 && object.getTechLevel() != 1)) continue;
            linkedHashSet2.add(object.getName());
        }
        for (String string : linkedHashSet) {
            this.m_cWeapons1.add(string);
            this.m_cWeapons2.add(string);
        }
        for (String string : linkedHashSet2) {
            this.m_cEquipment.add(string);
        }
        this.m_cWeapons1.invalidate();
        this.m_cWeapons2.invalidate();
        this.m_cEquipment.invalidate();
        this.pack();
    }

    private void filterMechs(boolean bl) {
        Vector<MechSummary> vector = new Vector<MechSummary>();
        int n = this.m_chWeightClass.getSelectedIndex();
        int n2 = this.m_chType.getSelectedIndex();
        int n3 = this.m_chUnitType.getSelectedIndex();
        MechSummary[] mechSummaryArray = MechSummaryCache.getInstance().getAllMechs();
        if (mechSummaryArray == null) {
            System.err.println("No units to filter!");
            return;
        }
        for (int i = 0; i < mechSummaryArray.length; ++i) {
            if (n != EntityWeightClass.SIZE && mechSummaryArray[i].getWeightClass() != n || n2 != 11 && n2 != mechSummaryArray[i].getType() && (n2 != 4 || mechSummaryArray[i].getType() != 0 && mechSummaryArray[i].getType() != 1 && mechSummaryArray[i].getType() != 2) && (n2 != 3 || mechSummaryArray[i].getType() != 0 && mechSummaryArray[i].getType() != 1) || n3 != UnitType.SIZE && !mechSummaryArray[i].getUnitType().equals(UnitType.getTypeName(n3)) || this.m_client.game.getOptions().booleanOption("canon_only") && !mechSummaryArray[i].isCanon()) continue;
            vector.addElement(mechSummaryArray[i]);
        }
        this.m_mechsCurrent = new MechSummary[vector.size()];
        vector.copyInto(this.m_mechsCurrent);
        this.m_count = vector.size();
        if (!(bl || this.m_old_nType == n2 && this.m_old_nUnitType == n3)) {
            this.populateWeaponsAndEquipmentChoices();
        }
        this.m_old_nType = n2;
        this.m_old_nUnitType = n3;
        this.sortMechs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortMechs() {
        Arrays.sort(this.m_mechsCurrent, new MechSummaryComparator(this.m_chSort.getSelectedIndex()));
        this.m_mechList.removeAll();
        try {
            this.m_mechList.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (int i = 0; i < this.m_mechsCurrent.length; ++i) {
                this.m_mechList.add(this.formatMech(this.m_mechsCurrent[i]));
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.m_mechList.setEnabled(true);
            this.m_mechList.setFont(this.m_mechList.getFont());
        }
        this.updateWidgetEnablements();
        this.m_lCount.setText(this.m_mechsCurrent.length + "/" + this.m_count);
        this.repaint();
    }

    private void searchFor(String string) {
        for (int i = 0; i < this.m_mechsCurrent.length; ++i) {
            if (!this.m_mechsCurrent[i].getName().toLowerCase().startsWith(string)) continue;
            this.m_mechList.select(i);
            ItemEvent itemEvent = new ItemEvent(this.m_mechList, 701, this.m_mechList, 1);
            this.itemStateChanged(itemEvent);
            break;
        }
    }

    private void advancedSearch() {
        int n;
        String string = this.m_lCount.getText();
        int n2 = Integer.parseInt(string.substring(0, string.indexOf(47)));
        if (n2 != (n = Integer.parseInt(string.substring(string.indexOf(47) + 1)))) {
            this.filterMechs(true);
        }
        Vector<MechSummary> vector = new Vector<MechSummary>();
        for (int i = 0; i < this.m_mechsCurrent.length; ++i) {
            MechSummary mechSummary = this.m_mechsCurrent[i];
            try {
                Entity entity = new MechFileParser(mechSummary.getSourceFile(), mechSummary.getEntryName()).getEntity();
                if (!this.isMatch(entity)) continue;
                vector.addElement(mechSummary);
                continue;
            }
            catch (EntityLoadingException entityLoadingException) {
                // empty catch block
            }
        }
        this.m_mechsCurrent = new MechSummary[vector.size()];
        vector.copyInto(this.m_mechsCurrent);
        this.clearMechPreview();
        this.sortMechs();
    }

    private boolean isMatch(Entity entity) {
        int n;
        int n2;
        int n3 = -1;
        try {
            n3 = Integer.parseInt(this.m_tWalk.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n3 > -1 && (this.m_cWalk.getSelectedIndex() == 0 ? entity.getWalkMP() < n3 : (this.m_cWalk.getSelectedIndex() == 1 ? n3 != entity.getWalkMP() : this.m_cWalk.getSelectedIndex() == 2 && entity.getWalkMP() > n3))) {
            return false;
        }
        int n4 = -1;
        try {
            n4 = Integer.parseInt(this.m_tJump.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n4 > -1 && (this.m_cJump.getSelectedIndex() == 0 ? entity.getJumpMP() < n4 : (this.m_cJump.getSelectedIndex() == 1 ? n4 != entity.getJumpMP() : this.m_cJump.getSelectedIndex() == 2 && entity.getJumpMP() > n4))) {
            return false;
        }
        int n5 = this.m_cArmor.getSelectedIndex();
        if (n5 > 0) {
            n2 = entity.getTotalArmor();
            n = entity.getTotalInternal() * 2 + 3;
            if (n5 == 1 ? (double)n2 < (double)n * 0.25 : (n5 == 2 ? (double)n2 < (double)n * 0.5 : (n5 == 3 ? (double)n2 < (double)n * 0.75 : n5 == 4 && (double)n2 < (double)n * 0.9))) {
                return false;
            }
        }
        n2 = 0;
        n = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n6 = 0;
        int n7 = -1;
        try {
            n7 = Integer.parseInt(this.m_tWeapons1.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n7 > -1) {
            n2 = 1;
            for (int i = 0; i < entity.getWeaponList().size(); ++i) {
                WeaponType weaponType = (WeaponType)entity.getWeaponList().get(i).getType();
                if (!weaponType.getName().equals(this.m_cWeapons1.getSelectedItem())) continue;
                ++n6;
            }
            if (n6 >= n7) {
                bl = true;
            }
        }
        n6 = 0;
        int n8 = -1;
        try {
            n8 = Integer.parseInt(this.m_tWeapons2.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n8 > -1) {
            n = 1;
            for (int i = 0; i < entity.getWeaponList().size(); ++i) {
                WeaponType weaponType = (WeaponType)entity.getWeaponList().get(i).getType();
                if (!weaponType.getName().equals(this.m_cWeapons2.getSelectedItem())) continue;
                ++n6;
            }
            if (n6 >= n8) {
                bl2 = true;
            }
        }
        int n9 = Integer.MIN_VALUE;
        int n10 = Integer.MAX_VALUE;
        try {
            n9 = Integer.parseInt(this.m_tStartYear.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n10 = Integer.parseInt(this.m_tEndYear.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (entity.getYear() < n9 || entity.getYear() > n10) {
            return false;
        }
        if (n2 != 0 && n == 0 && !bl) {
            return false;
        }
        if (n != 0 && n2 == 0 && !bl2) {
            return false;
        }
        if (n2 != 0 && n != 0 && (this.m_cOrAnd.getSelectedIndex() == 0 ? !bl && !bl2 : !bl || !bl2)) {
            return false;
        }
        n6 = 0;
        if (this.m_chkEquipment.getState()) {
            for (Mounted mounted : entity.getEquipment()) {
                EquipmentType equipmentType = mounted.getType();
                if (!equipmentType.getName().equals(this.m_cEquipment.getSelectedItem())) continue;
                ++n6;
            }
            if (n6 < 1) {
                return false;
            }
        }
        return true;
    }

    private void resetSearch() {
        this.m_cWalk.select(0);
        this.m_tWalk.setText("");
        this.m_cJump.select(0);
        this.m_tJump.setText("");
        this.m_cArmor.select(0);
        this.m_tWeapons1.setText("");
        this.m_cWeapons1.select(0);
        this.m_cOrAnd.select(0);
        this.m_tWeapons2.setText("");
        this.m_cWeapons2.select(0);
        this.m_chkEquipment.setState(false);
        this.m_cEquipment.select(0);
        this.filterMechs(false);
    }

    private Point computeDesiredLocation() {
        int n;
        int n2 = this.m_clientgui.frame.getLocation().x + this.m_clientgui.frame.getSize().width / 2 - this.getSize().width / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = this.m_clientgui.frame.getLocation().y + this.m_clientgui.frame.getSize().height / 2 - this.getSize().height / 2) < 0) {
            n = 0;
        }
        return new Point(n2, n);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.updatePlayerChoice();
            this.updateTechChoice();
            this.setLocation(this.computeDesiredLocation());
        }
        super.setVisible(bl);
    }

    private String formatMech(MechSummary mechSummary) {
        String string = "";
        String string2 = !mechSummary.getLevel().equals("F") ? TechConstants.T_SIMPLE_LEVEL[mechSummary.getType()] : "F";
        if (GUIPreferences.getInstance().getMechSelectorIncludeModel()) {
            string = string + this.makeLength(mechSummary.getModel(), 10) + " ";
        }
        if (GUIPreferences.getInstance().getMechSelectorIncludeName()) {
            string = string + this.makeLength(mechSummary.getChassis(), 20) + " ";
        }
        if (GUIPreferences.getInstance().getMechSelectorIncludeTons()) {
            string = string + this.makeLength("" + mechSummary.getTons(), 3) + " ";
        }
        if (GUIPreferences.getInstance().getMechSelectorIncludeBV()) {
            string = string + this.makeLength("" + mechSummary.getBV(), 5) + " ";
        }
        if (GUIPreferences.getInstance().getMechSelectorIncludeYear()) {
            string = string + mechSummary.getYear() + " ";
        }
        if (GUIPreferences.getInstance().getMechSelectorIncludeLevel()) {
            string = string + string2 + " ";
        }
        if (GUIPreferences.getInstance().getMechSelectorIncludeCost()) {
            string = string + mechSummary.getCost() + " ";
        }
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_bCancel) {
            this.squadron.removeAllElements();
            this.listFightersSelected.removeAll();
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.butAdd) {
            Entity entity;
            int n = this.m_mechList.getSelectedIndex();
            if (n == -1) {
                return;
            }
            MechSummary mechSummary = this.m_mechsCurrent[this.m_mechList.getSelectedIndex()];
            try {
                entity = new MechFileParser(mechSummary.getSourceFile(), mechSummary.getEntryName()).getEntity();
                this.listFightersSelected.add(entity.getDisplayName());
                this.squadron.add(entity);
            }
            catch (EntityLoadingException entityLoadingException) {
                System.out.println("Unable to load mech: " + mechSummary.getSourceFile() + ": " + mechSummary.getEntryName() + ": " + entityLoadingException.getMessage());
                entityLoadingException.printStackTrace();
                return;
            }
            this.clearSquadPreview();
            entity = Compute.compileSquadron(this.squadron);
            this.previewSquad(entity);
            if (this.squadron.size() == FighterSquadron.MAX_SIZE) {
                this.butAdd.setEnabled(false);
            }
        } else if (actionEvent.getSource() == this.butRemove) {
            int n = this.listFightersSelected.getSelectedIndex();
            if (n == -1) {
                return;
            }
            this.listFightersSelected.remove(n);
            this.squadron.remove(n);
            this.clearSquadPreview();
            FighterSquadron fighterSquadron = Compute.compileSquadron(this.squadron);
            this.previewSquad(fighterSquadron);
            this.butAdd.setEnabled(true);
        } else if (actionEvent.getSource() == this.m_bPick) {
            Object object;
            if (this.squadron.size() <= 0) {
                return;
            }
            Client client = null;
            if (this.m_chPlayer.getSelectedIndex() > 0) {
                object = this.m_chPlayer.getSelectedItem();
                client = this.m_clientgui.getBots().get(object);
            }
            if (client == null) {
                client = this.m_client;
            }
            object = Compute.compileSquadron(this.squadron);
            this.autoSetSkills((Entity)object);
            ((Entity)object).setOwner(client.getLocalPlayer());
            client.sendAddEntity((Entity)object);
            this.squadron.removeAllElements();
            this.listFightersSelected.removeAll();
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.m_bSearch) {
            this.advancedSearch();
        } else if (actionEvent.getSource() == this.m_bReset) {
            this.resetSearch();
        } else if (actionEvent.getSource() == this.m_bToggleAdvanced) {
            this.toggleAdvanced();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.m_chSort) {
            this.clearMechPreview();
            this.sortMechs();
        } else if (itemEvent.getSource() == this.m_chWeightClass || itemEvent.getSource() == this.m_chType || itemEvent.getSource() == this.m_chUnitType) {
            this.clearMechPreview();
            this.filterMechs(false);
        } else if (itemEvent.getSource() == this.m_mechList) {
            this.updateWidgetEnablements();
            int n = this.m_mechList.getSelectedIndex();
            if (n == -1) {
                this.clearMechPreview();
                return;
            }
            MechSummary mechSummary = this.m_mechsCurrent[n];
            try {
                Entity entity = new MechFileParser(mechSummary.getSourceFile(), mechSummary.getEntryName()).getEntity();
                this.previewMech(entity);
            }
            catch (EntityLoadingException entityLoadingException) {
                System.out.println("Unable to load mech: " + mechSummary.getSourceFile() + ": " + mechSummary.getEntryName() + ": " + entityLoadingException.getMessage());
                entityLoadingException.printStackTrace();
                this.clearMechPreview();
                return;
            }
        } else if (itemEvent.getSource() == this.m_cModel || itemEvent.getSource() == this.m_cName || itemEvent.getSource() == this.m_cTons || itemEvent.getSource() == this.m_cBV || itemEvent.getSource() == this.m_cYear || itemEvent.getSource() == this.m_cLevel || itemEvent.getSource() == this.m_cCost) {
            GUIPreferences.getInstance().setMechSelectorIncludeModel(this.m_cModel.getState());
            GUIPreferences.getInstance().setMechSelectorIncludeName(this.m_cName.getState());
            GUIPreferences.getInstance().setMechSelectorIncludeTons(this.m_cTons.getState());
            GUIPreferences.getInstance().setMechSelectorIncludeBV(this.m_cBV.getState());
            GUIPreferences.getInstance().setMechSelectorIncludeYear(this.m_cYear.getState());
            GUIPreferences.getInstance().setMechSelectorIncludeLevel(this.m_cLevel.getState());
            GUIPreferences.getInstance().setMechSelectorIncludeCost(this.m_cCost.getState());
            this.clearMechPreview();
            this.sortMechs();
            this.m_mechList.invalidate();
            this.pack();
            this.setLocation(this.computeDesiredLocation());
        }
    }

    void clearMechPreview() {
        this.m_mechView.setEditable(false);
        this.m_mechView.setText("");
        if (MechSummaryCache.getInstance().isInitialized()) {
            this.m_pPreview.removeBgDrawers();
            this.m_pPreview.paint(this.m_pPreview.getGraphics());
        }
    }

    void clearSquadPreview() {
        this.squadronView.setEditable(false);
        this.squadronView.setText("");
    }

    void previewMech(Entity entity) {
        MechView mechView = new MechView(entity, this.m_client.game.getOptions().booleanOption("show_bay_detail"));
        this.m_mechView.setEditable(false);
        String string = mechView.getMechReadout();
        StringBuffer stringBuffer = new StringBuffer(string);
        this.m_mechView.setText(string);
        if (entity instanceof Mech || entity instanceof Tank) {
            TestEntity testEntity = null;
            if (entity instanceof Mech) {
                testEntity = new TestMech((Mech)entity, this.entityVerifier.mechOption, null);
            }
            if (entity instanceof Tank) {
                testEntity = new TestTank((Tank)entity, this.entityVerifier.tankOption, null);
            }
            if (!((TestEntity)testEntity).correctEntity(stringBuffer, !this.m_clientgui.getClient().game.getOptions().booleanOption("is_eq_limits"))) {
                this.m_mechView.setText(stringBuffer.toString());
            }
        }
        this.m_mechView.setCaretPosition(0);
        this.m_pPreview.paint(this.m_pPreview.getGraphics());
    }

    void previewSquad(Entity entity) {
        MechView mechView = new MechView(entity, this.m_client.game.getOptions().booleanOption("show_bay_detail"));
        this.squadronView.setEditable(false);
        String string = mechView.getMechReadout();
        this.squadronView.setText(string);
        this.squadronView.setCaretPosition(0);
    }

    private String makeLength(String string, int n) {
        if (string.length() == n) {
            return string;
        }
        if (string.length() > n) {
            return string.substring(0, n - 2) + "..";
        }
        return string + SPACES.substring(0, n - string.length());
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        long l;
        if (keyEvent.getKeyCode() == 10) {
            ActionEvent actionEvent = new ActionEvent(this.m_bPick, 1001, "");
            this.actionPerformed(actionEvent);
        }
        if ((l = System.currentTimeMillis()) - this.m_nLastSearch > 1000L) {
            this.m_sbSearch = new StringBuffer();
        }
        this.m_nLastSearch = l;
        this.m_sbSearch.append(keyEvent.getKeyChar());
        this.searchFor(this.m_sbSearch.toString().toLowerCase());
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private void updateWidgetEnablements() {
        boolean bl = this.m_mechList.getSelectedIndex() != -1;
        this.butAdd.setEnabled(bl);
        this.m_bPick.setEnabled(true);
    }

    private void autoSetSkills(Entity entity) {
        IClientPreferences iClientPreferences = PreferenceManager.getClientPreferences();
        if (!iClientPreferences.useAverageSkills()) {
            return;
        }
        int n = 5;
        int n2 = 4;
        if (entity.isClan()) {
            if (entity instanceof Mech || entity instanceof BattleArmor) {
                n2 = 3;
                n = 4;
                if (this.m_client.game.getOptions().booleanOption("pilot_advantages")) {
                    PilotOptions pilotOptions = entity.getCrew().getOptions();
                    pilotOptions.getOption("clan_pilot_training").setValue(true);
                }
            } else if (entity instanceof Tank) {
                n2 = 5;
                n = 6;
            } else if (entity instanceof Infantry) {
                if (entity.getMovementMode() == 10) {
                    n2 = 5;
                    n = 5;
                } else {
                    n2 = 5;
                    n = 6;
                }
            }
        } else if (entity instanceof Infantry) {
            if (entity.getMovementMode() == 10 || entity instanceof BattleArmor) {
                n2 = 4;
                n = 5;
            } else {
                n2 = 4;
                n = 6;
            }
        }
        entity.getCrew().setGunnery(n2);
        entity.getCrew().setPiloting(n);
    }
}

