/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import megamek.MegaMek;
import megamek.client.Client;
import megamek.client.bot.BotClient;
import megamek.client.bot.TestBot;
import megamek.client.bot.ui.AWT.BotGUI;
import megamek.client.ui.AWT.AlertDialog;
import megamek.client.ui.AWT.BoardEditor;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.CommonAboutDialog;
import megamek.client.ui.AWT.CommonHelpDialog;
import megamek.client.ui.AWT.CommonMenuBar;
import megamek.client.ui.AWT.CommonSettingsDialog;
import megamek.client.ui.AWT.ConfirmDialog;
import megamek.client.ui.AWT.ConnectDialog;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.GameOptionsDialog;
import megamek.client.ui.AWT.HostDialog;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.ScenarioDialog;
import megamek.client.ui.AWT.widget.BackGroundDrawer;
import megamek.client.ui.AWT.widget.BufferedPanel;
import megamek.client.ui.IMegaMekGUI;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.MechSummaryCache;
import megamek.common.Player;
import megamek.common.options.GameOptions;
import megamek.common.options.IBasicOption;
import megamek.common.preference.PreferenceManager;
import megamek.server.ScenarioLoader;
import megamek.server.Server;

public class MegaMekGUI
implements IMegaMekGUI {
    public Frame frame;
    public Client client = null;
    public Server server = null;
    private CommonAboutDialog about = null;
    private CommonHelpDialog help = null;
    private GameOptionsDialog optdlg = null;
    private CommonSettingsDialog setdlg = null;
    protected ActionListener actionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equalsIgnoreCase("fileBoardNew")) {
                MegaMekGUI.this.showEditor();
            }
            if (actionEvent.getActionCommand().equalsIgnoreCase("fileBoardOpen")) {
                MegaMekGUI.this.showEditorOpen();
            }
            if (actionEvent.getActionCommand().equalsIgnoreCase("fileGameNew")) {
                MegaMekGUI.this.host();
            }
            if (actionEvent.getActionCommand().equalsIgnoreCase("fileGameScenario")) {
                MegaMekGUI.this.scenario();
            }
            if (actionEvent.getActionCommand().equalsIgnoreCase("fileGameConnect")) {
                MegaMekGUI.this.connect();
            }
            if (actionEvent.getActionCommand().equalsIgnoreCase("fileGameConnectBot")) {
                MegaMekGUI.this.connectBot();
            }
            if (actionEvent.getActionCommand().equalsIgnoreCase("fileGameOpen")) {
                MegaMekGUI.this.loadGame();
            }
            if (actionEvent.getActionCommand().equalsIgnoreCase("viewGameOptions")) {
                MegaMekGUI.this.showGameOptions();
            }
            if (actionEvent.getActionCommand().equalsIgnoreCase("helpAbout")) {
                MegaMekGUI.this.showAbout();
            }
            if (actionEvent.getActionCommand().equalsIgnoreCase("helpContents")) {
                MegaMekGUI.this.showHelp();
            }
            if (actionEvent.getActionCommand().equalsIgnoreCase("viewClientSettings")) {
                MegaMekGUI.this.showSettings();
            }
            if (actionEvent.getActionCommand().equalsIgnoreCase("quit")) {
                MegaMekGUI.this.quit();
            }
        }
    };

    public void start(String[] stringArray) {
        this.createGUI();
    }

    private void createGUI() {
        this.frame = new Frame("MegaMek");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MegaMekGUI.this.quit();
            }
        });
        this.frame.setBackground(SystemColor.menu);
        this.frame.setForeground(SystemColor.menuText);
        this.frame.setIconImage(this.frame.getToolkit().getImage("data/images/misc/megamek-icon.gif"));
        CommonMenuBar commonMenuBar = new CommonMenuBar();
        commonMenuBar.addActionListener(this.actionListener);
        this.frame.setMenuBar(commonMenuBar);
        this.showMainMenu();
        Dimension dimension = this.frame.getToolkit().getScreenSize();
        this.frame.pack();
        this.frame.setLocation(dimension.width / 2 - this.frame.getSize().width / 2, dimension.height / 2 - this.frame.getSize().height / 2);
        MechSummaryCache.getInstance();
        this.frame.setVisible(true);
        if (GUIPreferences.getInstance().getNagForReadme()) {
            ConfirmDialog confirmDialog = new ConfirmDialog(this.frame, Messages.getString("MegaMek.welcome.title") + MegaMek.VERSION, Messages.getString("MegaMek.welcome.message"), true);
            confirmDialog.setVisible(true);
            if (!confirmDialog.getShowAgain()) {
                GUIPreferences.getInstance().setNagForReadme(false);
            }
            if (confirmDialog.getAnswer()) {
                this.showHelp();
            }
        }
    }

    public void showMainMenu() {
        Label label = new Label();
        label.setText(Messages.getString("MegaMek.Version") + MegaMek.VERSION);
        Button button = new Button(Messages.getString("MegaMek.hostNewGame.label"));
        button.setActionCommand("fileGameNew");
        button.addActionListener(this.actionListener);
        Button button2 = new Button(Messages.getString("MegaMek.hostScenario.label"));
        button2.setActionCommand("fileGameScenario");
        button2.addActionListener(this.actionListener);
        Button button3 = new Button(Messages.getString("MegaMek.hostSavedGame.label"));
        button3.setActionCommand("fileGameOpen");
        button3.addActionListener(this.actionListener);
        Button button4 = new Button(Messages.getString("MegaMek.Connect.label"));
        button4.setActionCommand("fileGameConnect");
        button4.addActionListener(this.actionListener);
        Button button5 = new Button(Messages.getString("MegaMek.ConnectAsBot.label"));
        button5.setActionCommand("fileGameConnectBot");
        button5.addActionListener(this.actionListener);
        Button button6 = new Button(Messages.getString("MegaMek.MapEditor.label"));
        button6.setActionCommand("fileBoardNew");
        button6.addActionListener(this.actionListener);
        Button button7 = new Button(Messages.getString("MegaMek.Quit.label"));
        button7.setActionCommand("quit");
        button7.addActionListener(this.actionListener);
        Image image = this.frame.getToolkit().getImage("data/images/misc/megamek-splash.jpg");
        MediaTracker mediaTracker = new MediaTracker(this.frame);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        BufferedPanel bufferedPanel = new BufferedPanel();
        BackGroundDrawer backGroundDrawer = new BackGroundDrawer(image);
        bufferedPanel.addBgDrawer(backGroundDrawer);
        bufferedPanel.setPreferredSize(image.getWidth(null), image.getHeight(null));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.frame.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 1);
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 8;
        this.addBag(bufferedPanel, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.05;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        this.addBag(label, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addBag(button, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addBag(button3, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addBag(button2, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addBag(button4, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addBag(button5, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addBag(button6, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addBag(button7, gridBagLayout, gridBagConstraints);
        this.frame.validate();
    }

    public void showGameOptions() {
        GameOptions gameOptions = new GameOptions();
        gameOptions.initialize();
        gameOptions.loadOptions();
        if (this.optdlg == null) {
            this.optdlg = new GameOptionsDialog(this.frame, gameOptions);
        }
        this.optdlg.update(gameOptions);
        this.optdlg.setVisible(true);
    }

    public void showEditor() {
        BoardEditor boardEditor = new BoardEditor();
        this.launch(boardEditor.getFrame());
        boardEditor.boardNew();
    }

    public void showEditorOpen() {
        BoardEditor boardEditor = new BoardEditor();
        this.launch(boardEditor.getFrame());
        boardEditor.boardLoad();
    }

    public void host() {
        HostDialog hostDialog = new HostDialog(this.frame);
        hostDialog.setVisible(true);
        if (hostDialog.name == null || hostDialog.serverPass == null || hostDialog.port == 0) {
            return;
        }
        boolean bl = false;
        char[] cArray = hostDialog.name.toCharArray();
        for (int i = 0; !bl && i < cArray.length; ++i) {
            if (Character.isWhitespace(cArray[i])) continue;
            bl = true;
        }
        if (!bl) {
            new AlertDialog(this.frame, Messages.getString("MegaMek.PlayerNameAlert.title"), Messages.getString("MegaMek.PlayerNameAlert.message")).setVisible(true);
            return;
        }
        Compute.d6();
        try {
            this.server = new Server(hostDialog.serverPass, hostDialog.port);
        }
        catch (IOException iOException) {
            System.err.println("could not create server socket on port " + hostDialog.port);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Error: could not start server at localhost").append(":").append(hostDialog.port).append(" (").append(iOException.getMessage()).append(").");
            new AlertDialog(this.frame, Messages.getString("MegaMek.HostGameAllert.title"), stringBuffer.toString()).setVisible(true);
            return;
        }
        this.client = new Client(hostDialog.name, "localhost", hostDialog.port);
        ClientGUI clientGUI = new ClientGUI(this.client);
        clientGUI.initialize();
        if (!this.client.connect()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Error: could not connect to server at localhost").append(":").append(hostDialog.port).append(".");
            new AlertDialog(this.frame, Messages.getString("MegaMek.HostGameAllert.title"), stringBuffer.toString()).setVisible(true);
            this.frame.setVisible(false);
            this.client.die();
        }
        this.launch(clientGUI.getFrame());
        this.optdlg = null;
    }

    public void loadGame() {
        FileDialog fileDialog = new FileDialog(this.frame, Messages.getString("MegaMek.SaveGameDialog.title"), 0);
        fileDialog.setDirectory("savegames");
        fileDialog.setFilenameFilter(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return null != string && string.endsWith(".sav");
            }
        });
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            return;
        }
        HostDialog hostDialog = new HostDialog(this.frame);
        hostDialog.setVisible(true);
        if (hostDialog.name == null || hostDialog.serverPass == null || hostDialog.port == 0) {
            return;
        }
        boolean bl = false;
        char[] cArray = hostDialog.name.toCharArray();
        for (int i = 0; !bl && i < cArray.length; ++i) {
            if (Character.isWhitespace(cArray[i])) continue;
            bl = true;
        }
        if (!bl) {
            new AlertDialog(this.frame, Messages.getString("MegaMek.PlayerNameAlert1.title"), Messages.getString("MegaMek.PlayerNameAlert1.message")).setVisible(true);
            return;
        }
        Compute.d6();
        try {
            this.server = new Server(hostDialog.serverPass, hostDialog.port);
        }
        catch (IOException iOException) {
            System.err.println("could not create server socket on port " + hostDialog.port);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Error: could not start server at localhost").append(":").append(hostDialog.port).append(" (").append(iOException.getMessage()).append(").");
            new AlertDialog(this.frame, Messages.getString("MegaMek.HostGameAllert.title"), stringBuffer.toString()).setVisible(true);
            return;
        }
        if (!this.server.loadGame(new File(fileDialog.getDirectory(), fileDialog.getFile()))) {
            new AlertDialog(this.frame, Messages.getString("MegaMek.LoadGameAlert.title"), Messages.getString("MegaMek.LoadGameAlert.message")).setVisible(true);
            this.server.die();
            this.server = null;
            return;
        }
        this.client = new Client(hostDialog.name, "localhost", hostDialog.port);
        ClientGUI clientGUI = new ClientGUI(this.client);
        clientGUI.initialize();
        if (!this.client.connect()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Error: could not connect to server at localhost").append(":").append(hostDialog.port).append(".");
            new AlertDialog(this.frame, Messages.getString("MegaMek.HostGameAllert.title"), stringBuffer.toString()).setVisible(true);
            this.frame.setVisible(false);
            this.client.die();
        }
        this.optdlg = null;
        this.launch(clientGUI.getFrame());
    }

    public void scenario() {
        Object object;
        Object object2;
        FileDialog fileDialog = new FileDialog(this.frame, Messages.getString("MegaMek.SelectScenarioDialog.title"), 0);
        fileDialog.setDirectory("data" + File.separatorChar + "scenarios");
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".mms");
            }
        };
        fileDialog.setFilenameFilter(filenameFilter);
        fileDialog.setFile("*.mms");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            return;
        }
        ScenarioLoader scenarioLoader = new ScenarioLoader(new File(fileDialog.getDirectory(), fileDialog.getFile()));
        IGame iGame = null;
        try {
            iGame = scenarioLoader.createGame();
        }
        catch (Exception exception) {
            new AlertDialog(this.frame, Messages.getString("MegaMek.HostScenarioAllert.title"), Messages.getString("MegaMek.HostScenarioAllert.message") + exception.getMessage()).setVisible(true);
            return;
        }
        GameOptionsDialog gameOptionsDialog = new GameOptionsDialog(this.frame, iGame.getOptions());
        gameOptionsDialog.update(iGame.getOptions());
        gameOptionsDialog.setEditable(true);
        gameOptionsDialog.setVisible(true);
        for (IBasicOption object32 : gameOptionsDialog.getOptions()) {
            object2 = iGame.getOptions().getOption(object32.getName());
            object2.setValue(object32.getValue());
        }
        gameOptionsDialog = null;
        Object[] objectArray = new Player[iGame.getPlayersVector().size()];
        iGame.getPlayersVector().copyInto(objectArray);
        ScenarioDialog scenarioDialog = new ScenarioDialog(this.frame, (Player[])objectArray);
        scenarioDialog.setVisible(true);
        if (!scenarioDialog.bSet) {
            return;
        }
        object2 = new HostDialog(this.frame);
        boolean bl = false;
        if (!scenarioDialog.localName.equals("")) {
            bl = true;
        }
        ((HostDialog)object2).yourNameF.setText(scenarioDialog.localName);
        ((Dialog)object2).setVisible(true);
        if (((HostDialog)object2).name == null || ((HostDialog)object2).serverPass == null || ((HostDialog)object2).port == 0) {
            return;
        }
        scenarioDialog.localName = ((HostDialog)object2).name;
        boolean bl2 = false;
        char[] cArray = ((HostDialog)object2).name.toCharArray();
        for (int iOException = 0; !bl2 && iOException < cArray.length; ++iOException) {
            if (Character.isWhitespace(cArray[iOException])) continue;
            bl2 = true;
        }
        if (!bl2) {
            new AlertDialog(this.frame, Messages.getString("MegaMek.HostScenarioAllert1.title"), Messages.getString("MegaMek.HostScenarioAllert1.message")).setVisible(true);
            return;
        }
        Compute.d6();
        try {
            this.server = new Server(((HostDialog)object2).serverPass, ((HostDialog)object2).port);
        }
        catch (IOException clientGUI) {
            System.err.println("could not create server socket on port " + ((HostDialog)object2).port);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Error: could not start server at localhost").append(":").append(((HostDialog)object2).port).append(" (").append(clientGUI.getMessage()).append(").");
            new AlertDialog(this.frame, Messages.getString("MegaMek.HostGameAllert.title"), stringBuffer.toString()).setVisible(true);
            return;
        }
        this.server.setGame(iGame);
        scenarioLoader.applyDamage(this.server);
        ClientGUI clientGUI = null;
        if (scenarioDialog.localName != "") {
            this.client = new Client(((HostDialog)object2).name, "localhost", ((HostDialog)object2).port);
            clientGUI = new ClientGUI(this.client);
            clientGUI.initialize();
            if (!this.client.connect()) {
                StringBuffer i = new StringBuffer();
                i.append("Error: could not connect to server at localhost").append(":").append(((HostDialog)object2).port).append(".");
                new AlertDialog(this.frame, Messages.getString("MegaMek.HostGameAllert.title"), i.toString()).setVisible(true);
                this.frame.setVisible(false);
                this.client.die();
            }
        }
        this.optdlg = null;
        this.server.calculatePlayerBVs();
        for (int enumeration = 0; enumeration < objectArray.length; ++enumeration) {
            if (scenarioDialog.playerTypes[enumeration] != 2) continue;
            object = new TestBot(((Player)objectArray[enumeration]).getName(), "localhost", ((HostDialog)object2).port);
            ((BotClient)object).game.addGameListener(new BotGUI((BotClient)object));
            if (!((Client)object).connect()) {
                // empty if block
            }
            ((BotClient)object).retrieveServerInfo();
        }
        if (!bl) {
            Enumeration<Player> enumeration = this.server.getGame().getPlayers();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (!((Player)object).getName().equals(scenarioDialog.localName)) continue;
                ((Player)object).setObserver(true);
            }
        }
        this.launch(clientGUI.getFrame());
    }

    public void connect() {
        ConnectDialog connectDialog = new ConnectDialog(this.frame);
        connectDialog.setVisible(true);
        if (connectDialog.name == null || connectDialog.serverAddr == null || connectDialog.port == 0) {
            return;
        }
        boolean bl = false;
        char[] cArray = connectDialog.name.toCharArray();
        for (int i = 0; !bl && i < cArray.length; ++i) {
            if (Character.isWhitespace(cArray[i])) continue;
            bl = true;
        }
        if (!bl) {
            new AlertDialog(this.frame, Messages.getString("MegaMek.ConnectAllert.title"), Messages.getString("MegaMek.ConnectAllert.message")).setVisible(true);
            return;
        }
        this.client = new Client(connectDialog.name, connectDialog.serverAddr, connectDialog.port);
        ClientGUI clientGUI = new ClientGUI(this.client);
        clientGUI.initialize();
        if (!this.client.connect()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Error: could not connect to server at ").append(connectDialog.serverAddr).append(":").append(connectDialog.port).append(".");
            new AlertDialog(this.frame, Messages.getString("MegaMek.HostGameAllert.title"), stringBuffer.toString()).setVisible(true);
            this.frame.setVisible(false);
            this.client.die();
        }
        this.launch(clientGUI.getFrame());
    }

    public void connectBot() {
        ConnectDialog connectDialog = new ConnectDialog(this.frame);
        connectDialog.setVisible(true);
        if (connectDialog.name == null || connectDialog.serverAddr == null || connectDialog.port == 0) {
            return;
        }
        boolean bl = false;
        char[] cArray = connectDialog.name.toCharArray();
        for (int i = 0; !bl && i < cArray.length; ++i) {
            if (Character.isWhitespace(cArray[i])) continue;
            bl = true;
        }
        if (!bl) {
            new AlertDialog(this.frame, Messages.getString("MegaMek.ConnectGameAllert.title"), Messages.getString("MegaMek.ConnectGameAllert.message")).setVisible(true);
            return;
        }
        this.client = new TestBot(connectDialog.name, connectDialog.serverAddr, connectDialog.port);
        this.client.game.addGameListener(new BotGUI((BotClient)this.client));
        ClientGUI clientGUI = new ClientGUI(this.client);
        clientGUI.initialize();
        if (!this.client.connect()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Error: could not connect to server at ").append(connectDialog.serverAddr).append(":").append(connectDialog.port).append(".");
            new AlertDialog(this.frame, Messages.getString("MegaMek.HostGameAllert.title"), stringBuffer.toString()).setVisible(true);
            this.frame.setVisible(false);
            this.client.die();
        }
        this.launch(clientGUI.getFrame());
        this.client.retrieveServerInfo();
    }

    private void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.frame.add(component);
    }

    private void showAbout() {
        if (this.about == null) {
            this.about = new CommonAboutDialog(this.frame);
        }
        this.about.setVisible(true);
    }

    private void showHelp() {
        if (this.help == null) {
            this.help = MegaMekGUI.showHelp(this.frame, "readme");
        }
        this.help.setVisible(true);
    }

    private static CommonHelpDialog showHelp(Frame frame, String string) {
        Locale locale = Locale.getDefault();
        File file = new File(string + "-" + locale.getDisplayLanguage(Locale.ENGLISH) + ".txt");
        if (!file.exists()) {
            file = new File(string + ".txt");
        }
        return new CommonHelpDialog(frame, file);
    }

    private void showSettings() {
        if (this.setdlg == null) {
            this.setdlg = new CommonSettingsDialog(this.frame);
        }
        this.setdlg.setVisible(true);
    }

    private void quit() {
        PreferenceManager.getInstance().save();
        System.exit(0);
    }

    private void launch(Frame frame) {
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MegaMekGUI.this.unlaunch();
            }

            public void windowClosed(WindowEvent windowEvent) {
                MegaMekGUI.this.unlaunch();
            }
        });
        this.frame.setVisible(false);
    }

    private void unlaunch() {
        if (this.server != null) {
            this.server.die();
            this.server = null;
        }
        this.frame.setVisible(true);
        this.client = null;
        System.gc();
        System.runFinalization();
    }
}

