/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.boardview3d;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.Stripifier;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import megamek.client.ui.AWT.boardview3d.BoardModel;
import megamek.client.ui.AWT.boardview3d.C;

abstract class ArrowModel
extends BranchGroup {
    TransformGroup anim = new TransformGroup();
    private static final double[] arrowVertices = new double[]{BoardModel.HEX_SIDE_LENGTH / 18.0, 1.6666666666666667, 0.0, BoardModel.HEX_SIDE_LENGTH / 6.0, 1.6666666666666667, 0.0, 0.0, 5.0, 0.0, -BoardModel.HEX_SIDE_LENGTH / 6.0, 1.6666666666666667, 0.0, -BoardModel.HEX_SIDE_LENGTH / 18.0, 1.6666666666666667, 0.0, -BoardModel.HEX_SIDE_LENGTH / 18.0, -3.3333333333333335, 0.0, BoardModel.HEX_SIDE_LENGTH / 18.0, -3.3333333333333335, 0.0, BoardModel.HEX_SIDE_LENGTH / 18.0, 1.6666666666666667, 0.0};
    private static final int[] arrowStrips = new int[]{8};
    static final GeometryArray polygon = ArrowModel.makeArrow();
    static final GeometryArray border = ArrowModel.makeArrowOutline();

    ArrowModel() {
        this.setCapability(17);
        this.anim.setCapability(18);
        RotationInterpolator rotationInterpolator = new RotationInterpolator(C.defAlpha, this.anim, new Transform3D(), 0.0f, (float)Math.PI * 2);
        rotationInterpolator.setSchedulingBounds((Bounds)BoardModel.bounds);
        this.anim.addChild((Node)rotationInterpolator);
    }

    private static final GeometryArray makeArrow() {
        GeometryInfo geometryInfo = new GeometryInfo(5);
        int[] nArray = new int[]{1};
        float[] fArray = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        geometryInfo.setCoordinates(arrowVertices);
        geometryInfo.setStripCounts(arrowStrips);
        geometryInfo.setContourCounts(nArray);
        geometryInfo.setNormals(fArray);
        Stripifier stripifier = new Stripifier();
        stripifier.stripify(geometryInfo);
        return geometryInfo.getGeometryArray();
    }

    private static final GeometryArray makeArrowOutline() {
        LineStripArray lineStripArray = new LineStripArray(arrowVertices.length, 1, arrowStrips);
        lineStripArray.setCoordinates(0, arrowVertices);
        return lineStripArray;
    }

    protected static final GeometryArray makeArrow(double d) {
        GeometryInfo geometryInfo = new GeometryInfo(5);
        int[] nArray = new int[]{1};
        float[] fArray = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        double[] dArray = new double[arrowVertices.length];
        System.arraycopy(arrowVertices, 0, dArray, 0, dArray.length);
        d -= 15.0;
        for (int i = 0; i < 5; ++i) {
            int n = 3 * i + 1;
            dArray[n] = dArray[n] + d;
        }
        dArray[16] = dArray[16] + 15.0;
        dArray[19] = dArray[19] + 15.0;
        dArray[22] = dArray[22] + d;
        geometryInfo.setCoordinates(dArray);
        geometryInfo.setStripCounts(arrowStrips);
        geometryInfo.setContourCounts(nArray);
        geometryInfo.setNormals(fArray);
        Stripifier stripifier = new Stripifier();
        stripifier.stripify(geometryInfo);
        return geometryInfo.getGeometryArray();
    }

    static final GeometryArray makeArrowOutline(double d) {
        LineStripArray lineStripArray = new LineStripArray(arrowVertices.length, 1, arrowStrips);
        double[] dArray = new double[arrowVertices.length];
        System.arraycopy(arrowVertices, 0, dArray, 0, dArray.length);
        d -= 15.0;
        for (int i = 0; i < 5; ++i) {
            int n = 3 * i + 1;
            dArray[n] = dArray[n] + d;
        }
        dArray[16] = dArray[16] + 15.0;
        dArray[19] = dArray[19] + 15.0;
        dArray[22] = dArray[22] + d;
        lineStripArray.setCoordinates(0, dArray);
        return lineStripArray;
    }
}

