/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.boardview3d;

import java.util.List;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.Geometry;
import javax.media.j3d.Link;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.boardview3d.BoardModel;
import megamek.client.ui.AWT.boardview3d.C;
import megamek.client.ui.AWT.boardview3d.HexModel;
import megamek.client.ui.AWT.boardview3d.LabelModel;
import megamek.client.ui.AWT.boardview3d.TileTextureManager;
import megamek.common.Coords;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Minefield;
import megamek.common.Player;

class BoardHexModel
extends HexModel {
    private static final Material normal = new Material(C.grey90, C.black, C.grey90, C.black, 1.0f);
    private static final Material normalWater = new Material(C.grey75, C.black, C.grey75, C.white, 128.0f);
    private static final Material night = new Material(C.grey25, C.black, C.grey25, C.black, 1.0f);
    private static final Material dark = new Material(C.grey10, C.black, C.grey10, C.black, 1.0f);
    private static final Material side = new Material(C.plain, C.black, C.plain, C.black, 1.0f);
    private static final Material sideWater = new Material(C.water, C.black, C.water, C.black, 1.0f);
    private static final int KEEP = 3;
    Shape3D floor;
    Shape3D surface;
    IHex hex;
    Material current = normal;
    IGame game;
    private int ypos = 0;

    public static SharedGroup[] mkShared() {
        SharedGroup[] sharedGroupArray = new SharedGroup[2];
        Appearance appearance = new Appearance();
        appearance.setMaterial(side);
        Shape3D shape3D = new Shape3D((Geometry)shaft, appearance);
        shape3D.setPickable(false);
        sharedGroupArray[0] = new SharedGroup();
        sharedGroupArray[0].addChild((Node)shape3D);
        appearance = new Appearance();
        appearance.setMaterial(sideWater);
        shape3D = new Shape3D((Geometry)shaft, appearance);
        sharedGroupArray[1] = new SharedGroup();
        sharedGroupArray[1].addChild((Node)shape3D);
        return sharedGroupArray;
    }

    public BoardHexModel(IGame iGame, Coords coords, IHex iHex, TileTextureManager tileTextureManager, SharedGroup[] sharedGroupArray) {
        this.game = iGame;
        this.hex = iHex;
        Appearance appearance = new Appearance();
        appearance.setMaterial(normal);
        this.floor = new Shape3D((Geometry)polygon, appearance);
        this.floor.setCapability(14);
        this.floor.setCapability(15);
        this.floor.setPickable(true);
        this.addChild((Node)this.floor);
        this.addChild((Node)new Link(this.hex.depth() > 0 ? sharedGroupArray[1] : sharedGroupArray[0]));
        this.setUserData(new Coords(coords));
        this.ypos = 0;
        this.addText("" + coords.getBoardNum(), new Color3f(GUIPreferences.getInstance().getMapTextColor()));
        Point3d point3d = BoardModel.getHexLocation(coords, iHex.floor());
        this.setTransform(new Transform3D(C.nullRot, new Vector3d((Tuple3d)point3d), 1.0));
        if (this.surface == null && this.hex.depth() > 0) {
            TransformGroup transformGroup = new TransformGroup(new Transform3D(C.nullRot, new Vector3d(0.0, 0.0, (double)this.hex.depth() * 6.0), 1.0));
            this.surface = new Shape3D((Geometry)polygon);
            this.surface.setCapability(14);
            this.surface.setCapability(15);
            this.surface.setPickable(true);
            this.setSurfaceEffect(this.current, (Texture)tileTextureManager.getTexture(iHex, 0.6666667f));
            transformGroup.addChild((Node)this.surface);
            this.addChild((Node)transformGroup);
        }
    }

    public void update(IHex iHex, TileTextureManager tileTextureManager, Player player) {
        double d;
        int n;
        this.hex = iHex;
        Color3f color3f = new Color3f(GUIPreferences.getInstance().getMapTextColor());
        this.ypos = 1;
        Texture2D texture2D = tileTextureManager.getTexture(this.hex, 1.0f);
        if (texture2D != this.floor.getAppearance().getTexture()) {
            this.setEffect(this.current, (Texture)texture2D);
        }
        int n2 = this.surface == null ? 3 : 4;
        for (n = this.numChildren() - 1; n >= n2; --n) {
            this.removeChild(n);
        }
        if (this.game.containsMinefield((Coords)this.getUserData())) {
            Coords coords = (Coords)this.getUserData();
            Minefield minefield = this.game.getMinefields(coords).elementAt(0);
            this.addChild(tileTextureManager.getMinefieldSign());
            int n3 = this.game.getNbrMinefields(coords);
            if (n3 > 1) {
                this.addText(Messages.getString("BoardView1.Multiple"), color3f);
            } else if (n3 == 1) {
                switch (minefield.getType()) {
                    case 0: {
                        this.addText(Messages.getString("BoardView1.Conventional"), color3f);
                        break;
                    }
                    case 5: {
                        this.addText(Messages.getString("BoardView1.Thunder-Inf") + minefield.getDensity() + ")", color3f);
                        break;
                    }
                    case 3: {
                        this.addText(Messages.getString("BoardView1.Thunder-Actv") + minefield.getDensity() + ")", color3f);
                        break;
                    }
                    case 1: {
                        this.addText(Messages.getString("BoardView1.detonated"), color3f);
                        this.addText(Messages.getString("BoardView1.Command-"), color3f);
                        break;
                    }
                    case 2: {
                        if (player != null && minefield.getPlayerId() == player.getId()) {
                            this.addText(Messages.getString("BoardView1.Vibrabomb") + " (" + minefield.getSetting() + ")", color3f);
                            break;
                        }
                        this.addText(Messages.getString("BoardView1.Vibrabomb"), color3f);
                    }
                }
            }
        }
        if ((d = (double)Math.max(n = Math.max(this.hex.terrainLevel(24), this.hex.terrainLevel(28)), Math.max(this.hex.terrainLevel(20), this.hex.terrainLevel(19))) * 6.0) < 1.0) {
            d = 1.0;
        }
        Transform3D transform3D = new Transform3D();
        transform3D.setScale(new Vector3d(2.0 * BoardModel.HEX_SIDE_LENGTH, 30.0, d += (double)(this.hex.surface() - this.hex.floor()) * 6.0));
        transform3D.setTranslation(new Vector3d(0.0, 0.0, d / 2.0));
        TransformGroup transformGroup = new TransformGroup(transform3D);
        List<Shape3D> list = tileTextureManager.getModels(this.hex);
        for (Shape3D shape3D : list) {
            transformGroup.addChild((Node)shape3D);
        }
        transformGroup.setPickable(false);
        this.addChild((Node)transformGroup);
        if (Math.max(this.hex.terrainLevel(1), this.hex.terrainLevel(5)) > 0) {
            transform3D = new Transform3D();
            transform3D.setScale(new Vector3d(2.0 * BoardModel.HEX_SIDE_LENGTH, 30.0, 12.0));
            transform3D.setTranslation(new Vector3d(0.0, 0.0, 6.0));
            transformGroup = new TransformGroup(transform3D);
            transformGroup.addChild((Node)tileTextureManager.getModel(this.hex));
            transformGroup.setPickable(false);
            this.addChild((Node)transformGroup);
        }
        this.setBounds((Bounds)new BoundingBox(new Point3d(-BoardModel.HEX_SIDE_LENGTH, -15.0, 6.0 * (double)this.hex.floor()), new Point3d(BoardModel.HEX_SIDE_LENGTH, 15.0, d)));
        if (this.hex.getElevation() != 0) {
            this.addText(Messages.getString("BoardView1.LEVEL") + this.hex.getElevation(), color3f);
        }
        if (this.hex.depth() != 0) {
            this.addText(Messages.getString("BoardView1.DEPTH") + this.hex.depth(), color3f);
        }
        if (n > 0) {
            this.addText(Messages.getString("BoardView1.HEIGHT") + n, new Color3f(GUIPreferences.getInstance().getColor("AdvancedBuildingTextColor")));
        }
    }

    private void setSurfaceEffect(Material material, Texture texture) {
        Appearance appearance = new Appearance();
        appearance.setTexture(texture);
        appearance.setMaterial(material == normal ? normalWater : material);
        appearance.setTransparencyAttributes(new TransparencyAttributes(2, 0.0f));
        appearance.setPolygonAttributes(C.noCull);
        appearance.setTextureAttributes(C.materialModulate);
        this.surface.setAppearance(appearance);
    }

    private void setEffect(Material material, Texture texture) {
        this.current = material;
        Appearance appearance = new Appearance();
        appearance.setTexture(texture);
        appearance.setMaterial(this.current);
        appearance.setTextureAttributes(new TextureAttributes(2, new Transform3D(), new Color4f(), 1));
        this.floor.setAppearance(appearance);
        if (this.surface != null) {
            this.setSurfaceEffect(material, this.surface.getAppearance().getTexture());
        }
    }

    void setEffect(Material material) {
        this.setEffect(material, this.floor.getAppearance().getTexture());
    }

    public void darken() {
        this.setEffect(dark);
    }

    public void night() {
        this.setEffect(night);
    }

    public void reset() {
        this.setEffect(normal);
    }

    private final void addText(String string, Color3f color3f) {
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3d(0.0, -13.5 + (double)this.ypos * 2.75, (double)this.hex.depth() * 6.0));
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.addChild((Node)new LabelModel(string, color3f, null, LabelModel.BIG));
        this.addChild((Node)transformGroup);
        ++this.ypos;
    }
}

