/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.boardview3d;

import com.sun.j3d.utils.behaviors.mouse.MouseBehaviorCallback;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseWheelZoom;
import com.sun.j3d.utils.universe.MultiTransformGroup;
import javax.media.j3d.Bounds;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import megamek.client.ui.AWT.boardview3d.BoardModel;
import megamek.client.ui.AWT.boardview3d.C;
import megamek.client.ui.AWT.boardview3d.ViewTransform;
import megamek.common.Coords;
import megamek.common.IHex;

class MapViewTransform
extends ViewTransform
implements MouseBehaviorCallback {
    TransformGroup wheel = new TransformGroup();

    String getName() {
        return "Map View";
    }

    public void centerOnHex(Coords coords, IHex iHex) {
        if (coords == null || iHex == null) {
            return;
        }
        MultiTransformGroup multiTransformGroup = this.universe.getViewingPlatform().getMultiTransformGroup();
        multiTransformGroup.getTransformGroup(0).setTransform(new Transform3D(C.nullRot, new Vector3d((Tuple3d)BoardModel.getHexLocation(coords, iHex.getElevation())), 1.0));
        this.center();
    }

    void center() {
        MultiTransformGroup multiTransformGroup = this.universe.getViewingPlatform().getMultiTransformGroup();
        TransformGroup transformGroup = multiTransformGroup.getTransformGroup(1);
        Transform3D transform3D = new Transform3D();
        transform3D.rotX(1.5707963267948966);
        transformGroup.setTransform(transform3D);
    }

    void zoom(int n) {
        View view = this.universe.getViewer().getView();
        double d = view.getScreenScale();
        view.setScreenScale(d *= Math.pow(1.5, n));
        TransformGroup transformGroup = this.universe.getViewingPlatform().getMultiTransformGroup().getTransformGroup(1);
        Transform3D transform3D = new Transform3D();
        transformGroup.getTransform(transform3D);
        transformGroup.setTransform(transform3D);
    }

    void reset() {
        MultiTransformGroup multiTransformGroup = this.universe.getViewingPlatform().getMultiTransformGroup();
        View view = this.universe.getViewer().getView();
        view.setScreenScale(0.001);
        TransformGroup transformGroup = multiTransformGroup.getTransformGroup(2);
        Transform3D transform3D = new Transform3D();
        transform3D.rotX(-1.5707963267948966);
        transformGroup.setTransform(transform3D);
    }

    protected void setup() {
        MultiTransformGroup multiTransformGroup = this.universe.getViewingPlatform().getMultiTransformGroup();
        View view = this.universe.getViewer().getView();
        view.setProjectionPolicy(0);
        view.setScreenScalePolicy(1);
        view.setScreenScale(0.001);
        TransformGroup transformGroup = multiTransformGroup.getTransformGroup(1);
        Transform3D transform3D = new Transform3D();
        transform3D.rotX(1.5707963267948966);
        transformGroup.setTransform(transform3D);
        TransformGroup transformGroup2 = multiTransformGroup.getTransformGroup(2);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotX(-1.5707963267948966);
        transformGroup2.setTransform(transform3D2);
        Transform3D transform3D3 = new Transform3D();
        transform3D3.lookAt(new Point3d(0.0, 0.0, 600.0), new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0));
        transform3D3.invert();
        multiTransformGroup.getTransformGroup(5).setTransform(transform3D3);
        MouseWheelZoom mouseWheelZoom = new MouseWheelZoom(this.wheel);
        mouseWheelZoom.setFactor(0.3333333333333333);
        mouseWheelZoom.setupCallback((MouseBehaviorCallback)this);
        this.controllers.addChild((Node)mouseWheelZoom);
        mouseWheelZoom.setSchedulingBounds((Bounds)BoardModel.bounds);
        MouseRotate mouseRotate = new MouseRotate(transformGroup2);
        mouseRotate.setFactor(-0.002, 0.0);
        this.controllers.addChild((Node)mouseRotate);
        mouseRotate.setSchedulingBounds((Bounds)BoardModel.bounds);
        MouseTranslate mouseTranslate = new MouseTranslate(transformGroup);
        mouseTranslate.setFactor(-0.5);
        this.controllers.addChild((Node)mouseTranslate);
        mouseTranslate.setSchedulingBounds((Bounds)BoardModel.bounds);
    }

    Node makeViewRelative(Node node, double d) {
        return node;
    }

    public void transformChanged(int n, Transform3D transform3D) {
        if (n != 2) {
            return;
        }
        Vector3d vector3d = new Vector3d();
        transform3D.get(vector3d);
        this.zoom((int)Math.round(vector3d.z));
        transform3D.set(new Vector3d());
        this.wheel.setTransform(transform3D);
    }
}

