/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;
import java.util.Vector;

public class AdvancedLabel
extends Component {
    private static final long serialVersionUID = -8349184630103360938L;
    private Vector<String> stringVector = new Vector();
    private Color[] colorArray;
    private int lineHeight;
    private int maxLineWidth;
    private int descent;
    private boolean sized = false;
    private static final int leftMargin = 2;
    private static final int rightMargin = 2;

    public AdvancedLabel(String string) {
        this.colorArray = null;
        this.setText(string);
    }

    public AdvancedLabel(String string, Color[] colorArray) {
        this.colorArray = colorArray;
        this.setText(string);
    }

    public void paint(Graphics graphics) {
        this.getSizes();
        for (int i = 0; i < this.stringVector.size(); ++i) {
            if (this.colorArray != null) {
                graphics.setColor(this.colorArray[i]);
            }
            graphics.drawString(this.stringVector.elementAt(i), 2, this.lineHeight * (i + 1));
        }
    }

    public void setText(String string) {
        this.stringVector.removeAllElements();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            this.stringVector.addElement(stringTokenizer.nextToken());
        }
    }

    private void getSizes() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.lineHeight = fontMetrics.getHeight();
        for (int i = 0; i < this.stringVector.size(); ++i) {
            this.maxLineWidth = Math.max(this.maxLineWidth, fontMetrics.stringWidth(this.stringVector.elementAt(i)));
        }
        this.descent = fontMetrics.getDescent();
        this.sized = true;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        if (!this.sized) {
            this.getSizes();
        }
        int n = this.maxLineWidth + 2 + 2;
        int n2 = this.stringVector.size() * this.lineHeight + this.stringVector.size() * this.descent;
        Dimension dimension = new Dimension(n, n2);
        return dimension;
    }
}

