/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import megamek.client.Client;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.GBC;
import megamek.client.ui.swing.ClientDialog;
import megamek.client.ui.swing.ClientGUI;
import megamek.client.ui.swing.DialogOptionComponent;
import megamek.client.ui.swing.DialogOptionListener;
import megamek.client.ui.swing.Slider;
import megamek.common.Aero;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Dropship;
import megamek.common.Entity;
import megamek.common.EntitySelector;
import megamek.common.EquipmentType;
import megamek.common.FighterSquadron;
import megamek.common.GunEmplacement;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Jumpship;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Pilot;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.SmallCraft;
import megamek.common.Tank;
import megamek.common.TechConstants;
import megamek.common.WeaponType;
import megamek.common.options.IOption;
import megamek.common.options.IOptionGroup;
import megamek.common.options.PilotOptions;
import megamek.common.preference.PreferenceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomMechDialog
extends ClientDialog
implements ActionListener,
DialogOptionListener {
    private static final long serialVersionUID = -6809436986445582731L;
    private JLabel labName = new JLabel(Messages.getString("CustomMechDialog.labName"), 4);
    private JTextField fldName = new JTextField(20);
    private JLabel labGunnery = new JLabel(Messages.getString("CustomMechDialog.labGunnery"), 4);
    private JTextField fldGunnery = new JTextField(3);
    private JLabel labGunneryL = new JLabel(Messages.getString("CustomMechDialog.labGunneryL"), 4);
    private JTextField fldGunneryL = new JTextField(3);
    private JLabel labGunneryM = new JLabel(Messages.getString("CustomMechDialog.labGunneryM"), 4);
    private JTextField fldGunneryM = new JTextField(3);
    private JLabel labGunneryB = new JLabel(Messages.getString("CustomMechDialog.labGunneryB"), 4);
    private JTextField fldGunneryB = new JTextField(3);
    private JLabel labPiloting = new JLabel(Messages.getString("CustomMechDialog.labPiloting"), 4);
    private JTextField fldPiloting = new JTextField(3);
    private JLabel labInit = new JLabel(Messages.getString("CustomMechDialog.labInit"), 4);
    private JTextField fldInit = new JTextField(3);
    private JLabel labCommandInit = new JLabel(Messages.getString("CustomMechDialog.labCommandInit"), 4);
    private JTextField fldCommandInit = new JTextField(3);
    private JLabel labC3 = new JLabel(Messages.getString("CustomMechDialog.labC3"), 4);
    private JComboBox choC3 = new JComboBox();
    private int[] entityCorrespondance;
    private JLabel labCallsign = new JLabel(Messages.getString("CustomMechDialog.labCallsign"), 0);
    private JLabel labUnitNum = new JLabel(Messages.getString("CustomMechDialog.labUnitNum"), 0);
    private JComboBox choUnitNum = new JComboBox();
    private ArrayList<Entity> entityUnitNum = new ArrayList();
    private JLabel labDeployment = new JLabel(Messages.getString("CustomMechDialog.labDeployment"), 4);
    private JComboBox choDeployment = new JComboBox();
    private JLabel labAutoEject = new JLabel(Messages.getString("CustomMechDialog.labAutoEject"), 4);
    private JCheckBox chAutoEject = new JCheckBox();
    private JLabel labSearchlight = new JLabel(Messages.getString("CustomMechDialog.labSearchlight"), 4);
    private JCheckBox chSearchlight = new JCheckBox();
    private JLabel labCommander = new JLabel(Messages.getString("CustomMechDialog.labCommander"), 4);
    private JCheckBox chCommander = new JCheckBox();
    private JLabel labOffBoard = new JLabel(Messages.getString("CustomMechDialog.labOffBoard"), 4);
    private JCheckBox chOffBoard = new JCheckBox();
    private JLabel labOffBoardDirection = new JLabel(Messages.getString("CustomMechDialog.labOffBoardDirection"), 4);
    private JComboBox choOffBoardDirection = new JComboBox();
    private JLabel labOffBoardDistance = new JLabel(Messages.getString("CustomMechDialog.labOffBoardDistance"), 4);
    private JTextField fldOffBoardDistance = new JTextField(4);
    private JButton butOffBoardDistance = new JButton("0");
    private JLabel labTargSys = new JLabel(Messages.getString("CustomMechDialog.labTargSys"), 4);
    private JComboBox choTargSys = new JComboBox();
    private JLabel labStartVelocity = new JLabel(Messages.getString("CustomMechDialog.labStartVelocity"), 2);
    private JTextField fldStartVelocity = new JTextField(3);
    private JLabel labStartElevation = new JLabel(Messages.getString("CustomMechDialog.labStartElevation"), 2);
    private JTextField fldStartElevation = new JTextField(3);
    private JPanel panButtons = new JPanel();
    private JButton butOkay = new JButton(Messages.getString("Okay"));
    private JButton butCancel = new JButton(Messages.getString("Cancel"));
    private JButton butNext = new JButton(Messages.getString("Next"));
    private JButton butPrev = new JButton(Messages.getString("Previous"));
    private ArrayList<MunitionChoicePanel> m_vMunitions = new ArrayList();
    private JPanel panMunitions = new JPanel();
    private ArrayList<RapidfireMGPanel> m_vMGs = new ArrayList();
    private JPanel panRapidfireMGs = new JPanel();
    private ArrayList<MineChoicePanel> m_vMines = new ArrayList();
    private JPanel panMines = new JPanel();
    private ArrayList<SantaAnnaChoicePanel> m_vSantaAnna = new ArrayList();
    private JPanel panSantaAnna = new JPanel();
    private BombChoicePanel m_bombs;
    private JPanel panBombs = new JPanel();
    Entity entity;
    private boolean okay;
    ClientGUI clientgui;
    private Client client;
    private PilotOptions options;
    private ArrayList<DialogOptionComponent> optionComps = new ArrayList();
    private JPanel panOptions = new JPanel();
    private JScrollPane scrOptions;
    private JScrollPane scrAll;
    private JTextArea texDesc = new JTextArea(Messages.getString("CustomMechDialog.texDesc"), 20, 10);
    private boolean editable;
    private int direction = -1;
    private int distance = 17;

    public CustomMechDialog(ClientGUI clientGUI, Client client, Entity entity, boolean bl) {
        super(clientGUI.frame, Messages.getString("CustomMechDialog.title"), true);
        Object object;
        Mech mech;
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.entity = entity;
        this.clientgui = clientGUI;
        this.client = client;
        this.options = entity.getCrew().getOptions();
        this.editable = bl;
        this.texDesc.setEditable(false);
        this.texDesc.setLineWrap(true);
        this.texDesc.setWrapStyleWord(true);
        if (entity instanceof Tank) {
            this.labPiloting.setText(Messages.getString("CustomMechDialog.labDriving"));
        } else if (entity instanceof Infantry) {
            this.labPiloting.setText(Messages.getString("CustomMechDialog.labAntiMech"));
        } else {
            this.labPiloting.setText(Messages.getString("CustomMechDialog.labPiloting"));
        }
        jPanel.add((Component)this.labName, GBC.std());
        jPanel.add((Component)this.fldName, GBC.eol());
        if (client.game.getOptions().booleanOption("rpg_gunnery")) {
            jPanel.add((Component)this.labGunneryL, GBC.std());
            jPanel.add((Component)this.fldGunneryL, GBC.eol());
            jPanel.add((Component)this.labGunneryM, GBC.std());
            jPanel.add((Component)this.fldGunneryM, GBC.eol());
            jPanel.add((Component)this.labGunneryB, GBC.std());
            jPanel.add((Component)this.fldGunneryB, GBC.eol());
        } else {
            jPanel.add((Component)this.labGunnery, GBC.std());
            jPanel.add((Component)this.fldGunnery, GBC.eol());
        }
        jPanel.add((Component)this.labPiloting, GBC.std());
        jPanel.add((Component)this.fldPiloting, GBC.eol());
        if (client.game.getOptions().booleanOption("individual_initiative")) {
            jPanel.add((Component)this.labInit, GBC.std());
            jPanel.add((Component)this.fldInit, GBC.eol());
        }
        if (client.game.getOptions().booleanOption("command_init")) {
            jPanel.add((Component)this.labCommandInit, GBC.std());
            jPanel.add((Component)this.fldCommandInit, GBC.eol());
        }
        if (entity instanceof Aero) {
            jPanel.add((Component)this.labStartVelocity, GBC.std());
            jPanel.add((Component)this.fldStartVelocity, GBC.eol());
            jPanel.add((Component)this.labStartElevation, GBC.std());
            jPanel.add((Component)this.fldStartElevation, GBC.eol());
        }
        if (entity instanceof Mech && (mech = (Mech)entity).getCockpitType() != 1) {
            jPanel.add((Component)this.labAutoEject, GBC.std());
            jPanel.add((Component)this.chAutoEject, GBC.eol());
            this.chAutoEject.setSelected(!mech.isAutoEject());
        }
        jPanel.add((Component)this.labDeployment, GBC.std());
        jPanel.add((Component)this.choDeployment, GBC.eol());
        this.refreshDeployment();
        if (clientGUI.getClient().game.getOptions().booleanOption("pilot_advantages") || clientGUI.getClient().game.getOptions().booleanOption("manei_domini")) {
            this.scrOptions = new JScrollPane(this.panOptions);
            jPanel.add((Component)this.scrOptions, GBC.std());
            jPanel.add((Component)new JScrollPane(this.texDesc), GBC.eol());
        }
        if (entity.hasC3() || entity.hasC3i()) {
            jPanel.add((Component)this.labC3, GBC.std());
            jPanel.add((Component)this.choC3, GBC.eol());
            this.refreshC3();
        }
        boolean bl2 = false;
        for (Mounted object2 : entity.getWeaponList()) {
            WeaponType weaponType = (WeaponType)object2.getType();
            if (!weaponType.hasFlag(32768L)) continue;
            bl2 = true;
        }
        if (bl2) {
            jPanel.add((Component)this.labOffBoard, GBC.std());
            jPanel.add((Component)this.chOffBoard, GBC.eol());
            this.chOffBoard.setSelected(entity.isOffBoard());
            jPanel.add((Component)this.labOffBoardDirection, GBC.std());
            this.choOffBoardDirection.addItem(Messages.getString("CustomMechDialog.North"));
            this.choOffBoardDirection.addItem(Messages.getString("CustomMechDialog.South"));
            this.choOffBoardDirection.addItem(Messages.getString("CustomMechDialog.East"));
            this.choOffBoardDirection.addItem(Messages.getString("CustomMechDialog.West"));
            this.direction = entity.getOffBoardDirection();
            if (-1 == this.direction) {
                this.direction = 0;
            }
            this.choOffBoardDirection.setSelectedIndex(this.direction);
            jPanel.add((Component)this.choOffBoardDirection, GBC.eol());
            jPanel.add((Component)this.labOffBoardDistance, GBC.std());
            this.butOffBoardDistance.addActionListener(this);
            this.butOffBoardDistance.setText(Integer.toString(this.distance));
            jPanel.add((Component)this.butOffBoardDistance, GBC.eol());
        }
        if (!entity.hasTargComp() && clientGUI.getClient().game.getOptions().booleanOption("allow_level_3_targsys") && (entity instanceof Mech || clientGUI.getClient().game.getOptions().booleanOption("tank_level_3_targsys") && entity instanceof Tank) && !entity.hasC3() && !entity.hasC3i()) {
            jPanel.add((Component)this.labTargSys, GBC.std());
            this.choTargSys.addItem(MiscType.getTargetSysName(0));
            this.choTargSys.addItem(MiscType.getTargetSysName(2));
            this.choTargSys.addItem(MiscType.getTargetSysName(3));
            this.choTargSys.addItem(MiscType.getTargetSysName(5));
            jPanel.add((Component)this.choTargSys, GBC.eol());
            this.choTargSys.setSelectedItem(MiscType.getTargetSysName(entity.getTargSysType()));
        }
        if (entity instanceof Protomech) {
            object = new StringBuffer(Messages.getString("CustomMechDialog.Callsign"));
            ((StringBuffer)object).append(": ");
            ((StringBuffer)object).append((char)(this.entity.getUnitNumber() + PreferenceManager.getClientPreferences().getUnitStartChar())).append('-').append(this.entity.getId());
            this.labCallsign.setText(((StringBuffer)object).toString());
            jPanel.add((Component)this.labCallsign, GBC.eol().anchor(10));
            Enumeration<Entity> enumeration = client.game.getSelectedEntities(new EntitySelector(){
                private final int ownerId;
                private final char unitNumber;
                {
                    this.ownerId = CustomMechDialog.this.entity.getOwnerId();
                    this.unitNumber = CustomMechDialog.this.entity.getUnitNumber();
                }

                public boolean accept(Entity entity) {
                    return entity instanceof Protomech && this.ownerId == entity.getOwnerId() && this.unitNumber != entity.getUnitNumber();
                }
            });
            if (enumeration.hasMoreElements()) {
                jPanel.add((Component)this.labUnitNum, GBC.std());
                jPanel.add((Component)this.choUnitNum, GBC.eol());
                this.refreshUnitNum(enumeration);
            }
        }
        if (!(entity instanceof Infantry) || entity instanceof BattleArmor) {
            this.setupMunitions();
            jPanel.add((Component)this.panMunitions, GBC.eol().anchor(10));
        }
        if ((entity instanceof Dropship || entity instanceof Jumpship) && clientGUI.getClient().game.getOptions().booleanOption("at2_nukes")) {
            this.setupSantaAnna();
            jPanel.add((Component)this.panSantaAnna, GBC.eol().anchor(10));
        }
        if (entity instanceof Aero && !(entity instanceof FighterSquadron) && !(entity instanceof SmallCraft) && !(entity instanceof Jumpship)) {
            this.setupBombs();
            jPanel.add((Component)this.panBombs, GBC.eol().anchor(10));
        }
        if (clientGUI.getClient().game.getOptions().booleanOption("tacops_burst")) {
            this.setupRapidfireMGs();
            jPanel.add((Component)this.panRapidfireMGs, GBC.eol().anchor(10));
        }
        if (clientGUI.getClient().game.getPlanetaryConditions().getLight() > 1) {
            jPanel.add((Component)this.labSearchlight, GBC.std());
            jPanel.add((Component)this.chSearchlight, GBC.eol());
            this.chSearchlight.setSelected(entity.hasSpotlight());
        }
        if (clientGUI.getClient().game.getOptions().booleanOption("commander_killed")) {
            jPanel.add((Component)this.labCommander, GBC.std());
            jPanel.add((Component)this.chCommander, GBC.eol());
            this.chCommander.setSelected(entity.isCommander());
        }
        this.setupMines();
        jPanel.add((Component)this.panMines, GBC.eop().anchor(10));
        this.setupButtons();
        jPanel.add((Component)this.panButtons, GBC.eol().anchor(10).insets(5, 0, 5, 5));
        this.scrAll = new JScrollPane(jPanel);
        this.getContentPane().add(this.scrAll);
        this.fldName.setText(entity.getCrew().getName());
        this.fldName.addActionListener(this);
        this.fldGunnery.setText(Integer.toString(entity.getCrew().getGunnery()));
        this.fldGunnery.addActionListener(this);
        this.fldGunneryL.setText(Integer.toString(entity.getCrew().getGunneryL()));
        this.fldGunneryL.addActionListener(this);
        this.fldGunneryM.setText(Integer.toString(entity.getCrew().getGunneryM()));
        this.fldGunneryM.addActionListener(this);
        this.fldGunneryB.setText(Integer.toString(entity.getCrew().getGunneryB()));
        this.fldGunneryB.addActionListener(this);
        this.fldPiloting.setText(Integer.toString(entity.getCrew().getPiloting()));
        this.fldPiloting.addActionListener(this);
        this.fldInit.setText(Integer.toString(entity.getCrew().getInitBonus()));
        this.fldInit.addActionListener(this);
        this.fldCommandInit.setText(Integer.toString(entity.getCrew().getCommandBonus()));
        this.fldCommandInit.addActionListener(this);
        if (entity instanceof Aero) {
            object = (Aero)entity;
            this.fldStartVelocity.setText(new Integer(((Aero)object).getCurrentVelocity()).toString());
            this.fldStartVelocity.addActionListener(this);
            this.fldStartElevation.setText(new Integer(((Entity)object).getElevation()).toString());
            this.fldStartElevation.addActionListener(this);
        }
        if (!bl) {
            this.fldName.setEnabled(false);
            this.fldGunnery.setEnabled(false);
            this.fldGunneryL.setEnabled(false);
            this.fldGunneryM.setEnabled(false);
            this.fldGunneryB.setEnabled(false);
            this.fldPiloting.setEnabled(false);
            this.fldInit.setEnabled(false);
            this.fldCommandInit.setEnabled(false);
            this.choC3.setEnabled(false);
            this.choDeployment.setEnabled(false);
            this.chAutoEject.setEnabled(false);
            this.chSearchlight.setEnabled(false);
            this.choTargSys.setEnabled(false);
            this.chCommander.setEnabled(false);
            this.disableMunitionEditing();
            this.disableMGSetting();
            this.disableMineSetting();
            this.chOffBoard.setEnabled(false);
            this.choOffBoardDirection.setEnabled(false);
            this.fldOffBoardDistance.setEnabled(false);
            this.fldStartVelocity.setEnabled(false);
            this.fldStartElevation.setEnabled(false);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CustomMechDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setLocationRelativeTo(clientGUI);
    }

    private void setupButtons() {
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        this.butNext.addActionListener(this);
        this.butPrev.addActionListener(this);
        this.panButtons.setLayout(new GridLayout(1, 4, 10, 0));
        this.panButtons.add(this.butPrev);
        this.panButtons.add(this.butOkay);
        this.panButtons.add(this.butCancel);
        this.panButtons.add(this.butNext);
        this.butNext.setEnabled(this.getNextEntity(true) != null);
        this.butPrev.setEnabled(this.getNextEntity(false) != null);
    }

    private void setupRapidfireMGs() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panRapidfireMGs.setLayout(gridBagLayout);
        for (Mounted mounted : this.entity.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (!weaponType.hasFlag(512L)) continue;
            RapidfireMGPanel rapidfireMGPanel = new RapidfireMGPanel(mounted);
            this.panRapidfireMGs.add((Component)rapidfireMGPanel, GBC.eol());
            this.m_vMGs.add(rapidfireMGPanel);
        }
    }

    private void setupMines() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panMines.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        for (Mounted mounted : this.entity.getMisc()) {
            if (!mounted.getType().hasFlag(131072L)) continue;
            gridBagConstraints.gridy = n++;
            MineChoicePanel mineChoicePanel = new MineChoicePanel(mounted);
            gridBagLayout.setConstraints(mineChoicePanel, gridBagConstraints);
            this.panMines.add(mineChoicePanel);
            this.m_vMines.add(mineChoicePanel);
        }
    }

    private void setupSantaAnna() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panSantaAnna.setLayout(gridBagLayout);
        for (Mounted mounted : this.entity.getAmmo()) {
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (!this.clientgui.getClient().game.getOptions().booleanOption("at2_nukes") || ammoType.getAmmoType() != 57 && (ammoType.getAmmoType() != 61 || !ammoType.hasFlag(128L))) continue;
            SantaAnnaChoicePanel santaAnnaChoicePanel = new SantaAnnaChoicePanel(mounted);
            this.panSantaAnna.add((Component)santaAnnaChoicePanel, GBC.std());
            this.m_vSantaAnna.add(santaAnnaChoicePanel);
        }
    }

    private void setupBombs() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panBombs.setLayout(gridBagLayout);
        Aero aero = (Aero)this.entity;
        this.m_bombs = new BombChoicePanel(aero.getBombChoices(), aero.getMaxBombPoints());
        this.panBombs.add((Component)this.m_bombs, GBC.std());
    }

    private void setupMunitions() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panMunitions.setLayout(gridBagLayout);
        for (Mounted mounted : this.entity.getAmmo()) {
            AmmoType ammoType = (AmmoType)mounted.getType();
            ArrayList<AmmoType> arrayList = new ArrayList<AmmoType>();
            Vector<AmmoType> vector = AmmoType.getMunitionsFor(ammoType.getAmmoType());
            if (vector == null || this.entity instanceof Aero && ammoType.getAmmoType() != 45 && ammoType.getAmmoType() != 28 && ammoType.getAmmoType() != 13 && ammoType.getAmmoType() != 19) continue;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                AmmoType ammoType2 = vector.elementAt(i);
                boolean bl = TechConstants.isLegal(this.entity.getTechLevel(), ammoType2.getTechLevel());
                if (!bl && this.entity.getTechLevel() == 1 && ammoType2.getTechLevel() == 0) {
                    bl = true;
                }
                if (!this.clientgui.getClient().game.getOptions().booleanOption("is_eq_limits") && this.entity.getTechLevel() == 0 && ammoType2.getTechLevel() == 1) {
                    bl = true;
                }
                if (this.clientgui.getClient().game.getOptions().booleanOption("allow_level_3_ammo")) {
                    if (!this.clientgui.getClient().game.getOptions().booleanOption("is_eq_limits")) {
                        if (this.entity.getTechLevel() == 2 && (ammoType2.getTechLevel() == 6 || ammoType2.getTechLevel() == 8 || ammoType2.getTechLevel() == 10)) {
                            bl = true;
                        }
                        if (!(this.entity.getTechLevel() != 0 && this.entity.getTechLevel() != 1 || ammoType2.getTechLevel() != 5 && ammoType2.getTechLevel() != 7 && ammoType2.getTechLevel() != 9)) {
                            bl = true;
                        }
                    }
                } else if (ammoType2.getTechLevel() == 5 || ammoType2.getTechLevel() == 6) {
                    bl = false;
                }
                if (this.entity.isMixedTech()) {
                    bl = true;
                }
                long l = ammoType2.getMunitionType();
                if (!this.clientgui.getClient().game.getOptions().booleanOption("clan_ignore_eq_limits") && this.entity.isClan() && ((l &= 0xFFFFFFFFFFFDFFFFL) == 524288L || l == 0x200000L || l == 262144L || l == 512L || l == 0x800000L || l == 0x1000000L || l == 0x2000000L || l == 0x4000000L || l == 0x8000000000L || l == 0x10000000000L || l == 1024L || l == 2048L)) {
                    bl = false;
                }
                if (!this.clientgui.getClient().game.getOptions().booleanOption("minefields") && AmmoType.canDeliverMinefield(ammoType2) || ammoType2.hasFlag(4L) && !(this.entity instanceof Protomech) || this.entity instanceof Protomech && ammoType2.hasFlag(1L) && !ammoType2.hasFlag(4L) || !bl || ammoType2.getRackSize() != ammoType.getRackSize() || ammoType2.hasFlag(2L) != ammoType.hasFlag(2L) || ammoType2.hasFlag(16L) != ammoType.hasFlag(16L) || ammoType2.getTonnage(this.entity) != ammoType.getTonnage(this.entity)) continue;
                arrayList.add(ammoType2);
            }
            if (arrayList.size() < 2 && !this.client.game.getOptions().booleanOption("lobby_ammo_dump") && !this.client.game.getOptions().booleanOption("tacops_hotload")) continue;
            MunitionChoicePanel munitionChoicePanel = this.entity instanceof Protomech ? new ProtomechMunitionChoicePanel(mounted, arrayList) : new MunitionChoicePanel(mounted, arrayList);
            this.panMunitions.add((Component)munitionChoicePanel, GBC.eol());
            this.m_vMunitions.add(munitionChoicePanel);
        }
    }

    private void disableMunitionEditing() {
        for (int i = 0; i < this.m_vMunitions.size(); ++i) {
            this.m_vMunitions.get(i).setEnabled(false);
        }
    }

    private void disableMGSetting() {
        for (int i = 0; i < this.m_vMGs.size(); ++i) {
            this.m_vMGs.get(i).setEnabled(false);
        }
    }

    private void disableMineSetting() {
        for (int i = 0; i < this.m_vMines.size(); ++i) {
            this.m_vMines.get(i).setEnabled(false);
        }
    }

    private void setOptions() {
        Iterator<DialogOptionComponent> iterator = this.optionComps.iterator();
        while (iterator.hasNext()) {
            DialogOptionComponent dialogOptionComponent;
            DialogOptionComponent dialogOptionComponent2 = dialogOptionComponent = iterator.next();
            IOption iOption = dialogOptionComponent2.getOption();
            if (dialogOptionComponent2.getValue() == Messages.getString("CustomMechDialog.None")) {
                this.entity.getCrew().getOptions().getOption(iOption.getName()).setValue("None");
                continue;
            }
            this.entity.getCrew().getOptions().getOption(iOption.getName()).setValue(dialogOptionComponent2.getValue());
        }
    }

    public void refreshOptions() {
        this.panOptions.removeAll();
        this.optionComps = new ArrayList();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panOptions.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        Enumeration<IOptionGroup> enumeration = this.options.getGroups();
        while (enumeration.hasMoreElements()) {
            IOptionGroup iOptionGroup = enumeration.nextElement();
            if (iOptionGroup.getKey().equalsIgnoreCase("lvl3Advantages") && !this.clientgui.getClient().game.getOptions().booleanOption("pilot_advantages") || iOptionGroup.getKey().equalsIgnoreCase("MDAdvantages") && !this.clientgui.getClient().game.getOptions().booleanOption("manei_domini")) continue;
            this.addGroup(iOptionGroup, gridBagLayout, gridBagConstraints);
            Enumeration<IOption> enumeration2 = iOptionGroup.getOptions();
            while (enumeration2.hasMoreElements()) {
                IOption iOption = enumeration2.nextElement();
                if (!(!(this.entity instanceof Infantry) && !(this.entity instanceof BattleArmor) && !(this.entity instanceof GunEmplacement) || !iOption.getName().equals("vdni") && !iOption.getName().equals("bvdni"))) continue;
                this.addOption(iOption, gridBagLayout, gridBagConstraints, this.editable);
            }
        }
        this.validate();
    }

    private void addGroup(IOptionGroup iOptionGroup, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        JLabel jLabel = new JLabel(iOptionGroup.getDisplayableName());
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.panOptions.add(jLabel);
    }

    private void addOption(IOption iOption, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, boolean bl) {
        DialogOptionComponent dialogOptionComponent = new DialogOptionComponent(this, iOption, bl);
        if ("weapon_specialist".equals(iOption.getName())) {
            dialogOptionComponent.addValue(Messages.getString("CustomMechDialog.None"));
            TreeSet<String> treeSet = new TreeSet<String>();
            for (int i = 0; i < this.entity.getWeaponList().size(); ++i) {
                Mounted object = this.entity.getWeaponList().get(i);
                treeSet.add(object.getName());
            }
            for (String string : treeSet) {
                dialogOptionComponent.addValue(string);
            }
            dialogOptionComponent.setSelected(iOption.stringValue());
        }
        gridBagLayout.setConstraints(dialogOptionComponent, gridBagConstraints);
        this.panOptions.add(dialogOptionComponent);
        this.optionComps.add(dialogOptionComponent);
    }

    @Override
    public void showDescFor(IOption iOption) {
        this.texDesc.setText(iOption.getDescription());
    }

    @Override
    public void optionClicked(DialogOptionComponent dialogOptionComponent, IOption iOption, boolean bl) {
    }

    public boolean isOkay() {
        return this.okay;
    }

    private void refreshDeployment() {
        this.choDeployment.removeAllItems();
        this.choDeployment.addItem(Messages.getString("CustomMechDialog.StartOfGame"));
        if (this.entity.getDeployRound() < 1) {
            this.choDeployment.setSelectedIndex(0);
        }
        for (int i = 1; i <= 15; ++i) {
            this.choDeployment.addItem(Messages.getString("CustomMechDialog.AfterRound") + i);
            if (this.entity.getDeployRound() != i) continue;
            this.choDeployment.setSelectedIndex(i);
        }
    }

    private void refreshC3() {
        int n;
        this.choC3.removeAllItems();
        int n2 = 0;
        this.entityCorrespondance = new int[this.client.game.getNoOfEntities() + 2];
        if (this.entity.hasC3i()) {
            this.choC3.addItem(Messages.getString("CustomMechDialog.CreateNewNetwork"));
            if (this.entity.getC3Master() == null) {
                this.choC3.setSelectedIndex(n2);
            }
            this.entityCorrespondance[n2++] = this.entity.getId();
        } else if (this.entity.hasC3MM()) {
            n = this.entity.calculateFreeC3MNodes();
            int n3 = this.entity.calculateFreeC3Nodes();
            this.choC3.addItem(Messages.getString("CustomMechDialog.setCompanyMaster", new Object[]{new Integer(n), new Integer(n3)}));
            if (this.entity.C3MasterIs(this.entity)) {
                this.choC3.setSelectedIndex(n2);
            }
            this.entityCorrespondance[n2++] = this.entity.getId();
            this.choC3.addItem(Messages.getString("CustomMechDialog.setIndependentMaster", new Object[]{new Integer(n3)}));
            if (this.entity.getC3Master() == null) {
                this.choC3.setSelectedIndex(n2);
            }
            this.entityCorrespondance[n2++] = -1;
        } else if (this.entity.hasC3M()) {
            n = this.entity.calculateFreeC3Nodes();
            this.choC3.addItem(Messages.getString("CustomMechDialog.setCompanyMaster1", new Object[]{new Integer(n)}));
            if (this.entity.C3MasterIs(this.entity)) {
                this.choC3.setSelectedIndex(n2);
            }
            this.entityCorrespondance[n2++] = this.entity.getId();
            this.choC3.addItem(Messages.getString("CustomMechDialog.setIndependentMaster", new Object[]{new Integer(n)}));
            if (this.entity.getC3Master() == null) {
                this.choC3.setSelectedIndex(n2);
            }
            this.entityCorrespondance[n2++] = -1;
        }
        Enumeration<Entity> enumeration = this.client.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity;
            Entity entity2 = enumeration.nextElement();
            if (this.entity.isEnemyOf(entity2) || this.entity.equals(entity2) || this.entity.hasC3i() != entity2.hasC3i() || (entity = entity2.getC3Master()) != null && entity.getC3Master() != entity) continue;
            int n4 = entity2.calculateFreeC3Nodes();
            if (entity2.hasC3MM() && this.entity.hasC3M() && entity2.C3MasterIs(entity2)) {
                n4 = entity2.calculateFreeC3MNodes();
            }
            if (this.entity.C3MasterIs(entity2) && !this.entity.equals(entity2)) {
                ++n4;
            }
            if (this.entity.hasC3i() && (this.entity.onSameC3NetworkAs(entity2) || this.entity.equals(entity2))) {
                ++n4;
            }
            if (n4 == 0) continue;
            if (entity2.hasC3i()) {
                if (this.entity.onSameC3NetworkAs(entity2)) {
                    this.choC3.addItem(Messages.getString("CustomMechDialog.join1", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4 - 1)}));
                    this.choC3.setSelectedIndex(n2);
                } else {
                    this.choC3.addItem(Messages.getString("CustomMechDialog.join2", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4)}));
                }
                this.entityCorrespondance[n2++] = entity2.getId();
                continue;
            }
            if (entity2.C3MasterIs(entity2) && entity2.hasC3MM()) {
                this.choC3.addItem(Messages.getString("CustomMechDialog.connect2", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4)}));
                this.entityCorrespondance[n2] = entity2.getId();
                if (this.entity.C3MasterIs(entity2)) {
                    this.choC3.setSelectedIndex(n2);
                }
                ++n2;
                continue;
            }
            if (entity2.C3MasterIs(entity2) != this.entity.hasC3M()) continue;
            if (this.entity.C3MasterIs(entity2)) {
                this.choC3.addItem(Messages.getString("CustomMechDialog.connect1", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4 - 1)}));
                this.choC3.setSelectedIndex(n2);
                this.entityCorrespondance[n2++] = entity2.getId();
                continue;
            }
            this.choC3.addItem(Messages.getString("CustomMechDialog.connect2", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4)}));
            this.entityCorrespondance[n2++] = entity2.getId();
        }
    }

    private void refreshUnitNum(Enumeration<Entity> enumeration) {
        this.choUnitNum.removeAllItems();
        this.entityUnitNum.clear();
        this.choUnitNum.addItem(Messages.getString("CustomMechDialog.doNotSwapUnits"));
        this.entityUnitNum.add(this.entity);
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            this.entityUnitNum.add(entity);
            StringBuffer stringBuffer = new StringBuffer(entity.getDisplayName());
            stringBuffer.append(" (").append((char)(entity.getUnitNumber() + PreferenceManager.getClientPreferences().getUnitStartChar())).append('-').append(entity.getId()).append(')');
            this.choUnitNum.addItem(stringBuffer.toString());
        }
        this.choUnitNum.setSelectedIndex(0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (actionEvent.getSource().equals(this.butOffBoardDistance)) {
            int n = 323;
            for (Mounted mounted : this.entity.getWeaponList()) {
                int n2;
                EquipmentType equipmentType = mounted.getType();
                WeaponType weaponType = (WeaponType)equipmentType;
                if (!weaponType.hasFlag(32768L) || (n2 = (weaponType.getLongRange() - 1) * 17) >= n) continue;
                n = n2;
            }
            Slider slider = new Slider(this.clientgui.frame, Messages.getString("CustomMechDialog.offboardDistanceTitle"), Messages.getString("CustomMechDialog.offboardDistanceQuestion"), this.entity.getOffBoardDistance(), 17, n);
            if (!slider.showDialog()) {
                return;
            }
            this.distance = slider.getValue();
            this.butOffBoardDistance.setText(Integer.toString(this.distance));
            return;
        }
        if (!actionEvent.getSource().equals(this.butCancel)) {
            int n;
            Entity entity;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            object = this.fldName.getText();
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            boolean bl = this.chAutoEject.isSelected();
            try {
                n7 = Integer.parseInt(this.fldGunnery.getText());
                n6 = Integer.parseInt(this.fldGunneryL.getText());
                n5 = Integer.parseInt(this.fldGunneryM.getText());
                n4 = Integer.parseInt(this.fldGunneryB.getText());
                n3 = Integer.parseInt(this.fldPiloting.getText());
                n8 = Integer.parseInt(this.fldInit.getText());
                n9 = Integer.parseInt(this.fldCommandInit.getText());
                if (this.entity instanceof Aero) {
                    n10 = Integer.parseInt(this.fldStartVelocity.getText());
                    n11 = Integer.parseInt(this.fldStartElevation.getText());
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.clientgui.frame, Messages.getString("CustomMechDialog.EnterValidSkills"), Messages.getString("CustomMechDialog.NumberFormatError"), 0);
                return;
            }
            if (n7 < 0 || n7 > 8 || n3 < 0 || n3 > 8 || n6 < 0 || n6 > 8 || n5 < 0 || n5 > 8 || n4 < 0 || n4 > 8) {
                JOptionPane.showMessageDialog(this.clientgui.frame, Messages.getString("CustomMechDialog.EnterSkillsBetween0_8"), Messages.getString("CustomMechDialog.NumberFormatError"), 0);
                return;
            }
            if (this.entity instanceof Aero) {
                if (n10 > 2 * this.entity.getWalkMP() || n10 < 0) {
                    JOptionPane.showMessageDialog(this.clientgui.frame, Messages.getString("CustomMechDialog.EnterCorrectVelocity"), Messages.getString("CustomMechDialog.NumberFormatError"), 0);
                    return;
                }
                if (n11 < 1 || n11 > 10) {
                    JOptionPane.showMessageDialog(this.clientgui.frame, Messages.getString("CustomMechDialog.EnterCorrectElevation"), Messages.getString("CustomMechDialog.NumberFormatError"), 0);
                    return;
                }
            }
            if (this.chOffBoard.isSelected()) {
                int n12;
                try {
                    n12 = this.distance;
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this.clientgui.frame, Messages.getString("CustomMechDialog.EnterValidSkills"), Messages.getString("CustomMechDialog.NumberFormatError"), 0);
                    return;
                }
                if (n12 < 17) {
                    JOptionPane.showMessageDialog(this.clientgui.frame, Messages.getString("CustomMechDialog.OffboardDistance"), Messages.getString("CustomMechDialog.NumberFormatError"), 0);
                    return;
                }
                this.entity.setOffBoard(n12, this.choOffBoardDirection.getSelectedIndex());
            } else {
                this.entity.setOffBoard(0, -1);
            }
            if (this.client.game.getOptions().booleanOption("rpg_gunnery")) {
                this.entity.setCrew(new Pilot((String)object, n6, n5, n4, n3));
            } else {
                this.entity.setCrew(new Pilot((String)object, n7, n3));
            }
            this.entity.getCrew().setInitBonus(n8);
            this.entity.getCrew().setCommandBonus(n9);
            if (this.entity instanceof Mech) {
                entity = (Mech)this.entity;
                ((Mech)entity).setAutoEject(!bl);
            }
            if (this.entity instanceof Aero) {
                entity = (Aero)this.entity;
                ((Aero)entity).setCurrentVelocity(n10);
                ((Aero)entity).setNextVelocity(n10);
                entity.setElevation(n11);
            }
            if (this.entity.hasC3() && this.choC3.getSelectedIndex() > -1) {
                int n13;
                entity = this.client.getEntity(this.entityCorrespondance[this.choC3.getSelectedIndex()]);
                n = this.client.game.getC3SubNetworkMembers(this.entity).size();
                if (n + (n13 = this.client.game.getC3NetworkMembers(entity).size()) <= 12) {
                    this.entity.setC3Master(entity);
                } else {
                    String string = Messages.getString("CustomMechDialog.NetworkTooBig.message", new Object[]{this.entity.getShortName(), entity.getShortName(), new Integer(n), new Integer(n13), new Integer(12)});
                    this.clientgui.doAlertDialog(Messages.getString("CustomMechDialog.NetworkTooBig.title"), string);
                    this.refreshC3();
                }
            } else if (this.entity.hasC3i() && this.choC3.getSelectedIndex() > -1) {
                this.entity.setC3NetId(this.client.getEntity(this.entityCorrespondance[this.choC3.getSelectedIndex()]));
            }
            if (!this.entity.hasTargComp() && this.clientgui.getClient().game.getOptions().booleanOption("allow_level_3_targsys")) {
                int n14 = 0;
                if (this.choTargSys.getSelectedItem() != null) {
                    n14 = MiscType.getTargetSysType((String)this.choTargSys.getSelectedItem());
                }
                if (n14 >= 0) {
                    this.entity.setTargSysType(n14);
                } else {
                    System.err.println("Illegal targeting system index: " + n14);
                    this.entity.setTargSysType(0);
                }
            }
            if (!this.entityUnitNum.isEmpty() && this.choUnitNum.getSelectedIndex() > 0) {
                Entity entity2 = this.entityUnitNum.get(this.choUnitNum.getSelectedIndex());
                n = this.entity.getUnitNumber();
                this.entity.setUnitNumber(entity2.getUnitNumber());
                entity2.setUnitNumber((char)n);
                this.client.sendUpdateEntity(entity2);
            }
            this.entity.setDeployRound(this.choDeployment.getSelectedIndex());
            for (MunitionChoicePanel munitionChoicePanel : this.m_vMunitions) {
                munitionChoicePanel.applyChoice();
            }
            for (RapidfireMGPanel rapidfireMGPanel : this.m_vMGs) {
                rapidfireMGPanel.applyChoice();
            }
            for (MineChoicePanel mineChoicePanel : this.m_vMines) {
                mineChoicePanel.applyChoice();
            }
            for (SantaAnnaChoicePanel santaAnnaChoicePanel : this.m_vSantaAnna) {
                santaAnnaChoicePanel.applyChoice();
            }
            if (null != this.m_bombs) {
                this.m_bombs.applyChoice();
            }
            this.entity.setSpotlight(this.chSearchlight.isSelected());
            this.entity.setSpotlightState(this.chSearchlight.isSelected());
            this.setOptions();
            this.okay = true;
            this.clientgui.chatlounge.refreshEntities();
        }
        this.setVisible(false);
        object = null;
        if (actionEvent.getSource().equals(this.butPrev)) {
            object = this.getNextEntity(false);
        } else if (actionEvent.getSource().equals(this.butNext)) {
            object = this.getNextEntity(true);
        }
        if (object != null) {
            this.clientgui.chatlounge.customizeMech((Entity)object);
        }
    }

    private Entity getNextEntity(boolean bl) {
        IGame iGame = this.client.game;
        boolean bl2 = iGame.getOptions().booleanOption("blind_drop");
        boolean bl3 = iGame.getOptions().booleanOption("real_blind_drop");
        Player player = this.client.getLocalPlayer();
        Entity entity = bl ? iGame.getNextEntityFromList(this.entity) : iGame.getPreviousEntityFromList(this.entity);
        while (entity != null && !entity.equals(this.entity)) {
            if (entity.getOwner().equals(player) || !bl2 && !bl3) {
                return entity;
            }
            if (bl) {
                entity = iGame.getNextEntityFromList(entity);
                continue;
            }
            entity = iGame.getPreviousEntityFromList(entity);
        }
        return null;
    }

    class RapidfireMGPanel
    extends JPanel {
        private static final long serialVersionUID = 5261919826318225201L;
        private Mounted m_mounted;
        JCheckBox chRapid = new JCheckBox();

        RapidfireMGPanel(Mounted mounted) {
            this.m_mounted = mounted;
            int n = mounted.getLocation();
            String string = Messages.getString("CustomMechDialog.switchToRapidFire", new Object[]{CustomMechDialog.this.entity.getLocationAbbr(n)});
            JLabel jLabel = new JLabel(string);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            this.add((Component)jLabel, GBC.std().anchor(13));
            this.chRapid.setSelected(mounted.isRapidfire());
            this.add((Component)this.chRapid, GBC.eol());
        }

        public void applyChoice() {
            boolean bl = this.chRapid.isSelected();
            this.m_mounted.setRapidfire(bl);
        }

        public void setEnabled(boolean bl) {
            this.chRapid.setEnabled(bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProtomechMunitionChoicePanel
    extends MunitionChoicePanel {
        private static final long serialVersionUID = -8170286698673268120L;
        private final float m_origShotsLeft;
        private final AmmoType m_origAmmo;

        ProtomechMunitionChoicePanel(Mounted mounted, ArrayList<AmmoType> arrayList) {
            super(mounted, arrayList);
            this.m_origAmmo = (AmmoType)mounted.getType();
            this.m_origShotsLeft = mounted.getShotsLeft();
        }

        @Override
        public void applyChoice() {
            super.applyChoice();
            this.setShotsLeft(Math.round((float)this.getShotsLeft() * this.m_origShotsLeft / (float)this.m_origAmmo.getShots()));
            if (this.chDump.isSelected()) {
                this.setShotsLeft(0);
            }
        }
    }

    class BombChoicePanel
    extends Panel
    implements ItemListener {
        private static final long serialVersionUID = 483782753790544050L;
        private JComboBox b_choice_he;
        private JComboBox b_choice_cl;
        private JComboBox b_choice_lg;
        private JComboBox b_choice_inf;
        private JComboBox b_choice_mine;
        private JComboBox b_choice_tag;
        private JComboBox b_choice_arrow;
        private JComboBox b_choice_rl;
        private JComboBox b_choice_alamo;
        private int maxPoints = 0;

        public BombChoicePanel(int[] nArray, int n) {
            Label label;
            String string;
            int n2;
            int n3;
            this.maxPoints = n;
            this.b_choice_he = new JComboBox();
            this.b_choice_cl = new JComboBox();
            this.b_choice_lg = new JComboBox();
            this.b_choice_inf = new JComboBox();
            this.b_choice_mine = new JComboBox();
            this.b_choice_tag = new JComboBox();
            this.b_choice_arrow = new JComboBox();
            this.b_choice_rl = new JComboBox();
            this.b_choice_alamo = new JComboBox();
            this.b_choice_he.addItemListener(this);
            this.b_choice_cl.addItemListener(this);
            this.b_choice_lg.addItemListener(this);
            this.b_choice_inf.addItemListener(this);
            this.b_choice_mine.addItemListener(this);
            this.b_choice_tag.addItemListener(this);
            this.b_choice_arrow.addItemListener(this);
            this.b_choice_rl.addItemListener(this);
            this.b_choice_alamo.addItemListener(this);
            int n4 = 0;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n4 += nArray[n3] * Aero.bombCosts[n3];
            }
            n3 = n - n4;
            for (n2 = 0; n2 <= Math.max(n3, nArray[0]); ++n2) {
                this.b_choice_he.addItem(Integer.toString(n2));
            }
            for (n2 = 0; n2 <= Math.max(n3, nArray[1]); ++n2) {
                this.b_choice_cl.addItem(Integer.toString(n2));
            }
            for (n2 = 0; n2 <= Math.max(n3, nArray[2]); ++n2) {
                this.b_choice_lg.addItem(Integer.toString(n2));
            }
            for (n2 = 0; n2 <= Math.max(n3, nArray[3]); ++n2) {
                this.b_choice_inf.addItem(Integer.toString(n2));
            }
            for (n2 = 0; n2 <= Math.max(n3, nArray[4]); ++n2) {
                this.b_choice_mine.addItem(Integer.toString(n2));
            }
            for (n2 = 0; n2 <= Math.max(n3, nArray[5]); ++n2) {
                this.b_choice_tag.addItem(Integer.toString(n2));
            }
            for (n2 = 0; n2 <= Math.max(n3, nArray[7]); ++n2) {
                this.b_choice_rl.addItem(Integer.toString(n2));
            }
            for (n2 = 0; n2 <= Math.max(Math.round(n3 / 5), nArray[6]); ++n2) {
                this.b_choice_arrow.addItem(Integer.toString(n2));
            }
            for (n2 = 0; n2 <= Math.max(Math.round(n3 / 10), nArray[8]); ++n2) {
                this.b_choice_alamo.addItem(Integer.toString(n2));
            }
            this.b_choice_he.setSelectedIndex(nArray[0]);
            this.b_choice_cl.setSelectedIndex(nArray[1]);
            this.b_choice_lg.setSelectedIndex(nArray[2]);
            this.b_choice_inf.setSelectedIndex(nArray[3]);
            this.b_choice_mine.setSelectedIndex(nArray[4]);
            this.b_choice_tag.setSelectedIndex(nArray[5]);
            this.b_choice_arrow.setSelectedIndex(nArray[6]);
            this.b_choice_rl.setSelectedIndex(nArray[7]);
            this.b_choice_alamo.setSelectedIndex(nArray[8]);
            String string2 = Messages.getString("CustomMechDialog.labBombHE");
            Label label2 = new Label(string2);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            this.add((Component)label2, GBC.std().anchor(13));
            this.add((Component)this.b_choice_he, GBC.std());
            String string3 = Messages.getString("CustomMechDialog.labBombTAG");
            Label label3 = new Label(string3);
            this.add((Component)label3, GBC.std().anchor(13));
            this.add((Component)this.b_choice_tag, GBC.eol());
            String string4 = Messages.getString("CustomMechDialog.labBombCL");
            Label label4 = new Label(string4);
            this.add((Component)label4, GBC.std().anchor(13));
            this.add((Component)this.b_choice_cl, GBC.std());
            String string5 = Messages.getString("CustomMechDialog.labBombArrow");
            Label label5 = new Label(string5);
            this.add((Component)label5, GBC.std().anchor(13));
            this.add((Component)this.b_choice_arrow, GBC.std());
            String string6 = Messages.getString("CustomMechDialog.labBombLG");
            Label label6 = new Label(string6);
            this.add((Component)label6, GBC.std().anchor(13));
            this.add((Component)this.b_choice_lg, GBC.std());
            String string7 = Messages.getString("CustomMechDialog.labBombRL");
            Label label7 = new Label(string7);
            this.add((Component)label7, GBC.std().anchor(13));
            this.add((Component)this.b_choice_rl, GBC.eol());
            String string8 = Messages.getString("CustomMechDialog.labBombInf");
            Label label8 = new Label(string8);
            this.add((Component)label8, GBC.std().anchor(13));
            if (CustomMechDialog.this.clientgui.getClient().game.getOptions().booleanOption("at2_nukes")) {
                this.add((Component)this.b_choice_inf, GBC.std());
                string = Messages.getString("CustomMechDialog.labBombAlamo");
                label = new Label(string);
                this.add((Component)label, GBC.std().anchor(13));
                this.add((Component)this.b_choice_alamo, GBC.eol());
            } else {
                this.add((Component)this.b_choice_inf, GBC.eol());
            }
            string = Messages.getString("CustomMechDialog.labBombMine");
            label = new Label(string);
            this.add((Component)label, GBC.std().anchor(13));
            this.add((Component)this.b_choice_mine, GBC.eol());
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            int n;
            int n2 = this.b_choice_he.getSelectedIndex();
            int n3 = this.b_choice_cl.getSelectedIndex();
            int n4 = this.b_choice_lg.getSelectedIndex();
            int n5 = this.b_choice_inf.getSelectedIndex();
            int n6 = this.b_choice_mine.getSelectedIndex();
            int n7 = this.b_choice_tag.getSelectedIndex();
            int n8 = this.b_choice_arrow.getSelectedIndex();
            int n9 = this.b_choice_rl.getSelectedIndex();
            int n10 = this.b_choice_alamo.getSelectedIndex();
            int n11 = n2 + n3 + n4 + n5 + n6 + n7 + 5 * n8 + n9 + 10 * n10;
            int n12 = this.maxPoints - n11;
            this.b_choice_he.removeItemListener(this);
            this.b_choice_cl.removeItemListener(this);
            this.b_choice_lg.removeItemListener(this);
            this.b_choice_inf.removeItemListener(this);
            this.b_choice_mine.removeItemListener(this);
            this.b_choice_tag.removeItemListener(this);
            this.b_choice_arrow.removeItemListener(this);
            this.b_choice_rl.removeItemListener(this);
            this.b_choice_alamo.removeItemListener(this);
            this.b_choice_he.removeAllItems();
            this.b_choice_cl.removeAllItems();
            this.b_choice_lg.removeAllItems();
            this.b_choice_inf.removeAllItems();
            this.b_choice_mine.removeAllItems();
            this.b_choice_tag.removeAllItems();
            this.b_choice_arrow.removeAllItems();
            this.b_choice_rl.removeAllItems();
            this.b_choice_alamo.removeAllItems();
            for (n = 0; n <= Math.max(n12, n2); ++n) {
                this.b_choice_he.addItem(Integer.toString(n));
            }
            for (n = 0; n <= Math.max(n12, n3); ++n) {
                this.b_choice_cl.addItem(Integer.toString(n));
            }
            for (n = 0; n <= Math.max(n12, n4); ++n) {
                this.b_choice_lg.addItem(Integer.toString(n));
            }
            for (n = 0; n <= Math.max(n12, n5); ++n) {
                this.b_choice_inf.addItem(Integer.toString(n));
            }
            for (n = 0; n <= Math.max(n12, n6); ++n) {
                this.b_choice_mine.addItem(Integer.toString(n));
            }
            for (n = 0; n <= Math.max(n12, n7); ++n) {
                this.b_choice_tag.addItem(Integer.toString(n));
            }
            for (n = 0; n <= Math.max(n12, n9); ++n) {
                this.b_choice_rl.addItem(Integer.toString(n));
            }
            for (n = 0; n <= Math.max(Math.round(n12 / 5), n8); ++n) {
                this.b_choice_arrow.addItem(Integer.toString(n));
            }
            for (n = 0; n <= Math.max(Math.round(n12 / 10), n10); ++n) {
                this.b_choice_alamo.addItem(Integer.toString(n));
            }
            this.b_choice_he.setSelectedIndex(n2);
            this.b_choice_cl.setSelectedIndex(n3);
            this.b_choice_lg.setSelectedIndex(n4);
            this.b_choice_inf.setSelectedIndex(n5);
            this.b_choice_mine.setSelectedIndex(n6);
            this.b_choice_tag.setSelectedIndex(n7);
            this.b_choice_arrow.setSelectedIndex(n8);
            this.b_choice_rl.setSelectedIndex(n9);
            this.b_choice_alamo.setSelectedIndex(n10);
            this.b_choice_he.addItemListener(this);
            this.b_choice_cl.addItemListener(this);
            this.b_choice_lg.addItemListener(this);
            this.b_choice_inf.addItemListener(this);
            this.b_choice_mine.addItemListener(this);
            this.b_choice_tag.addItemListener(this);
            this.b_choice_arrow.addItemListener(this);
            this.b_choice_rl.addItemListener(this);
            this.b_choice_alamo.addItemListener(this);
        }

        public void applyChoice() {
            int[] nArray = new int[]{this.b_choice_he.getSelectedIndex(), this.b_choice_cl.getSelectedIndex(), this.b_choice_lg.getSelectedIndex(), this.b_choice_inf.getSelectedIndex(), this.b_choice_mine.getSelectedIndex(), this.b_choice_tag.getSelectedIndex(), this.b_choice_arrow.getSelectedIndex(), this.b_choice_rl.getSelectedIndex(), this.b_choice_alamo.getSelectedIndex()};
            ((Aero)CustomMechDialog.this.entity).setBombChoices(nArray);
        }

        public void setEnabled(boolean bl) {
            this.b_choice_he.setEnabled(bl);
            this.b_choice_cl.setEnabled(bl);
            this.b_choice_lg.setEnabled(bl);
            this.b_choice_inf.setEnabled(bl);
            this.b_choice_mine.setEnabled(bl);
            this.b_choice_tag.setEnabled(bl);
            this.b_choice_arrow.setEnabled(bl);
            this.b_choice_rl.setEnabled(bl);
            this.b_choice_alamo.setEnabled(bl);
        }
    }

    class SantaAnnaChoicePanel
    extends Panel {
        private static final long serialVersionUID = -1645895479085898410L;
        private JComboBox m_choice;
        private Mounted m_mounted;

        public SantaAnnaChoicePanel(Mounted mounted) {
            int n;
            this.m_mounted = mounted;
            this.m_choice = new JComboBox();
            for (n = 0; n <= this.m_mounted.getShotsLeft(); ++n) {
                this.m_choice.addItem(Integer.toString(n));
            }
            n = mounted.getLocation();
            String string = "Nuclear warheads for " + this.m_mounted.getName() + " (" + CustomMechDialog.this.entity.getLocationAbbr(n) + "):";
            Label label = new Label(string);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            this.add((Component)label, GBC.std());
            this.m_choice.setSelectedIndex(mounted.getNSantaAnna());
            this.add((Component)this.m_choice, GBC.eol());
        }

        public void applyChoice() {
            this.m_mounted.setNSantaAnna(this.m_choice.getSelectedIndex());
        }

        public void setEnabled(boolean bl) {
            this.m_choice.setEnabled(bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MunitionChoicePanel
    extends JPanel {
        private static final long serialVersionUID = 3401106035583965326L;
        private ArrayList<AmmoType> m_vTypes;
        private JComboBox m_choice;
        private Mounted m_mounted;
        JLabel labDump = new JLabel(Messages.getString("CustomMechDialog.labDump"));
        JCheckBox chDump = new JCheckBox();
        JLabel labHotLoad = new JLabel(Messages.getString("CustomMechDialog.switchToHotLoading"));
        JCheckBox chHotLoad = new JCheckBox();

        MunitionChoicePanel(Mounted mounted, ArrayList<AmmoType> arrayList) {
            Object object;
            this.m_vTypes = arrayList;
            this.m_mounted = mounted;
            AmmoType ammoType = (AmmoType)mounted.getType();
            this.m_choice = new JComboBox();
            Iterator<AmmoType> iterator = this.m_vTypes.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                object = iterator.next();
                this.m_choice.addItem(((EquipmentType)object).getName());
                if (((EquipmentType)object).getInternalName() == ammoType.getInternalName()) {
                    this.m_choice.setSelectedIndex(n);
                }
                ++n;
            }
            if (mounted.getLocation() == -1) {
                object = mounted.getLinkedBy();
                n = ((Mounted)object).getLocation();
            } else {
                n = mounted.getLocation();
            }
            object = '(' + CustomMechDialog.this.entity.getLocationAbbr(n) + ')';
            JLabel jLabel = new JLabel((String)object);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            this.add((Component)jLabel, GBC.std());
            this.add((Component)this.m_choice, GBC.eol());
            if (CustomMechDialog.this.clientgui.getClient().game.getOptions().booleanOption("lobby_ammo_dump")) {
                this.add((Component)this.labDump, GBC.std());
                this.add((Component)this.chDump, GBC.eol());
                if (CustomMechDialog.this.clientgui.getClient().game.getOptions().booleanOption("tacops_hotload") && ammoType.hasFlag(8L)) {
                    this.add((Component)this.labHotLoad, GBC.std());
                    this.add((Component)this.chHotLoad, GBC.eol());
                }
            } else if (CustomMechDialog.this.clientgui.getClient().game.getOptions().booleanOption("tacops_hotload") && ammoType.hasFlag(8L)) {
                this.add((Component)this.labHotLoad, GBC.std());
                this.add((Component)this.chHotLoad, GBC.eol());
            }
        }

        public void applyChoice() {
            int n = this.m_choice.getSelectedIndex();
            AmmoType ammoType = this.m_vTypes.get(n);
            this.m_mounted.changeAmmoType(ammoType);
            if (this.chDump.isSelected()) {
                this.m_mounted.setShotsLeft(0);
            }
            if (CustomMechDialog.this.clientgui.getClient().game.getOptions().booleanOption("tacops_hotload") && this.chHotLoad.isSelected() != this.m_mounted.isHotLoaded()) {
                this.m_mounted.setHotLoad(this.chHotLoad.isSelected());
            }
        }

        @Override
        public void setEnabled(boolean bl) {
            this.m_choice.setEnabled(bl);
        }

        int getShotsLeft() {
            return this.m_mounted.getShotsLeft();
        }

        void setShotsLeft(int n) {
            this.m_mounted.setShotsLeft(n);
        }
    }

    class MineChoicePanel
    extends JPanel {
        private static final long serialVersionUID = -1868675102440527538L;
        private JComboBox m_choice;
        private Mounted m_mounted;

        MineChoicePanel(Mounted mounted) {
            this.m_mounted = mounted;
            this.m_choice = new JComboBox();
            this.m_choice.addItem(Messages.getString("CustomMechDialog.Conventional"));
            this.m_choice.addItem(Messages.getString("CustomMechDialog.Vibrabomb"));
            int n = mounted.getLocation();
            String string = '(' + CustomMechDialog.this.entity.getLocationAbbr(n) + ')';
            JLabel jLabel = new JLabel(string);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            this.add((Component)jLabel, GBC.std());
            this.m_choice.setSelectedIndex(mounted.getMineType());
            this.add((Component)this.m_choice, GBC.eol());
        }

        public void applyChoice() {
            this.m_mounted.setMineType(this.m_choice.getSelectedIndex());
        }

        public void setEnabled(boolean bl) {
            this.m_choice.setEnabled(bl);
        }
    }
}

