/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import megamek.client.Client;
import megamek.client.ui.swing.BoardView1;
import megamek.client.ui.swing.ClientGUI;
import megamek.client.ui.swing.FiringDisplay;
import megamek.client.ui.swing.Messages;
import megamek.client.ui.swing.MovementDisplay;
import megamek.client.ui.swing.PhysicalDisplay;
import megamek.client.ui.swing.TargetingPhaseDisplay;
import megamek.common.AmmoType;
import megamek.common.BipedMech;
import megamek.common.BuildingTarget;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.EquipmentMode;
import megamek.common.HexTarget;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.MinefieldTarget;
import megamek.common.Mounted;
import megamek.common.Tank;
import megamek.common.TargetRoll;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.BAVibroClawAttackAction;
import megamek.common.actions.BreakGrappleAttackAction;
import megamek.common.actions.GrappleAttackAction;
import megamek.common.weapons.CLFireExtinguisher;
import megamek.common.weapons.ISFireExtinguisher;

public class MapMenu
extends JPopupMenu
implements ActionListener {
    private static final long serialVersionUID = 2879345079968414986L;
    private Coords coords;
    private IGame game;
    private Component currentPanel;
    private IBoard board;
    private Client client;
    private ClientGUI gui;
    private Entity selectedEntity;
    private Entity myEntity;
    private Targetable myTarget = null;
    private boolean hasMenu = false;

    public MapMenu(Coords coords, Client client, Component component, ClientGUI clientGUI) {
        this.coords = coords;
        this.game = client.game;
        this.currentPanel = component;
        this.board = client.getBoard();
        this.client = client;
        this.gui = clientGUI;
        this.selectedEntity = this.myEntity = this.game.getEntity(clientGUI.getSelectedEntityNum());
        this.hasMenu = this.createMenu();
    }

    private boolean canSelectEntities() {
        return this.client.isMyTurn() && (this.currentPanel instanceof FiringDisplay || this.currentPanel instanceof PhysicalDisplay || this.currentPanel instanceof MovementDisplay || this.currentPanel instanceof TargetingPhaseDisplay);
    }

    private boolean canTargetEntities() {
        return this.client.isMyTurn() && (this.currentPanel instanceof FiringDisplay || this.currentPanel instanceof PhysicalDisplay || this.currentPanel instanceof TargetingPhaseDisplay);
    }

    private boolean createMenu() {
        this.removeAll();
        int n = 0;
        JMenu jMenu = this.createSelectMenu();
        if (jMenu.getItemCount() > 0) {
            this.add(jMenu);
            ++n;
        }
        if ((jMenu = this.createViewMenu()).getItemCount() > 0) {
            this.add(jMenu);
            ++n;
        }
        if (this.client.isMyTurn() && this.myEntity != null) {
            this.selectTarget();
            jMenu = this.createTargetMenu();
            if (jMenu.getItemCount() > 0) {
                this.add(jMenu);
                ++n;
            }
            if (this.currentPanel instanceof MovementDisplay) {
                jMenu = this.createMovementMenu(this.myEntity.getPosition().equals(this.coords));
                if (n > 0) {
                    this.addSeparator();
                    ++n;
                }
                if (jMenu.getItemCount() > 0) {
                    this.add(jMenu);
                    ++n;
                }
                if ((jMenu = this.createTurnMenu()).getItemCount() > 0) {
                    this.add(jMenu);
                    ++n;
                }
                if ((jMenu = this.createStandMenu()).getItemCount() > 0) {
                    this.add(jMenu);
                    ++n;
                }
                if ((jMenu = this.createPhysicalMenu(true)).getItemCount() > 0) {
                    this.addSeparator();
                    this.add(jMenu);
                    ++n;
                }
            } else if (this.currentPanel instanceof FiringDisplay && this.client.isMyTurn()) {
                if (n > 0) {
                    this.addSeparator();
                    ++n;
                }
                if ((jMenu = this.createWeaponsFireMenu()).getItemCount() > 0) {
                    this.add(jMenu);
                    ++n;
                }
                if ((jMenu = this.createModeMenu()).getItemCount() > 0) {
                    this.add(jMenu);
                    ++n;
                }
                if ((jMenu = this.createTorsoTwistMenu()).getItemCount() > 0) {
                    this.add(jMenu);
                    ++n;
                }
            } else if (this.currentPanel instanceof PhysicalDisplay && this.client.isMyTurn() && (jMenu = this.createPhysicalMenu(false)).getItemCount() > 0) {
                this.addSeparator();
                this.add(jMenu);
                ++n;
            }
        }
        return n > 0;
    }

    private JMenuItem TargetMenuItem(Targetable targetable) {
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("ClientGUI.targetMenuItem") + targetable.getDisplayName());
        String string = "";
        string = targetable instanceof Entity ? "E|" + ((Entity)targetable).getId() : (targetable instanceof BuildingTarget ? "B|" + targetable.getPosition().x + "|" + targetable.getPosition().y + "|" + (targetable.getTargetType() == 4) : (targetable instanceof MinefieldTarget ? "M|" + targetable.getPosition().x + "|" + targetable.getPosition().y : "H|" + targetable.getPosition().x + "|" + targetable.getPosition().y + "|" + targetable.getTargetType()));
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapMenu.this.myTarget = MapMenu.this.decodeTargetInfo(actionEvent.getActionCommand());
                if (MapMenu.this.currentPanel instanceof FiringDisplay) {
                    ((FiringDisplay)MapMenu.this.currentPanel).target(MapMenu.this.myTarget);
                } else if (MapMenu.this.currentPanel instanceof PhysicalDisplay) {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).target(MapMenu.this.myTarget);
                } else if (MapMenu.this.currentPanel instanceof TargetingPhaseDisplay) {
                    ((TargetingPhaseDisplay)MapMenu.this.currentPanel).target(MapMenu.this.myTarget);
                }
            }
        });
        return jMenuItem;
    }

    private JMenuItem createChargeMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("MovementDisplay.butCharge"));
        if (!this.client.game.getEntities(this.coords).hasMoreElements()) {
            return null;
        }
        jMenuItem.setActionCommand("moveCharge");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapMenu.this.plotCourse(actionEvent);
            }
        });
        return jMenuItem;
    }

    private JMenuItem createDFAJMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("MovementDisplay.butDfa"));
        if (!this.client.game.getEntities(this.coords).hasMoreElements()) {
            return null;
        }
        jMenuItem.setActionCommand("moveDFA");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapMenu.this.plotCourse(actionEvent);
            }
        });
        return jMenuItem;
    }

    private JMenuItem SelectJMenuItem(Entity entity) {
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("ClientGUI.selectMenuItem") + entity.getDisplayName());
        jMenuItem.setActionCommand(Integer.toString(entity.getId()));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Entity entity = MapMenu.this.game.getEntity(Integer.parseInt(actionEvent.getActionCommand()));
                    MapMenu.this.selectedEntity = entity;
                    if (MapMenu.this.currentPanel instanceof MovementDisplay) {
                        ((MovementDisplay)MapMenu.this.currentPanel).selectEntity(MapMenu.this.selectedEntity.getId());
                    } else if (MapMenu.this.currentPanel instanceof FiringDisplay) {
                        ((FiringDisplay)MapMenu.this.currentPanel).selectEntity(MapMenu.this.selectedEntity.getId());
                    } else if (MapMenu.this.currentPanel instanceof PhysicalDisplay) {
                        ((PhysicalDisplay)MapMenu.this.currentPanel).selectEntity(MapMenu.this.selectedEntity.getId());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenuItem ViewJMenuItem(Entity entity) {
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("ClientGUI.viewMenuItem") + entity.getDisplayName());
        jMenuItem.setActionCommand(Integer.toString(entity.getId()));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MapMenu.this.selectedEntity = MapMenu.this.game.getEntity(Integer.parseInt(actionEvent.getActionCommand()));
                    MapMenu.this.gui.setDisplayVisible(true);
                    ((MapMenu)MapMenu.this).gui.mechD.displayEntity(MapMenu.this.selectedEntity);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenu createSelectMenu() {
        JMenu jMenu = new JMenu("Select");
        if (this.canSelectEntities()) {
            Enumeration<Entity> enumeration = this.client.game.getEntities(this.coords);
            while (enumeration.hasMoreElements()) {
                Entity entity = enumeration.nextElement();
                if (!this.client.getMyTurn().isValidEntity(entity, this.client.game)) continue;
                jMenu.add(this.SelectJMenuItem(entity));
            }
        }
        return jMenu;
    }

    private JMenu createViewMenu() {
        JMenu jMenu = new JMenu("View");
        Enumeration<Entity> enumeration = this.client.game.getEntities(this.coords);
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            jMenu.add(this.ViewJMenuItem(entity));
        }
        return jMenu;
    }

    private JMenu createMovementMenu(boolean bl) {
        JMenu jMenu = new JMenu("Movement");
        if (this.myEntity == null) {
            return jMenu;
        }
        if (bl) {
            JMenuItem jMenuItem = new JMenuItem(Messages.getString("MovementDisplay.butWalk"));
            jMenuItem.setActionCommand("moveWalk");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(Messages.getString("MovementDisplay.butBackup"));
            jMenuItem.setActionCommand("moveBackUp");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            jMenu.add(jMenuItem);
            if (this.myEntity.getJumpMP() > 0) {
                jMenuItem = new JMenuItem(Messages.getString("CommonMenuBar.moveJump"));
                jMenuItem.setActionCommand("moveJump");
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                jMenu.add(jMenuItem);
            }
            if (this.game.getOptions().booleanOption("tacops_evade")) {
                jMenuItem = new JMenuItem(Messages.getString("MovementDisplay.butEvade"));
                jMenuItem.setActionCommand("MoveEvade");
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                jMenu.add(jMenuItem);
            }
            if (this.game.getPlanetaryConditions().isRecklessConditions() && !this.game.getBoard().inSpace()) {
                jMenuItem = new JMenuItem(Messages.getString("MovementDisplay.butReckless"));
                jMenuItem.setActionCommand("moveReckless");
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                jMenu.add(jMenuItem);
            }
        } else {
            JMenuItem jMenuItem = new JMenuItem(Messages.getString("MovementDisplay.butWalk"));
            jMenuItem.setActionCommand("moveWalk");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        MapMenu.this.plotCourse(actionEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(Messages.getString("MovementDisplay.butBackup"));
            jMenuItem.setActionCommand("moveBackUp");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        MapMenu.this.plotCourse(actionEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            jMenu.add(jMenuItem);
            if (this.myEntity.getJumpMP() > 0) {
                jMenuItem = new JMenuItem(Messages.getString("CommonMenuBar.moveJump"));
                jMenuItem.setActionCommand("moveJump");
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            MapMenu.this.plotCourse(actionEvent);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                jMenu.add(jMenuItem);
            }
            if (this.game.getOptions().booleanOption("tacops_evade")) {
                jMenuItem = new JMenuItem(Messages.getString("MovementDisplay.butEvade"));
                jMenuItem.setActionCommand("MoveEvade");
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            MapMenu.this.plotCourse(actionEvent);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                jMenu.add(jMenuItem);
            }
            if (this.game.getPlanetaryConditions().isRecklessConditions() && !this.game.getBoard().inSpace()) {
                jMenuItem = new JMenuItem(Messages.getString("MovementDisplay.butReckless"));
                jMenuItem.setActionCommand("moveReckless");
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            MapMenu.this.plotCourse(actionEvent);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                jMenu.add(jMenuItem);
            }
        }
        return jMenu;
    }

    private JMenu createTurnMenu() {
        JMenu jMenu = new JMenu(Messages.getString("MovementDisplay.butTurn"));
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("MovementDisplay.butTurnRight"));
        jMenuItem.setActionCommand("MoveTurnRight");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(Messages.getString("MovementDisplay.butTurnLeft"));
        jMenuItem.setActionCommand("MoveTurnLeft");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("About Face");
        jMenuItem.setActionCommand("MoveTurnRight");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                    ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                    ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private JMenu createWeaponsFireMenu() {
        JMenu jMenu = new JMenu("Weapons");
        jMenu.add(this.createFireJMenuItem());
        jMenu.add(this.createSkipJMenuItem());
        jMenu.add(this.createAlphaStrikeJMenuItem());
        if (this.myEntity.canFlipArms()) {
            jMenu.add(this.createFlipArmsJMenuItem());
        }
        return jMenu;
    }

    private JMenuItem createSkipJMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Skip");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((FiringDisplay)MapMenu.this.currentPanel).nextWeapon();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenuItem createAlphaStrikeJMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Alpha Strike");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Mounted mounted;
                    int n;
                    int n2;
                    FiringDisplay firingDisplay = (FiringDisplay)MapMenu.this.currentPanel;
                    int n3 = MapMenu.this.myEntity.getWeaponList().size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        n = ((MapMenu)MapMenu.this).gui.mechD.wPan.getSelectedWeaponNum();
                        mounted = MapMenu.this.myEntity.getEquipment(n);
                        if (mounted.getType().hasFlag(131072L) && mounted.usedInPhase() == IGame.Phase.PHASE_UNKNOWN) {
                            firingDisplay.fire();
                            continue;
                        }
                        firingDisplay.nextWeapon();
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        n = ((MapMenu)MapMenu.this).gui.mechD.wPan.getSelectedWeaponNum();
                        mounted = MapMenu.this.myEntity.getEquipment(n);
                        if (mounted.getType().hasFlag(65536L) && mounted.usedInPhase() == IGame.Phase.PHASE_UNKNOWN) {
                            firingDisplay.fire();
                            continue;
                        }
                        firingDisplay.nextWeapon();
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        n = ((MapMenu)MapMenu.this).gui.mechD.wPan.getSelectedWeaponNum();
                        mounted = MapMenu.this.myEntity.getEquipment(n);
                        if (mounted.usedInPhase() == IGame.Phase.PHASE_UNKNOWN) {
                            firingDisplay.fire();
                            continue;
                        }
                        firingDisplay.nextWeapon();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenuItem createFlipArmsJMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Flip Arms");
        jMenuItem.setActionCommand(Integer.toString(this.myEntity.getId()));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    FiringDisplay firingDisplay = (FiringDisplay)MapMenu.this.currentPanel;
                    int n = Integer.parseInt(actionEvent.getActionCommand());
                    firingDisplay.updateFlipArms(!MapMenu.this.game.getEntity(n).getArmsFlipped());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenuItem createFireJMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Fire");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((FiringDisplay)MapMenu.this.currentPanel).fire();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenu createPhysicalMenu(boolean bl) {
        JMenu jMenu = new JMenu("Physicals");
        if (bl) {
            JMenuItem jMenuItem;
            if (this.myEntity.canCharge() && (jMenuItem = this.createChargeMenuItem()) != null) {
                jMenu.add(jMenuItem);
            }
            if (this.myEntity.canDFA() && (jMenuItem = this.createDFAJMenuItem()) != null) {
                jMenu.add(jMenuItem);
            }
        } else {
            ToHitData toHitData;
            Serializable serializable;
            JMenuItem jMenuItem = null;
            if (!(this.myEntity.isHullDown() || this.myEntity.isProne() || this.myEntity.hasHipCrit())) {
                jMenuItem = this.createKickJMenuItem();
                if (jMenuItem != null) {
                    jMenu.add(jMenuItem);
                }
                if ((jMenuItem = this.createTripJMenuItem()) != null) {
                    jMenu.add(jMenuItem);
                }
            }
            if (!(!(this.myEntity instanceof BipedMech) || this.myEntity.isLocationBad(5) && this.myEntity.isLocationBad(4) || (jMenuItem = this.createPunchJMenuItem()) == null)) {
                jMenu.add(jMenuItem);
            }
            if (this.myEntity instanceof BipedMech && !this.myEntity.isLocationBad(5) && !this.myEntity.isLocationBad(4) && (jMenuItem = this.createPushJMenuItem()) != null) {
                jMenu.add(jMenuItem);
            }
            if (this.myEntity.getJumpMP() > 0 && (jMenuItem = this.createJumpJetAttackJMenuItem()) != null) {
                jMenu.add(jMenuItem);
            }
            if (this.myEntity.isProne() && (jMenuItem = this.createThrashJMenuItem()) != null) {
                jMenu.add(jMenuItem);
            }
            if ((jMenuItem = this.createDodgeJMenuItem()) != null) {
                jMenu.add(jMenuItem);
            }
            if (this.myEntity.getClubs().size() > 0 && ((JMenu)(serializable = this.createClubMenu())).getItemCount() > 0) {
                jMenu.add((JMenuItem)serializable);
            }
            serializable = GrappleAttackAction.toHit(this.client.game, this.myEntity.getId(), this.myTarget);
            ToHitData toHitData2 = BreakGrappleAttackAction.toHit(this.client.game, this.myEntity.getId(), this.myTarget);
            if ((((TargetRoll)serializable).getValue() != Integer.MAX_VALUE || toHitData2.getValue() != Integer.MAX_VALUE) && (jMenuItem = this.createGrappleJMenuItem()) != null) {
                jMenu.add(jMenuItem);
            }
            if (this.myTarget != null && (toHitData = BAVibroClawAttackAction.toHit(this.client.game, this.myEntity.getId(), this.myTarget)).getValue() != Integer.MAX_VALUE && (jMenuItem = this.createVibroClawMenuItem()) != null) {
                jMenu.add(jMenuItem);
            }
        }
        return jMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    private JMenu createStandMenu() {
        JMenu jMenu = new JMenu();
        if (this.selectedEntity.isProne()) {
            jMenu.setText("Stand");
            jMenu.add(this.createStandJMenuItem(false));
            if (this.game.getOptions().booleanOption("tacops_careful_stand") && this.myEntity.getWalkMP() > 2 && this.myEntity.moved < 1) {
                jMenu.add(this.createStandJMenuItem(true));
            }
            if (this.game.getOptions().booleanOption("tacops_hull_down")) {
                jMenu.add(this.createHullDownJMenuItem());
            }
        } else if (this.selectedEntity.isHullDown()) {
            jMenu.setText("Stand");
            jMenu.add(this.createStandJMenuItem(false));
            if (this.game.getOptions().booleanOption("tacops_careful_stand")) {
                jMenu.add(this.createStandJMenuItem(true));
            }
            jMenu.add(this.createProneJMenuItem());
        } else {
            jMenu.setText("Prone");
            jMenu.add(this.createProneJMenuItem());
            if (this.game.getOptions().booleanOption("tacops_hull_down")) {
                jMenu.add(this.createHullDownJMenuItem());
            }
        }
        return jMenu;
    }

    private JMenuItem createStandJMenuItem(boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("MovementDisplay.butUp"));
        if (bl) {
            jMenuItem.setText("Careful Stand");
            jMenuItem.setActionCommand("moveCarefulStand");
        } else {
            jMenuItem.setActionCommand("moveGetUp");
        }
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenuItem createHullDownJMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("MovementDisplay.butHullDown"));
        jMenuItem.setActionCommand("moveHullDown");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenuItem createProneJMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("MovementDisplay.butDown"));
        jMenuItem.setActionCommand("moveGoProne");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenu createTargetMenu() {
        JMenu jMenu = new JMenu("Target");
        if (this.canTargetEntities()) {
            Object object = this.client.game.getEntities(this.coords);
            while (object.hasMoreElements()) {
                Entity entity = object.nextElement();
                jMenu.add(this.TargetMenuItem(entity));
            }
            if (this.currentPanel instanceof FiringDisplay || this.currentPanel instanceof PhysicalDisplay || this.currentPanel instanceof TargetingPhaseDisplay) {
                object = this.board.getHex(this.coords);
                if (object != null && this.currentPanel instanceof FiringDisplay && !this.board.inSpace() && !this.board.inAtmosphere()) {
                    jMenu.add(this.TargetMenuItem(new HexTarget(this.coords, this.board, 1)));
                    if (this.client.game.getOptions().booleanOption("tacops_start_fire") && (object.containsTerrain(1) || object.containsTerrain(5) || object.containsTerrain(9) || this.hasMunitionType(0x20000000L) || this.hasMunitionType(0x8000000000L) || this.hasMunitionType(0x1000000L))) {
                        jMenu.add(this.TargetMenuItem(new HexTarget(this.coords, this.board, 2)));
                    }
                }
                if (object != null && object.containsTerrain(29)) {
                    jMenu.add(this.TargetMenuItem(new BuildingTarget(this.coords, this.board, false)));
                    if (this.client.game.getOptions().booleanOption("tacops_start_fire")) {
                        jMenu.add(this.TargetMenuItem(new BuildingTarget(this.coords, this.board, true)));
                    }
                }
                if (object != null && object.containsTerrain(22)) {
                    jMenu.add(this.TargetMenuItem(new BuildingTarget(this.coords, this.board, false)));
                    if (this.client.game.getOptions().booleanOption("tacops_start_fire")) {
                        jMenu.add(this.TargetMenuItem(new BuildingTarget(this.coords, this.board, true)));
                    }
                }
                if (object != null && this.currentPanel instanceof FiringDisplay) {
                    if (this.board.inSpace() && this.hasAmmoType(62)) {
                        jMenu.add(this.TargetMenuItem(new HexTarget(this.coords, this.board, 17)));
                    } else {
                        if ((this.hasAmmoType(7) || this.hasAmmoType(45)) && (this.hasMunitionType(0x4000000000L) || this.hasMunitionType(0x400000L) || this.hasMunitionType(0x4000000L) || this.hasMunitionType(0x800000L) || this.hasMunitionType(0x1000000L) || this.hasMunitionType(0x2000000L))) {
                            jMenu.add(this.TargetMenuItem(new HexTarget(this.coords, this.board, 6)));
                        }
                        if (this.hasMunitionType(262144L)) {
                            jMenu.add(this.TargetMenuItem(new HexTarget(this.coords, this.board, 13)));
                        }
                        if (this.hasAmmoType(25)) {
                            jMenu.add(this.TargetMenuItem(new HexTarget(this.coords, this.board, 14)));
                        }
                        if (this.hasAmmoType(15) || this.hasAmmoType(17) || this.hasAmmoType(68) || this.hasAmmoType(63) || this.hasAmmoType(57) || this.hasAmmoType(16) || this.hasAmmoType(18)) {
                            jMenu.add(this.TargetMenuItem(new HexTarget(this.coords, this.board, 7)));
                        }
                        if (this.client.game.getOptions().booleanOption("tacops_start_fire") && object.containsTerrain(19) && this.hasFireExtinguisher()) {
                            jMenu.add(this.TargetMenuItem(new HexTarget(this.coords, this.board, 8)));
                        }
                    }
                }
                if (object != null && this.currentPanel instanceof TargetingPhaseDisplay && !this.board.inSpace() && !this.board.inAtmosphere() && (this.hasAmmoType(15) || this.hasAmmoType(17) || this.hasAmmoType(68) || this.hasAmmoType(63) || this.hasAmmoType(57) || this.hasAmmoType(16) || this.hasAmmoType(18))) {
                    jMenu.add(this.TargetMenuItem(new HexTarget(this.coords, this.board, 7)));
                }
            }
        }
        return jMenu;
    }

    private void plotCourse(ActionEvent actionEvent) {
        ((MovementDisplay)this.currentPanel).actionPerformed(actionEvent);
        ((BoardView1)this.gui.bv).mouseAction(this.coords, 3, 16);
        ((BoardView1)this.gui.bv).mouseAction(this.coords, 1, 16);
    }

    private Targetable decodeTargetInfo(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = stringTokenizer.nextToken();
        if (string2.equalsIgnoreCase("E")) {
            return this.game.getEntity(Integer.parseInt(stringTokenizer.nextToken()));
        }
        Coords coords = new Coords(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
        if (string2.equals("B")) {
            return new BuildingTarget(coords, this.board, Boolean.parseBoolean(stringTokenizer.nextToken()));
        }
        if (string2.equals("M")) {
            return new MinefieldTarget(coords, this.board);
        }
        return new HexTarget(coords, this.board, Integer.parseInt(stringTokenizer.nextToken()));
    }

    private boolean hasAmmoType(int n) {
        if (this.myEntity.getAmmo().size() < 1) {
            return false;
        }
        for (Mounted mounted : this.myEntity.getAmmo()) {
            if (((AmmoType)mounted.getType()).getAmmoType() != n) continue;
            return true;
        }
        return false;
    }

    private boolean hasMunitionType(long l) {
        if (this.myEntity.getAmmo().size() < 1) {
            return false;
        }
        for (Mounted mounted : this.myEntity.getAmmo()) {
            if (((AmmoType)mounted.getType()).getMunitionType() != l) continue;
            return true;
        }
        return false;
    }

    private boolean hasFireExtinguisher() {
        if (this.myEntity.getWeaponList().size() < 1) {
            return false;
        }
        for (Mounted mounted : this.myEntity.getWeaponList()) {
            if (!((WeaponType)mounted.getType() instanceof ISFireExtinguisher) && !((WeaponType)mounted.getType() instanceof CLFireExtinguisher)) continue;
            return true;
        }
        return false;
    }

    private JMenuItem createTorsoTwistJMenuItem(int n) {
        JMenuItem jMenuItem = new JMenuItem();
        if (n == 1) {
            jMenuItem.setText("Right");
        } else {
            jMenuItem.setText("Left");
        }
        jMenuItem.setActionCommand(Integer.toString(n));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.parseInt(actionEvent.getActionCommand());
                    ((FiringDisplay)MapMenu.this.currentPanel).torsoTwist(n);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenuItem createTorsoTwistJMenuItem(Coords coords) {
        JMenuItem jMenuItem = new JMenuItem("Twist");
        jMenuItem.setActionCommand(coords.x + "|" + coords.y);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(actionEvent.getActionCommand(), "|");
                    Coords coords = new Coords(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                    ((FiringDisplay)MapMenu.this.currentPanel).torsoTwist(coords);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenu createTorsoTwistMenu() {
        JMenu jMenu = new JMenu();
        if (this.myEntity instanceof BipedMech) {
            jMenu.setText("Torso Twist");
            if (this.coords.equals(this.myEntity.getPosition())) {
                jMenu.add(this.createTorsoTwistJMenuItem(1));
                jMenu.add(this.createTorsoTwistJMenuItem(0));
            } else {
                jMenu.add(this.createTorsoTwistJMenuItem(this.coords));
            }
        } else if (this.myEntity instanceof Tank && ((Tank)this.myEntity).getInternal(5) > -1) {
            jMenu.setText("Turret Twist");
            if (this.coords.equals(this.myEntity.getPosition())) {
                jMenu.add(this.createTorsoTwistJMenuItem(1));
                jMenu.add(this.createTorsoTwistJMenuItem(0));
            } else {
                jMenu.add(this.createTorsoTwistJMenuItem(this.coords));
            }
        }
        return jMenu;
    }

    private void selectTarget() {
        Vector<Entity> vector = new Vector<Entity>();
        for (Entity entity : this.game.getEntitiesVector(this.coords)) {
            if (!entity.isEnemyOf(this.myEntity) && (!this.game.getOptions().booleanOption("friendly_fire") || entity.equals(this.myEntity))) continue;
            vector.add(entity);
        }
        if (vector.size() == 1) {
            this.selectedEntity = (Entity)vector.firstElement();
            this.myTarget = this.selectedEntity;
            if (this.currentPanel instanceof FiringDisplay) {
                FiringDisplay firingDisplay = (FiringDisplay)this.currentPanel;
                firingDisplay.target(this.myTarget);
            } else if (this.currentPanel instanceof PhysicalDisplay) {
                ((PhysicalDisplay)this.currentPanel).target(this.myTarget);
            } else if (this.currentPanel instanceof TargetingPhaseDisplay) {
                ((TargetingPhaseDisplay)this.currentPanel).target(this.myTarget);
            }
        }
    }

    private JMenu createModeMenu() {
        JMenu jMenu = new JMenu("Modes");
        int n = this.gui.mechD.wPan.getSelectedWeaponNum();
        Mounted mounted = this.myEntity.getEquipment(n);
        if (mounted != null && mounted.getType().hasModes()) {
            for (int i = 0; i < mounted.getType().getModesCount(); ++i) {
                jMenu.add(this.createModeJMenuItem(mounted, i));
            }
        }
        return jMenu;
    }

    private JMenuItem createModeJMenuItem(Mounted mounted, int n) {
        JMenuItem jMenuItem = new JMenuItem();
        EquipmentMode equipmentMode = mounted.getType().getMode(n);
        if (equipmentMode.equals(mounted.curMode())) {
            jMenuItem.setText("* " + equipmentMode.getDisplayableName());
        } else {
            jMenuItem.setText(equipmentMode.getDisplayableName());
        }
        jMenuItem.setActionCommand(Integer.toString(n));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.parseInt(actionEvent.getActionCommand());
                    int n2 = ((MapMenu)MapMenu.this).gui.mechD.wPan.getSelectedWeaponNum();
                    Mounted mounted = MapMenu.this.myEntity.getEquipment(n2);
                    mounted.setMode(n);
                    MapMenu.this.client.sendModeChange(MapMenu.this.myEntity.getId(), n2, n);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenuItem createPunchJMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Punch");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).punch();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenuItem createKickJMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Kick");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).kick();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenuItem createPushJMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Push");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).push();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenuItem createVibroClawMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Vibro Claw Attack");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).vibroclawatt();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenuItem createJumpJetAttackJMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Jump Jet Attack");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).jumpjetatt();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenuItem createThrashJMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Thrash");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).thrash();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenuItem createGrappleJMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Grapple");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).doGrapple();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenuItem createTripJMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Trip");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).trip();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenuItem createDodgeJMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Dodge");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).dodge();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    private JMenu createClubMenu() {
        JMenu jMenu = new JMenu("Weapon");
        for (int i = 0; i < this.myEntity.getClubs().size(); ++i) {
            Mounted mounted = this.myEntity.getClubs().get(i);
            if (mounted.isDestroyed()) continue;
            jMenu.add(this.createClubJMenuItem(mounted.getName(), i));
        }
        return jMenu;
    }

    private JMenuItem createClubJMenuItem(String string, int n) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(Integer.toString(n));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Mounted mounted = MapMenu.this.myEntity.getClubs().get(Integer.parseInt(actionEvent.getActionCommand()));
                    ((PhysicalDisplay)MapMenu.this.currentPanel).club(mounted);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return jMenuItem;
    }

    public void show(Component component, int n, int n2) {
        if (this.client.isMyTurn() && this.myEntity != null) {
            this.selectTarget();
        }
        super.show(component, n, n2);
    }

    public boolean getHasMenu() {
        return this.hasMenu;
    }
}

