/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Board;
import megamek.common.BuildingTarget;
import megamek.common.ClampMountMech;
import megamek.common.ClampMountTank;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Dropship;
import megamek.common.Entity;
import megamek.common.EntitySelector;
import megamek.common.Flare;
import megamek.common.GameReports;
import megamek.common.GameTurn;
import megamek.common.HexTarget;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.INarcPod;
import megamek.common.Infantry;
import megamek.common.Jumpship;
import megamek.common.Mech;
import megamek.common.Minefield;
import megamek.common.MinefieldTarget;
import megamek.common.Mounted;
import megamek.common.PilotingRollData;
import megamek.common.PlanetaryConditions;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.Report;
import megamek.common.SmallCraft;
import megamek.common.SpaceStation;
import megamek.common.TagInfo;
import megamek.common.Tank;
import megamek.common.Targetable;
import megamek.common.Team;
import megamek.common.TurnOrdered;
import megamek.common.UnitLocation;
import megamek.common.VTOL;
import megamek.common.Warship;
import megamek.common.actions.ArtilleryAttackAction;
import megamek.common.actions.AttackAction;
import megamek.common.actions.EntityAction;
import megamek.common.actions.LayMinefieldAction;
import megamek.common.event.GameBoardChangeEvent;
import megamek.common.event.GameBoardNewEvent;
import megamek.common.event.GameEndEvent;
import megamek.common.event.GameEntityChangeEvent;
import megamek.common.event.GameEntityNewEvent;
import megamek.common.event.GameEntityNewOffboardEvent;
import megamek.common.event.GameEntityRemoveEvent;
import megamek.common.event.GameEvent;
import megamek.common.event.GameListener;
import megamek.common.event.GameMapQueryEvent;
import megamek.common.event.GameNewActionEvent;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GamePlayerChangeEvent;
import megamek.common.event.GamePlayerChatEvent;
import megamek.common.event.GamePlayerConnectedEvent;
import megamek.common.event.GamePlayerDisconnectedEvent;
import megamek.common.event.GameReportEvent;
import megamek.common.event.GameSettingsChangeEvent;
import megamek.common.event.GameTurnChangeEvent;
import megamek.common.options.GameOptions;
import megamek.common.weapons.AttackHandler;
import megamek.debug.Assert;
import megamek.server.SmokeCloud;
import megamek.server.victory.SpaghettiVictoryFactory;
import megamek.server.victory.Victory;
import megamek.server.victory.VictoryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Game
implements Serializable,
IGame {
    private static final long serialVersionUID = 8376320092671792532L;
    private GameOptions options = new GameOptions();
    public IBoard board = new Board();
    private Vector<Entity> entities = new Vector();
    private Hashtable<Integer, Entity> entityIds = new Hashtable();
    Vector<Entity> vOutOfGame = new Vector();
    private Vector<Player> players = new Vector();
    private Vector<Team> teams = new Vector();
    private Hashtable<Integer, Player> playerIds = new Hashtable();
    private boolean deploymentComplete = false;
    private PlanetaryConditions planetaryConditions = new PlanetaryConditions();
    private int roundCount = 0;
    private Vector<GameTurn> turnVector = new Vector();
    private int turnIndex = 0;
    private IGame.Phase phase = IGame.Phase.PHASE_UNKNOWN;
    private IGame.Phase lastPhase = IGame.Phase.PHASE_UNKNOWN;
    private Vector<EntityAction> actions = new Vector();
    private Vector<AttackAction> pendingCharges = new Vector();
    private Vector<AttackAction> pendingRams = new Vector();
    private Vector<AttackAction> pendingTeleMissileAttacks = new Vector();
    private Vector<LayMinefieldAction> pendingLayMinefieldActions = new Vector();
    private Vector<PilotingRollData> pilotRolls = new Vector();
    private Vector<PilotingRollData> extremeGravityRolls = new Vector();
    private Vector<PilotingRollData> controlRolls = new Vector();
    private Vector<Team> initiativeRerollRequests = new Vector();
    private GameReports gameReports = new GameReports();
    private boolean forceVictory = false;
    private int victoryPlayerId = -1;
    private int victoryTeam = 0;
    private Hashtable<Integer, Vector<Entity>> deploymentTable = new Hashtable();
    private int lastDeploymentRound = 0;
    private Hashtable<Coords, Vector<Minefield>> minefields = new Hashtable();
    private Vector<Minefield> vibrabombs = new Vector();
    private Vector<AttackHandler> attacks = new Vector();
    private Vector<ArtilleryAttackAction> offboardArtilleryAttacks = new Vector();
    private int lastEntityId;
    private Vector<TagInfo> tagInfoForTurn = new Vector();
    private Vector<Flare> flares = new Vector();
    private HashMap<String, Object> victoryContext = null;
    private int externalGameId = 0;
    private Victory victory = null;
    private VictoryFactory vf = new SpaghettiVictoryFactory();
    private ArrayList<SmokeCloud> smokeCloudList = new ArrayList();
    private Vector<GameListener> gameListeners = new Vector();

    @Override
    public int getExternalGameId() {
        return this.externalGameId;
    }

    @Override
    public void setExternalGameId(int n) {
        this.externalGameId = n;
    }

    @Override
    public IBoard getBoard() {
        return this.board;
    }

    @Override
    public void setBoard(IBoard iBoard) {
        IBoard iBoard2 = this.board;
        this.board = iBoard;
        this.processGameEvent(new GameBoardNewEvent(this, iBoard2, iBoard));
    }

    @Override
    public boolean containsMinefield(Coords coords) {
        return this.minefields.containsKey(coords);
    }

    @Override
    public Vector<Minefield> getMinefields(Coords coords) {
        Vector<Minefield> vector = this.minefields.get(coords);
        if (vector == null) {
            return new Vector<Minefield>();
        }
        return vector;
    }

    @Override
    public int getNbrMinefields(Coords coords) {
        Vector<Minefield> vector = this.minefields.get(coords);
        if (vector == null) {
            return 0;
        }
        return vector.size();
    }

    @Override
    public Enumeration<Coords> getMinedCoords() {
        return this.minefields.keys();
    }

    @Override
    public void addMinefield(Minefield minefield) {
        this.addMinefieldHelper(minefield);
        this.processGameEvent(new GameBoardChangeEvent(this));
    }

    @Override
    public void addMinefields(Vector<Minefield> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Minefield minefield = vector.elementAt(i);
            this.addMinefieldHelper(minefield);
        }
        this.processGameEvent(new GameBoardChangeEvent(this));
    }

    @Override
    public void setMinefields(Vector<Minefield> vector) {
        this.clearMinefieldsHelper();
        for (int i = 0; i < vector.size(); ++i) {
            Minefield minefield = vector.elementAt(i);
            this.addMinefieldHelper(minefield);
        }
        this.processGameEvent(new GameBoardChangeEvent(this));
    }

    @Override
    public void resetMinefieldDensity(Vector<Minefield> vector) {
        if (vector.size() < 1) {
            return;
        }
        Vector<Minefield> vector2 = this.minefields.get(vector.firstElement().getCoords());
        vector2.clear();
        for (int i = 0; i < vector.size(); ++i) {
            Minefield minefield = vector.elementAt(i);
            this.addMinefieldHelper(minefield);
        }
        this.processGameEvent(new GameBoardChangeEvent(this));
    }

    protected void addMinefieldHelper(Minefield minefield) {
        Vector<Minefield> vector = this.minefields.get(minefield.getCoords());
        if (vector == null) {
            vector = new Vector();
            vector.addElement(minefield);
            this.minefields.put(minefield.getCoords(), vector);
            return;
        }
        vector.addElement(minefield);
    }

    @Override
    public void removeMinefield(Minefield minefield) {
        this.removeMinefieldHelper(minefield);
        this.processGameEvent(new GameBoardChangeEvent(this));
    }

    public void removeMinefieldHelper(Minefield minefield) {
        Vector<Minefield> vector = this.minefields.get(minefield.getCoords());
        if (vector == null) {
            return;
        }
        Enumeration<Minefield> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Minefield minefield2 = enumeration.nextElement();
            if (!minefield2.equals(minefield)) continue;
            vector.removeElement(minefield2);
            break;
        }
        if (vector.isEmpty()) {
            this.minefields.remove(minefield.getCoords());
        }
    }

    @Override
    public void clearMinefields() {
        this.clearMinefieldsHelper();
        this.processGameEvent(new GameBoardChangeEvent(this));
    }

    protected void clearMinefieldsHelper() {
        this.minefields.clear();
    }

    @Override
    public Vector<Minefield> getVibrabombs() {
        return this.vibrabombs;
    }

    @Override
    public void addVibrabomb(Minefield minefield) {
        this.vibrabombs.addElement(minefield);
    }

    @Override
    public void removeVibrabomb(Minefield minefield) {
        this.vibrabombs.removeElement(minefield);
    }

    @Override
    public boolean containsVibrabomb(Minefield minefield) {
        return this.vibrabombs.contains(minefield);
    }

    @Override
    public GameOptions getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(GameOptions gameOptions) {
        if (null == gameOptions) {
            System.err.println("Can't set the game options to null!");
        } else {
            this.options = gameOptions;
            this.processGameEvent(new GameSettingsChangeEvent(this));
        }
    }

    @Override
    public Enumeration<Team> getTeams() {
        return this.teams.elements();
    }

    @Override
    public int getNoOfTeams() {
        return this.teams.size();
    }

    @Override
    public Vector<Team> getTeamsVector() {
        return (Vector)this.teams.clone();
    }

    @Override
    public Team getTeamForPlayer(Player player) {
        Enumeration<Team> enumeration = this.teams.elements();
        while (enumeration.hasMoreElements()) {
            Team team = enumeration.nextElement();
            Enumeration<Player> enumeration2 = team.getPlayers();
            while (enumeration2.hasMoreElements()) {
                Player player2 = enumeration2.nextElement();
                if (player != player2) continue;
                return team;
            }
        }
        return null;
    }

    @Override
    public void setupTeams() {
        Object object;
        TurnOrdered turnOrdered;
        Vector<Object> vector = new Vector<Object>();
        boolean bl = this.getOptions().getOption("team_initiative").booleanValue();
        Enumeration<Player> enumeration = this.getPlayers();
        while (enumeration.hasMoreElements()) {
            turnOrdered = enumeration.nextElement();
            if (bl && turnOrdered.getTeam() != 0) continue;
            object = new Team(0);
            ((Team)object).addPlayer((Player)turnOrdered);
            vector.addElement(object);
        }
        if (bl) {
            for (int i = 1; i < Player.MAX_TEAMS; ++i) {
                turnOrdered = null;
                object = this.getPlayers();
                while (object.hasMoreElements()) {
                    Player player = (Player)object.nextElement();
                    if (player.getTeam() != i) continue;
                    if (turnOrdered == null) {
                        turnOrdered = new Team(i);
                    }
                    ((Team)turnOrdered).addPlayer(player);
                }
                if (turnOrdered == null) continue;
                vector.addElement(turnOrdered);
            }
        }
        this.teams = vector;
    }

    @Override
    public Enumeration<Player> getPlayers() {
        return this.players.elements();
    }

    @Override
    public Vector<Player> getPlayersVector() {
        return this.players;
    }

    @Override
    public int getNoOfPlayers() {
        return this.players.size();
    }

    @Override
    public Player getPlayer(int n) {
        if (-1 == n) {
            return null;
        }
        return this.playerIds.get(new Integer(n));
    }

    @Override
    public void addPlayer(int n, Player player) {
        player.setGame(this);
        this.players.addElement(player);
        this.playerIds.put(new Integer(n), player);
        this.updatePlayer(player);
    }

    @Override
    public void setPlayer(int n, Player player) {
        Player player2 = this.getPlayer(n);
        player.setGame(this);
        this.players.setElementAt(player, this.players.indexOf(player2));
        this.playerIds.put(new Integer(n), player);
        this.updatePlayer(player);
    }

    protected void updatePlayer(Player player) {
        this.processGameEvent(new GamePlayerChangeEvent((Object)this, player));
    }

    @Override
    public void removePlayer(int n) {
        Player player = this.getPlayer(n);
        this.players.removeElement(player);
        this.playerIds.remove(new Integer(n));
        this.processGameEvent(new GamePlayerChangeEvent((Object)this, player));
    }

    @Override
    public int getEntitiesOwnedBy(Player player) {
        int n = 0;
        Enumeration<Entity> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!entity.getOwner().equals(player)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getAllEntitiesOwnedBy(Player player) {
        Entity entity;
        int n = 0;
        Enumeration<Entity> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            entity = enumeration.nextElement();
            if (!entity.getOwner().equals(player)) continue;
            ++n;
        }
        enumeration = this.vOutOfGame.elements();
        while (enumeration.hasMoreElements()) {
            entity = enumeration.nextElement();
            if (!entity.getOwner().equals(player)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getLiveEntitiesOwnedBy(Player player) {
        int n = 0;
        Enumeration<Entity> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!entity.getOwner().equals(player) || entity.isDestroyed()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getLiveDeployedEntitiesOwnedBy(Player player) {
        int n = 0;
        Enumeration<Entity> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!entity.getOwner().equals(player) || entity.isDestroyed() || !entity.isDeployed() || entity.isOffBoard() || entity.isCaptured()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getLiveCommandersOwnedBy(Player player) {
        int n = 0;
        Enumeration<Entity> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!entity.getOwner().equals(player) || entity.isDestroyed() || !entity.isCommander() || entity.isOffBoard() || entity.isCaptured()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean hasTacticalGenius(Player player) {
        Enumeration<Entity> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!entity.getCrew().getOptions().booleanOption("tactical_genius") || !entity.getOwner().equals(player) || entity.isDestroyed() || !entity.isDeployed() || entity.getCrew().isUnconscious()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Vector<Entity> getValidTargets(Entity entity) {
        Vector<Entity> vector = new Vector<Entity>();
        boolean bl = this.getOptions().booleanOption("friendly_fire");
        Enumeration<Entity> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity2 = enumeration.nextElement();
            if (entity2.getPosition() == null || entity2.isOffBoard() || !entity.isEnemyOf(entity2) && (!bl || entity.getId() == entity2.getId())) continue;
            vector.addElement(entity2);
        }
        return vector;
    }

    @Override
    public boolean phaseHasTurns(IGame.Phase phase) {
        switch (phase) {
            case PHASE_SET_ARTYAUTOHITHEXES: 
            case PHASE_DEPLOY_MINEFIELDS: 
            case PHASE_DEPLOYMENT: 
            case PHASE_MOVEMENT: 
            case PHASE_FIRING: 
            case PHASE_PHYSICAL: 
            case PHASE_TARGETING: 
            case PHASE_OFFBOARD: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPhaseSimultaneous() {
        switch (this.phase) {
            case PHASE_DEPLOYMENT: 
            case PHASE_MOVEMENT: {
                return false;
            }
            case PHASE_FIRING: {
                return this.getOptions().booleanOption("simultaneous_firing");
            }
            case PHASE_PHYSICAL: {
                return this.getOptions().booleanOption("simultaneous_physical");
            }
            case PHASE_TARGETING: {
                return this.getOptions().booleanOption("simultaneous_targeting");
            }
        }
        return false;
    }

    @Override
    public GameTurn getTurn() {
        if (this.turnIndex < 0 || this.turnIndex >= this.turnVector.size()) {
            return null;
        }
        return this.turnVector.elementAt(this.turnIndex);
    }

    @Override
    public GameTurn getTurnForPlayer(int n) {
        for (int i = this.turnIndex; i < this.turnVector.size(); ++i) {
            GameTurn gameTurn = this.turnVector.get(i);
            if (!gameTurn.isValid(n, this)) continue;
            return gameTurn;
        }
        return null;
    }

    @Override
    public GameTurn changeToNextTurn() {
        ++this.turnIndex;
        return this.getTurn();
    }

    @Override
    public void resetTurnIndex() {
        this.turnIndex = -1;
    }

    @Override
    public boolean hasMoreTurns() {
        return this.turnVector.size() > this.turnIndex + 1;
    }

    @Override
    public void insertNextTurn(GameTurn gameTurn) {
        this.turnVector.insertElementAt(gameTurn, this.turnIndex + 1);
    }

    @Override
    public Enumeration<GameTurn> getTurns() {
        return this.turnVector.elements();
    }

    @Override
    public int getTurnIndex() {
        return this.turnIndex;
    }

    @Override
    public void setTurnIndex(int n) {
        this.turnIndex = n;
        this.processGameEvent(new GameTurnChangeEvent((Object)this, this.getPlayer(this.getTurn().getPlayerNum())));
    }

    @Override
    public Vector<GameTurn> getTurnVector() {
        return this.turnVector;
    }

    @Override
    public void setTurnVector(Vector<GameTurn> vector) {
        this.turnVector = vector;
    }

    @Override
    public IGame.Phase getPhase() {
        return this.phase;
    }

    @Override
    public void setPhase(IGame.Phase phase) {
        IGame.Phase phase2 = this.phase;
        this.phase = phase;
        switch (phase) {
            case PHASE_LOUNGE: {
                this.reset();
                break;
            }
            case PHASE_MOVEMENT: {
                this.resetActions();
                break;
            }
            case PHASE_FIRING: {
                this.resetActions();
                break;
            }
            case PHASE_PHYSICAL: {
                this.resetActions();
                break;
            }
            case PHASE_INITIATIVE: {
                this.resetActions();
                this.resetCharges();
                this.resetRams();
                this.resetLayMinefieldActions();
                break;
            }
            case PHASE_PHYSICAL_REPORT: 
            case PHASE_END: {
                this.resetCharges();
                this.resetRams();
                this.resetLayMinefieldActions();
            }
        }
        this.processGameEvent(new GamePhaseChangeEvent(this, phase2, phase));
    }

    @Override
    public IGame.Phase getLastPhase() {
        return this.lastPhase;
    }

    @Override
    public void setLastPhase(IGame.Phase phase) {
        this.lastPhase = phase;
    }

    @Override
    public void setDeploymentComplete(boolean bl) {
        this.deploymentComplete = bl;
    }

    @Override
    public boolean isDeploymentComplete() {
        return this.deploymentComplete;
    }

    @Override
    public void setupRoundDeployment() {
        this.deploymentTable = new Hashtable();
        for (int i = 0; i < this.entities.size(); ++i) {
            Entity entity = this.entities.elementAt(i);
            if (entity.isDeployed()) continue;
            Vector<Entity> vector = this.deploymentTable.get(new Integer(entity.getDeployRound()));
            if (null == vector) {
                vector = new Vector();
                this.deploymentTable.put(new Integer(entity.getDeployRound()), vector);
            }
            vector.addElement(entity);
            this.lastDeploymentRound = Math.max(this.lastDeploymentRound, entity.getDeployRound());
        }
    }

    @Override
    public void checkForCompleteDeployment() {
        this.setDeploymentComplete(this.lastDeploymentRound < this.getRoundCount());
    }

    @Override
    public boolean shouldDeployThisRound() {
        return this.shouldDeployForRound(this.getRoundCount());
    }

    @Override
    public boolean shouldDeployForRound(int n) {
        Vector<Entity> vector = this.getEntitiesToDeployForRound(n);
        return null != vector && vector.size() != 0;
    }

    private Vector<Entity> getEntitiesToDeployForRound(int n) {
        return this.deploymentTable.get(new Integer(n));
    }

    @Override
    public void clearDeploymentThisRound() {
        this.deploymentTable.remove(new Integer(this.getRoundCount()));
    }

    @Override
    public Vector<Entity> getUndeployedEntities() {
        Vector<Entity> vector = new Vector<Entity>();
        Enumeration<Vector<Entity>> enumeration = this.deploymentTable.elements();
        while (enumeration.hasMoreElements()) {
            Vector<Entity> vector2 = enumeration.nextElement();
            for (int i = 0; i < vector2.size(); ++i) {
                vector.addElement(vector2.elementAt(i));
            }
        }
        return vector;
    }

    @Override
    public Enumeration<Entity> getEntities() {
        return this.entities.elements();
    }

    @Override
    public Entity getPreviousEntityFromList(Entity entity) {
        if (entity != null && this.entities != null && this.entities.contains(entity)) {
            int n = this.entities.indexOf(entity) - 1;
            if (n < 0) {
                n = this.entities.size() - 1;
            }
            return this.entities.elementAt(n);
        }
        return null;
    }

    @Override
    public Entity getNextEntityFromList(Entity entity) {
        if (entity != null && this.entities != null && this.entities.contains(entity)) {
            int n = this.entities.indexOf(entity) + 1;
            if (n >= this.entities.size()) {
                n = 0;
            }
            return this.entities.elementAt(n);
        }
        return null;
    }

    @Override
    public Vector<Entity> getEntitiesVector() {
        return this.entities;
    }

    @Override
    public void setEntitiesVector(Vector<Entity> vector) {
        this.entities = vector;
        this.reindexEntities();
        this.processGameEvent(new GameEntityNewEvent((Object)this, vector));
    }

    @Override
    public Vector<Entity> getOutOfGameEntitiesVector() {
        return this.vOutOfGame;
    }

    @Override
    public void setOutOfGameEntitiesVector(Vector<Entity> vector) {
        Assert.assertTrue(vector != null, "New out-of-game list should not be null.");
        if (vector != null) {
            Vector<Entity> vector2 = new Vector<Entity>();
            Enumeration<Entity> enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Entity entity = enumeration.nextElement();
                int n = entity.getOwnerId();
                if (n == -1 || this.getPlayer(n) == null) continue;
                entity.setGame(this);
                vector2.addElement(entity);
            }
            this.vOutOfGame = vector2;
            this.processGameEvent(new GameEntityNewOffboardEvent(this));
        }
    }

    @Override
    public Entity getOutOfGameEntity(int n) {
        Entity entity = null;
        Enumeration<Entity> enumeration = this.vOutOfGame.elements();
        while (null == entity && enumeration.hasMoreElements()) {
            Entity entity2 = enumeration.nextElement();
            if (n != entity2.getId()) continue;
            entity = entity2;
        }
        return entity;
    }

    @Override
    public Vector<Entity> getC3NetworkMembers(Entity entity) {
        Vector<Entity> vector = new Vector<Entity>();
        if (entity != null && (entity.hasC3() || entity.hasC3i())) {
            Enumeration<Entity> enumeration = this.entities.elements();
            while (enumeration.hasMoreElements()) {
                Entity entity2 = enumeration.nextElement();
                if (!entity.equals(entity2) && !entity.onSameC3NetworkAs(entity2)) continue;
                vector.addElement(entity2);
            }
        }
        return vector;
    }

    @Override
    public Vector<Entity> getC3SubNetworkMembers(Entity entity) {
        if (entity == null || entity.hasC3i() || entity.C3MasterIs(entity)) {
            return this.getC3NetworkMembers(entity);
        }
        Vector<Entity> vector = new Vector<Entity>();
        if (entity.hasC3()) {
            Enumeration<Entity> enumeration = this.entities.elements();
            while (enumeration.hasMoreElements()) {
                Entity entity2 = enumeration.nextElement();
                if (!entity.equals(entity2) && !entity2.C3MasterIs(entity)) continue;
                vector.addElement(entity2);
            }
        }
        return vector;
    }

    @Override
    public Hashtable<Coords, Vector<Entity>> getPositionMap() {
        Hashtable<Coords, Vector<Entity>> hashtable = new Hashtable<Coords, Vector<Entity>>();
        Vector<Entity> vector = null;
        Enumeration<Entity> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            Coords coords = entity.getPosition();
            if (coords == null) continue;
            vector = hashtable.get(coords);
            if (vector == null) {
                vector = new Vector();
                hashtable.put(coords, vector);
            }
            vector.addElement(entity);
        }
        return hashtable;
    }

    @Override
    public Enumeration<Entity> getGraveyardEntities() {
        Vector<Entity> vector = new Vector<Entity>();
        Enumeration<Entity> enumeration = this.vOutOfGame.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (entity.getRemovalCondition() != 512 && entity.getRemovalCondition() != 528) continue;
            vector.addElement(entity);
        }
        return vector.elements();
    }

    @Override
    public Enumeration<Entity> getWreckedEntities() {
        Vector<Entity> vector = new Vector<Entity>();
        Enumeration<Entity> enumeration = this.vOutOfGame.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (entity.getRemovalCondition() != 512 && entity.getRemovalCondition() != 528 && entity.getRemovalCondition() != 1024) continue;
            vector.addElement(entity);
        }
        return vector.elements();
    }

    @Override
    public Enumeration<Entity> getRetreatedEntities() {
        Vector<Entity> vector = new Vector<Entity>();
        Enumeration<Entity> enumeration = this.vOutOfGame.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (entity.getRemovalCondition() != 256 && entity.getRemovalCondition() != 288 && entity.getRemovalCondition() != 272) continue;
            vector.addElement(entity);
        }
        return vector.elements();
    }

    @Override
    public Enumeration<Entity> getDevastatedEntities() {
        Vector<Entity> vector = new Vector<Entity>();
        Enumeration<Entity> enumeration = this.vOutOfGame.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (entity.getRemovalCondition() != 1024) continue;
            vector.addElement(entity);
        }
        return vector.elements();
    }

    @Override
    public int getNoOfEntities() {
        return this.entities.size();
    }

    @Override
    public Targetable getTarget(int n, int n2) {
        try {
            switch (n) {
                case 0: {
                    return this.getEntity(n2);
                }
                case 1: 
                case 2: 
                case 6: 
                case 7: 
                case 8: 
                case 13: 
                case 14: 
                case 17: {
                    return new HexTarget(HexTarget.idToCoords(n2), this.board, n);
                }
                case 3: 
                case 4: 
                case 15: 
                case 16: {
                    return new BuildingTarget(BuildingTarget.idToCoords(n2), this.board, n);
                }
                case 5: {
                    return new MinefieldTarget(MinefieldTarget.idToCoords(n2), this.board);
                }
                case 11: {
                    return INarcPod.idToInstance(n2);
                }
            }
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    public Entity getEntity(int n) {
        return this.entityIds.get(new Integer(n));
    }

    @Override
    public void addEntity(int n, Entity entity) {
        entity.setGame(this);
        entity.setGameOptions();
        this.entities.addElement(entity);
        this.entityIds.put(new Integer(n), entity);
        if (n > this.lastEntityId) {
            this.lastEntityId = n;
        }
        Assert.assertTrue(this.entities.size() == this.entityIds.size());
        this.processGameEvent(new GameEntityNewEvent((Object)this, entity));
    }

    @Override
    public void setEntity(int n, Entity entity) {
        this.setEntity(n, entity, null);
        Assert.assertTrue(this.entities.size() == this.entityIds.size());
    }

    @Override
    public void setEntity(int n, Entity entity, Vector<UnitLocation> vector) {
        Entity entity2 = this.getEntity(n);
        if (entity2 == null) {
            this.addEntity(n, entity);
        } else {
            entity.setGame(this);
            this.entities.setElementAt(entity, this.entities.indexOf(entity2));
            this.entityIds.put(new Integer(n), entity);
            if (n > this.lastEntityId) {
                this.lastEntityId = n;
            }
            this.processGameEvent(new GameEntityChangeEvent((Object)this, entity, vector));
        }
        Assert.assertTrue(this.entities.size() == this.entityIds.size());
    }

    @Override
    public int getNextEntityId() {
        return this.lastEntityId + 1;
    }

    @Override
    public boolean hasEntity(int n) {
        return this.entityIds.containsKey(new Integer(n));
    }

    @Override
    public void removeEntity(int n, int n2) {
        Entity entity = this.getEntity(n);
        if (entity == null) {
            return;
        }
        this.entities.removeElement(entity);
        this.entityIds.remove(new Integer(n));
        entity.setRemovalCondition(n2);
        if (this.vOutOfGame != null && n2 != 2048) {
            this.vOutOfGame.addElement(entity);
        }
        if (this.deploymentTable.size() > 0) {
            Enumeration<Vector<Entity>> enumeration = this.deploymentTable.elements();
            while (enumeration.hasMoreElements()) {
                Vector<Entity> vector = enumeration.nextElement();
                for (int i = vector.size() - 1; i >= 0; --i) {
                    Entity entity2 = vector.elementAt(i);
                    if (entity2.getId() != n) continue;
                    vector.removeElementAt(i);
                }
            }
        }
        this.processGameEvent(new GameEntityRemoveEvent((Object)this, entity));
    }

    @Override
    public void reset() {
        this.roundCount = 0;
        this.entities.removeAllElements();
        this.entityIds.clear();
        this.vOutOfGame.removeAllElements();
        this.resetActions();
        this.resetCharges();
        this.resetRams();
        this.resetPSRs();
        this.resetArtilleryAttacks();
        this.resetAttacks();
        this.removeMinefields();
        this.removeArtyAutoHitHexes();
        this.resetLayMinefieldActions();
        this.flares.removeAllElements();
        this.clearAllReports();
        this.smokeCloudList.clear();
        this.forceVictory = false;
        this.victoryPlayerId = -1;
        this.victoryTeam = 0;
    }

    private void removeArtyAutoHitHexes() {
        Enumeration<Player> enumeration = this.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            player.removeArtyAutoHitHexes();
        }
    }

    private void removeMinefields() {
        this.minefields.clear();
        this.vibrabombs.removeAllElements();
        Enumeration<Player> enumeration = this.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            player.removeMinefields();
        }
    }

    private void reindexEntities() {
        this.entityIds.clear();
        this.lastEntityId = 0;
        if (this.entities != null) {
            Enumeration<Entity> enumeration = this.entities.elements();
            while (enumeration.hasMoreElements()) {
                Entity entity = enumeration.nextElement();
                int n = entity.getId();
                this.entityIds.put(new Integer(n), entity);
                entity.setGame(this);
                if (n <= this.lastEntityId) continue;
                this.lastEntityId = n;
            }
        }
    }

    @Override
    public Entity getFirstEntity(Coords coords) {
        Enumeration<Entity> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!coords.equals(entity.getPosition()) || !entity.isTargetable()) continue;
            return entity;
        }
        return null;
    }

    @Override
    public Entity getFirstEnemyEntity(Coords coords, Entity entity) {
        Enumeration<Entity> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity2 = enumeration.nextElement();
            if (!coords.equals(entity2.getPosition()) || !entity2.isTargetable() || !entity2.isEnemyOf(entity)) continue;
            return entity2;
        }
        return null;
    }

    @Override
    public Enumeration<Entity> getEntities(Coords coords) {
        Vector<Entity> vector = new Vector<Entity>();
        if (this.board.contains(coords)) {
            Enumeration<Entity> enumeration = this.entities.elements();
            while (enumeration.hasMoreElements()) {
                Entity entity = enumeration.nextElement();
                if (!coords.equals(entity.getPosition()) || !entity.isTargetable()) continue;
                vector.addElement(entity);
            }
        }
        return vector.elements();
    }

    @Override
    public Vector<Entity> getEntitiesVector(Coords coords) {
        Vector<Entity> vector = new Vector<Entity>();
        if (this.board.contains(coords)) {
            Enumeration<Entity> enumeration = this.entities.elements();
            while (enumeration.hasMoreElements()) {
                Entity entity = enumeration.nextElement();
                if (!coords.equals(entity.getPosition()) || !entity.isTargetable()) continue;
                vector.addElement(entity);
            }
        }
        return vector;
    }

    @Override
    public Entity getAffaTarget(Coords coords, Entity entity) {
        Vector<Entity> vector = new Vector<Entity>();
        if (this.board.contains(coords)) {
            Enumeration<Entity> enumeration = this.entities.elements();
            while (enumeration.hasMoreElements()) {
                Entity entity2 = enumeration.nextElement();
                if (!coords.equals(entity2.getPosition()) || !entity2.isTargetable() || entity2 instanceof Infantry || entity2 == entity) continue;
                vector.addElement(entity2);
            }
        }
        if (!vector.isEmpty()) {
            int n = vector.size();
            int n2 = Compute.randomInt(n);
            return (Entity)vector.elementAt(n2);
        }
        return null;
    }

    @Override
    public Enumeration<Entity> getEnemyEntities(final Coords coords, final Entity entity) {
        return this.getSelectedEntities(new EntitySelector(){
            private Coords coords;
            private Entity friendly;
            {
                this.coords = coords;
                this.friendly = entity;
            }

            public boolean accept(Entity entity2) {
                return this.coords.equals(entity2.getPosition()) && entity2.isTargetable() && entity2.isEnemyOf(this.friendly);
            }
        });
    }

    @Override
    public Enumeration<Entity> getFriendlyEntities(final Coords coords, final Entity entity) {
        return this.getSelectedEntities(new EntitySelector(){
            private Coords coords;
            private Entity friendly;
            {
                this.coords = coords;
                this.friendly = entity;
            }

            public boolean accept(Entity entity2) {
                return this.coords.equals(entity2.getPosition()) && entity2.isTargetable() && !entity2.isEnemyOf(this.friendly);
            }
        });
    }

    @Override
    public void moveToGraveyard(int n) {
        this.removeEntity(n, 512);
    }

    @Override
    public boolean isOutOfGame(int n) {
        Enumeration<Entity> enumeration = this.vOutOfGame.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (entity.getId() != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOutOfGame(Entity entity) {
        return this.isOutOfGame(entity.getId());
    }

    @Override
    public Entity getFirstEntity() {
        return this.getFirstEntity(this.getTurn());
    }

    @Override
    public Entity getFirstEntity(GameTurn gameTurn) {
        return this.getEntity(this.getFirstEntityNum(gameTurn));
    }

    @Override
    public int getFirstEntityNum() {
        return this.getFirstEntityNum(this.getTurn());
    }

    @Override
    public int getFirstEntityNum(GameTurn gameTurn) {
        if (gameTurn == null) {
            return -1;
        }
        Enumeration<Entity> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!gameTurn.isValidEntity(entity, this)) continue;
            return entity.getId();
        }
        return -1;
    }

    @Override
    public Entity getNextEntity(int n) {
        return this.getEntity(this.getNextEntityNum(this.getTurn(), n));
    }

    @Override
    public int getNextEntityNum(int n) {
        return this.getNextEntityNum(this.getTurn(), n);
    }

    @Override
    public int getNextEntityNum(GameTurn gameTurn, int n) {
        boolean bl = false;
        Enumeration<Entity> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (entity.getId() == n) {
                bl = true;
                continue;
            }
            if (!bl || !gameTurn.isValidEntity(entity, this)) continue;
            return entity.getId();
        }
        return this.getFirstEntityNum(gameTurn);
    }

    @Override
    public int getFirstDeployableEntityNum() {
        return this.getFirstDeployableEntityNum(this.getTurn());
    }

    @Override
    public int getFirstDeployableEntityNum(GameTurn gameTurn) {
        if (gameTurn == null) {
            return -1;
        }
        Enumeration<Entity> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!gameTurn.isValidEntity(entity, this) || !entity.shouldDeploy(this.getRoundCount())) continue;
            return entity.getId();
        }
        return -1;
    }

    @Override
    public int getNextDeployableEntityNum(int n) {
        return this.getNextDeployableEntityNum(this.getTurn(), n);
    }

    @Override
    public int getNextDeployableEntityNum(GameTurn gameTurn, int n) {
        boolean bl = false;
        Enumeration<Entity> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (entity.getId() == n) {
                bl = true;
                continue;
            }
            if (!bl || !gameTurn.isValidEntity(entity, this) || !entity.shouldDeploy(this.getRoundCount())) continue;
            return entity.getId();
        }
        return this.getFirstDeployableEntityNum(gameTurn);
    }

    @Override
    public ArrayList<Entity> getPlayerEntities(Player player) {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        Enumeration<Entity> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!player.equals(entity.getOwner())) continue;
            arrayList.add(entity);
        }
        return arrayList;
    }

    @Override
    public boolean isEntityStranded(Entity entity) {
        int n = entity.getTransportId();
        Entity entity2 = this.getEntity(n);
        return -1 != n && null != entity2 && (entity2.isImmobile() || 0 == entity2.getWalkMP());
    }

    @Override
    public int getInfantryLeft(int n) {
        Player player = this.getPlayer(n);
        int n2 = 0;
        Enumeration<Entity> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!player.equals(entity.getOwner()) || !entity.isSelectableThisTurn() || !(entity instanceof Infantry)) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public int getProtomechsLeft(int n) {
        Player player = this.getPlayer(n);
        int n2 = 0;
        Enumeration<Entity> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!player.equals(entity.getOwner()) || !entity.isSelectableThisTurn() || !(entity instanceof Protomech)) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public int getVehiclesLeft(int n) {
        Player player = this.getPlayer(n);
        int n2 = 0;
        Enumeration<Entity> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!player.equals(entity.getOwner()) || !entity.isSelectableThisTurn() || !(entity instanceof Tank)) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public GameTurn removeFirstTurnFor(Entity entity) {
        assert (this.phase != IGame.Phase.PHASE_MOVEMENT);
        for (int i = this.turnIndex; i < this.turnVector.size(); ++i) {
            GameTurn gameTurn = this.turnVector.elementAt(i);
            if (!gameTurn.isValidEntity(entity, this)) continue;
            this.turnVector.removeElementAt(i);
            return gameTurn;
        }
        return null;
    }

    @Override
    public void removeTurnFor(Entity entity) {
        if (this.getOptions().booleanOption("inf_move_multi") && entity instanceof Infantry && this.phase == IGame.Phase.PHASE_MOVEMENT && this.getInfantryLeft(entity.getOwnerId()) % this.getOptions().intOption("inf_proto_move_multi") != 1) {
            GameTurn.EntityClassTurn entityClassTurn;
            GameTurn gameTurn;
            if (this.hasMoreTurns() && (gameTurn = this.turnVector.elementAt(this.turnIndex + 1)) instanceof GameTurn.EntityClassTurn && (entityClassTurn = (GameTurn.EntityClassTurn)gameTurn).isValidClass(1) && !entityClassTurn.isValidClass(-2)) {
                this.turnVector.removeElementAt(this.turnIndex + 1);
            }
            return;
        }
        if (this.getOptions().booleanOption("protos_move_multi") && entity instanceof Protomech && this.phase == IGame.Phase.PHASE_MOVEMENT && this.getProtomechsLeft(entity.getOwnerId()) % this.getOptions().intOption("inf_proto_move_multi") != 1) {
            GameTurn.EntityClassTurn entityClassTurn;
            GameTurn gameTurn;
            if (this.hasMoreTurns() && (gameTurn = this.turnVector.elementAt(this.turnIndex + 1)) instanceof GameTurn.EntityClassTurn && (entityClassTurn = (GameTurn.EntityClassTurn)gameTurn).isValidClass(2) && !entityClassTurn.isValidClass(-3)) {
                this.turnVector.removeElementAt(this.turnIndex + 1);
            }
            return;
        }
        if (this.getOptions().booleanOption("vehicle_lance_movement") && entity instanceof Tank && this.phase == IGame.Phase.PHASE_MOVEMENT && this.getProtomechsLeft(entity.getOwnerId()) % this.getOptions().intOption("vehicle_lance_movement_number") != 1) {
            GameTurn.EntityClassTurn entityClassTurn;
            GameTurn gameTurn;
            if (this.hasMoreTurns() && (gameTurn = this.turnVector.elementAt(this.turnIndex + 1)) instanceof GameTurn.EntityClassTurn && (entityClassTurn = (GameTurn.EntityClassTurn)gameTurn).isValidClass(4) && !entityClassTurn.isValidClass(-5)) {
                this.turnVector.removeElementAt(this.turnIndex + 1);
            }
            return;
        }
        for (int i = this.turnVector.size() - 1; i >= this.turnIndex; --i) {
            GameTurn gameTurn = this.turnVector.elementAt(i);
            if (!gameTurn.isValidEntity(entity, this)) continue;
            this.turnVector.removeElementAt(i);
            break;
        }
    }

    @Override
    public boolean checkForMagneticClamp() {
        Player player = null;
        Entity entity = null;
        Hashtable<Player, Boolean> hashtable = null;
        String string = null;
        boolean bl = false;
        hashtable = new Hashtable<Player, Boolean>(this.getNoOfPlayers());
        Enumeration<Entity> enumeration = this.entities.elements();
        block0: while (enumeration.hasMoreElements()) {
            entity = enumeration.nextElement();
            if (!(entity instanceof BattleArmor)) continue;
            for (Mounted mounted : entity.getMisc()) {
                string = mounted.getType().getInternalName();
                if (!"BA-Magnetic Clamp".equals(string)) continue;
                bl = true;
                hashtable.put(entity.getOwner(), Boolean.TRUE);
                continue block0;
            }
        }
        if (bl) {
            enumeration = this.entities.elements();
            while (enumeration.hasMoreElements()) {
                entity = enumeration.nextElement();
                player = entity.getOwner();
                if (!Boolean.TRUE.equals(hashtable.get(player))) continue;
                if (!entity.isOmni() && entity instanceof Mech) {
                    entity.addTransporter(new ClampMountMech());
                    continue;
                }
                if (!(entity instanceof Tank) || entity instanceof VTOL) continue;
                entity.addTransporter(new ClampMountTank());
            }
        }
        return bl;
    }

    @Override
    public void addAction(EntityAction entityAction) {
        this.actions.addElement(entityAction);
        this.processGameEvent(new GameNewActionEvent((Object)this, entityAction));
    }

    @Override
    public void setArtilleryVector(Vector<ArtilleryAttackAction> vector) {
        this.offboardArtilleryAttacks = vector;
        this.processGameEvent(new GameBoardChangeEvent(this));
    }

    public void resetArtilleryAttacks() {
        this.offboardArtilleryAttacks.removeAllElements();
    }

    @Override
    public Enumeration<ArtilleryAttackAction> getArtilleryAttacks() {
        return this.offboardArtilleryAttacks.elements();
    }

    @Override
    public int getArtillerySize() {
        return this.offboardArtilleryAttacks.size();
    }

    @Override
    public Enumeration<EntityAction> getActions() {
        return this.actions.elements();
    }

    @Override
    public void resetActions() {
        this.actions.removeAllElements();
    }

    @Override
    public void removeActionsFor(int n) {
        Vector<EntityAction> vector = new Vector<EntityAction>(this.actions.size());
        Enumeration<EntityAction> enumeration = this.actions.elements();
        while (enumeration.hasMoreElements()) {
            EntityAction entityAction = enumeration.nextElement();
            if (entityAction.getEntityId() == n) continue;
            vector.addElement(entityAction);
        }
        this.actions = vector;
    }

    @Override
    public void removeAction(Object object) {
        this.actions.removeElement(object);
    }

    @Override
    public int actionsSize() {
        return this.actions.size();
    }

    @Override
    public Vector<EntityAction> getActionsVector() {
        return this.actions;
    }

    @Override
    public void addInitiativeRerollRequest(Team team) {
        this.initiativeRerollRequests.addElement(team);
    }

    @Override
    public void rollInitAndResolveTies() {
        if (this.getOptions().booleanOption("individual_initiative")) {
            Vector<Entity> vector = new Vector<Entity>();
            for (int i = 0; i < this.entities.size(); ++i) {
                Entity entity = this.entities.elementAt(i);
                if (!this.initiativeRerollRequests.contains(this.getTeamForPlayer(entity.getOwner()))) continue;
                vector.add(entity);
            }
            TurnOrdered.rollInitAndResolveTies(this.entities, vector);
        } else {
            TurnOrdered.rollInitAndResolveTies(this.teams, this.initiativeRerollRequests);
        }
        this.initiativeRerollRequests.removeAllElements();
    }

    @Override
    public int getNoOfInitiativeRerollRequests() {
        return this.initiativeRerollRequests.size();
    }

    @Override
    public void addCharge(AttackAction attackAction) {
        this.pendingCharges.addElement(attackAction);
        this.processGameEvent(new GameNewActionEvent((Object)this, attackAction));
    }

    @Override
    public Enumeration<AttackAction> getCharges() {
        return this.pendingCharges.elements();
    }

    @Override
    public void resetCharges() {
        this.pendingCharges.removeAllElements();
    }

    @Override
    public Vector<AttackAction> getChargesVector() {
        return this.pendingCharges;
    }

    @Override
    public void addRam(AttackAction attackAction) {
        this.pendingRams.addElement(attackAction);
        this.processGameEvent(new GameNewActionEvent((Object)this, attackAction));
    }

    @Override
    public Enumeration<AttackAction> getRams() {
        return this.pendingRams.elements();
    }

    @Override
    public void resetRams() {
        this.pendingRams.removeAllElements();
    }

    @Override
    public Vector<AttackAction> getRamsVector() {
        return this.pendingRams;
    }

    @Override
    public void addTeleMissileAttack(AttackAction attackAction) {
        this.pendingTeleMissileAttacks.addElement(attackAction);
        this.processGameEvent(new GameNewActionEvent((Object)this, attackAction));
    }

    @Override
    public Enumeration<AttackAction> getTeleMissileAttacks() {
        return this.pendingTeleMissileAttacks.elements();
    }

    @Override
    public void resetTeleMissileAttacks() {
        this.pendingTeleMissileAttacks.removeAllElements();
    }

    @Override
    public Vector<AttackAction> getTeleMissileAttacksVector() {
        return this.pendingTeleMissileAttacks;
    }

    @Override
    public void addLayMinefieldAction(LayMinefieldAction layMinefieldAction) {
        this.pendingLayMinefieldActions.addElement(layMinefieldAction);
        this.processGameEvent(new GameNewActionEvent((Object)this, layMinefieldAction));
    }

    @Override
    public Enumeration<LayMinefieldAction> getLayMinefieldActions() {
        return this.pendingLayMinefieldActions.elements();
    }

    @Override
    public void resetLayMinefieldActions() {
        this.pendingLayMinefieldActions.removeAllElements();
    }

    @Override
    public Vector<LayMinefieldAction> getLayMinefieldActionsVector() {
        return this.pendingLayMinefieldActions;
    }

    @Override
    public void addPSR(PilotingRollData pilotingRollData) {
        this.pilotRolls.addElement(pilotingRollData);
    }

    @Override
    public Enumeration<PilotingRollData> getPSRs() {
        return this.pilotRolls.elements();
    }

    @Override
    public void addExtremeGravityPSR(PilotingRollData pilotingRollData) {
        this.extremeGravityRolls.addElement(pilotingRollData);
    }

    @Override
    public Enumeration<PilotingRollData> getExtremeGravityPSRs() {
        return this.extremeGravityRolls.elements();
    }

    @Override
    public void resetPSRs(Entity entity) {
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        for (n = 0; n < this.pilotRolls.size(); ++n) {
            PilotingRollData pilotingRollData = this.pilotRolls.elementAt(n);
            if (pilotingRollData.getEntityId() != entity.getId()) continue;
            vector.addElement(new Integer(n));
        }
        for (n = vector.size() - 1; n > -1; --n) {
            this.pilotRolls.removeElementAt((Integer)vector.elementAt(n));
        }
    }

    @Override
    public void resetExtremeGravityPSRs() {
        this.extremeGravityRolls.removeAllElements();
    }

    @Override
    public void resetExtremeGravityPSRs(Entity entity) {
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        for (n = 0; n < this.extremeGravityRolls.size(); ++n) {
            PilotingRollData pilotingRollData = this.extremeGravityRolls.elementAt(n);
            if (pilotingRollData.getEntityId() != entity.getId()) continue;
            vector.addElement(new Integer(n));
        }
        for (n = vector.size() - 1; n > -1; --n) {
            this.extremeGravityRolls.removeElementAt((Integer)vector.elementAt(n));
        }
    }

    @Override
    public void resetPSRs() {
        this.pilotRolls.removeAllElements();
    }

    @Override
    public void addAttack(AttackHandler attackHandler) {
        this.attacks.add(attackHandler);
    }

    @Override
    public void removeAttack(AttackHandler attackHandler) {
        this.attacks.removeElement(attackHandler);
    }

    @Override
    public Enumeration<AttackHandler> getAttacks() {
        return this.attacks.elements();
    }

    @Override
    public Vector<AttackHandler> getAttacksVector() {
        return this.attacks;
    }

    @Override
    public void resetAttacks() {
        this.attacks = new Vector();
    }

    @Override
    public void setAttacksVector(Vector<AttackHandler> vector) {
        this.attacks = vector;
    }

    @Override
    public int getRoundCount() {
        return this.roundCount;
    }

    @Override
    public void setRoundCount(int n) {
        this.roundCount = n;
    }

    @Override
    public void incrementRoundCount() {
        ++this.roundCount;
    }

    @Override
    public boolean isForceVictory() {
        return this.forceVictory;
    }

    @Override
    public void setForceVictory(boolean bl) {
        this.forceVictory = bl;
    }

    @Override
    public void addReports(Vector<Report> vector) {
        if (vector.size() == 0) {
            System.out.println("Game.addReports() received blank vector.");
            return;
        }
        this.gameReports.add(this.roundCount, vector);
    }

    @Override
    public Vector<Report> getReports(int n) {
        return this.gameReports.get(n);
    }

    @Override
    public Vector<Vector<Report>> getAllReports() {
        return this.gameReports.get();
    }

    @Override
    public void setAllReports(Vector<Vector<Report>> vector) {
        this.gameReports.set(vector);
    }

    @Override
    public void clearAllReports() {
        this.gameReports.clear();
    }

    @Override
    public void end(int n, int n2) {
        this.setVictoryPlayerId(n);
        this.setVictoryTeam(n2);
        this.processGameEvent(new GameEndEvent(this));
    }

    @Override
    public int getVictoryPlayerId() {
        return this.victoryPlayerId;
    }

    @Override
    public void setVictoryPlayerId(int n) {
        this.victoryPlayerId = n;
    }

    @Override
    public int getVictoryTeam() {
        return this.victoryTeam;
    }

    @Override
    public void setVictoryTeam(int n) {
        this.victoryTeam = n;
    }

    @Override
    public boolean isPlayerVictor(Player player) {
        if (player.getTeam() == 0) {
            return player.getId() == this.victoryPlayerId;
        }
        return player.getTeam() == this.victoryTeam;
    }

    @Override
    public HashMap<String, Object> getVictoryContext() {
        return this.victoryContext;
    }

    @Override
    public void setVictoryContext(HashMap<String, Object> hashMap) {
        this.victoryContext = hashMap;
    }

    @Override
    public boolean isPlayerVictor(int n) {
        return this.isPlayerVictor(this.getPlayer(n));
    }

    @Override
    public Enumeration<Entity> getSelectedEntities(EntitySelector entitySelector) {
        Enumeration<Entity> enumeration;
        if (null == entitySelector) {
            enumeration = this.getEntities();
        } else {
            final EntitySelector entitySelector2 = entitySelector;
            enumeration = new Enumeration<Entity>(){
                private EntitySelector entitySelector;
                private Entity current;
                private Enumeration<Entity> iter;
                {
                    this.entitySelector = entitySelector2;
                    this.current = null;
                    this.iter = Game.this.getEntities();
                }

                @Override
                public boolean hasMoreElements() {
                    if (null == this.current) {
                        while (null == this.current && this.iter.hasMoreElements()) {
                            this.current = this.iter.nextElement();
                            if (this.entitySelector.accept(this.current)) continue;
                            this.current = null;
                        }
                    }
                    return null != this.current;
                }

                @Override
                public Entity nextElement() {
                    if (!this.hasMoreElements()) {
                        return null;
                    }
                    Entity entity = this.current;
                    this.current = null;
                    return entity;
                }
            };
        }
        return enumeration;
    }

    @Override
    public int getSelectedEntityCount(EntitySelector entitySelector) {
        int n = 0;
        if (null == entitySelector) {
            n = this.getNoOfEntities();
        } else {
            Enumeration<Entity> enumeration = this.getEntities();
            while (enumeration.hasMoreElements()) {
                if (!entitySelector.accept(enumeration.nextElement())) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public Enumeration<Entity> getSelectedOutOfGameEntities(EntitySelector entitySelector) {
        Enumeration<Entity> enumeration;
        if (null == entitySelector) {
            enumeration = this.vOutOfGame.elements();
        } else {
            final EntitySelector entitySelector2 = entitySelector;
            enumeration = new Enumeration<Entity>(){
                private EntitySelector entitySelector;
                private Entity current;
                private Enumeration<Entity> iter;
                {
                    this.entitySelector = entitySelector2;
                    this.current = null;
                    this.iter = Game.this.vOutOfGame.elements();
                }

                @Override
                public boolean hasMoreElements() {
                    if (null == this.current) {
                        while (null == this.current && this.iter.hasMoreElements()) {
                            this.current = this.iter.nextElement();
                            if (this.entitySelector.accept(this.current)) continue;
                            this.current = null;
                        }
                    }
                    return null != this.current;
                }

                @Override
                public Entity nextElement() {
                    if (!this.hasMoreElements()) {
                        return null;
                    }
                    Entity entity = this.current;
                    this.current = null;
                    return entity;
                }
            };
        }
        return enumeration;
    }

    @Override
    public int getSelectedOutOfGameEntityCount(EntitySelector entitySelector) {
        int n = 0;
        if (null == entitySelector) {
            n = this.vOutOfGame.size();
        } else {
            Enumeration<Entity> enumeration = this.vOutOfGame.elements();
            while (enumeration.hasMoreElements()) {
                if (!entitySelector.accept(enumeration.nextElement())) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public boolean checkForValidNonInfantryAndOrProtomechs(int n) {
        for (Entity entity : this.getPlayerEntities(this.getPlayer(n))) {
            boolean bl = false;
            if (entity instanceof Infantry && this.getOptions().booleanOption("inf_move_later")) {
                bl = true;
            } else if (entity instanceof Protomech && this.getOptions().booleanOption("protos_move_later")) {
                bl = true;
            }
            if (bl || !this.getTurn().isValidEntity(entity, this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Enumeration<Entity> getNemesisTargets(Entity entity, Coords coords) {
        Coords coords2 = entity.getPosition();
        ArrayList<Coords> arrayList = Coords.intervening(coords2, coords);
        Vector<Entity> vector = new Vector<Entity>();
        for (Coords coords3 : arrayList) {
            Enumeration<Entity> enumeration = this.getEntities(coords3);
            while (enumeration.hasMoreElements()) {
                Entity entity2 = enumeration.nextElement();
                if (!entity2.isINarcedWith(8L) || entity2.isEnemyOf(entity)) continue;
                vector.addElement(entity2);
            }
        }
        return vector.elements();
    }

    @Override
    public void addGameListener(GameListener gameListener) {
        this.gameListeners.addElement(gameListener);
    }

    @Override
    public void removeGameListener(GameListener gameListener) {
        this.gameListeners.removeElement(gameListener);
    }

    @Override
    public void processGameEvent(GameEvent gameEvent) {
        Enumeration<GameListener> enumeration = this.gameListeners.elements();
        while (enumeration.hasMoreElements()) {
            GameListener gameListener = enumeration.nextElement();
            switch (gameEvent.getType()) {
                case 0: {
                    gameListener.gamePlayerConnected((GamePlayerConnectedEvent)gameEvent);
                    break;
                }
                case 1: {
                    gameListener.gamePlayerDisconnected((GamePlayerDisconnectedEvent)gameEvent);
                    break;
                }
                case 2: {
                    gameListener.gamePlayerChange((GamePlayerChangeEvent)gameEvent);
                    break;
                }
                case 3: {
                    gameListener.gamePlayerChat((GamePlayerChatEvent)gameEvent);
                    break;
                }
                case 4: {
                    gameListener.gamePhaseChange((GamePhaseChangeEvent)gameEvent);
                    break;
                }
                case 5: {
                    gameListener.gameTurnChange((GameTurnChangeEvent)gameEvent);
                    break;
                }
                case 6: {
                    gameListener.gameReport((GameReportEvent)gameEvent);
                    break;
                }
                case 7: {
                    gameListener.gameEnd((GameEndEvent)gameEvent);
                    break;
                }
                case 8: {
                    gameListener.gameBoardNew((GameBoardNewEvent)gameEvent);
                    break;
                }
                case 9: {
                    gameListener.gameBoardChanged((GameBoardChangeEvent)gameEvent);
                    break;
                }
                case 10: {
                    gameListener.gameSettingsChange((GameSettingsChangeEvent)gameEvent);
                    break;
                }
                case 11: {
                    gameListener.gameMapQuery((GameMapQueryEvent)gameEvent);
                    break;
                }
                case 12: {
                    gameListener.gameEntityNew((GameEntityNewEvent)gameEvent);
                    break;
                }
                case 13: {
                    gameListener.gameEntityRemove((GameEntityRemoveEvent)gameEvent);
                    break;
                }
                case 14: {
                    gameListener.gameEntityNewOffboard((GameEntityNewOffboardEvent)gameEvent);
                    break;
                }
                case 15: {
                    gameListener.gameEntityChange((GameEntityChangeEvent)gameEvent);
                    break;
                }
                case 16: {
                    gameListener.gameNewAction((GameNewActionEvent)gameEvent);
                }
            }
        }
    }

    @Override
    public Vector<TagInfo> getTagInfo() {
        return this.tagInfoForTurn;
    }

    @Override
    public void addTagInfo(TagInfo tagInfo) {
        this.tagInfoForTurn.addElement(tagInfo);
    }

    @Override
    public void updateTagInfo(TagInfo tagInfo, int n) {
        this.tagInfoForTurn.setElementAt(tagInfo, n);
    }

    @Override
    public void resetTagInfo() {
        this.tagInfoForTurn.removeAllElements();
    }

    @Override
    public void clearTagInfoShots(Entity entity, Coords coords) {
        for (int i = 0; i < this.tagInfoForTurn.size(); ++i) {
            TagInfo tagInfo = this.tagInfoForTurn.elementAt(i);
            Entity entity2 = this.getEntity(tagInfo.attackerId);
            Entity entity3 = this.getEntity(tagInfo.targetId);
            if (entity.isEnemyOf(entity2) || !entity3.isOnSameSheet(coords)) continue;
            tagInfo.shots = 0;
            this.tagInfoForTurn.setElementAt(tagInfo, i);
        }
    }

    @Override
    public Vector<Flare> getFlares() {
        return this.flares;
    }

    @Override
    public void setFlares(Vector<Flare> vector) {
        this.flares = vector;
        this.processGameEvent(new GameBoardChangeEvent(this));
    }

    @Override
    public void addFlare(Flare flare) {
        this.flares.addElement(flare);
        this.processGameEvent(new GameBoardChangeEvent(this));
    }

    @Override
    public boolean isPositionIlluminated(Coords coords) {
        Enumeration<Flare> enumeration = this.flares.elements();
        while (enumeration.hasMoreElements()) {
            Flare flare = enumeration.nextElement();
            if (!flare.illuminates(coords)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Vector<Report> ageFlares() {
        Vector<Report> vector = new Vector<Report>();
        for (int i = this.flares.size() - 1; i >= 0; --i) {
            Flare flare = this.flares.elementAt(i);
            Report report = new Report(5235);
            report.add(flare.position.getBoardNum());
            report.newlines = 0;
            vector.addElement(report);
            if ((flare.flags & Flare.F_IGNITED) != 0) {
                --flare.turnsToBurn;
                if ((flare.flags & Flare.F_DRIFTING) != 0) {
                    int n = this.planetaryConditions.getWindDirection();
                    int n2 = this.planetaryConditions.getWindStrength();
                    if (n2 > 0) {
                        flare.position = flare.position.translated(n);
                        if (n2 > 2) {
                            flare.position = flare.position.translated(n);
                        }
                        if (n2 > 3) {
                            flare.position = flare.position.translated(n);
                        }
                        if (n2 > 4) {
                            flare.position = flare.position.translated(n);
                        }
                        if (n2 > 5) {
                            flare.position = flare.position.translated(n);
                        }
                        report = new Report(5236);
                        report.add(flare.position.getBoardNum());
                        report.newlines = 0;
                        vector.addElement(report);
                    }
                }
            } else {
                report = new Report(5237);
                report.newlines = 0;
                vector.addElement(report);
                flare.flags |= Flare.F_IGNITED;
            }
            if (flare.turnsToBurn <= 0) {
                report = new Report(5238);
                vector.addElement(report);
                this.flares.removeElementAt(i);
                continue;
            }
            report = new Report(5239);
            report.add(flare.turnsToBurn);
            vector.addElement(report);
            this.flares.setElementAt(flare, i);
        }
        this.processGameEvent(new GameBoardChangeEvent(this));
        return vector;
    }

    @Override
    public boolean gameTimerIsExpired() {
        return this.getOptions().booleanOption("use_game_turn_limit") && this.getRoundCount() == this.getOptions().intOption("game_turn_limit");
    }

    @Override
    public void createVictoryConditions() {
        this.victory = this.vf.createVictory("this string should be taken from game options");
    }

    @Override
    public Victory getVictory() {
        return this.victory;
    }

    @Override
    public boolean useVectorMove() {
        return this.getOptions().booleanOption("advanced_movement") && this.board.inSpace();
    }

    @Override
    public void addControlRoll(PilotingRollData pilotingRollData) {
        this.controlRolls.addElement(pilotingRollData);
    }

    @Override
    public Enumeration<PilotingRollData> getControlRolls() {
        return this.controlRolls.elements();
    }

    @Override
    public void resetControlRolls(Entity entity) {
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        for (n = 0; n < this.controlRolls.size(); ++n) {
            PilotingRollData pilotingRollData = this.controlRolls.elementAt(n);
            if (pilotingRollData.getEntityId() != entity.getId()) continue;
            vector.addElement(new Integer(n));
        }
        for (n = vector.size() - 1; n > -1; --n) {
            this.controlRolls.removeElementAt((Integer)vector.elementAt(n));
        }
    }

    @Override
    public void resetControlRolls() {
        this.controlRolls.removeAllElements();
    }

    @Override
    public boolean checkForValidSpaceStations(int n) {
        for (Entity entity : this.getPlayerEntities(this.getPlayer(n))) {
            if (!(entity instanceof SpaceStation) || !this.getTurn().isValidEntity(entity, this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkForValidJumpships(int n) {
        for (Entity entity : this.getPlayerEntities(this.getPlayer(n))) {
            if (!(entity instanceof Jumpship) || entity instanceof Warship || !this.getTurn().isValidEntity(entity, this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkForValidWarships(int n) {
        for (Entity entity : this.getPlayerEntities(this.getPlayer(n))) {
            if (!(entity instanceof Warship) || !this.getTurn().isValidEntity(entity, this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkForValidDropships(int n) {
        for (Entity entity : this.getPlayerEntities(this.getPlayer(n))) {
            if (!(entity instanceof Dropship) || !this.getTurn().isValidEntity(entity, this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkForValidSmallCraft(int n) {
        for (Entity entity : this.getPlayerEntities(this.getPlayer(n))) {
            if (!(entity instanceof SmallCraft) || !this.getTurn().isValidEntity(entity, this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PlanetaryConditions getPlanetaryConditions() {
        return this.planetaryConditions;
    }

    @Override
    public void setPlanetaryConditions(PlanetaryConditions planetaryConditions) {
        if (null == planetaryConditions) {
            System.err.println("Can't set the planetary conditions to null!");
        } else {
            this.planetaryConditions = planetaryConditions;
            this.processGameEvent(new GameSettingsChangeEvent(this));
        }
    }

    @Override
    public void addSmokeCloud(SmokeCloud smokeCloud) {
        this.smokeCloudList.add(smokeCloud);
    }

    @Override
    public List<SmokeCloud> getSmokeCloudList() {
        return this.smokeCloudList;
    }
}

