/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Mech;
import megamek.common.Protomech;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.PhysicalAttackAction;

public class BreakGrappleAttackAction
extends PhysicalAttackAction {
    private static final long serialVersionUID = 5615694825997720537L;

    public BreakGrappleAttackAction(int n, int n2) {
        super(n, n2);
    }

    public BreakGrappleAttackAction(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public ToHitData toHit(IGame iGame) {
        return BreakGrappleAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()));
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable) {
        Entity entity = iGame.getEntity(n);
        if (entity == null) {
            return new ToHitData(Integer.MAX_VALUE, "You can't attack from a null entity!");
        }
        if (!iGame.getOptions().booleanOption("tacops_grappling")) {
            return new ToHitData(Integer.MAX_VALUE, "grappling attack not allowed");
        }
        String string = BreakGrappleAttackAction.toHitIsImpossible(iGame, entity, targetable);
        if (string != null && !string.equals("Locked in Grapple")) {
            return new ToHitData(Integer.MAX_VALUE, "impossible");
        }
        if (!(entity instanceof Mech) && !(entity instanceof Protomech)) {
            return new ToHitData(Integer.MAX_VALUE, "Only mechs and protomechs can be grappled");
        }
        if (entity.getGrappled() != targetable.getTargetId()) {
            return new ToHitData(Integer.MAX_VALUE, "Not grappled");
        }
        int n2 = entity.getCrew().getPiloting();
        ToHitData toHitData = new ToHitData(n2, "base");
        if (entity.isGrappleAttacker()) {
            toHitData.addModifier(Integer.MIN_VALUE, "original attacker");
            return toHitData;
        }
        BreakGrappleAttackAction.setCommonModifiers(toHitData, iGame, entity, targetable);
        if (entity instanceof Mech) {
            if (!entity.hasWorkingSystem(7, 5)) {
                toHitData.addModifier(2, "Left shoulder actuator destroyed");
            }
            if (!entity.hasWorkingSystem(8, 5)) {
                toHitData.addModifier(2, "Left upper arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(9, 5)) {
                toHitData.addModifier(2, "Left lower arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(10, 5)) {
                toHitData.addModifier(1, "Left hand actuator destroyed");
            }
            if (!entity.hasWorkingSystem(7, 4)) {
                toHitData.addModifier(2, "Right shoulder actuator destroyed");
            }
            if (!entity.hasWorkingSystem(8, 4)) {
                toHitData.addModifier(2, "Right upper arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(9, 4)) {
                toHitData.addModifier(2, "Right lower arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(10, 4)) {
                toHitData.addModifier(1, "Right hand actuator destroyed");
            }
            if (entity.hasFunctionalArmAES(4) && entity.hasFunctionalArmAES(5)) {
                toHitData.addModifier(-1, "AES modifer");
            }
        }
        Entity entity2 = (Entity)targetable;
        int n3 = entity2.getWeightClass() - entity.getWeightClass();
        if (entity2 instanceof Protomech && !(entity instanceof Protomech)) {
            n3 = entity.getWeightClass() * -1;
        } else if (entity instanceof Protomech && !(entity2 instanceof Protomech)) {
            n3 = entity2.getWeightClass();
        } else if (entity2 instanceof Protomech && entity instanceof Protomech) {
            n3 = 0;
        }
        if (n3 != 0) {
            toHitData.addModifier(n3, "Weight class difference");
        }
        return toHitData;
    }
}

