/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.QuadMech;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.PhysicalAttackAction;

public class TripAttackAction
extends PhysicalAttackAction {
    private static final long serialVersionUID = -8639566786588420601L;

    public TripAttackAction(int n, int n2) {
        super(n, n2);
    }

    public TripAttackAction(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public ToHitData toHit(IGame iGame) {
        return TripAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()));
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable) {
        Entity entity = iGame.getEntity(n);
        if (entity == null) {
            return new ToHitData(Integer.MAX_VALUE, "You can't attack from a null entity!");
        }
        if (!iGame.getOptions().booleanOption("tacops_trip_attack")) {
            return new ToHitData(Integer.MAX_VALUE, "no Trip attack");
        }
        String string = TripAttackAction.toHitIsImpossible(iGame, entity, targetable);
        if (string != null) {
            return new ToHitData(Integer.MAX_VALUE, "impossible");
        }
        if (entity.getGrappled() != -1) {
            return new ToHitData(Integer.MAX_VALUE, "impossible");
        }
        if (!iGame.getOptions().booleanOption("friendly_fire") && targetable.getTargetType() == 0 && (((Entity)targetable).getOwnerId() == entity.getOwnerId() || ((Entity)targetable).getOwner().getTeam() != 0 && entity.getOwner().getTeam() != 0 && entity.getOwner().getTeam() == ((Entity)targetable).getOwner().getTeam())) {
            return new ToHitData(Integer.MAX_VALUE, "A friendly unit can never be the target of a direct attack.");
        }
        if (!(entity instanceof Mech) || !(targetable instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Only mechs can trip other mechs");
        }
        if (entity.isLocationBad(7) || entity.isLocationBad(6)) {
            return new ToHitData(Integer.MAX_VALUE, "Leg missing");
        }
        int n2 = entity.getPosition().distance(targetable.getPosition());
        if (n2 > 1) {
            return new ToHitData(Integer.MAX_VALUE, "Target out of range");
        }
        int n3 = -1;
        if (!Compute.isInArc(entity.getPosition(), entity.getFacing(), targetable.getPosition(), 1)) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in arc");
        }
        if (entity.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is prone");
        }
        if (((Entity)targetable).isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is prone");
        }
        if (entity.getElevation() != targetable.getElevation()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker and Target must be at the same elevation");
        }
        boolean[] blArray = new boolean[entity.locations()];
        for (int i = 0; i < entity.locations(); ++i) {
            blArray[i] = false;
        }
        for (Mounted serializable2 : entity.getWeaponList()) {
            int toHitData3;
            if (!serializable2.isUsedThisRound() || (toHitData3 = serializable2.getLocation()) == -1) continue;
            blArray[toHitData3] = true;
        }
        if (!entity.hasWorkingSystem(11, 6)) {
            blArray[6] = true;
        }
        if (!entity.hasWorkingSystem(11, 7)) {
            blArray[7] = true;
        }
        if (!entity.hasWorkingSystem(11, 4)) {
            blArray[4] = true;
        }
        if (!entity.hasWorkingSystem(11, 5)) {
            blArray[5] = true;
        }
        if (entity instanceof QuadMech) {
            if (blArray[4]) {
                if (blArray[5]) {
                    return new ToHitData(Integer.MAX_VALUE, "both legs unusable");
                }
                n3 = 5;
            }
        } else if (blArray[6]) {
            if (blArray[7]) {
                return new ToHitData(Integer.MAX_VALUE, "both legs unusable");
            }
            n3 = 7;
        }
        int n5 = entity.getCrew().getPiloting() - 1;
        ToHitData toHitData = new ToHitData(n5, "base");
        TripAttackAction.setCommonModifiers(toHitData, iGame, entity, targetable);
        if (entity instanceof QuadMech) {
            if (n3 == -1) {
                ToHitData toHitData2 = TripAttackAction.getLimbModifier(5, entity);
                ToHitData toHitData3 = TripAttackAction.getLimbModifier(4, entity);
                if (toHitData2.getValue() < toHitData3.getValue()) {
                    toHitData.append(toHitData2);
                } else {
                    toHitData.append(toHitData3);
                }
            } else {
                toHitData.append(TripAttackAction.getLimbModifier(n3, entity));
            }
        } else if (n3 == -1) {
            ToHitData toHitData4 = TripAttackAction.getLimbModifier(7, entity);
            ToHitData toHitData5 = TripAttackAction.getLimbModifier(6, entity);
            if (toHitData4.getValue() < toHitData5.getValue()) {
                toHitData.append(toHitData4);
            } else {
                toHitData.append(toHitData5);
            }
        } else {
            toHitData.append(TripAttackAction.getLimbModifier(n3, entity));
        }
        if (entity.hasFunctionalLegAES()) {
            toHitData.addModifier(-1, "AES modifer");
        }
        return toHitData;
    }

    private static ToHitData getLimbModifier(int n, Entity entity) {
        ToHitData toHitData = new ToHitData();
        if (!entity.hasWorkingSystem(12, n)) {
            toHitData.addModifier(2, "Upper leg actuator destroyed");
        }
        if (!entity.hasWorkingSystem(13, n)) {
            toHitData.addModifier(2, "Lower leg actuator destroyed");
        }
        if (!entity.hasWorkingSystem(14, n)) {
            toHitData.addModifier(1, "Foot actuator destroyed");
        }
        return toHitData;
    }
}

