/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import megamek.common.ASFBay;
import megamek.common.AmmoType;
import megamek.common.BattleArmorBay;
import megamek.common.CargoBay;
import megamek.common.Dropship;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HeavyVehicleBay;
import megamek.common.InfantryBay;
import megamek.common.LightVehicleBay;
import megamek.common.LocationFullException;
import megamek.common.MechBay;
import megamek.common.Mounted;
import megamek.common.SmallCraftBay;
import megamek.common.WeaponType;
import megamek.common.loaders.BLKFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;
import megamek.common.util.BuildingBlock;

public class BLKDropshipFile
extends BLKFile
implements IMechLoader {
    public static final int NOSE = 0;
    public static final int RW = 1;
    public static final int LW = 2;
    public static final int AFT = 3;

    public BLKDropshipFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public Entity getEntity() throws EntityLoadingException {
        Dropship dropship = new Dropship();
        if (!this.dataFile.exists("Name")) {
            throw new EntityLoadingException("Could not find name block.");
        }
        dropship.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (this.dataFile.exists("Model") && this.dataFile.getDataAsString("Model")[0] != null) {
            dropship.setModel(this.dataFile.getDataAsString("Model")[0]);
        } else {
            dropship.setModel("");
        }
        this.setTechLevel(dropship);
        if (!this.dataFile.exists("crew")) {
            throw new EntityLoadingException("Could not find crew block.");
        }
        dropship.setNCrew(this.dataFile.getDataAsInt("crew")[0]);
        if (!this.dataFile.exists("passengers")) {
            throw new EntityLoadingException("Could not find passenger block.");
        }
        dropship.setNPassenger(this.dataFile.getDataAsInt("passengers")[0]);
        if (!this.dataFile.exists("life_boat")) {
            throw new EntityLoadingException("Could not find life boat block.");
        }
        dropship.setLifeBoats(this.dataFile.getDataAsInt("life_boat")[0]);
        if (!this.dataFile.exists("escape_pod")) {
            throw new EntityLoadingException("Could not find escape pod block.");
        }
        dropship.setEscapePods(this.dataFile.getDataAsInt("escape_pod")[0]);
        if (!this.dataFile.exists("tonnage")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        dropship.setWeight(this.dataFile.getDataAsFloat("tonnage")[0]);
        if (!this.dataFile.exists("motion_type")) {
            throw new EntityLoadingException("Could not find movement block.");
        }
        String string = this.dataFile.getDataAsString("motion_type")[0];
        int n = 16;
        if (string.equals("spheroid")) {
            n = 17;
            dropship.setSpheroid(true);
        }
        dropship.setMovementMode(n);
        if (!this.dataFile.exists("structural_integrity")) {
            throw new EntityLoadingException("Could not find structual integrity block.");
        }
        dropship.set0SI(this.dataFile.getDataAsInt("structural_integrity")[0]);
        if (!this.dataFile.exists("heatsinks")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        dropship.setHeatSinks(this.dataFile.getDataAsInt("heatsinks")[0]);
        if (!this.dataFile.exists("sink_type")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        dropship.setHeatType(this.dataFile.getDataAsInt("sink_type")[0]);
        if (!this.dataFile.exists("fuel")) {
            throw new EntityLoadingException("Could not find fuel block.");
        }
        dropship.setFuel(this.dataFile.getDataAsInt("fuel")[0]);
        if (!this.dataFile.exists("SafeThrust")) {
            throw new EntityLoadingException("Could not find Safe Thrust block.");
        }
        dropship.setOriginalWalkMP(this.dataFile.getDataAsInt("SafeThrust")[0]);
        dropship.setEngine(new Engine(400, 0, 0));
        if (this.dataFile.exists("armor_type")) {
            dropship.setArmorType(this.dataFile.getDataAsInt("armor_type")[0]);
        }
        if (this.dataFile.exists("armor_tech")) {
            dropship.setArmorTechLevel(this.dataFile.getDataAsInt("armor_tech")[0]);
        }
        if (this.dataFile.exists("internal_type")) {
            dropship.setStructureType(this.dataFile.getDataAsInt("internal_type")[0]);
        }
        if (!this.dataFile.exists("armor")) {
            throw new EntityLoadingException("Could not find armor block.");
        }
        int[] nArray = this.dataFile.getDataAsInt("armor");
        if (nArray.length != 4) {
            throw new EntityLoadingException("Incorrect armor array length");
        }
        dropship.initializeArmor(nArray[0], 0);
        dropship.initializeArmor(nArray[1], 2);
        dropship.initializeArmor(nArray[2], 1);
        dropship.initializeArmor(nArray[3], 3);
        dropship.autoSetInternal();
        dropship.autoSetThresh();
        this.loadEquipment(dropship, "Nose", 0);
        this.loadEquipment(dropship, "Right Side", 2);
        this.loadEquipment(dropship, "Left Side", 1);
        this.loadEquipment(dropship, "Aft", 3);
        if (this.dataFile.exists("omni")) {
            dropship.setOmni(true);
        }
        if (this.dataFile.exists("transporters")) {
            String[] stringArray = this.dataFile.getDataAsString("transporters");
            for (int i = 0; i < stringArray.length; ++i) {
                int n2;
                int n3;
                String[] stringArray2;
                String string2;
                if (stringArray[i].startsWith("ASFBay:", 0)) {
                    string2 = stringArray[i].substring(7);
                    stringArray2 = string2.split(":");
                    n3 = Integer.parseInt(stringArray2[0]);
                    n2 = Integer.parseInt(stringArray2[1]);
                    dropship.addTransporter(new ASFBay(n3, n2));
                    continue;
                }
                if (stringArray[i].startsWith("SmallCraftBay:", 0)) {
                    string2 = stringArray[i].substring(14);
                    stringArray2 = string2.split(":");
                    n3 = Integer.parseInt(stringArray2[0]);
                    n2 = Integer.parseInt(stringArray2[1]);
                    dropship.addTransporter(new SmallCraftBay(n3, n2));
                    continue;
                }
                if (stringArray[i].startsWith("MechBay:", 0)) {
                    string2 = stringArray[i].substring(8);
                    stringArray2 = string2.split(":");
                    n3 = Integer.parseInt(stringArray2[0]);
                    n2 = Integer.parseInt(stringArray2[1]);
                    dropship.addTransporter(new MechBay(n3, n2));
                    continue;
                }
                if (stringArray[i].startsWith("LightVehicleBay:", 0)) {
                    string2 = stringArray[i].substring(16);
                    stringArray2 = string2.split(":");
                    n3 = Integer.parseInt(stringArray2[0]);
                    n2 = Integer.parseInt(stringArray2[1]);
                    dropship.addTransporter(new LightVehicleBay(n3, n2));
                    continue;
                }
                if (stringArray[i].startsWith("HeavyVehicleBay:", 0)) {
                    string2 = stringArray[i].substring(16);
                    stringArray2 = string2.split(":");
                    n3 = Integer.parseInt(stringArray2[0]);
                    n2 = Integer.parseInt(stringArray2[1]);
                    dropship.addTransporter(new HeavyVehicleBay(n3, n2));
                    continue;
                }
                if (stringArray[i].startsWith("InfantryBay:", 0)) {
                    string2 = stringArray[i].substring(12);
                    stringArray2 = string2.split(":");
                    n3 = Integer.parseInt(stringArray2[0]);
                    n2 = Integer.parseInt(stringArray2[1]);
                    dropship.addTransporter(new InfantryBay(n3, n2));
                    continue;
                }
                if (stringArray[i].startsWith("BattleArmorBay:", 0)) {
                    string2 = stringArray[i].substring(15);
                    stringArray2 = string2.split(":");
                    n3 = Integer.parseInt(stringArray2[0]);
                    n2 = Integer.parseInt(stringArray2[1]);
                    dropship.addTransporter(new BattleArmorBay(n3, n2));
                    continue;
                }
                if (!stringArray[i].startsWith("CargoBay:", 0)) continue;
                string2 = stringArray[i].substring(9);
                stringArray2 = string2.split(":");
                n3 = Integer.parseInt(stringArray2[0]);
                n2 = Integer.parseInt(stringArray2[1]);
                dropship.addTransporter(new CargoBay(n3, n2));
            }
        }
        return dropship;
    }

    protected void loadEquipment(Dropship dropship, String string, int n) throws EntityLoadingException {
        String[] stringArray = this.dataFile.getDataAsString(string + " Equipment");
        if (stringArray == null) {
            return;
        }
        String string2 = dropship.getTechLevel() == 2 ? "Clan " : "IS ";
        boolean bl = false;
        int n2 = 1;
        Mounted mounted = null;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        int n4 = 1;
        if (stringArray[0] != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                bl = false;
                n2 = 1;
                bl2 = false;
                bl3 = false;
                String string3 = stringArray[i].trim();
                if (string3.startsWith("(R) ")) {
                    bl = true;
                    string3 = string3.substring(4);
                }
                if (string3.startsWith("(B) ")) {
                    bl2 = true;
                    string3 = string3.substring(4);
                }
                if (string3.startsWith("(SC) ")) {
                    bl2 = true;
                    bl3 = true;
                    string3 = string3.substring(4);
                }
                if (string3.contains(":") && string3.contains("Ammo")) {
                    object = string3.split(":");
                    string3 = object[0];
                    if (object[1] != null) {
                        n2 = Integer.parseInt(object[1]);
                    }
                }
                if ((object = EquipmentType.get(string3)) == null) {
                    object = EquipmentType.get(string2 + string3);
                }
                if (object != null) {
                    Mounted mounted2;
                    try {
                        mounted2 = n2 == 1 ? dropship.addEquipment((EquipmentType)object, n, bl) : dropship.addEquipment((EquipmentType)object, n, bl, n2);
                    }
                    catch (LocationFullException locationFullException) {
                        throw new EntityLoadingException(locationFullException.getMessage());
                    }
                    if (mounted2.getType() instanceof WeaponType) {
                        WeaponType weaponType = (WeaponType)mounted2.getType();
                        if (mounted == null) {
                            if (bl3) {
                                try {
                                    mounted = dropship.addEquipment(WeaponType.getSubCapBayType(weaponType.getAtClass()), n, bl);
                                    bl2 = false;
                                }
                                catch (LocationFullException locationFullException) {
                                    throw new EntityLoadingException(locationFullException.getMessage());
                                }
                            }
                            try {
                                mounted = dropship.addEquipment(WeaponType.getBayType(weaponType.getAtClass()), n, bl);
                                bl2 = false;
                            }
                            catch (LocationFullException locationFullException) {
                                throw new EntityLoadingException(locationFullException.getMessage());
                            }
                        }
                        int n5 = weaponType.getRoundShortAV();
                        if (weaponType.isCapital()) {
                            n5 *= 10;
                        }
                        if (!(bl2 || n3 + n5 > 700 || mounted.isRearMounted() != bl || weaponType.getAtClass() != ((WeaponType)mounted.getType()).getAtClass() || ((WeaponType)mounted.getType()).isSubCapital() && !weaponType.isSubCapital())) {
                            mounted.addWeaponToBay(dropship.getEquipmentNum(mounted2));
                            n3 += n5;
                        } else {
                            if (bl3) {
                                try {
                                    mounted = dropship.addEquipment(WeaponType.getSubCapBayType(weaponType.getAtClass()), n, bl);
                                }
                                catch (LocationFullException locationFullException) {
                                    throw new EntityLoadingException(locationFullException.getMessage());
                                }
                            }
                            try {
                                mounted = dropship.addEquipment(WeaponType.getBayType(weaponType.getAtClass()), n, bl);
                            }
                            catch (LocationFullException locationFullException) {
                                throw new EntityLoadingException(locationFullException.getMessage());
                            }
                            mounted.addWeaponToBay(dropship.getEquipmentNum(mounted2));
                            n3 = n5;
                            ++n4;
                        }
                    }
                    if (!(mounted2.getType() instanceof AmmoType)) continue;
                    mounted.addAmmoToBay(dropship.getEquipmentNum(mounted2));
                    continue;
                }
                if (string3 == "0") continue;
                dropship.addFailedEquipment(string3);
            }
        }
    }
}

