/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import megamek.common.Entity;
import megamek.common.Infantry;
import megamek.common.loaders.BLKFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;
import megamek.common.util.BuildingBlock;

public class BLKInfantryFile
extends BLKFile
implements IMechLoader {
    private static final String[] MOVES = new String[]{"", "", "", "Tracked", "Wheeled", "Hover", "", "", "", "", "Leg", "Motorized", "Jump", "", "", "", "", "", "Submarine"};

    public BLKInfantryFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public Entity getEntity() throws EntityLoadingException {
        int n;
        Infantry infantry = new Infantry();
        if (!this.dataFile.exists("name")) {
            throw new EntityLoadingException("Could not find name block.");
        }
        infantry.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (!this.dataFile.exists("model")) {
            throw new EntityLoadingException("Could not find model block.");
        }
        infantry.setModel(this.dataFile.getDataAsString("Model")[0]);
        this.setTechLevel(infantry);
        if (!this.dataFile.exists("tonnage")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        infantry.setWeight(this.dataFile.getDataAsFloat("tonnage")[0]);
        if (!this.dataFile.exists("motion_type")) {
            throw new EntityLoadingException("Could not find movement block.");
        }
        String string = this.dataFile.getDataAsString("motion_type")[0];
        int n2 = -1;
        for (n = 0; n < MOVES.length; ++n) {
            if (!string.equals(MOVES[n])) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            throw new EntityLoadingException("Invalid movement type: " + string);
        }
        infantry.setMovementMode(n2);
        if (!this.dataFile.exists("cruiseMP")) {
            throw new EntityLoadingException("Could not find cruiseMP block.");
        }
        infantry.setOriginalWalkMP(this.dataFile.getDataAsInt("cruiseMP")[0]);
        if (this.dataFile.exists("jumpingMP")) {
            infantry.setOriginalJumpMP(this.dataFile.getDataAsInt("jumpingMP")[0]);
        }
        this.loadEquipment(infantry, "Platoon", 0);
        if (this.dataFile.exists("troopers")) {
            n = this.dataFile.getDataAsInt("troopers")[0];
            infantry.initializeInternal(n, 0);
            if (infantry.hasWorkingMisc(262144L, 16L)) {
                infantry.initializeArmor(n, 0);
            }
        } else {
            infantry.autoSetInternal();
        }
        return infantry;
    }
}

