/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.options;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.options.IBasicOptionGroup;
import megamek.common.options.IOptionInfo;
import megamek.common.options.IOptionsInfo;
import megamek.common.options.Messages;
import megamek.common.options.OptionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractOptionsInfo
implements IOptionsInfo {
    protected static final String GROUP_SUFFIX = ".group.";
    protected static final String OPTION_SUFFIX = ".option.";
    protected static final String DISPLAYABLE_NAME_SUFFIX = ".displayableName";
    protected static final String DESCRIPTION_SUFFIX = ".description";
    private String name;
    private Hashtable<String, OptionInfo> optionsHash = new Hashtable();
    private Vector<IBasicOptionGroup> groups = new Vector();
    private boolean finished;
    private static HashSet<String> names = new HashSet();

    protected AbstractOptionsInfo(String string) {
        if (names.contains(string)) {
            throw new IllegalArgumentException("OptionsInfo '" + string + "' is already registered");
        }
        this.name = string;
    }

    @Override
    public IOptionInfo getOptionInfo(String string) {
        return this.optionsHash.get(string);
    }

    @Override
    public Enumeration<IBasicOptionGroup> getGroups() {
        return this.groups.elements();
    }

    IBasicOptionGroup addGroup(String string) {
        return this.addGroup(string, null);
    }

    IBasicOptionGroup addGroup(String string, String string2) {
        IBasicOptionGroup iBasicOptionGroup = null;
        if (!this.finished) {
            for (int i = 0; i < this.groups.size(); ++i) {
                IBasicOptionGroup iBasicOptionGroup2 = this.groups.elementAt(i);
                if (iBasicOptionGroup2 == null || !iBasicOptionGroup2.getName().equals(string)) continue;
                iBasicOptionGroup = this.groups.elementAt(i);
                break;
            }
            if (iBasicOptionGroup == null) {
                iBasicOptionGroup = string2 == null ? new OptionGroup(string) : new OptionGroup(string, string2);
                this.groups.addElement(iBasicOptionGroup);
            }
        }
        return iBasicOptionGroup;
    }

    void addOptionInfo(IBasicOptionGroup iBasicOptionGroup, String string) {
        if (!this.finished) {
            ((OptionGroup)iBasicOptionGroup).addOptionName(string);
            this.setOptionInfo(string, new OptionInfo(string));
        }
    }

    protected String getGroupDisplayableName(String string) {
        for (int i = 0; i < this.groups.size(); ++i) {
            IBasicOptionGroup iBasicOptionGroup = this.groups.elementAt(i);
            if (iBasicOptionGroup == null || !iBasicOptionGroup.getName().equals(string)) continue;
            return Messages.getString(this.name + GROUP_SUFFIX + string + DISPLAYABLE_NAME_SUFFIX);
        }
        return null;
    }

    void finish() {
        this.finished = true;
    }

    private void setOptionInfo(String string, OptionInfo optionInfo) {
        this.optionsHash.put(string, optionInfo);
    }

    private String getOptionDisplayableName(String string) {
        return Messages.getString(this.name + OPTION_SUFFIX + string + DISPLAYABLE_NAME_SUFFIX);
    }

    private String getOptionDescription(String string) {
        return Messages.getString(this.name + OPTION_SUFFIX + string + DESCRIPTION_SUFFIX);
    }

    private class OptionInfo
    implements IOptionInfo {
        private String name;
        private int textFieldLength = 2;
        private boolean labelBeforeTextField = false;

        public OptionInfo(String string) {
            this.name = string;
        }

        public String getDisplayableName() {
            return AbstractOptionsInfo.this.getOptionDisplayableName(this.name);
        }

        public String getDisplayableNameWithValue() {
            return AbstractOptionsInfo.this.getOptionDisplayableName(this.name);
        }

        public String getDescription() {
            return AbstractOptionsInfo.this.getOptionDescription(this.name);
        }

        public int getTextFieldLength() {
            return this.textFieldLength;
        }

        public boolean isLabelBeforeTextField() {
            return this.labelBeforeTextField;
        }
    }
}

