/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.AmmoType;
import megamek.common.IGame;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.RangeType;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.BayWeaponHandler;
import megamek.server.Server;

public class AmmoBayWeaponHandler
extends BayWeaponHandler {
    private static final long serialVersionUID = -1618484541772117621L;

    public AmmoBayWeaponHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    protected int calcAttackValue() {
        int n = this.ae.getPosition().distance(this.target.getPosition());
        double d = 0.0;
        int n2 = RangeType.rangeBracket(n, this.wtype.getATRanges(), true);
        for (int n3 : this.weapon.getBayWeapons()) {
            Mounted mounted = this.ae.getEquipment(n3);
            Mounted mounted2 = mounted.getLinked();
            if (null == mounted2 || mounted2.getShotsLeft() < 1) {
                this.ae.loadWeaponWithSameAmmo(mounted);
                mounted2 = mounted.getLinked();
            }
            if (mounted.isBreached() || mounted.isDestroyed() || mounted.isJammed() || mounted2 == null || this.ae.getTotalAmmoOfType(mounted2.getType()) < mounted.getCurrentShots()) continue;
            WeaponType weaponType = (WeaponType)mounted.getType();
            double d2 = 0.0;
            AmmoType ammoType = (AmmoType)mounted2.getType();
            if (n2 == 1) {
                d2 = weaponType.getShortAV();
            } else if (n2 == 2) {
                d2 = weaponType.getMedAV();
            } else if (n2 == 3) {
                d2 = weaponType.getLongAV();
            } else if (n2 == 4) {
                d2 = weaponType.getExtAV();
            }
            d2 = this.updateAVforAmmo(d2, ammoType, weaponType, n2, n3);
            d += d2;
            if (d2 > 0.0) {
                int n4 = mounted.getCurrentShots();
                for (int i = 0; i < n4; ++i) {
                    if (null == mounted2 || mounted2.getShotsLeft() < 1) {
                        this.ae.loadWeaponWithSameAmmo(mounted);
                        mounted2 = mounted.getLinked();
                    }
                    if (null == mounted2) continue;
                    mounted2.setShotsLeft(mounted2.getShotsLeft() - 1);
                }
            }
            if (!ammoType.hasFlag(512L) && !ammoType.hasFlag(1024L)) continue;
            this.insertedAttacks.addElement(n3);
            d -= d2;
        }
        return (int)Math.ceil(d);
    }

    protected double updateAVforAmmo(double d, AmmoType ammoType, WeaponType weaponType, int n, int n2) {
        Mounted mounted = this.weapon.getLinkedBy();
        int n3 = 0;
        if (mounted != null && mounted.getType() instanceof MiscType && !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached() && mounted.getType().hasFlag(512L) && ammoType.getMunitionType() == 8192L) {
            n3 = (int)Math.ceil((double)ammoType.getRackSize() / 5.0);
            if (ammoType.getAmmoType() == 9) {
                n3 = 2;
            }
            d += (double)n3;
        }
        if (ammoType.getMunitionType() == 1L) {
            d = Math.floor(0.6 * d);
        } else if (28 == ammoType.getAmmoType()) {
            if (ammoType.getMunitionType() == 128L) {
                d = weaponType.getExtAV() / 2.0;
            } else if (ammoType.getMunitionType() == 256L) {
                d = 1.5 * d;
                if (n > 1) {
                    d = 0.0;
                }
            }
        } else if (ammoType.getAmmoType() == 45 && !ammoType.hasFlag(32L)) {
            d = 2.0 * d;
            if (n > 1) {
                d = 0.0;
            }
        } else if (ammoType.getAmmoType() == 61) {
            d = ammoType.hasFlag(128L) ? 4.0 : (ammoType.hasFlag(64L) ? 3.0 : 2.0);
        }
        return d;
    }
}

