/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Iterator;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.IGame;
import megamek.common.Mounted;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoBayWeaponHandler;
import megamek.common.weapons.Weapon;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapitalMissileBayHandler
extends AmmoBayWeaponHandler {
    private static final long serialVersionUID = -1618484541772117621L;

    public CapitalMissileBayHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected int getCapMisMod() {
        int n = 0;
        for (int n2 : this.weapon.getBayWeapons()) {
            int n3 = 0;
            Mounted mounted = this.ae.getEquipment(n2);
            Mounted mounted2 = mounted.getLinked();
            AmmoType ammoType = (AmmoType)mounted2.getType();
            n3 = this.getCritMod(ammoType);
            if (n3 <= n) continue;
            n = n3;
        }
        return n;
    }

    protected int getCritMod(AmmoType ammoType) {
        if (ammoType == null || ammoType.getAmmoType() == 74) {
            return 0;
        }
        if (ammoType.getAmmoType() == 58 || ammoType.hasFlag(64L)) {
            return 9;
        }
        if (ammoType.getAmmoType() == 57 || ammoType.hasFlag(128L) || ammoType.getAmmoType() == 71) {
            return 10;
        }
        if (ammoType.getAmmoType() == 60) {
            return 8;
        }
        if (ammoType.getAmmoType() == 73) {
            return 12;
        }
        return 11;
    }

    @Override
    protected void insertAttacks(IGame.Phase phase, Vector<Report> vector) {
        Iterator iterator = this.insertedAttacks.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            Mounted mounted = this.ae.getEquipment(n);
            WeaponAttackAction weaponAttackAction = new WeaponAttackAction(this.ae.getId(), this.waa.getTargetId(), n);
            Weapon weapon = (Weapon)mounted.getType();
            mounted.getLinked().setShotsLeft(mounted.getLinked().getShotsLeft() + 1);
            weapon.fire(weaponAttackAction, this.game, this.server).handle(phase, vector);
        }
    }
}

