/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MekMortarHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = -2073773899108954657L;
    String sSalvoType = " shell(s) ";

    public MekMortarHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        int n;
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            return 1;
        }
        boolean bl = this.target.getTargetType() == 1 || this.target.getTargetType() == 2;
        int n2 = 0;
        if (bl) {
            n = this.wtype.getRackSize();
        } else {
            if (this.game.getOptions().booleanOption("tacops_range") && this.nRange > this.wtype.getRanges(this.weapon)[3]) {
                n2 -= 2;
            }
            if (this.bGlancing) {
                n2 -= 4;
            } else if (this.bDirect) {
                n2 += this.toHit.getMoS() / 3 * 2;
            }
            n = Compute.missilesHit(this.wtype.getRackSize(), n2);
        }
        if (n > 0) {
            this.r = new Report(3325);
            this.r.subject = this.subjectId;
            this.r.add(n);
            this.r.add(this.sSalvoType);
            this.r.add(this.toHit.getTableDesc());
            this.r.newlines = 0;
            vector.addElement(this.r);
            if (n2 != 0) {
                this.r = n2 > 0 ? new Report(3340) : new Report(3341);
                this.r.subject = this.subjectId;
                this.r.add(n2);
                this.r.newlines = 0;
                vector.addElement(this.r);
            }
        }
        this.r = new Report(3345);
        this.r.subject = this.subjectId;
        this.r.newlines = 0;
        vector.addElement(this.r);
        this.bSalvo = true;
        return n;
    }

    @Override
    protected int calcnCluster() {
        return 2;
    }

    @Override
    protected boolean specialResolution(Vector<Report> vector, Entity entity, boolean bl) {
        if (this.target.getTargetType() == 1) {
            int n = this.nDamPerHit * this.calcHits(vector);
            int[] nArray = new int[]{n};
            Building building = this.game.getBoard().getBuildingAt(this.target.getPosition());
            this.handleClearDamage(vector, building, n, this.bSalvo);
            this.server.doExplosion(nArray, false, this.target.getPosition(), true, vector, null, this.calcnCluster());
            return true;
        }
        return false;
    }

    @Override
    protected int calcDamagePerHit() {
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            double d = this.wtype.getRackSize();
            d = Compute.directBlowInfantryDamage(d, this.bDirect ? this.toHit.getMoS() / 3 : 0, 3);
            if (this.bGlancing) {
                d /= 2.0;
            }
            d = Math.ceil(d);
            return (int)d;
        }
        return 2;
    }
}

