/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrototypeGaussHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = -156828547249911617L;

    public PrototypeGaussHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected int calcDamagePerHit() {
        float f = this.wtype.getDamage();
        int n = this.ae.getPosition().distance(this.target.getPosition());
        if (this.game.getOptions().booleanOption("tacops_range") && n > this.wtype.getRanges(this.weapon)[3]) {
            f -= 1.0f;
        }
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            f = (float)Compute.directBlowInfantryDamage(f, this.bDirect ? this.toHit.getMoS() / 3 : 0, 0);
        } else if (this.bDirect) {
            f = Math.min(f + (float)(this.toHit.getMoS() / 3), f * 2.0f);
        }
        if (this.bGlancing) {
            f = (int)Math.floor((double)f / 2.0);
        }
        return (int)Math.ceil(f);
    }

    @Override
    protected boolean doChecks(Vector<Report> vector) {
        if (this.roll == 2) {
            this.r = new Report(3165);
            this.r.subject = this.subjectId;
            this.weapon.setJammed(true);
            this.weapon.setHit(true);
            vector.addElement(this.r);
            return true;
        }
        return false;
    }
}

