/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.MissileWeaponHandler;
import megamek.server.Server;

public class ThunderBoltWeaponHandler
extends MissileWeaponHandler {
    private static final long serialVersionUID = 6329291710822071023L;

    public ThunderBoltWeaponHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    protected int calcDamagePerHit() {
        AmmoType ammoType = (AmmoType)this.ammo.getType();
        float f = ammoType.getDamagePerShot();
        if (this.nRange <= this.wtype.getMinimumRange() && !this.weapon.isHotLoaded()) {
            f /= 2.0f;
        }
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            f = (float)Compute.directBlowInfantryDamage(f, this.bDirect ? this.toHit.getMoS() / 3 : 0, 3);
        } else if (this.bDirect) {
            f = Math.min(f + (float)(this.toHit.getMoS() / 3), f * 2.0f);
        }
        return (int)Math.ceil(f);
    }
}

