/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote;

import com.lyrisoft.chat.ICommands;

public class CommandMakerRemote
implements ICommands {
    public static final String constructSignonAck(String myname) {
        StringBuffer sb = new StringBuffer();
        sb.append("/ack_signon");
        sb.append("\t");
        sb.append(myname);
        return sb.toString();
    }

    public static final String constructJoinRoomAck(String room) {
        StringBuffer sb = new StringBuffer();
        sb.append("/ack_join");
        sb.append("\t");
        sb.append(room);
        return sb.toString();
    }

    public static final String constructErrorMessage(String msg) {
        StringBuffer sb = new StringBuffer();
        sb.append("/err");
        sb.append("\t");
        sb.append(msg);
        return sb.toString();
    }

    public static final String constructGeneralMessage(String msg) {
        return msg;
    }

    public static final String constructRoomMessage(String from, String room, String msg) {
        StringBuffer sb = new StringBuffer();
        sb.append("/sayroom");
        sb.append("\t");
        sb.append(from);
        sb.append("\t");
        sb.append(room);
        sb.append("\t");
        sb.append(msg);
        return sb.toString();
    }

    public static final String constructPrivateMessage(String from, String msg) {
        StringBuffer sb = new StringBuffer();
        sb.append("/msg");
        sb.append("\t");
        sb.append(from);
        sb.append("\t");
        sb.append(msg);
        return sb.toString();
    }

    public static final String constructSignoffAckMessage() {
        return "/quit";
    }

    public static final String constructRoomUserListMessage(String room, String[] names) {
        StringBuffer sb = new StringBuffer();
        sb.append("/who");
        sb.append("\t");
        sb.append(room);
        sb.append("\t");
        int i = 0;
        while (i < names.length) {
            sb.append(names[i]);
            sb.append("\t");
            ++i;
        }
        return sb.toString();
    }

    public static final String constructGlobalUserListMessage(String[] names) {
        StringBuffer sb = new StringBuffer();
        sb.append("/users");
        sb.append("\t");
        int i = 0;
        while (i < names.length) {
            sb.append(names[i]);
            sb.append("\t");
            ++i;
        }
        return sb.toString();
    }

    public static final String constructUserJoinedRoomMessage(String user, String room) {
        StringBuffer sb = new StringBuffer();
        sb.append("/roomuser");
        sb.append("\t");
        sb.append(room);
        sb.append("\t");
        sb.append("+");
        sb.append("\t");
        sb.append(user);
        return sb.toString();
    }

    public static final String constructUserPartedRoomMessage(String user, String room, boolean signOff) {
        StringBuffer sb = new StringBuffer();
        sb.append("/roomuser");
        sb.append("\t");
        sb.append(room);
        sb.append("\t");
        sb.append("-");
        sb.append("\t");
        sb.append(user);
        return sb.toString();
    }

    public static final String constructPartRoomAck(String room) {
        StringBuffer sb = new StringBuffer();
        sb.append("/ack_part");
        sb.append("\t");
        sb.append(room);
        return sb.toString();
    }

    public static final String constructPrivateEmoteMessage(String from, String msg) {
        StringBuffer sb = new StringBuffer();
        sb.append("/mesg");
        sb.append("\t");
        sb.append(from);
        sb.append("\t");
        sb.append(msg);
        return sb.toString();
    }

    public static final String constructRoomListMessage(String[] rooms) {
        StringBuffer sb = new StringBuffer();
        sb.append("/rooms");
        sb.append("\t");
        int i = 0;
        while (i < rooms.length) {
            sb.append(rooms[i]);
            sb.append("\t");
            ++i;
        }
        return sb.toString();
    }

    public static final String constructPing(String user, String arg) {
        StringBuffer sb = new StringBuffer();
        sb.append("/ping");
        sb.append("\t");
        sb.append(user);
        sb.append("\t");
        sb.append(arg);
        return sb.toString();
    }

    public static final String constructPong(String user, String arg) {
        StringBuffer sb = new StringBuffer();
        sb.append("/pong");
        sb.append("\t");
        sb.append(user);
        sb.append("\t");
        sb.append(arg);
        return sb.toString();
    }

    public static final String constructGeneralRoomMessage(String room, String msg) {
        StringBuffer sb = new StringBuffer();
        sb.append("/room_msg");
        sb.append("\t");
        sb.append(room);
        sb.append("\t");
        sb.append(msg);
        return sb.toString();
    }

    public static String constructRoomJoinError(String s, String room) {
        StringBuffer sb = new StringBuffer(s);
        sb.append("\t");
        sb.append(room);
        return sb.toString();
    }

    public static String constructSignOnError(String s, String user) {
        StringBuffer sb = new StringBuffer(s);
        sb.append("\t");
        sb.append(user);
        return sb.toString();
    }

    public static String constructError(String type, String arg) {
        StringBuffer sb = new StringBuffer(type);
        if (arg != null) {
            sb.append("\t");
            sb.append(arg);
        }
        return sb.toString();
    }

    public static String constructKilled(String killer, String msg) {
        StringBuffer sb = new StringBuffer("/kill");
        sb.append("\t");
        sb.append(killer);
        sb.append("\t");
        sb.append(msg);
        return sb.toString();
    }

    public static String constructIgnoreListMessage(String[] ignorees) {
        StringBuffer sb = new StringBuffer();
        sb.append("/ignorelist");
        sb.append("\t");
        int i = 0;
        while (i < ignorees.length) {
            sb.append(ignorees[i]);
            sb.append("\t");
            ++i;
        }
        return sb.toString();
    }

    public static String constructAckKill(String victim) {
        StringBuffer sb = new StringBuffer("/ack_kill");
        sb.append("\t");
        sb.append(victim);
        return sb.toString();
    }

    public static String constructEmote(String user, String room, String message) {
        StringBuffer sb = new StringBuffer("/me");
        sb.append("\t");
        sb.append(user);
        sb.append("\t");
        sb.append(room);
        sb.append("\t");
        sb.append(message);
        return sb.toString();
    }

    public static String constructUserSignOn(String userId) {
        return CommandMakerRemote.constructUserDiff(userId, "+");
    }

    public static String constructUserSignOff(String userId) {
        return CommandMakerRemote.constructUserDiff(userId, "-");
    }

    private static String constructUserDiff(String userId, String diff) {
        StringBuffer sb = new StringBuffer("/user");
        sb.append("\t");
        sb.append(diff);
        sb.append("\t");
        sb.append(userId);
        return sb.toString();
    }

    public static String constructRoomCreated(String room) {
        return CommandMakerRemote.constructRoomDiff(room, "+");
    }

    public static String constructRoomDestroyed(String room) {
        return CommandMakerRemote.constructRoomDiff(room, "-");
    }

    private static String constructRoomDiff(String room, String diff) {
        StringBuffer sb = new StringBuffer("/room");
        sb.append("\t");
        sb.append(diff);
        sb.append("\t");
        sb.append(room);
        return sb.toString();
    }
}

