/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote;

import com.lyrisoft.chat.ICommands;
import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.server.remote.ChatClient;
import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.RoomJoinException;
import com.lyrisoft.chat.server.remote.TimedUserList;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class RoomServer
implements ICommands {
    protected String _roomName;
    protected ArrayList _users;
    protected HashMap _ops;
    protected TimedUserList _kickedUsers;
    protected ChatServer _server;
    private String _password;

    public RoomServer(String name, ChatServer server) {
        this._server = server;
        this._roomName = name;
        this._users = new ArrayList();
        this._ops = new HashMap();
        this._kickedUsers = new TimedUserList(this._server.getKickBanSeconds());
    }

    public RoomServer(String name, String password, ChatServer server) {
        this(name, server);
        this._password = password;
    }

    public ChatClient getOldestClient() {
        ArrayList arrayList = this._users;
        synchronized (arrayList) {
            return this._users.size() > 0 ? (ChatClient)this._users.get(0) : null;
        }
    }

    public String getName() {
        return this._roomName;
    }

    public boolean isEmpty() {
        return this._users.size() == 0;
    }

    public void broadcast(String message) {
        ArrayList arrayList = this._users;
        synchronized (arrayList) {
            Iterator i = ((AbstractList)this._users).iterator();
            while (i.hasNext()) {
                ChatClient rcpt = (ChatClient)i.next();
                rcpt.generalRoomMessage(this._roomName, message);
            }
        }
    }

    public void emote(ChatClient sender, String message) {
        this.emote(sender.getUserId(), message);
    }

    public void emote(String from, String message) {
        ArrayList arrayList = this._users;
        synchronized (arrayList) {
            Iterator i = ((AbstractList)this._users).iterator();
            while (i.hasNext()) {
                ChatClient rcpt = (ChatClient)i.next();
                rcpt.emote(from, this._roomName, message);
            }
        }
    }

    public void say(ChatClient sender, String message) {
        String from = sender.getUserId();
        this.say(from, message);
    }

    public void say(String from, String message) {
        ArrayList arrayList = this._users;
        synchronized (arrayList) {
            Iterator i = ((AbstractList)this._users).iterator();
            while (i.hasNext()) {
                ChatClient rcpt = (ChatClient)i.next();
                rcpt.messageFromUser(from, this._roomName, message);
            }
        }
    }

    protected void notifyJoin(String userId) {
        ArrayList arrayList = this._users;
        synchronized (arrayList) {
            Iterator i = ((AbstractList)this._users).iterator();
            while (i.hasNext()) {
                ((ChatClient)i.next()).userJoinedRoom(userId, this._roomName);
            }
        }
    }

    public void remoteJoin(String username, String password) {
        this.notifyJoin(username);
    }

    protected void notifyPart(String userId, boolean isSignoff) {
        ArrayList arrayList = this._users;
        synchronized (arrayList) {
            ChatClient rcpt = null;
            Iterator i = ((AbstractList)this._users).iterator();
            while (i.hasNext()) {
                rcpt = (ChatClient)i.next();
                rcpt.userPartedRoom(userId, this._roomName, isSignoff);
            }
        }
    }

    public void remotePart(String username, boolean isSignoff) {
        this.notifyPart(username, isSignoff);
    }

    public void join(ChatClient client, String password) throws RoomJoinException {
        ChatClient nextOp;
        String userId = client.getUserId();
        int level = this._server.getRoomAccessLevel(client, this);
        if (level == 0 || this._kickedUsers.contains(userId) || this._password != null && !this._password.equals(password)) {
            throw new RoomJoinException("/roomaccessdenied");
        }
        ArrayList arrayList = this._users;
        synchronized (arrayList) {
            if (!this._users.contains(client)) {
                this.notifyJoin(client.getUserId());
                this._users.add(client);
                client.ackJoinRoom(this._roomName);
            }
        }
        if (level >= 2) {
            this.op(client);
        } else if (this._ops.size() == 0 && (nextOp = this._server.getRoomNextOp(this)) != null) {
            this.op(nextOp);
        }
    }

    public void op(ChatClient client) {
        this.op(null, client);
    }

    public void deop(ChatClient client) {
        this.deop(null, client);
    }

    public void op(ChatClient op, ChatClient newOp) {
        HashMap hashMap = this._ops;
        synchronized (hashMap) {
            if (op == null || this._ops.keySet().contains(ChatServer.clientKey(op))) {
                if (!this._ops.keySet().contains(ChatServer.clientKey(newOp))) {
                    this._ops.put(ChatServer.clientKey(newOp), newOp);
                    newOp.generalMessage(Translator.getMessage("op.add.confirm", this._roomName));
                    String actor = op == null ? "server" : op.getUserId();
                    this.broadcast(Translator.getMessage("op.add", actor, newOp.getUserId()));
                }
            } else {
                op.generalError(Translator.getMessage("op.denied"));
            }
        }
    }

    public void deop(ChatClient op, ChatClient newOp) {
        HashMap hashMap = this._ops;
        synchronized (hashMap) {
            if (op == null || this._ops.keySet().contains(ChatServer.clientKey(op))) {
                ChatClient nextOp;
                if (this._ops.keySet().contains(ChatServer.clientKey(newOp))) {
                    this._ops.remove(ChatServer.clientKey(newOp));
                    newOp.generalMessage(Translator.getMessage("op.remove.confirm", this._roomName));
                    String actor = op == null ? "server" : op.getUserId();
                    this.broadcast(Translator.getMessage("op.remove", actor, newOp.getUserId()));
                }
                if (this._ops.size() == 0 && (nextOp = this._server.getRoomNextOp(this)) != null) {
                    this.op(nextOp);
                }
            } else {
                op.generalError(Translator.getMessage("op.denied"));
            }
        }
    }

    public void part(ChatClient client, boolean isSignoff) {
        String userId = client.getUserId();
        ArrayList arrayList = this._users;
        synchronized (arrayList) {
            if (((AbstractCollection)this._users).remove(client)) {
                if (this._server.getClient(userId) != null) {
                    client.ackPartRoom(this._roomName);
                }
                this.notifyPart(userId, isSignoff);
            }
        }
        this.deop(client);
    }

    public void kick(ChatClient kicker, String victim) {
        if (kicker.getAccessLevel() >= 100 || this._ops.keySet().contains(ChatServer.clientKey(kicker))) {
            ChatClient victimClient = this._server.getClient(victim);
            if (victimClient == null || !this._users.contains(victimClient)) {
                kicker.error("/nosuchuser", victim);
            } else {
                this._kickedUsers.add(victim);
                this._server.partRoom(victimClient, this._roomName);
                victimClient.generalMessage(Translator.getMessage("kicked", this._roomName, kicker.getUserId()));
                this.broadcast(Translator.getMessage("kick.room.msg", kicker.getUserId(), victim));
            }
        }
    }

    public int getUserCount() {
        return this._users.size();
    }

    public String[] getUsers() {
        String[] names = new String[this._users.size()];
        ArrayList arrayList = this._users;
        synchronized (arrayList) {
            int j = 0;
            Iterator i = ((AbstractList)this._users).iterator();
            while (i.hasNext()) {
                String name = ((ChatClient)i.next()).getUserId();
                names[j++] = name;
            }
        }
        return names;
    }

    public void invite(ChatClient inviter, String invitee) {
    }

    public void uninvite(ChatClient inviter, String invitee) {
    }
}

