/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote;

import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.util.MultiValueHashMap;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class RoomTable {
    private HashMap _rooms = new HashMap();
    private HashMap _roomNames = new HashMap();
    private ChatServer _server;

    public RoomTable(ChatServer server) {
        this._server = server;
    }

    public boolean userExistsInRoom(String username, String roomname) {
        return this.getUsers(roomname).contains(username);
    }

    public boolean roomExists(String roomname) {
        return this._roomNames.keySet().contains(roomname);
    }

    public Collection getRoomNames() {
        LinkedList newList = new LinkedList();
        newList.addAll(this._roomNames.values());
        return newList;
    }

    public Collection getUsers(String room) {
        LinkedList newList = new LinkedList();
        String key = MultiValueHashMap.key(room);
        Map users = (Map)this._rooms.get(key);
        if (users != null) {
            newList.addAll(users.values());
        }
        return newList;
    }

    public int countUsers(String room) {
        return MultiValueHashMap.size(this._rooms, MultiValueHashMap.key(room));
    }

    public boolean join(String room, String user) {
        String key = MultiValueHashMap.key(room);
        boolean isNew = MultiValueHashMap.size(this._rooms, key) == 0;
        MultiValueHashMap.put(this._rooms, key, user);
        if (isNew) {
            this._roomNames.put(key, room);
        }
        return isNew;
    }

    public boolean part(String room, String user) {
        String key = MultiValueHashMap.key(room);
        MultiValueHashMap.remove(this._rooms, key, user);
        if (MultiValueHashMap.size(this._rooms, key) == 0) {
            this._roomNames.remove(key);
            this._rooms.remove(key);
            return true;
        }
        return false;
    }

    private String internalPart(String room, String user) {
        String key = MultiValueHashMap.key(room);
        MultiValueHashMap.remove(this._rooms, key, user);
        if (MultiValueHashMap.size(this._rooms, key) == 0) {
            return key;
        }
        return null;
    }

    public Collection signoff(String user) {
        LinkedList deadRooms = new LinkedList();
        Iterator i = this._roomNames.values().iterator();
        while (i.hasNext()) {
            String room = (String)i.next();
            String deadRoom = this.internalPart(room, user);
            if (deadRoom == null) continue;
            i.remove();
            this._rooms.remove(deadRoom);
        }
        return deadRooms;
    }

    public void dump(PrintStream out) {
        out.println("RoomTable dump:");
        MultiValueHashMap.dump(this._rooms, out);
    }
}

