/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote;

import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.util.MultiValueHashMap;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class ServerTable {
    private HashMap _servers = new HashMap();
    private HashMap _serverNames = new HashMap();
    private HashMap _serverPings = new HashMap();
    private ChatServer _server;

    public ServerTable(ChatServer server) {
        this._server = server;
    }

    public boolean userExists(String username) {
        Iterator i = this._servers.values().iterator();
        while (i.hasNext()) {
            Map users = (Map)i.next();
            if (users.get(MultiValueHashMap.key(username)) == null) continue;
            return true;
        }
        return false;
    }

    public int countUsers(String servername) {
        Map m = (Map)this._servers.get(MultiValueHashMap.key(servername));
        if (m != null) {
            return m.size();
        }
        return 0;
    }

    public boolean serverExists(String servername) {
        return this._servers.get(MultiValueHashMap.key(servername)) != null;
    }

    public void setLastBroadcastPing(String server, long time) {
        String key = MultiValueHashMap.key(server);
        this._serverPings.put(key, new Long(time));
    }

    public long getLastPingReply(String server) {
        Long l = (Long)this._serverPings.get(MultiValueHashMap.key(server));
        if (l != null) {
            return l;
        }
        return 0L;
    }

    public Collection getAllUsers() {
        LinkedList allUsers = new LinkedList();
        Iterator i = this._servers.values().iterator();
        while (i.hasNext()) {
            HashMap users = (HashMap)i.next();
            if (users == null) continue;
            allUsers.addAll(users.values());
        }
        return allUsers;
    }

    public Collection getUsers(String server) {
        LinkedList newList = new LinkedList();
        HashMap users = (HashMap)this._servers.get(MultiValueHashMap.key(server));
        if (users != null) {
            newList.addAll(users.values());
        }
        return newList;
    }

    public void add(String server) {
        String key = MultiValueHashMap.key(server);
        boolean reconnect = false;
        if (this._servers.keySet().contains(key)) {
            this._server.serverSignOff(server);
            reconnect = true;
        }
        this._servers.put(key, new HashMap());
        this._serverNames.put(key, server);
        this.setLastBroadcastPing(server, System.currentTimeMillis());
        if (reconnect) {
            ChatServer.log("Server " + server + " reconnected.");
        } else {
            ChatServer.log("Server " + server + " connected.");
        }
    }

    public void delete(String server) {
        String key = MultiValueHashMap.key(server);
        this._servers.remove(key);
        this._serverNames.remove(key);
        this._serverPings.remove(key);
    }

    public Collection getServerNames() {
        LinkedList newList = new LinkedList();
        newList.addAll(this._serverNames.values());
        return newList;
    }

    public void signon(String server, String user) {
        String key = MultiValueHashMap.key(server);
        if (!this._serverNames.keySet().contains(key)) {
            this.add(server);
        }
        MultiValueHashMap.put(this._servers, key, user);
    }

    public void signoff(String server, String user) {
        MultiValueHashMap.remove(this._servers, MultiValueHashMap.key(server), user);
    }

    public void dump(PrintStream out) {
        out.println("ServerTable dump:");
        MultiValueHashMap.dump(this._servers, out);
    }

    public void checkServerPings(long timeout) {
        LinkedList<String> deadServers = new LinkedList<String>();
        Iterator<Object> i = this._serverPings.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String name = (String)this._serverNames.get(key);
            if (key.equalsIgnoreCase(this._server.getName())) continue;
            long now = System.currentTimeMillis();
            long last = this.getLastPingReply(key);
            if (last + timeout < now) {
                ChatServer.log("Ping timeout for server: " + name);
                deadServers.add(key);
                continue;
            }
            if (!ChatServer.DEBUG) continue;
            double remaining = (double)(last + timeout - now) / 60000.0;
            ChatServer.DEBUG("Ping for " + name + " is ok.  (" + remaining + " minutes remaining.)");
        }
        i = deadServers.iterator();
        while (i.hasNext()) {
            this._server.serverSignOff((String)i.next());
        }
    }
}

