/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote;

import com.lyrisoft.chat.IConnectionHandler;
import com.lyrisoft.chat.IConnectionListener;
import com.lyrisoft.chat.server.remote.TunnelServlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletConnectionHandler
implements IConnectionHandler {
    private String _id;
    private IConnectionListener _connectionListener;
    private String _host;
    protected LinkedList _queue;
    private TunnelServlet _tunnelServlet;

    public ServletConnectionHandler(TunnelServlet tunnelServlet, HttpServletRequest request, String id) {
        this._tunnelServlet = tunnelServlet;
        this._id = id;
        this._host = request.getRemoteAddr();
        this._queue = new LinkedList();
        this.queueMessage(id);
    }

    public String getId() {
        return this._id;
    }

    public String getHost() {
        return this._host;
    }

    public void setListener(IConnectionListener listener) {
        this._connectionListener = listener;
    }

    public void incoming(String s) {
        this._connectionListener.incomingMessage(s);
    }

    void block() {
        try {
            while (this._queue.size() == 0) {
                Thread.sleep(25L);
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    protected void flush(PrintWriter out) {
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            while (this._queue.size() > 0) {
                String message = (String)this._queue.removeFirst();
                out.println(message);
            }
        }
    }

    public void flushNewMessagesOrBlock(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.block();
        PrintWriter out = response.getWriter();
        this.flush(out);
        out.flush();
        out.close();
    }

    public void queueMessage(String message) {
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            this._queue.add(message);
        }
    }

    public void sendImmediately(String message) {
        throw new UnsupportedOperationException("ServletConnectionHandler cannot send a message immeditately");
    }

    public void shutdown(boolean notify) {
        if (notify) {
            this._connectionListener.socketClosed();
        }
        this._tunnelServlet.remove(this);
    }
}

