/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

class TimedUserList {
    ArrayList _users = new ArrayList(2);
    int _seconds;

    public TimedUserList(int seconds) {
        this._seconds = seconds;
    }

    public void add(String userId) {
        ArrayList arrayList = this._users;
        synchronized (arrayList) {
            this._users.add(new UserRecord(userId));
        }
    }

    public boolean contains(String userId) {
        long now = System.currentTimeMillis();
        ArrayList arrayList = this._users;
        synchronized (arrayList) {
            Iterator i = ((AbstractList)this._users).iterator();
            while (i.hasNext()) {
                UserRecord u = (UserRecord)i.next();
                if (now > u.whenAdded + (long)(this._seconds * 1000)) {
                    i.remove();
                    continue;
                }
                if (!u.userId.equalsIgnoreCase(userId)) continue;
                return true;
            }
        }
        return false;
    }

    private class UserRecord {
        public String userId;
        public long whenAdded;

        public UserRecord(String userId) {
            this.userId = userId;
            this.whenAdded = System.currentTimeMillis();
        }
    }
}

