/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote;

import com.lyrisoft.chat.server.remote.ChatClient;
import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.ServletConnectionHandler;
import com.lyrisoft.util.io.ResourceLoader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TunnelServlet
extends HttpServlet
implements Runnable {
    protected ChatServer _chatServer;
    protected Thread _runner;
    protected HashMap _connectionHandlers;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ResourceLoader.setServletContext(this.getServletContext());
        this._connectionHandlers = new HashMap();
        String chatServerClass = config.getInitParameter("chatServerClass");
        if (chatServerClass == null) {
            chatServerClass = "com.lyrisoft.chat.server.remote.ChatServer";
        }
        try {
            String conf = config.getInitParameter("config");
            if (conf == null) {
                Class<?> chatServer = Class.forName(chatServerClass);
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("javax.servlet.ServletContext");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Constructor<?> constructor = chatServer.getConstructor(classArray);
                this._chatServer = (ChatServer)constructor.newInstance(this.getServletContext());
            } else {
                Class<?> chatServer = Class.forName(chatServerClass);
                Class[] classArray = new Class[2];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("javax.servlet.ServletContext");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz2;
                Constructor<?> constructor = chatServer.getConstructor(classArray);
                this._chatServer = (ChatServer)constructor.newInstance(conf, this.getServletContext());
            }
            config.getServletContext().setAttribute("chatServer", (Object)this._chatServer);
            ChatServer.log("ChatServer started by the Servlet");
            this._runner = new Thread(this);
            this._runner.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException(e.toString());
        }
    }

    public void pleaseStop() {
        this._chatServer.pleaseStop();
    }

    public void run() {
        this._chatServer.acceptConnections();
    }

    void remove(ServletConnectionHandler handler) {
        this._connectionHandlers.remove(handler.getId());
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        String id = request.getParameter("id");
        if (id == null) {
            id = String.valueOf(System.currentTimeMillis());
            ServletConnectionHandler handler = this.createServletConnectionHandler(request, id);
            this._connectionHandlers.put(id, handler);
            ChatClient c = this.createChatClient(handler);
            this._chatServer._vulture.addClient(c);
            handler.flushNewMessagesOrBlock(request, response);
        } else {
            ServletConnectionHandler handler = (ServletConnectionHandler)this._connectionHandlers.get(id);
            if (handler != null) {
                handler.flushNewMessagesOrBlock(request, response);
            } else {
                response.setStatus(204);
            }
        }
    }

    public ServletConnectionHandler createServletConnectionHandler(HttpServletRequest request, String id) {
        return new ServletConnectionHandler(this, request, id);
    }

    public ChatClient createChatClient(ServletConnectionHandler handler) {
        return new ChatClient(this._chatServer, handler);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        String id = request.getParameter("id");
        String arg = request.getParameter("arg");
        if (id != null && arg != null) {
            ServletConnectionHandler handler = (ServletConnectionHandler)this._connectionHandlers.get(id);
            if (handler != null) {
                handler.incoming(arg);
                out.println("ok");
            } else {
                out.println("You do not exist.  Go away.");
            }
            out.close();
        } else {
            out.println("bad request.");
        }
        out.close();
    }

    public void destroy() {
        if (this._runner == null) {
            return;
        }
        try {
            this.pleaseStop();
            if (this._runner.isAlive()) {
                System.err.println("Forcefully killing the accept thread.");
                this._runner.stop();
            }
        }
        catch (Throwable t) {
            System.err.println("Exception during TunnelServlet.destroy");
            t.printStackTrace();
        }
    }
}

