/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote.command;

import com.lyrisoft.chat.Constants;
import com.lyrisoft.chat.ICommands;
import com.lyrisoft.chat.server.remote.ChatClient;
import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.command.CommandBase;

public class Pong
extends CommandBase
implements Constants,
ICommands {
    public boolean process(ChatClient client, String[] args) {
        if (args.length < 3) {
            client.generalError(this.getUsage(args[0]));
            return false;
        }
        if (args[1].equals("server")) {
            client.setLastServerPong(Long.parseLong(args[2]));
            return false;
        }
        ChatClient otherClient = client.getServer().getClient(args[1]);
        if (otherClient == null) {
            if (!client.getServer().userExists(args[1])) {
                client.error("/nosuchuser", args[1]);
                return false;
            }
            return true;
        }
        otherClient.pong(client.getUserId(), args[2]);
        return false;
    }

    public void processDistributed(String client, String origin, String[] args, ChatServer server) {
        if (args.length < 3) {
            return;
        }
        if (args[1].equals(server.getName())) {
            server.handlePong(origin, args[2]);
        } else {
            ChatClient otherClient = server.getClient(args[1]);
            if (otherClient != null) {
                otherClient.pong(client, args[2]);
            }
        }
    }
}

