/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote.command;

import com.lyrisoft.chat.ICommands;
import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.server.remote.AccessDenied;
import com.lyrisoft.chat.server.remote.AccessException;
import com.lyrisoft.chat.server.remote.ChatClient;
import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.command.CommandBase;

public class SignOn
extends CommandBase
implements ICommands {
    public boolean process(ChatClient client, String[] args) {
        if (args.length < 2) {
            client.generalError(this.getUsage(args[0]));
            return false;
        }
        if (client.getUserId() != null) {
            client.generalError(Translator.getMessage("already_on"));
            return false;
        }
        client.setUserId(args[1]);
        try {
            if (args.length < 3) {
                client.getServer().signOn(client, null);
            } else {
                client.getServer().signOn(client, args[2]);
            }
            return true;
        }
        catch (AccessException e) {
            String userId = client.getUserId();
            client.setUserId(null);
            client.signOnError(e.getMessage(), userId);
        }
        catch (AccessDenied e) {
            client.setUserId(null);
            client.error("/denied", e.getMessage());
        }
        return false;
    }

    public void processDistributed(String client, String origin, String[] args, ChatServer server) {
        server.remoteSignOn(origin, client);
    }
}

