/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote.command;

import com.lyrisoft.chat.ICommands;
import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.server.remote.ChatClient;
import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.Formatter;
import com.lyrisoft.chat.server.remote.command.CommandBase;
import java.util.Date;
import java.util.Vector;

public class Whois
extends CommandBase
implements ICommands {
    public boolean process(ChatClient client, String[] args) {
        if (args.length < 2) {
            client.generalError(this.getUsage(args[0]));
            return false;
        }
        ChatClient otherGuy = client.getServer().getClient(args[1]);
        if (otherGuy == null) {
            if (!client.getServer().userExists(args[1])) {
                client.error("/nosuchuser", args[1]);
                return false;
            }
            return true;
        }
        String[] whois = this.getWhois(otherGuy);
        int i = 0;
        while (i < whois.length) {
            client.generalMessage(whois[i]);
            ++i;
        }
        return false;
    }

    public void processDistributed(String client, String origin, String[] args, ChatServer server) {
        ChatClient otherGuy = server.getClient(args[1]);
        if (otherGuy != null) {
            String[] whois = this.getWhois(otherGuy);
            int i = 0;
            while (i < whois.length) {
                server.distribute(otherGuy, "/rclient\t" + client + "\t" + whois[i]);
                ++i;
            }
        } else {
            System.err.println(String.valueOf(args[1]) + " not found for whois");
        }
    }

    String[] getWhois(ChatClient c) {
        Vector<String> v = new Vector<String>();
        v.add(Translator.getMessage("whois.user", c.getUserId()));
        v.add("  " + Translator.getMessage("whois.host", c.getHost()));
        v.add("  " + Translator.getMessage("whois.since", new Date(c.getConnectionTime()).toString()));
        v.add("  " + Translator.getMessage("whois.idle", Formatter.millisToString(c.getIdle())));
        v.add("  " + Translator.getMessage("whois.access", String.valueOf(c.getAccessLevel())));
        v.add("  " + Translator.getMessage("whois.server", c.getServer().getName()));
        v.add("  " + Translator.getMessage("whois.ping", String.valueOf(c.getServerPingAvg()), String.valueOf(c.getServerPingCount())));
        String version = c.getClientVersion();
        if (version != null) {
            v.add("  " + Translator.getMessage("whois.version", version));
        }
        Object[] whois = new String[v.size()];
        v.copyInto(whois);
        return whois;
    }
}

