/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote.persistence;

import com.lyrisoft.chat.server.remote.ChatServer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JdbcStatementTemplate {
    private static final Pattern _p = Pattern.compile(":.+?\\b");
    private String[] _varNames;
    private PreparedStatement _ps;
    private Connection _conn;
    private HashMap _varMap;

    public JdbcStatementTemplate(Connection c, String[] varNames) {
        this._varNames = varNames;
        this._conn = c;
    }

    public void parse(String sql) {
        this._varMap = new HashMap(5);
        try {
            ChatServer.log("Parsing " + sql);
            Matcher m = _p.matcher(sql);
            int i = 1;
            while (m.find()) {
                String var = sql.substring(m.start(), m.end());
                this._varMap.put(var, new Integer(i));
                ++i;
            }
            String parsedSql = m.replaceAll("?");
            this._ps = this._conn.prepareStatement(parsedSql);
            ChatServer.log("Parsed to " + parsedSql);
        }
        catch (Exception e) {
            ChatServer.log(e);
        }
    }

    public PreparedStatement bind(Object[] vars) {
        try {
            int i = 0;
            while (i < this._varNames.length) {
                Integer j = (Integer)this._varMap.get(this._varNames[i]);
                if (j != null) {
                    this._ps.setObject(j, vars[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            ChatServer.log(e);
        }
        return this._ps;
    }
}

