/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote.persistence.auth;

import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.server.remote.AccessDenied;
import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.persistence.Jdbc;
import com.lyrisoft.chat.server.remote.persistence.auth.Auth;
import com.lyrisoft.chat.server.remote.persistence.auth.NullAuthenticator;
import com.lyrisoft.util.properties.PropertyException;
import com.lyrisoft.util.properties.PropertyTool;
import java.security.MessageDigest;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class JdbcAuthenticator
extends NullAuthenticator {
    private static final int NONE = 0;
    private static final int MYSQL = 1;
    private static final int MD5 = 2;
    private int _cryptMethod = 0;
    private MessageDigest _digest;
    private PreparedStatement _countStmt;
    private PreparedStatement _selectStmt;
    private PreparedStatement _insertStmt;

    public JdbcAuthenticator(ChatServer server, boolean allowGuests, boolean storeGuests) {
        super(server, allowGuests, storeGuests);
        try {
            String table = PropertyTool.getString("jdbc.Table", Jdbc.p);
            String idField = PropertyTool.getString("jdbc.IdField", Jdbc.p);
            String passwordField = PropertyTool.getString("jdbc.PasswordField", Jdbc.p);
            String authField = PropertyTool.getString("jdbc.AuthField", Jdbc.p);
            try {
                if (PropertyTool.getBoolean("jdbc.CryptPassword", Jdbc.p)) {
                    this._cryptMethod = 1;
                }
            }
            catch (PropertyException propertyException) {
                // empty catch block
            }
            try {
                String cType = PropertyTool.getString("jdbc.CryptMethod", Jdbc.p);
                if (cType.equalsIgnoreCase("md5")) {
                    this._cryptMethod = 2;
                    this._digest = MessageDigest.getInstance("MD5");
                } else if (cType.equalsIgnoreCase("mySQL")) {
                    this._cryptMethod = 1;
                }
            }
            catch (PropertyException cType) {
                // empty catch block
            }
            this._countStmt = Jdbc.conn.prepareStatement("SELECT COUNT(*) FROM " + table + " WHERE lower(" + idField + ") = lower(?)");
            String query = "SELECT " + authField + " FROM " + table + " WHERE " + idField + "=? ";
            query = this._cryptMethod == 1 ? String.valueOf(query) + "AND " + passwordField + "=password(?)" : String.valueOf(query) + "AND " + passwordField + "=?";
            this._selectStmt = Jdbc.conn.prepareStatement(query);
            query = "INSERT INTO " + table + " (" + idField + ", " + passwordField + ", " + authField + ")";
            query = this._cryptMethod == 1 ? String.valueOf(query) + " VALUES (?, password(?), ?)" : String.valueOf(query) + " VALUES (?, ?, ?)";
            this._insertStmt = Jdbc.conn.prepareStatement(query);
            if (this._allowGuests) {
                if (this._storeGuests) {
                    ChatServer.log("JDBC authentication initialized. Guest access allowed, adding guests to the database.");
                } else {
                    ChatServer.log("JDBC authentication initialized. Guest access allowed, not adding guests to the database.");
                }
            } else {
                ChatServer.log("JDBC authentication initialized. No guest access allowed.");
            }
        }
        catch (Exception e) {
            ChatServer.log(e);
            throw new RuntimeException(e.toString());
        }
    }

    private String encrypt(String password) {
        if (password == null) {
            password = "";
        }
        if (this._cryptMethod == 2) {
            return this.asHexString(this._digest.digest(password.getBytes()));
        }
        return password;
    }

    private String asHexString(byte[] b) {
        StringBuffer buffer = new StringBuffer(b.length * 2);
        int i = 0;
        while (i < b.length) {
            if ((b[i] & 0xFF) < 16) {
                buffer.append("0");
            }
            buffer.append(Long.toString(b[i] & 0xFF, 16));
            ++i;
        }
        return buffer.toString();
    }

    public boolean isExistingUser(String userId) {
        return super.isExistingUser(userId) || this.isStoredUser(userId);
    }

    private final synchronized boolean isStoredUser(String userId) {
        boolean exists = false;
        try {
            this._countStmt.setString(1, userId);
            ResultSet rs = this._countStmt.executeQuery();
            if (rs.next()) {
                exists = rs.getInt(1) > 0;
            }
            rs.close();
        }
        catch (Exception e) {
            ChatServer.log(e);
        }
        return exists;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized Auth authenticate(String userId, String password) throws AccessDenied {
        block18: {
            block15: {
                block17: {
                    block14: {
                        rs = null;
                        try {
                            try {
                                this._selectStmt.setString(1, userId);
                                this._selectStmt.setString(2, this.encrypt(password));
                                rs = this._selectStmt.executeQuery();
                                ChatServer.log("Jdbc auth attempting " + userId);
                                if (rs.next()) {
                                    var7_4 = new Auth(userId, rs.getInt(1));
                                    var5_6 = null;
                                    break block14;
                                }
                                if (this._allowGuests == false) throw new AccessDenied(userId);
                                auth = super.authenticate(userId, password);
                                if (this._storeGuests) {
                                    this._insertStmt.setString(1, auth.getUserId());
                                    this._insertStmt.setString(2, this.encrypt(password));
                                    this._insertStmt.setInt(3, 1);
                                    this._insertStmt.executeUpdate();
                                }
                                var7_5 = auth;
                                break block15;
                            }
                            catch (SQLException sqle) {
                                ChatServer.log(sqle);
                                ChatServer.logError("  SQLException: " + sqle.getMessage());
                                ChatServer.logError("  SQLState:     " + sqle.getSQLState());
                                ChatServer.logError("  VendorError:  " + sqle.getErrorCode());
                                throw new AccessDenied(Translator.getMessage("sql_error", sqle.toString()));
                            }
                        }
                        catch (Throwable var6_14) {
                            var5_8 = null;
                            try {
                                this._countStmt.clearParameters();
                                this._selectStmt.clearParameters();
                            }
                            catch (SQLException var8_11) {
                                // empty catch block
                            }
                            if (rs == null) throw var6_14;
                            try {
                                rs.close();
                                throw var6_14;
                            }
                            catch (SQLException e) {
                                ChatServer.log(e);
                                throw var6_14;
                            }
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [2 : 290->311)] { 
lbl49:
                    // 1 sources

                    this._countStmt.clearParameters();
                    this._selectStmt.clearParameters();
                    break block17;
lbl52:
                    // 1 sources

                    catch (SQLException var8_9) {
                        // empty catch block
                    }
                }
                if (rs == null) return var7_4;
                ** try [egrp 3[TRYBLOCK] [3 : 317->326)] { 
lbl57:
                // 1 sources

                rs.close();
                return var7_4;
lbl59:
                // 1 sources

                catch (SQLException e) {
                    ChatServer.log(e);
                }
                return var7_4;
            }
            var5_7 = null;
            ** try [egrp 2[TRYBLOCK] [2 : 290->311)] { 
lbl65:
            // 1 sources

            this._countStmt.clearParameters();
            this._selectStmt.clearParameters();
            break block18;
lbl68:
            // 1 sources

            catch (SQLException var8_10) {
                // empty catch block
            }
        }
        if (rs == null) return var7_5;
        ** try [egrp 3[TRYBLOCK] [3 : 317->326)] { 
lbl73:
        // 1 sources

        rs.close();
        return var7_5;
lbl75:
        // 1 sources

        catch (SQLException e) {
            ChatServer.log(e);
        }
        return var7_5;
    }
}

