/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.util.io;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class Logger
extends Thread {
    private PrintWriter _out;
    private boolean _enabled = true;
    private Vector _messages = new Vector();
    private boolean _keepgoing = true;
    private SimpleDateFormat _dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss");

    public Logger(String outputFile, boolean append) throws IOException {
        this(new PrintWriter(new FileWriter(outputFile, append)));
    }

    public Logger(String outputFile) throws IOException {
        this(outputFile, false);
    }

    public Logger(PrintWriter writer) {
        this._out = writer;
        this.start();
    }

    public Logger(PrintStream ps) {
        this._out = new PrintWriter(ps);
        new Thread(this).start();
    }

    public void run() {
        this.setPriority(1);
        while (this._keepgoing) {
            int len = this._messages.size();
            int i = 0;
            while (i < len) {
                Object o = this._messages.elementAt(0);
                this._messages.removeElementAt(0);
                if (o instanceof Exception) {
                    this._log((Exception)o);
                } else {
                    this._log((String)o);
                }
                ++i;
            }
            this._out.flush();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        if (this._out != null) {
            this._out.close();
        }
        this._out = null;
    }

    public void log(String s) {
        if (this._enabled) {
            this._messages.addElement(s);
        }
    }

    public void log(Exception e) {
        if (this._enabled) {
            this._messages.addElement(e);
        }
    }

    private void _log(String s) {
        this._out.println(String.valueOf(this._dateFormat.format(new Date())) + " " + s);
    }

    private void _log(Exception e) {
        this._out.print(String.valueOf(this._dateFormat.format(new Date())) + " ");
        e.printStackTrace(this._out);
    }

    public void setEnabled(boolean b) {
        if (b) {
            System.err.println("Logger enabled.");
        } else {
            System.err.println("Logger disabled.");
        }
        this._enabled = b;
    }

    public void close() {
        this._enabled = false;
        this._keepgoing = false;
    }

    public void finalize() throws Throwable {
        this.close();
    }
}

