/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.util.properties;

import com.lyrisoft.util.io.ResourceException;
import com.lyrisoft.util.io.ResourceLoader;
import com.lyrisoft.util.properties.PropertyException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class PropertyTool {
    public static Properties loadProperties(String relativePath) throws PropertyException {
        try {
            InputStream is = ResourceLoader.getResource(relativePath);
            return PropertyTool.loadProperties(is);
        }
        catch (ResourceException e) {
            throw new PropertyException(e.toString());
        }
    }

    public static Properties loadProperties(InputStream is) throws PropertyException {
        Properties p;
        block10: {
            p = new Properties();
            try {
                try {
                    p.load(is);
                }
                catch (Exception e) {
                    throw new PropertyException(e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            Object var3_5 = null;
            if (is == null) break block10;
            try {
                is.close();
            }
            catch (IOException e) {}
        }
        return p;
    }

    public static String getString(String name, Properties p) throws PropertyException {
        String s = p.getProperty(name);
        if (s == null) {
            throw new PropertyException("No such property: " + name);
        }
        return s;
    }

    public static Vector getStringVector(String name, Properties p) throws PropertyException {
        String s = PropertyTool.getString(name, p);
        StringTokenizer st = new StringTokenizer(s, ", ");
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        return v;
    }

    public static String[] getStringArray(String name, Properties p) throws PropertyException {
        Vector v = PropertyTool.getStringVector(name, p);
        Object[] strings = new String[v.size()];
        v.copyInto(strings);
        return strings;
    }

    public static int getInteger(String name, Properties p) throws PropertyException {
        String s = PropertyTool.getString(name, p);
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new PropertyException("Property " + name + " is not an integer.");
        }
    }

    public static float getFloat(String name, Properties p) throws PropertyException {
        String s = PropertyTool.getString(name, p);
        try {
            return Float.valueOf(s).floatValue();
        }
        catch (NumberFormatException e) {
            throw new PropertyException("Property " + name + " is not a float.");
        }
    }

    public static double getDouble(String name, Properties p) throws PropertyException {
        String s = PropertyTool.getString(name, p);
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new PropertyException("Property " + name + " is not a double.");
        }
    }

    public static boolean getBoolean(String name, Properties p) throws PropertyException {
        String s = PropertyTool.getString(name, p);
        return Boolean.valueOf(s);
    }
}

