/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.bot;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.bot.BotConfiguration;
import megamek.client.bot.Messages;
import megamek.client.bot.PhysicalOption;
import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.GameTurn;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Minefield;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.event.GameListenerAdapter;
import megamek.common.event.GamePlayerChatEvent;
import megamek.common.event.GameReportEvent;
import megamek.common.event.GameTurnChangeEvent;

public abstract class BotClient
extends Client {
    BotConfiguration config = new BotConfiguration();
    private static float[] expectedHitsByRackSize = new float[]{0.0f, 1.0f, 1.58f, 2.0f, 2.63f, 3.17f, 4.0f, 4.49f, 4.98f, 5.47f, 6.31f, 7.23f, 8.14f, 8.59f, 9.04f, 9.5f, 0.0f, 0.0f, 0.0f, 0.0f, 12.7f};

    public BotClient(String string, String string2, int n) {
        super(string, string2, n);
        this.game.addGameListener(new GameListenerAdapter(){

            public void gamePlayerChat(GamePlayerChatEvent gamePlayerChatEvent) {
                BotClient.this.processChat(gamePlayerChatEvent);
            }

            public void gameTurnChange(GameTurnChangeEvent gameTurnChangeEvent) {
                if (BotClient.this.isMyTurn()) {
                    BotClient.this.calculateMyTurn();
                }
            }

            public void gameReport(GameReportEvent gameReportEvent) {
                if (BotClient.this.game.getPhase() == 6) {
                    BotClient.this.sendDone(true);
                }
            }
        });
    }

    public abstract void initialize();

    protected abstract void processChat(GamePlayerChatEvent var1);

    protected abstract void initMovement();

    protected abstract void initFiring();

    protected abstract MovePath calculateMoveTurn();

    protected abstract void calculateFiringTurn();

    protected abstract void calculateDeployment();

    protected abstract PhysicalOption calculatePhysicalTurn();

    protected abstract MovePath continueMovementFor(Entity var1);

    protected abstract Vector calculateMinefieldDeployment();

    protected abstract Vector calculateArtyAutoHitHexes();

    public ArrayList getEntitiesOwned() {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.getOwner().equals(this.getLocalPlayer()) || entity.getPosition() == null || entity.isOffBoard()) continue;
            arrayList.add(entity);
        }
        return arrayList;
    }

    public ArrayList getEnemyEntities() {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.getOwner().isEnemyOf(this.getLocalPlayer()) || entity.getPosition() == null || entity.isOffBoard()) continue;
            arrayList.add(entity);
        }
        return arrayList;
    }

    public void changePhase(int n) {
        super.changePhase(n);
        try {
            switch (n) {
                case 1: {
                    this.sendChat(Messages.getString("BotClient.Hi"));
                    break;
                }
                case 4: {
                    this.initialize();
                    break;
                }
                case 8: {
                    if (this.game.getEntitiesOwnedBy(this.getLocalPlayer()) == 0) {
                        this.sendChat(Messages.getString("BotClient.HowAbout"));
                        this.die();
                    }
                    if (!this.game.getOptions().booleanOption("double_blind") && this.game.getEntitiesOwnedBy(this.getLocalPlayer()) - this.game.getNoOfEntities() == 0) {
                        this.die();
                    }
                    this.initMovement();
                    break;
                }
                case 12: {
                    this.initFiring();
                    break;
                }
                case 14: {
                    break;
                }
                case 17: {
                    this.toggleStealth();
                }
                case 6: 
                case 9: 
                case 11: 
                case 13: 
                case 15: {
                    this.sendDone(true);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void calculateMyTurn() {
        try {
            if (this.game.getPhase() == 8) {
                MovePath movePath = null;
                if (this.game.getTurn() instanceof GameTurn.SpecificEntityTurn) {
                    GameTurn.SpecificEntityTurn specificEntityTurn = (GameTurn.SpecificEntityTurn)this.game.getTurn();
                    Entity entity = this.game.getEntity(specificEntityTurn.getEntityNum());
                    movePath = this.continueMovementFor(entity);
                } else {
                    movePath = this.calculateMoveTurn();
                }
                this.moveEntity(movePath.getEntity().getId(), movePath);
            } else if (this.game.getPhase() == 12) {
                if (this.game.getTurn() instanceof GameTurn.SpecificEntityTurn) {
                    GameTurn.SpecificEntityTurn specificEntityTurn = (GameTurn.SpecificEntityTurn)this.game.getTurn();
                    MovePath movePath = this.continueMovementFor(this.game.getEntity(specificEntityTurn.getEntityNum()));
                    this.moveEntity(movePath.getEntity().getId(), movePath);
                }
                this.calculateFiringTurn();
            } else if (this.game.getPhase() == 14) {
                PhysicalOption physicalOption = this.calculatePhysicalTurn();
                if (null != physicalOption) {
                    this.sendAttackData(physicalOption.attacker.getId(), physicalOption.getVector());
                } else {
                    this.sendAttackData(this.getLocalPlayer().getId(), new Vector(0));
                }
            } else if (this.game.getPhase() == 4) {
                this.calculateDeployment();
            } else if (this.game.getPhase() == 20) {
                Vector vector = this.calculateMinefieldDeployment();
                for (int i = 0; i < vector.size(); ++i) {
                    this.game.addMinefield((Minefield)vector.elementAt(i));
                }
                this.sendDeployMinefields(vector);
                this.sendPlayerInfo();
            } else if (this.game.getPhase() == 22) {
                Vector vector = this.calculateArtyAutoHitHexes();
                this.sendArtyAutoHitHexes(vector);
            } else if (this.game.getPhase() == 7 || this.game.getPhase() == 10) {
                this.sendAttackData(this.game.getFirstEntityNum(), new Vector(0));
                this.sendDone(true);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected Coords getCoordsAround(Entity entity, Coords[] coordsArray) {
        for (int i = 0; i < coordsArray.length; ++i) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            Enumeration enumeration = this.game.getEntities(coordsArray[i]);
            while (enumeration.hasMoreElements()) {
                Entity entity2 = (Entity)enumeration.nextElement();
                if (entity2 instanceof Mech) {
                    ++n;
                    continue;
                }
                if (entity.isEnemyOf(entity2)) {
                    ++n3;
                    continue;
                }
                ++n2;
            }
            if (entity instanceof Mech) {
                ++n;
            } else {
                ++n2;
            }
            if (n > 1 || n2 + n > 2 || n2 + n > 2 || n2 + n3 > 4) continue;
            return coordsArray[i];
        }
        System.out.println("Returning no deployment position; THIS IS BAD!");
        return null;
    }

    protected Coords getStartingCoords() {
        Coords[] coordsArray = this.getStartingCoordsArray();
        if (coordsArray != null && coordsArray.length > 0) {
            return coordsArray[0];
        }
        return null;
    }

    protected Coords[] getStartingCoordsArray() {
        boolean bl;
        Object object;
        Object object2;
        int n;
        double[] dArray;
        Coords[] coordsArray;
        Coords coords = new Coords();
        Coords coords2 = new Coords();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Entity entity = this.getEntity(this.game.getFirstDeployableEntityNum());
        switch (this.getLocalPlayer().getStartingPos()) {
            default: {
                coordsArray = new Coords[this.game.getBoard().getWidth() * this.game.getBoard().getHeight()];
                dArray = new double[this.game.getBoard().getWidth() * this.game.getBoard().getHeight()];
                break;
            }
            case 1: {
                coordsArray = new Coords[3 * this.game.getBoard().getWidth() + 3 * this.game.getBoard().getHeight() - 9];
                dArray = new double[3 * this.game.getBoard().getWidth() + 3 * this.game.getBoard().getHeight() - 9];
                break;
            }
            case 2: {
                coordsArray = new Coords[this.game.getBoard().getWidth() * 3];
                dArray = new double[this.game.getBoard().getWidth() * 3];
                break;
            }
            case 3: {
                coordsArray = new Coords[3 * this.game.getBoard().getWidth() + 3 * this.game.getBoard().getHeight() - 9];
                dArray = new double[3 * this.game.getBoard().getWidth() + 3 * this.game.getBoard().getHeight() - 9];
                break;
            }
            case 4: {
                coordsArray = new Coords[this.game.getBoard().getHeight() * 3];
                dArray = new double[this.game.getBoard().getHeight() * 3];
                break;
            }
            case 5: {
                coordsArray = new Coords[3 * this.game.getBoard().getWidth() + 3 * this.game.getBoard().getHeight() - 9];
                dArray = new double[3 * this.game.getBoard().getWidth() + 3 * this.game.getBoard().getHeight() - 9];
                break;
            }
            case 6: {
                coordsArray = new Coords[this.game.getBoard().getWidth() * 3];
                dArray = new double[this.game.getBoard().getWidth() * 3];
                break;
            }
            case 7: {
                coordsArray = new Coords[3 * this.game.getBoard().getWidth() + 3 * this.game.getBoard().getHeight() - 9];
                dArray = new double[3 * this.game.getBoard().getWidth() + 3 * this.game.getBoard().getHeight() - 9];
                break;
            }
            case 8: {
                coordsArray = new Coords[this.game.getBoard().getHeight() * 3];
                dArray = new double[this.game.getBoard().getHeight() * 3];
            }
        }
        int n2 = 0;
        for (int i = 0; i <= this.game.getBoard().getWidth(); ++i) {
            for (int j = 0; j <= this.game.getBoard().getHeight(); ++j) {
                coords2.x = i;
                coords2.y = j;
                if (!this.game.getBoard().isLegalDeployment(coords2, this.getLocalPlayer()) || entity.isHexProhibited(this.game.getBoard().getHex(coords2.x, coords2.y))) continue;
                coordsArray[n2] = new Coords(coords2);
                ++n2;
            }
        }
        for (n = 0; n < n2; ++n) {
            int n3 = Compute.randomInt(n2);
            if (n3 < 0) {
                n3 = 0;
            }
            coords2 = coordsArray[n];
            coordsArray[n] = coordsArray[n3];
            coordsArray[n3] = coords2;
        }
        Coords[] coordsArray2 = new Coords[n2];
        for (int i = 0; i < n2; ++i) {
            coordsArray2[i] = coordsArray[i];
        }
        coordsArray = coordsArray2;
        int n4 = -100;
        int n5 = 100;
        for (n = 0; n < n2; ++n) {
            if (this.game.getBoard().getHex(coordsArray[n].x, coordsArray[n].y).getElevation() > n4) {
                n4 = this.game.getBoard().getHex(coordsArray[n].x, coordsArray[n].y).getElevation();
            }
            if (this.game.getBoard().getHex(coordsArray[n].x, coordsArray[n].y).getElevation() >= n5) continue;
            n5 = this.game.getBoard().getHex(coordsArray[n].x, coordsArray[n].y).getElevation();
        }
        double d = 0.0;
        int n6 = 0;
        vector = entity.getWeaponList();
        Object object3 = vector.elements();
        while (object3.hasMoreElements()) {
            object2 = (Mounted)object3.nextElement();
            object = (WeaponType)((Mounted)object2).getType();
            if (((EquipmentType)object).getName() == "ATM 3" || ((EquipmentType)object).getName() == "ATM 6" || ((EquipmentType)object).getName() == "ATM 9" || ((EquipmentType)object).getName() == "ATM 12") continue;
            d = entity.getC3Master() != null ? (d += (double)((WeaponType)object).getLongRange() * 1.25) : (d += (double)((WeaponType)object).getLongRange());
            ++n6;
        }
        Enumeration enumeration = entity.getAmmo();
        while (enumeration.hasMoreElements()) {
            object3 = (Mounted)enumeration.nextElement();
            object2 = (AmmoType)((Mounted)object3).getType();
            if (((AmmoType)object2).getAmmoType() != 29) continue;
            ++n6;
            d += 15.0;
            if (((AmmoType)object2).getAmmoType() == 29 && ((AmmoType)object2).getMunitionType() == 64L) {
                d -= 6.0;
            }
            if (((AmmoType)object2).getAmmoType() != 29 || ((AmmoType)object2).getMunitionType() != 32L) continue;
            d += 12.0;
        }
        double d2 = (double)n5 + (d /= (double)n6) / 18.0 * (double)(n4 - n5);
        if (d2 > (double)n4) {
            d2 = n4;
        }
        double d3 = -100.0;
        for (n = 0; n < n2; ++n) {
            double d4;
            WeaponAttackAction weaponAttackAction;
            Entity entity2;
            dArray[n] = -1.0 * Math.abs(d2 - (double)this.game.getBoard().getHex(coordsArray[n].x, coordsArray[n].y).getElevation());
            double d5 = 0.0;
            entity.setPosition(coordsArray[n]);
            vector2 = this.game.getValidTargets(entity);
            object3 = vector2.elements();
            while (object3.hasMoreElements()) {
                entity2 = (Entity)object3.nextElement();
                if (!entity2.isDeployed() || entity2.isOffBoard()) continue;
                vector = entity2.getWeaponList();
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    object = (Mounted)enumeration2.nextElement();
                    weaponAttackAction = new WeaponAttackAction(entity2.getId(), entity.getId(), entity2.getEquipmentNum((Mounted)object));
                    d4 = BotClient.getDeployDamage(this.game, weaponAttackAction);
                    d5 += d4;
                }
            }
            dArray[n] = dArray[n] - d5 / 10.0;
            d5 = 0.0;
            vector = entity.getWeaponList();
            object3 = vector.elements();
            while (object3.hasMoreElements()) {
                Mounted mounted = (Mounted)object3.nextElement();
                double d6 = 0.0;
                object = vector2.elements();
                while (object.hasMoreElements()) {
                    entity2 = (Entity)object.nextElement();
                    if (!entity2.isDeployed() || entity2.isOffBoard() || !((d4 = (double)BotClient.getDeployDamage(this.game, weaponAttackAction = new WeaponAttackAction(entity.getId(), entity2.getId(), entity.getEquipmentNum(mounted)))) > d6)) continue;
                    d6 = d4;
                }
                d5 += d6;
            }
            dArray[n] = dArray[n] + d5 / 10.0;
            if (entity instanceof Mech) {
                if (this.game.getBoard().getHex(coordsArray[n].x, coordsArray[n].y).containsTerrain(1)) {
                    int n7 = n;
                    dArray[n7] = dArray[n7] + 1.0;
                }
                if (this.game.getBoard().getHex(coordsArray[n].x, coordsArray[n].y).containsTerrain(4) && this.game.getBoard().getHex(coordsArray[n].x, coordsArray[n].y).depth() > 1) {
                    int n8 = n;
                    dArray[n8] = dArray[n8] - (double)this.game.getBoard().getHex(coordsArray[n].x, coordsArray[n].y).depth();
                }
            }
            if (entity instanceof Infantry) {
                if (this.game.getBoard().getHex(coordsArray[n].x, coordsArray[n].y).containsTerrain(2)) {
                    int n9 = n;
                    dArray[n9] = dArray[n9] + 1.5;
                }
                if (this.game.getBoard().getHex(coordsArray[n].x, coordsArray[n].y).containsTerrain(1)) {
                    int n10 = n;
                    dArray[n10] = dArray[n10] + 2.0;
                }
                if (this.game.getBoard().getHex(coordsArray[n].x, coordsArray[n].y).containsTerrain(10)) {
                    int n11 = n;
                    dArray[n11] = dArray[n11] + 4.0;
                }
                coords = coordsArray[n];
                object3 = this.game.getEntities(coords);
                while (object3.hasMoreElements()) {
                    entity2 = (Entity)object3.nextElement();
                    if (entity.getOwner() != entity2.getOwner() || entity.equals(entity2) || !(entity2 instanceof Infantry)) continue;
                    int n12 = n;
                    dArray[n12] = dArray[n12] + 2.0;
                    break;
                }
                block23: for (int i = 0; i < 6; ++i) {
                    coords = coordsArray[n];
                    coords = coords.translated(i);
                    object = this.game.getEntities(coords);
                    while (object.hasMoreElements()) {
                        entity2 = (Entity)object.nextElement();
                        if (entity.getOwner() != entity2.getOwner() || entity.equals(entity2) || !(entity2 instanceof Infantry)) continue;
                        int n13 = n;
                        dArray[n13] = dArray[n13] + 1.0;
                        break block23;
                    }
                }
                if (this.game.getBoard().getHex(coordsArray[n].x, coordsArray[n].y).containsTerrain(4)) {
                    int n14 = n;
                    dArray[n14] = dArray[n14] - 10.0;
                }
            }
            if (entity instanceof Tank) {
                if (entity.getMovementMode() == 3 && this.game.getBoard().getHex(coordsArray[n].x, coordsArray[n].y).containsTerrain(1)) {
                    int n15 = n;
                    dArray[n15] = dArray[n15] + 2.0;
                }
                if (entity.getMovementMode() == 5 && this.game.getBoard().getHex(coordsArray[n].x, coordsArray[n].y).containsTerrain(4)) {
                    int n16 = n;
                    dArray[n16] = dArray[n16] + 2.0;
                }
            }
            if (entity instanceof Protomech && this.game.getBoard().getHex(coordsArray[n].x, coordsArray[n].y).containsTerrain(1)) {
                int n17 = n;
                dArray[n17] = dArray[n17] + 2.0;
            }
            if (!(dArray[n] > d3)) continue;
            d3 = dArray[n];
        }
        block25: do {
            bl = false;
            for (int i = 0; i < coordsArray.length - 1; ++i) {
                if (!(dArray[i] < dArray[i + 1])) continue;
                coords2 = coordsArray[i + 1];
                double d7 = dArray[i + 1];
                coordsArray[i + 1] = coordsArray[i];
                dArray[i + 1] = dArray[i];
                coordsArray[i] = coords2;
                dArray[i] = d7;
                bl = true;
                continue block25;
            }
        } while (bl);
        return coordsArray;
    }

    private static float getDeployDamage(IGame iGame, WeaponAttackAction weaponAttackAction) {
        Entity entity = iGame.getEntity(weaponAttackAction.getEntityId());
        Mounted mounted = entity.getEquipment(weaponAttackAction.getWeaponId());
        ToHitData toHitData = weaponAttackAction.toHit(iGame);
        if (toHitData.getValue() == Integer.MAX_VALUE || toHitData.getValue() == 0x7FFFFFFE) {
            return 0.0f;
        }
        float f = 0.0f;
        f = toHitData.getValue() == Integer.MIN_VALUE ? 1.0f : (float)Compute.oddsAbove(toHitData.getValue()) / 100.0f;
        float f2 = 0.0f;
        WeaponType weaponType = (WeaponType)mounted.getType();
        if (weaponType.getDamage() == -2) {
            if (mounted.getLinked() == null) {
                return 0.0f;
            }
            AmmoType ammoType = (AmmoType)mounted.getLinked().getType();
            float f3 = 0.0f;
            f3 = weaponType.getAmmoType() == 11 || weaponType.getAmmoType() == 32 ? (float)weaponType.getRackSize() : (weaponType.getRackSize() == 40 || weaponType.getRackSize() == 30 ? 2.0f * expectedHitsByRackSize[weaponType.getRackSize() / 2] : expectedHitsByRackSize[weaponType.getRackSize()]);
            Vector vector = weaponAttackAction.getCounterEquipment();
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Mounted mounted2 = (Mounted)vector.elementAt(i);
                    if (!(mounted2.getType() instanceof WeaponType) || !mounted2.getType().hasFlag(0x1000000)) continue;
                    float f4 = 3.5f * (float)((WeaponType)mounted2.getType()).getDamage();
                    f3 = Math.max(0.0f, f3 - f4);
                }
            }
            f2 = f3 * (float)ammoType.getDamagePerShot();
        } else {
            f2 = weaponType.getDamage();
        }
        return f2 *= f;
    }

    private void toggleStealth() {
        int n = 1;
        Enumeration enumeration = this.game.getEntities();
        block0: while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (entity.getOwnerId() != this.local_pn || !(entity instanceof Mech) || !((Mech)entity).hasStealth()) continue;
            Enumeration enumeration2 = entity.getMisc();
            while (enumeration2.hasMoreElements()) {
                Mounted mounted = (Mounted)enumeration2.nextElement();
                MiscType miscType = (MiscType)mounted.getType();
                if (!"Mek Stealth".equals(miscType.getInternalName())) continue;
                int n2 = 13 + Compute.randomInt(7);
                if (entity.heat > n2) {
                    n = 0;
                } else {
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    n2 = 5;
                    Enumeration enumeration3 = this.game.getEntities();
                    while (enumeration3.hasMoreElements()) {
                        Entity entity2 = (Entity)enumeration3.nextElement();
                        if (!entity.isEnemyOf(entity2)) continue;
                        n3 += entity2.calculateBattleValue();
                        if (!entity2.isVisibleToEnemy()) continue;
                        ++n6;
                        n4 += entity2.calculateBattleValue();
                        n5 += Compute.effectiveDistance(this.game, entity, entity2);
                    }
                    if (n6 == 0 || n4 < n3 / 2) {
                        n = 1;
                    } else if (n6 != 0) {
                        n = n5 / n6 <= 5 + Compute.randomInt(5) ? 0 : 1;
                    }
                }
                mounted.setMode(n);
                this.sendModeChange(entity.getId(), entity.getEquipmentNum(mounted), n);
                continue block0;
            }
        }
    }

    public void retrieveServerInfo() {
        super.retrieveServerInfo();
        this.initialize();
    }
}

