/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.ui.AWT.AlertDialog;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.DialogOptionComponent;
import megamek.client.ui.AWT.DialogOptionListener;
import megamek.client.ui.AWT.Messages;
import megamek.common.options.GameOptions;
import megamek.common.options.IBasicOption;
import megamek.common.options.IOption;
import megamek.common.options.IOptionGroup;

public class GameOptionsDialog
extends Dialog
implements ActionListener,
DialogOptionListener {
    private ClientGUI client;
    private GameOptions options;
    private boolean editable = true;
    private Vector optionComps = new Vector();
    private int maxOptionWidth = 0;
    private AlertDialog savedAlert = null;
    private Panel panOptions = new Panel();
    private ScrollPane scrOptions = new ScrollPane();
    private TextArea texDesc = new TextArea(Messages.getString("GameOptionsDialog.optionDescriptionHint"), 3, 35, 1);
    private Panel panPassword = new Panel();
    private Label labPass = new Label(Messages.getString("GameOptionsDialog.Password"));
    private TextField texPass = new TextField(15);
    private Panel panButtons = new Panel();
    private Button butSave = new Button(Messages.getString("GameOptionsDialog.Save"));
    private Button butOkay = new Button(Messages.getString("Okay"));
    private Button butCancel = new Button(Messages.getString("Cancel"));
    private Frame currentFrame = new Frame();

    private void init(Frame frame, GameOptions gameOptions) {
        this.options = gameOptions;
        this.currentFrame = frame;
        this.scrOptions.add(this.panOptions);
        this.scrOptions.getVAdjustable().setUnitIncrement(10);
        this.texDesc.setEditable(false);
        this.setupButtons();
        this.setupPassword();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.scrOptions, gridBagConstraints);
        this.add(this.scrOptions);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.texDesc, gridBagConstraints);
        this.add(this.texDesc);
        gridBagLayout.setConstraints(this.panPassword, gridBagConstraints);
        this.add(this.panPassword);
        gridBagLayout.setConstraints(this.panButtons, gridBagConstraints);
        this.add(this.panButtons);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GameOptionsDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setSize(this.getSize().width, Math.max(this.getSize().height, 400));
        this.setResizable(false);
        this.setLocation(frame.getLocation().x + frame.getSize().width / 2 - this.getSize().width / 2, frame.getLocation().y + frame.getSize().height / 2 - this.getSize().height / 2);
        this.savedAlert = new AlertDialog(frame, Messages.getString("GameOptionsDialog.OptionSavedDialog.title"), Messages.getString("GameOptionsDialog.OptionSavedDialog.message"));
    }

    public GameOptionsDialog(ClientGUI clientGUI) {
        super(clientGUI.frame, Messages.getString("GameOptionsDialog.title"), true);
        this.client = clientGUI;
        this.init(clientGUI.frame, clientGUI.getClient().game.getOptions());
    }

    public GameOptionsDialog(Frame frame, GameOptions gameOptions) {
        super(frame, Messages.getString("GameOptionsDialog.title"), true);
        this.init(frame, gameOptions);
        this.butOkay.setEnabled(false);
    }

    public void update(GameOptions gameOptions) {
        this.options = gameOptions;
        this.refreshOptions();
    }

    public void send() {
        Vector<IBasicOption> vector = new Vector<IBasicOption>();
        Enumeration enumeration = this.optionComps.elements();
        while (enumeration.hasMoreElements()) {
            DialogOptionComponent dialogOptionComponent = (DialogOptionComponent)enumeration.nextElement();
            if (!dialogOptionComponent.hasChanged()) continue;
            vector.addElement(dialogOptionComponent.changedOption());
        }
        if (this.client != null && vector.size() > 0) {
            this.client.getClient().sendGameOptions(this.texPass.getText(), vector);
        }
    }

    public void doSave() {
        Vector<IBasicOption> vector = new Vector<IBasicOption>();
        Enumeration enumeration = this.optionComps.elements();
        while (enumeration.hasMoreElements()) {
            DialogOptionComponent dialogOptionComponent = (DialogOptionComponent)enumeration.nextElement();
            IBasicOption iBasicOption = dialogOptionComponent.changedOption();
            vector.addElement(iBasicOption);
        }
        GameOptions.saveOptions(vector);
        this.savedAlert.show();
    }

    private void refreshOptions() {
        this.panOptions.removeAll();
        this.optionComps = new Vector();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panOptions.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        Enumeration enumeration = this.options.getGroups();
        while (enumeration.hasMoreElements()) {
            IOptionGroup iOptionGroup = (IOptionGroup)enumeration.nextElement();
            this.addGroup(iOptionGroup, gridBagLayout, gridBagConstraints);
            Enumeration enumeration2 = iOptionGroup.getOptions();
            while (enumeration2.hasMoreElements()) {
                IOption iOption = (IOption)enumeration2.nextElement();
                this.addOption(iOption, gridBagLayout, gridBagConstraints);
            }
        }
        this.setSize(Math.min(this.currentFrame.getSize().width, this.maxOptionWidth + 30), Math.max(this.getSize().height, 400));
        this.validate();
    }

    private void addGroup(IOptionGroup iOptionGroup, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        Label label = new Label(iOptionGroup.getDisplayableName());
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.panOptions.add(label);
    }

    private void addOption(IOption iOption, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        DialogOptionComponent dialogOptionComponent = new DialogOptionComponent(this, iOption);
        gridBagLayout.setConstraints(dialogOptionComponent, gridBagConstraints);
        this.panOptions.add(dialogOptionComponent);
        this.maxOptionWidth = Math.max(this.maxOptionWidth, dialogOptionComponent.getPreferredSize().width);
        if (iOption.getName().equals("inf_deploy_even")) {
            if (!this.options.getOption("inf_move_even").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if (iOption.getName().equals("inf_move_multi")) {
            if (this.options.getOption("inf_move_even").booleanValue() || this.options.getOption("inf_move_later").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if (iOption.getName().equals("inf_move_even")) {
            if (this.options.getOption("inf_move_multi").booleanValue() || this.options.getOption("inf_move_later").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if (iOption.getName().equals("inf_move_later")) {
            if (this.options.getOption("inf_move_even").booleanValue() || this.options.getOption("inf_move_multi").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if (iOption.getName().equals("protos_deploy_even")) {
            if (!this.options.getOption("protos_move_even").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if (iOption.getName().equals("protos_move_multi")) {
            if (this.options.getOption("protos_move_even").booleanValue() || this.options.getOption("protos_move_later").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if (iOption.getName().equals("protos_move_even")) {
            if (this.options.getOption("protos_move_multi").booleanValue() || this.options.getOption("protos_move_later").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if (iOption.getName().equals("protos_move_later")) {
            if (this.options.getOption("protos_move_even").booleanValue() || this.options.getOption("protos_move_multi").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else {
            dialogOptionComponent.setEditable(this.editable);
        }
        this.optionComps.addElement(dialogOptionComponent);
    }

    public void showDescFor(IOption iOption) {
        this.texDesc.setText(iOption.getDescription());
    }

    public void optionClicked(DialogOptionComponent dialogOptionComponent, IOption iOption, boolean bl) {
        DialogOptionComponent dialogOptionComponent2;
        Enumeration enumeration;
        if (iOption.getName().equals("inf_move_even")) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = (DialogOptionComponent)enumeration.nextElement();
                if (dialogOptionComponent2.option.getName().equals("inf_deploy_even")) {
                    dialogOptionComponent2.setEditable(bl);
                    dialogOptionComponent2.setState(false);
                }
                if (dialogOptionComponent2.option.getName().equals("inf_move_multi")) {
                    dialogOptionComponent2.setEditable(!bl);
                }
                if (!dialogOptionComponent2.option.getName().equals("inf_move_later")) continue;
                dialogOptionComponent2.setEditable(!bl);
            }
        }
        if (iOption.getName().equals("inf_move_multi")) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = (DialogOptionComponent)enumeration.nextElement();
                if (dialogOptionComponent2.option.getName().equals("inf_move_even")) {
                    dialogOptionComponent2.setEditable(!bl);
                }
                if (!dialogOptionComponent2.option.getName().equals("inf_move_later")) continue;
                dialogOptionComponent2.setEditable(!bl);
            }
        }
        if (iOption.getName().equals("inf_move_later")) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = (DialogOptionComponent)enumeration.nextElement();
                if (dialogOptionComponent2.option.getName().equals("inf_move_even")) {
                    dialogOptionComponent2.setEditable(!bl);
                }
                if (!dialogOptionComponent2.option.getName().equals("inf_move_multi")) continue;
                dialogOptionComponent2.setEditable(!bl);
            }
        }
        if (iOption.getName().equals("protos_move_even")) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = (DialogOptionComponent)enumeration.nextElement();
                if (dialogOptionComponent2.option.getName().equals("protos_deploy_even")) {
                    dialogOptionComponent2.setEditable(bl);
                    dialogOptionComponent2.setState(false);
                }
                if (dialogOptionComponent2.option.getName().equals("protos_move_multi")) {
                    dialogOptionComponent2.setEditable(!bl);
                }
                if (!dialogOptionComponent2.option.getName().equals("protos_move_later")) continue;
                dialogOptionComponent2.setEditable(!bl);
            }
        }
        if (iOption.getName().equals("protos_move_multi")) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = (DialogOptionComponent)enumeration.nextElement();
                if (dialogOptionComponent2.option.getName().equals("protos_move_even")) {
                    dialogOptionComponent2.setEditable(!bl);
                }
                if (!dialogOptionComponent2.option.getName().equals("protos_move_later")) continue;
                dialogOptionComponent2.setEditable(!bl);
            }
        }
        if (iOption.getName().equals("protos_move_later")) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = (DialogOptionComponent)enumeration.nextElement();
                if (dialogOptionComponent2.option.getName().equals("protos_move_even")) {
                    dialogOptionComponent2.setEditable(!bl);
                }
                if (!dialogOptionComponent2.option.getName().equals("protos_move_multi")) continue;
                dialogOptionComponent2.setEditable(!bl);
            }
        }
        if (iOption.getName().equals("vacuum")) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = (DialogOptionComponent)enumeration.nextElement();
                if (!dialogOptionComponent2.option.getName().equals("fire")) continue;
                dialogOptionComponent2.setEditable(!bl);
                dialogOptionComponent2.setState(false);
            }
        }
    }

    private void setupButtons() {
        this.butSave.addActionListener(this);
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panButtons.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.butOkay, gridBagConstraints);
        this.panButtons.add(this.butOkay);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.butSave, gridBagConstraints);
        this.panButtons.add(this.butSave);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.butCancel, gridBagConstraints);
        this.panButtons.add(this.butCancel);
    }

    private void setupPassword() {
        this.panPassword.setLayout(new BorderLayout());
        this.panPassword.add((Component)this.labPass, "West");
        this.panPassword.add((Component)this.texPass, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.butOkay) {
            this.send();
        } else if (actionEvent.getSource() == this.butSave) {
            this.doSave();
            if (this.butOkay.isEnabled()) {
                return;
            }
        }
        this.setVisible(false);
    }

    public void setEditable(boolean bl) {
        Enumeration enumeration = this.optionComps.elements();
        while (enumeration.hasMoreElements()) {
            DialogOptionComponent dialogOptionComponent = (DialogOptionComponent)enumeration.nextElement();
            dialogOptionComponent.setEditable(bl);
        }
        this.texPass.setEnabled(bl);
        this.butOkay.setEnabled(bl && this.client != null);
        this.butSave.setEnabled(bl);
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }
}

