/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.MechView;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.UnitFailureDialog;
import megamek.client.ui.AWT.UnitLoadingDialog;
import megamek.client.ui.AWT.widget.BufferedPanel;
import megamek.common.Entity;
import megamek.common.EntityWeightClass;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.MechSummaryComparator;
import megamek.common.TechConstants;
import megamek.common.UnitType;
import megamek.common.loaders.EntityLoadingException;

public class MechSelectorDialog
extends Dialog
implements ActionListener,
ItemListener,
KeyListener,
Runnable,
WindowListener {
    private static final int KEY_TIMEOUT = 1000;
    private String[] m_saSorts = new String[]{Messages.getString("MechSelectorDialog.0"), Messages.getString("MechSelectorDialog.1"), Messages.getString("MechSelectorDialog.2"), Messages.getString("MechSelectorDialog.3"), Messages.getString("MechSelectorDialog.4"), Messages.getString("MechSelectorDialog.5")};
    private MechSummary[] m_mechsCurrent;
    private Client m_client;
    private ClientGUI m_clientgui;
    private UnitLoadingDialog unitLoadingDialog;
    private StringBuffer m_sbSearch = new StringBuffer();
    private long m_nLastSearch = 0L;
    private Label m_labelWeightClass = new Label(Messages.getString("MechSelectorDialog.m_labelWeightClass"), 2);
    private Choice m_chWeightClass = new Choice();
    private Label m_labelType = new Label(Messages.getString("MechSelectorDialog.m_labelType"), 2);
    private Choice m_chType = new Choice();
    private Label m_labelUnitType = new Label(Messages.getString("MechSelectorDialog.m_labelUnitType"), 2);
    private Choice m_chUnitType = new Choice();
    private Label m_labelSort = new Label(Messages.getString("MechSelectorDialog.m_labelSort"), 2);
    private Choice m_chSort = new Choice();
    private Panel m_pParams = new Panel();
    private Panel m_pListOptions = new Panel();
    private Label m_labelListOptions = new Label(Messages.getString("MechSelectorDialog.m_labelListOptions"));
    private Checkbox m_cModel = new Checkbox(Messages.getString("MechSelectorDialog.m_cModel"), GUIPreferences.getInstance().getMechSelectorIncludeModel());
    private Checkbox m_cName = new Checkbox(Messages.getString("MechSelectorDialog.m_cName"), GUIPreferences.getInstance().getMechSelectorIncludeName());
    private Checkbox m_cTons = new Checkbox(Messages.getString("MechSelectorDialog.m_cTons"), GUIPreferences.getInstance().getMechSelectorIncludeTons());
    private Checkbox m_cBV = new Checkbox(Messages.getString("MechSelectorDialog.m_cBV"), GUIPreferences.getInstance().getMechSelectorIncludeBV());
    private Checkbox m_cYear = new Checkbox(Messages.getString("MechSelectorDialog.m_cYear"), GUIPreferences.getInstance().getMechSelectorIncludeYear());
    private Checkbox m_cLevel = new Checkbox(Messages.getString("MechSelectorDialog.m_cLevel"), GUIPreferences.getInstance().getMechSelectorIncludeLevel());
    private Checkbox m_cCost = new Checkbox(Messages.getString("MechSelectorDialog.m_cCost"), GUIPreferences.getInstance().getMechSelectorIncludeCost());
    List m_mechList = new List(10);
    private Button m_bPick = new Button(Messages.getString("MechSelectorDialog.m_bPick"));
    private Button m_bPickClose = new Button(Messages.getString("MechSelectorDialog.m_bPickClose"));
    private Button m_bCancel = new Button(Messages.getString("Close"));
    private Panel m_pButtons = new Panel();
    private TextArea m_mechViewLeft = new TextArea("", 18, 25, 2);
    private TextArea m_mechViewRight = new TextArea(18, 28);
    private Panel m_pLeft = new Panel();
    private Panel m_pUpper = new Panel();
    BufferedPanel m_pPreview = new BufferedPanel();
    private Label m_labelPlayer = new Label(Messages.getString("MechSelectorDialog.m_labelPlayer"), 2);
    private Choice m_chPlayer = new Choice();
    private boolean includeMaxTech;
    private static final String SPACES = "                        ";

    public MechSelectorDialog(ClientGUI clientGUI, UnitLoadingDialog unitLoadingDialog) {
        super(clientGUI.frame, Messages.getString("MechSelectorDialog.title"), true);
        this.m_client = clientGUI.getClient();
        this.m_clientgui = clientGUI;
        this.unitLoadingDialog = unitLoadingDialog;
        for (int i = 0; i < this.m_saSorts.length; ++i) {
            this.m_chSort.addItem(this.m_saSorts[i]);
        }
        this.updatePlayerChoice();
        this.m_pParams.setLayout(new GridLayout(4, 2));
        this.m_pParams.add(this.m_labelWeightClass);
        this.m_pParams.add(this.m_chWeightClass);
        this.m_pParams.add(this.m_labelType);
        this.m_pParams.add(this.m_chType);
        this.m_pParams.add(this.m_labelUnitType);
        this.m_pParams.add(this.m_chUnitType);
        this.m_pParams.add(this.m_labelSort);
        this.m_pParams.add(this.m_chSort);
        this.m_pListOptions.add(this.m_labelListOptions);
        this.m_cModel.addItemListener(this);
        this.m_pListOptions.add(this.m_cModel);
        this.m_cName.addItemListener(this);
        this.m_pListOptions.add(this.m_cName);
        this.m_cTons.addItemListener(this);
        this.m_pListOptions.add(this.m_cTons);
        this.m_cBV.addItemListener(this);
        this.m_pListOptions.add(this.m_cBV);
        this.m_cYear.addItemListener(this);
        this.m_pListOptions.add(this.m_cYear);
        this.m_cLevel.addItemListener(this);
        this.m_pListOptions.add(this.m_cLevel);
        this.m_cCost.addItemListener(this);
        this.m_pListOptions.add(this.m_cCost);
        this.m_pButtons.setLayout(new FlowLayout(1));
        this.m_pButtons.add(this.m_bPick);
        this.m_pButtons.add(this.m_bPickClose);
        this.m_pButtons.add(this.m_bCancel);
        this.m_pButtons.add(this.m_labelPlayer);
        this.m_pButtons.add(this.m_chPlayer);
        this.m_pUpper.setLayout(new BorderLayout());
        this.m_pPreview.setPreferredSize(84, 72);
        this.m_pUpper.add((Component)this.m_pParams, "West");
        this.m_pUpper.add((Component)this.m_pPreview, "Center");
        this.m_pUpper.add((Component)this.m_pListOptions, "South");
        this.m_pLeft.setLayout(new BorderLayout());
        this.m_pLeft.add((Component)this.m_pUpper, "North");
        this.m_mechList.setFont(new Font("Monospaced", 0, 12));
        this.m_mechList.addKeyListener(this);
        this.m_pLeft.add((Component)this.m_mechList, "Center");
        this.m_pLeft.add((Component)this.m_pButtons, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_pLeft, "West");
        this.m_mechViewLeft.setFont(new Font("Monospaced", 0, 12));
        this.add((Component)this.m_mechViewLeft, "Center");
        this.m_mechViewRight.setFont(new Font("Monospaced", 0, 12));
        this.add((Component)this.m_mechViewRight, "East");
        this.m_chWeightClass.addItemListener(this);
        this.m_chType.addItemListener(this);
        this.m_chUnitType.addItemListener(this);
        this.m_chSort.addItemListener(this);
        this.m_mechList.addItemListener(this);
        this.m_bPick.addActionListener(this);
        this.m_bPickClose.addActionListener(this);
        this.m_bCancel.addActionListener(this);
        this.setSize(770, 350);
        this.setLocation(this.computeDesiredLocation());
        this.populateChoices();
        this.addWindowListener(this);
        this.updateWidgetEnablements();
    }

    private void updateTechChoice() {
        int n;
        boolean bl = this.m_client.game.getOptions().booleanOption("allow_level_3_units");
        int n2 = n = bl ? TechConstants.SIZE : 5;
        if (this.includeMaxTech == bl) {
            return;
        }
        this.includeMaxTech = bl;
        this.m_chType.removeAll();
        for (int i = 0; i < n; ++i) {
            this.m_chType.addItem(TechConstants.getLevelDisplayableName(i));
        }
    }

    private void updatePlayerChoice() {
        String string = this.m_chPlayer.getSelectedItem();
        this.m_chPlayer.removeAll();
        this.m_chPlayer.setEnabled(true);
        this.m_chPlayer.addItem(this.m_clientgui.getClient().getName());
        Iterator iterator = this.m_clientgui.getBots().values().iterator();
        while (iterator.hasNext()) {
            this.m_chPlayer.addItem(((Client)iterator.next()).getName());
        }
        if (this.m_chPlayer.getItemCount() == 1) {
            this.m_chPlayer.setEnabled(false);
        } else {
            this.m_chPlayer.select(string);
        }
    }

    public void run() {
        this.filterMechs();
        this.m_mechList.invalidate();
        this.pack();
        this.setLocation(this.computeDesiredLocation());
        this.unitLoadingDialog.hide();
        Hashtable hashtable = MechSummaryCache.getInstance().getFailedFiles();
        if (hashtable != null && hashtable.size() > 0) {
            new UnitFailureDialog(this.m_clientgui.frame, hashtable);
        }
    }

    private void populateChoices() {
        int n;
        int n2;
        for (n2 = 0; n2 < EntityWeightClass.SIZE; ++n2) {
            this.m_chWeightClass.addItem(EntityWeightClass.getClassName(n2));
        }
        this.m_chWeightClass.addItem(Messages.getString("MechSelectorDialog.All"));
        this.m_chWeightClass.select(0);
        this.includeMaxTech = this.m_client.game.getOptions().booleanOption("allow_level_3_units");
        n2 = this.includeMaxTech ? TechConstants.SIZE : 5;
        for (n = 0; n < n2; ++n) {
            this.m_chType.addItem(TechConstants.getLevelDisplayableName(n));
        }
        this.m_chType.select(0);
        for (n = 0; n < UnitType.SIZE; ++n) {
            this.m_chUnitType.addItem(UnitType.getTypeDisplayableName(n));
        }
        this.m_chUnitType.addItem(Messages.getString("MechSelectorDialog.All"));
        this.m_chUnitType.select(0);
    }

    private void filterMechs() {
        Vector<MechSummary> vector = new Vector<MechSummary>();
        int n = this.m_chWeightClass.getSelectedIndex();
        int n2 = this.m_chType.getSelectedIndex();
        String string = this.m_chType.getSelectedItem();
        int n3 = this.m_chUnitType.getSelectedIndex();
        MechSummary[] mechSummaryArray = MechSummaryCache.getInstance().getAllMechs();
        if (mechSummaryArray == null) {
            System.err.println("No units to filter!");
            return;
        }
        for (int i = 0; i < mechSummaryArray.length; ++i) {
            if (n != EntityWeightClass.SIZE && mechSummaryArray[i].getWeightClass() != n || n2 != 7 && n2 != mechSummaryArray[i].getType() && (n2 != 4 || mechSummaryArray[i].getType() != 0 && mechSummaryArray[i].getType() != 1 && mechSummaryArray[i].getType() != 2) && (n2 != 3 || mechSummaryArray[i].getType() != 0 && mechSummaryArray[i].getType() != 1) || n3 != UnitType.SIZE && !mechSummaryArray[i].getUnitType().equals(UnitType.getTypeName(n3)) || this.m_client.game.getOptions().booleanOption("canon_only") && !mechSummaryArray[i].isCanon()) continue;
            vector.addElement(mechSummaryArray[i]);
        }
        this.m_mechsCurrent = new MechSummary[vector.size()];
        vector.copyInto(this.m_mechsCurrent);
        this.sortMechs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortMechs() {
        Arrays.sort(this.m_mechsCurrent, new MechSummaryComparator(this.m_chSort.getSelectedIndex()));
        this.m_mechList.removeAll();
        try {
            this.m_mechList.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (int i = 0; i < this.m_mechsCurrent.length; ++i) {
                this.m_mechList.add(this.formatMech(this.m_mechsCurrent[i]));
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.m_mechList.setEnabled(true);
            this.m_mechList.setFont(this.m_mechList.getFont());
        }
        this.updateWidgetEnablements();
        this.repaint();
    }

    private void searchFor(String string) {
        for (int i = 0; i < this.m_mechsCurrent.length; ++i) {
            if (!this.m_mechsCurrent[i].getName().toLowerCase().startsWith(string)) continue;
            this.m_mechList.select(i);
            ItemEvent itemEvent = new ItemEvent(this.m_mechList, 701, this.m_mechList, 1);
            this.itemStateChanged(itemEvent);
            break;
        }
    }

    private Point computeDesiredLocation() {
        int n;
        int n2 = this.m_clientgui.frame.getLocation().x + this.m_clientgui.frame.getSize().width / 2 - this.getSize().width / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = this.m_clientgui.frame.getLocation().y + this.m_clientgui.frame.getSize().height / 2 - this.getSize().height / 2) < 0) {
            n = 0;
        }
        return new Point(n2, n);
    }

    public void show() {
        this.updatePlayerChoice();
        this.updateTechChoice();
        this.setLocation(this.computeDesiredLocation());
        super.show();
    }

    private String formatMech(MechSummary mechSummary) {
        String string = "";
        String string2 = !mechSummary.getLevel().equals("F") ? TechConstants.T_SIMPLE_LEVEL[mechSummary.getType()] : "F";
        if (GUIPreferences.getInstance().getMechSelectorIncludeModel()) {
            string = string + this.makeLength(mechSummary.getModel(), 10) + " ";
        }
        if (GUIPreferences.getInstance().getMechSelectorIncludeName()) {
            string = string + this.makeLength(mechSummary.getChassis(), 20) + " ";
        }
        if (GUIPreferences.getInstance().getMechSelectorIncludeTons()) {
            string = string + this.makeLength("" + mechSummary.getTons(), 3) + " ";
        }
        if (GUIPreferences.getInstance().getMechSelectorIncludeBV()) {
            string = string + this.makeLength("" + mechSummary.getBV(), 5) + " ";
        }
        if (GUIPreferences.getInstance().getMechSelectorIncludeYear()) {
            string = string + mechSummary.getYear() + " ";
        }
        if (GUIPreferences.getInstance().getMechSelectorIncludeLevel()) {
            string = string + string2 + " ";
        }
        if (GUIPreferences.getInstance().getMechSelectorIncludeCost()) {
            string = string + mechSummary.getCost() + " ";
        }
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_bCancel) {
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.m_bPick || actionEvent.getSource() == this.m_bPickClose) {
            int n = this.m_mechList.getSelectedIndex();
            if (n == -1) {
                return;
            }
            MechSummary mechSummary = this.m_mechsCurrent[this.m_mechList.getSelectedIndex()];
            try {
                Entity entity = new MechFileParser(mechSummary.getSourceFile(), mechSummary.getEntryName()).getEntity();
                Client client = null;
                if (this.m_chPlayer.getSelectedIndex() > 0) {
                    String string = this.m_chPlayer.getSelectedItem();
                    client = (Client)this.m_clientgui.getBots().get(string);
                }
                if (client == null) {
                    client = this.m_client;
                }
                entity.setOwner(client.getLocalPlayer());
                client.sendAddEntity(entity);
            }
            catch (EntityLoadingException entityLoadingException) {
                System.out.println("Unable to load mech: " + mechSummary.getSourceFile() + ": " + mechSummary.getEntryName() + ": " + entityLoadingException.getMessage());
                entityLoadingException.printStackTrace();
                return;
            }
            if (actionEvent.getSource() == this.m_bPickClose) {
                this.setVisible(false);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.m_chSort) {
            this.clearMechPreview();
            this.sortMechs();
        } else if (itemEvent.getSource() == this.m_chWeightClass || itemEvent.getSource() == this.m_chType || itemEvent.getSource() == this.m_chUnitType) {
            this.clearMechPreview();
            this.filterMechs();
        } else if (itemEvent.getSource() == this.m_mechList) {
            this.updateWidgetEnablements();
            int n = this.m_mechList.getSelectedIndex();
            if (n == -1) {
                this.clearMechPreview();
                return;
            }
            MechSummary mechSummary = this.m_mechsCurrent[n];
            try {
                Entity entity = new MechFileParser(mechSummary.getSourceFile(), mechSummary.getEntryName()).getEntity();
                this.previewMech(entity);
            }
            catch (EntityLoadingException entityLoadingException) {
                System.out.println("Unable to load mech: " + mechSummary.getSourceFile() + ": " + mechSummary.getEntryName() + ": " + entityLoadingException.getMessage());
                entityLoadingException.printStackTrace();
                this.clearMechPreview();
                return;
            }
        } else if (itemEvent.getSource() == this.m_cModel || itemEvent.getSource() == this.m_cName || itemEvent.getSource() == this.m_cTons || itemEvent.getSource() == this.m_cBV || itemEvent.getSource() == this.m_cYear || itemEvent.getSource() == this.m_cLevel || itemEvent.getSource() == this.m_cCost) {
            GUIPreferences.getInstance().setMechSelectorIncludeModel(this.m_cModel.getState());
            GUIPreferences.getInstance().setMechSelectorIncludeName(this.m_cName.getState());
            GUIPreferences.getInstance().setMechSelectorIncludeTons(this.m_cTons.getState());
            GUIPreferences.getInstance().setMechSelectorIncludeBV(this.m_cBV.getState());
            GUIPreferences.getInstance().setMechSelectorIncludeYear(this.m_cYear.getState());
            GUIPreferences.getInstance().setMechSelectorIncludeLevel(this.m_cLevel.getState());
            GUIPreferences.getInstance().setMechSelectorIncludeCost(this.m_cCost.getState());
            this.clearMechPreview();
            this.sortMechs();
            this.m_mechList.invalidate();
            this.pack();
            this.setLocation(this.computeDesiredLocation());
        }
    }

    void clearMechPreview() {
        this.m_mechViewLeft.setEditable(false);
        this.m_mechViewRight.setEditable(false);
        this.m_mechViewLeft.setText("");
        this.m_mechViewRight.setText("");
        if (MechSummaryCache.getInstance().isInitialized()) {
            this.m_pPreview.removeBgDrawers();
            this.m_pPreview.paint(this.m_pPreview.getGraphics());
        }
    }

    void previewMech(Entity entity) {
        MechView mechView = new MechView(entity);
        this.m_mechViewLeft.setEditable(false);
        this.m_mechViewRight.setEditable(false);
        this.m_mechViewLeft.setText(mechView.getMechReadoutBasic());
        this.m_mechViewRight.setText(mechView.getMechReadoutLoadout());
        this.m_mechViewLeft.setCaretPosition(0);
        this.m_mechViewRight.setCaretPosition(0);
        this.m_clientgui.loadPreviewImage(this.m_pPreview, entity, this.m_client.getLocalPlayer());
        this.m_pPreview.paint(this.m_pPreview.getGraphics());
    }

    private String makeLength(String string, int n) {
        if (string.length() == n) {
            return string;
        }
        if (string.length() > n) {
            return string.substring(0, n - 2) + "..";
        }
        return string + SPACES.substring(0, n - string.length());
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        long l;
        if (keyEvent.getKeyCode() == 10) {
            ActionEvent actionEvent = new ActionEvent(this.m_bPick, 1001, "");
            this.actionPerformed(actionEvent);
        }
        if ((l = System.currentTimeMillis()) - this.m_nLastSearch > 1000L) {
            this.m_sbSearch = new StringBuffer();
        }
        this.m_nLastSearch = l;
        this.m_sbSearch.append(keyEvent.getKeyChar());
        this.searchFor(this.m_sbSearch.toString().toLowerCase());
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private void updateWidgetEnablements() {
        boolean bl = this.m_mechList.getSelectedIndex() != -1;
        this.m_bPick.setEnabled(bl);
        this.m_bPickClose.setEnabled(bl);
    }
}

